/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.runtimeconfig.model.AttributeLabelType;
import oracle.bpel.services.workflow.runtimeconfig.model.PayloadMapping;
import oracle.bpel.services.workflow.runtimeconfig.model.PayloadMappingsList;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.analytics.dashboard.DashboardService;
import oracle.bpm.analytics.dashboard.query.DashboardQueryException;
import oracle.bpm.analytics.dashboard.query.JpqlTabularData;
import oracle.bpm.analytics.dashboard.query.WidgetData;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.common.resources.BPMServicesResource;
import oracle.bpm.services.processdashboard.IProcessDashboardService;
import oracle.bpm.services.processdashboard.impl.PredicateDrillDownBuilder;
import oracle.bpm.services.processdashboard.impl.ProcessDashboardUtils;
import oracle.bpm.services.processdashboard.impl.StandardWidgets;
import oracle.bpm.services.processdashboard.model.ComponentGroup;
import oracle.bpm.services.processdashboard.model.DataSource;
import oracle.bpm.services.processdashboard.model.PrincipleRef;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.TabularData;
import oracle.bpm.services.processdashboard.model.Widget;
import oracle.bpm.services.processdashboard.model.WidgetView;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.TabularDataImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetViewImpl;
import oracle.bpm.services.processdashboard.model.jaxb.TabularDataType;
import oracle.bpm.services.processdashboard.model.jaxb.TabularMetadataType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import org.jetbrains.annotations.NotNull;

public class ProcessDashboardService
implements IProcessDashboardService {
    private DashboardService dashboardService;
    private IProcessMetadataService processMetadataService;
    private IRuntimeConfigService runtimeConfigService;
    private IUserMetadataService userMetadataService;
    private IVerificationService verificationService;

    public TabularData getWidgetData(@NotNull IBPMContext context, @NotNull Widget widget) throws BPMException {
        this.validateContext(context);
        Widget fixedWidget = ProcessDashboardUtils.fixWidget(context, this.getProcessMetadataService(), widget);
        if (fixedWidget != null) {
            return this.loadWidgetData(context, fixedWidget);
        }
        return TabularDataImpl.create();
    }

    public TabularData getWidgetData(@NotNull IBPMContext context, @NotNull String widgetViewId) throws BPMException {
        Widget widget;
        Set<ComponentDNModel> processes;
        WidgetViewImpl widgetView = this.loadWidgetView(context, widgetViewId);
        if (widgetView != null && (widgetView = ProcessDashboardUtils.validateWidgetView(widgetView, processes = ProcessDashboardUtils.getProcesses(context, this.getProcessMetadataService()))) != null && widgetView.hasWidget() && (widget = ProcessDashboardUtils.fixWidget(context, processes, widgetView.getWidget())) != null) {
            return this.loadWidgetData(context, widget);
        }
        return TabularDataImpl.create();
    }

    public TabularData getWidgetDrillDownData(@NotNull IBPMContext context, @NotNull String widgetViewId, @NotNull String dimension, String value) throws BPMException {
        Set<ComponentDNModel> processes;
        WidgetViewImpl widgetView = this.loadWidgetView(context, widgetViewId);
        if (widgetView != null && (widgetView = ProcessDashboardUtils.validateWidgetView(widgetView, processes = ProcessDashboardUtils.getProcesses(context, this.getProcessMetadataService()))) != null && widgetView.hasWidget()) {
            return this.getWidgetDrillDownData(context, widgetView.getWidget(), dimension, value);
        }
        return TabularDataImpl.create();
    }

    public TabularData getWidgetDrillDownData(@NotNull IBPMContext context, @NotNull Widget widget, @NotNull String dimension, String value) throws BPMException {
        return this.getWidgetData(context, this.getWidgetDrillDown(context, widget, dimension, value));
    }

    public Widget getWidgetDrillDown(@NotNull IBPMContext context, @NotNull Widget widget, @NotNull String dimension, String value) throws BPMException {
        this.validateContext(context);
        WidgetType widgetType = this.getDashboardService().getWidgetDrillDown(ModelTypeFactory.createWidgetType((Widget)widget), dimension, value);
        return WidgetImpl.create((WidgetType)widgetType);
    }

    public WidgetView createWidgetView(@NotNull IBPMContext context, @NotNull WidgetView widgetView) throws BPMException {
        this.validateContext(context);
        if (StandardWidgets.isStandardId(widgetView.getId())) {
            throw new BPMException(71409, (Object[])new String[]{widgetView.getId()}, null);
        }
        UserApplicationDataType userApplicationDataType = ModelTypeFactory.createUserApplicationDataType((WidgetView)widgetView);
        try {
            IUserMetadataService userMetadataService = this.getUserMetadataService();
            userApplicationDataType = userMetadataService.createUserApplicationData((IWorkflowContext)context, userApplicationDataType);
        }
        catch (Exception cause) {
            throw new BPMException(71406, (Object[])new String[]{widgetView.getId()}, (Throwable)cause);
        }
        return WidgetViewImpl.create((UserApplicationDataType)userApplicationDataType);
    }

    public WidgetView updateWidgetView(@NotNull IBPMContext context, @NotNull WidgetView widgetView) throws BPMException {
        this.validateContext(context);
        if (StandardWidgets.isStandardId(widgetView.getId())) {
            throw new BPMException(71409, (Object[])new String[0], null);
        }
        UserApplicationDataType userApplicationDataType = ModelTypeFactory.createUserApplicationDataType((WidgetView)widgetView);
        try {
            IUserMetadataService userMetadataService = this.getUserMetadataService();
            userApplicationDataType = userMetadataService.updateUserApplicationData((IWorkflowContext)context, userApplicationDataType);
        }
        catch (Exception cause) {
            throw new BPMException(71407, (Object[])new String[]{widgetView.getId()}, (Throwable)cause);
        }
        return WidgetViewImpl.create((UserApplicationDataType)userApplicationDataType);
    }

    public void deleteWidgetView(@NotNull IBPMContext context, @NotNull String widgetViewId) throws BPMException {
        this.validateContext(context);
        if (StandardWidgets.isStandardId(widgetViewId)) {
            throw new BPMException(71409, (Object[])new String[0], null);
        }
        try {
            IUserMetadataService userMetadataService = this.getUserMetadataService();
            userMetadataService.deleteUserApplicationData((IWorkflowContext)context, widgetViewId);
        }
        catch (Exception cause) {
            throw new BPMException(71408, (Object[])new String[]{widgetViewId}, (Throwable)cause);
        }
    }

    public List<WidgetView> listStandardWidgetViews(@NotNull IBPMContext context) throws BPMException {
        this.validateContext(context);
        return StandardWidgets.getAll(context);
    }

    public List<WidgetView> listWidgetViews(@NotNull IBPMContext context, String owner) throws BPMException {
        this.validateContext(context);
        ArrayList<WidgetView> widgets = new ArrayList<WidgetView>();
        try {
            IUserMetadataService userMetadataService = this.getUserMetadataService();
            List userApplicationDatas = userMetadataService.listUserApplicationData((IWorkflowContext)context, "BAM-WIDGET", owner);
            if (userApplicationDatas != null && !userApplicationDatas.isEmpty()) {
                Set<ComponentDNModel> processes = ProcessDashboardUtils.getProcesses(context, this.getProcessMetadataService());
                for (UserApplicationDataType userApplicationDataType : userApplicationDatas) {
                    WidgetViewImpl widgetView = WidgetViewImpl.create((UserApplicationDataType)userApplicationDataType);
                    if ((widgetView = ProcessDashboardUtils.validateWidgetView(widgetView, processes)) == null) continue;
                    widgets.add((WidgetView)widgetView);
                }
            }
        }
        catch (WorkflowException cause) {
            throw new BPMException(71410, (Object[])new String[0], (Throwable)cause);
        }
        return widgets;
    }

    public List<WidgetView> listGrantedWidgetViews(@NotNull IBPMContext context, PrincipleRef grantee) throws BPMException {
        this.validateContext(context);
        ArrayList<WidgetView> widgets = new ArrayList<WidgetView>();
        widgets.addAll(StandardWidgets.getAll(context));
        try {
            PrincipleRefType principleRefType = grantee == null ? null : ModelTypeFactory.createPrincipleRefType((PrincipleRef)grantee);
            IUserMetadataService userMetadataService = this.getUserMetadataService();
            List userApplicationDatas = userMetadataService.listGrantedUserApplicationData((IWorkflowContext)context, "BAM-WIDGET", principleRefType, false);
            if (userApplicationDatas != null && !userApplicationDatas.isEmpty()) {
                Set<ComponentDNModel> processes = ProcessDashboardUtils.getProcesses(context, this.getProcessMetadataService());
                for (UserApplicationDataType userApplicationDataType : userMetadataService.listGrantedUserApplicationData((IWorkflowContext)context, "BAM-WIDGET", principleRefType, false)) {
                    WidgetViewImpl widgetView = WidgetViewImpl.create((UserApplicationDataType)userApplicationDataType);
                    if ((widgetView = ProcessDashboardUtils.validateWidgetView(widgetView, processes)) == null) continue;
                    widgets.add((WidgetView)widgetView);
                }
            }
        }
        catch (WorkflowException cause) {
            throw new BPMException(71410, (Object[])new String[0], (Throwable)cause);
        }
        return widgets;
    }

    public Predicate getPredicateDrillDown(@NotNull IBPMContext context, @NotNull Widget widget, @NotNull String dimension, @NotNull String value) throws BPMException {
        this.validateContext(context);
        DataSource dataSource = DataSource.CUBE_WORKLOAD;
        for (Series series : widget.getData().getSeries()) {
            dataSource = series.getDataSource();
        }
        List componentInstances = null;
        try {
            switch (dataSource) {
                case CUBE_PROCESS_PERFORMANCE: 
                case CUBE_TASK_PERFORMANCE: {
                    componentInstances = this.dashboardService.getComponentInstances(ModelTypeFactory.createWidgetType((Widget)widget), dimension, value);
                    if (componentInstances == null || componentInstances.isEmpty()) {
                        throw new BPMException(71400);
                    }
                    return PredicateDrillDownBuilder.buildPredicateDrillDown(componentInstances);
                }
            }
            return PredicateDrillDownBuilder.buildPredicateDrillDown(widget, dimension, value, this.getProcessVariableMappings(context, widget));
        }
        catch (DashboardQueryException initCause) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_DASHBOARD_SERVICE, (Severity)Severity.WARNING, (Throwable)initCause);
            throw new BPMException(71403, (Object[])new String[]{initCause.getLocalizedMessage()}, (Throwable)initCause);
        }
    }

    public WidgetView getWidgetView(@NotNull IBPMContext context, @NotNull String widgetId) throws BPMException {
        this.validateContext(context);
        if (StandardWidgets.isStandardId(widgetId)) {
            return StandardWidgets.get(widgetId);
        }
        WidgetViewImpl widgetView = this.loadWidgetView(context, widgetId);
        if (widgetView != null) {
            Set<ComponentDNModel> processes = ProcessDashboardUtils.getProcesses(context, this.getProcessMetadataService());
            return ProcessDashboardUtils.validateWidgetView(widgetView, processes);
        }
        return null;
    }

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService verificationService) {
        this.verificationService = verificationService;
    }

    public DashboardService getDashboardService() {
        return this.dashboardService;
    }

    public void setDashboardService(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    public IUserMetadataService getUserMetadataService() {
        return this.userMetadataService;
    }

    public void setUserMetadataService(IUserMetadataService userMetadataService) {
        this.userMetadataService = userMetadataService;
    }

    public IRuntimeConfigService getRuntimeConfigService() {
        return this.runtimeConfigService;
    }

    public void setRuntimeConfigService(IRuntimeConfigService runtimeConfigService) {
        this.runtimeConfigService = runtimeConfigService;
    }

    public IProcessMetadataService getProcessMetadataService() {
        return this.processMetadataService;
    }

    public void setProcessMetadataService(IProcessMetadataService processMetadataService) {
        this.processMetadataService = processMetadataService;
    }

    private Map<String, Map<String, String>> getProcessVariableMappings(@NotNull IBPMContext context, @NotNull Widget widget) throws BPMException {
        TreeMap<String, Map<String, String>> processVariableMappings = new TreeMap<String, Map<String, String>>();
        for (Series series : widget.getData().getSeries()) {
            String processId;
            if (!series.hasProcess() || processVariableMappings.containsKey(processId = series.getProcess())) continue;
            processVariableMappings.put(processId, this.getVariableMapping(context, processId));
        }
        return processVariableMappings;
    }

    private void validateContext(IBPMContext context) throws BPMException {
        try {
            this.getVerificationService().validateContext((IWorkflowContext)context);
        }
        catch (Exception cause) {
            throw new BPMException(70687, null, (Throwable)cause);
        }
    }

    private Map<String, String> getVariableMapping(@NotNull IBPMContext context, @NotNull String processId) throws BPMException {
        TreeMap<String, String> mappings = new TreeMap<String, String>();
        try {
            PayloadMappingsList payloadMappingsList = this.getRuntimeConfigService().getWorkflowPayloadMappings((IWorkflowContext)context, processId);
            for (Object object : payloadMappingsList.getPayloadMapping()) {
                PayloadMapping payloadMapping = (PayloadMapping)object;
                AttributeLabelType attributeLabel = payloadMapping.getLabel();
                mappings.put(payloadMapping.getPayloadAttribute(), attributeLabel.getTaskAttribute());
            }
        }
        catch (WorkflowException cause) {
            throw new BPMException(71403, (Object[])new String[]{cause.getLocalizedMessage()}, (Throwable)cause);
        }
        return mappings;
    }

    private TabularData loadWidgetData(@NotNull IBPMContext context, @NotNull Widget fixedWidget) throws BPMException {
        try {
            WidgetData widgetData = this.getDashboardService().getWidgetData(ModelTypeFactory.createWidgetType((Widget)fixedWidget));
            if (widgetData != null && !widgetData.isEmpty()) {
                TabularDataType tabularDataType = ((JpqlTabularData)widgetData.get(0)).toTabularDataType();
                tabularDataType.setType(ComponentGroup.GRAPH.name());
                if (fixedWidget.getVisualization().hasComponentType()) {
                    tabularDataType.setType(fixedWidget.getVisualization().getComponentType().getGroup().name());
                }
                if (tabularDataType.isSetMetadata()) {
                    TabularMetadataType tabularMetadataType = tabularDataType.getMetadata();
                    if (tabularMetadataType.isSetMeasure()) {
                        tabularMetadataType.setMeasure(this.fixMeasureLabel(tabularMetadataType.getMeasure(), context.getLocale()));
                    }
                    if (tabularMetadataType.isSetSeries()) {
                        tabularMetadataType.setSeries(this.fixDimensionLabel(tabularMetadataType.getSeries(), context.getLocale()));
                    }
                    if (tabularMetadataType.isSetGroup()) {
                        tabularMetadataType.setGroup(this.fixDimensionLabel(tabularMetadataType.getGroup(), context.getLocale()));
                    }
                    tabularDataType.setMetadata(tabularMetadataType);
                }
                return TabularDataImpl.create((TabularDataType)tabularDataType);
            }
        }
        catch (DashboardQueryException cause) {
            throw new BPMException(71401, (Object[])new String[0], (Throwable)cause);
        }
        return TabularDataImpl.create();
    }

    private WidgetViewImpl loadWidgetView(@NotNull IBPMContext context, @NotNull String widgetId) throws BPMException {
        try {
            String applicationDataType;
            IUserMetadataService userMetadataService = this.getUserMetadataService();
            UserApplicationDataType userApplicationDataType = userMetadataService.getUserApplicationData((IWorkflowContext)context, widgetId);
            if (userApplicationDataType != null && (applicationDataType = userApplicationDataType.getApplicationDataType()) != null && "BAM-WIDGET".equalsIgnoreCase(applicationDataType)) {
                return WidgetViewImpl.create((UserApplicationDataType)userApplicationDataType);
            }
        }
        catch (WorkflowException cause) {
            throw new BPMException(71411, (Object[])new String[]{widgetId}, (Throwable)cause);
        }
        return null;
    }

    private String fixDimensionLabel(String dimension, Locale locale) {
        if (dimension != null) {
            Locale _locale;
            Locale locale2 = _locale = locale == null ? Locale.ENGLISH : locale;
            if (dimension.equalsIgnoreCase("project")) {
                return BPMServicesResource.getNotNullResource((String)"PROJECT", (Locale)_locale);
            }
            if (dimension.equalsIgnoreCase("revision")) {
                return BPMServicesResource.getNotNullResource((String)"REVISION", (Locale)_locale);
            }
            if (dimension.equalsIgnoreCase("activity")) {
                return BPMServicesResource.getNotNullResource((String)"ACTIVITY", (Locale)_locale);
            }
            if (dimension.equalsIgnoreCase("completionDate")) {
                return BPMServicesResource.getNotNullResource((String)"COMPLETION_DATE", (Locale)_locale);
            }
            if (dimension.equalsIgnoreCase("participant")) {
                return BPMServicesResource.getNotNullResource((String)"PARTICIPANT", (Locale)_locale);
            }
            if (dimension.equalsIgnoreCase("process")) {
                return BPMServicesResource.getNotNullResource((String)"PROCESS", (Locale)_locale);
            }
            if (dimension.equalsIgnoreCase("role")) {
                return BPMServicesResource.getNotNullResource((String)"ROLE", (Locale)_locale);
            }
            return dimension;
        }
        return dimension;
    }

    private String fixMeasureLabel(String measure, Locale locale) {
        if (measure != null) {
            Locale _locale;
            Locale locale2 = _locale = locale == null ? Locale.ENGLISH : locale;
            if (measure.equalsIgnoreCase(ValueTypeEnum.SECONDS.value())) {
                return BPMServicesResource.getNotNullResource((String)"SECONDS", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase(ValueTypeEnum.AUTOMATIC_HANDLE_DATE.value()) || measure.equalsIgnoreCase(ValueTypeEnum.MINUTES.value())) {
                return BPMServicesResource.getNotNullResource((String)"MINUTES", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase(ValueTypeEnum.HOURS.value())) {
                return BPMServicesResource.getNotNullResource((String)"HOURS", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase(ValueTypeEnum.DAYS.value())) {
                return BPMServicesResource.getNotNullResource((String)"DAYS", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase("avgTimeProcess")) {
                return BPMServicesResource.getNotNullResource((String)"PROCESS_AVG_TIME", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase("avgTimeTask")) {
                return BPMServicesResource.getNotNullResource((String)"TASK_AVG_TIME", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase("medianTimeProcess")) {
                return BPMServicesResource.getNotNullResource((String)"PROCESS_MEDIAN_TIME", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase("medianTimeTask")) {
                return BPMServicesResource.getNotNullResource((String)"TASK_MEDIAN_TIME", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase("quantity")) {
                return BPMServicesResource.getNotNullResource((String)"INSTANCES", (Locale)_locale);
            }
            if (measure.equalsIgnoreCase("taskTime")) {
                return BPMServicesResource.getNotNullResource((String)"TASK_TIME", (Locale)_locale);
            }
            return measure;
        }
        return measure;
    }
}

