/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.test.AbstractExtendedUserPropertiesPersistenceTest;

public class RemoteExtendedUserPropertiesPersistenceTest
extends AbstractExtendedUserPropertiesPersistenceTest {
    private IBPMUserAuthenticationService authService;
    private IBPMOrganizationService orgService;

    public RemoteExtendedUserPropertiesPersistenceTest(String name) {
        super(name);
        IBPMServiceClient svcClient;
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, TestUtil.getWFEJBURL());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, TestUtil.getEJBUser());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, TestUtil.getEJBCred());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        if (bpmServiceClientFactory != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"RemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated BPMServiceClientFactory.");
        }
        if ((svcClient = bpmServiceClientFactory.getBPMServiceClient()) != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"RemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated IBPMServiceClient.");
        }
        this.orgService = svcClient.getBPMOrganizationService();
        if (this.orgService != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"RemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated IBPMOrganizationService.");
        }
        this.authService = bpmServiceClientFactory.getBPMUserAuthenticationService();
        if (this.authService != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"RemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated IBPMUserAuthenticationService.");
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testAddDateProperty"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testAddFreeformStringProperty"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testAddNumberProperty"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testAddStringProperty"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testForceDeleteProperty"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testForceDeletePropertyValue"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testGentleDeleteProperty"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testGentleDeletePropertyValue"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testGetParticipantsWithStringProperties"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testGetPropertiesOfParticipants"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSearchParticipantsWithDateProperties"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSearchParticipantsWithFreeformStringProperties"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSearchParticipantsWithNumberProperties"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSearchParticipantsWithStringProperties"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSearchParticipantsBug9410894String"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSearchPropertyDefinitions"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSetPropertiesOnParticipants"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testUpdatePropertyName"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testUpdatePropertyValue"));
        suite.addTest((Test)new RemoteExtendedUserPropertiesPersistenceTest("testSearchParticipantsWithFreeformStringPropertiesUsingIN_NOTIN_OPERATORS2"));
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RemoteExtendedUserPropertiesPersistenceTest.suite());
    }

    @Override
    public IBPMOrganizationService getBPMOrganizationService() {
        if (this.orgService != null) {
            return this.orgService;
        }
        throw new RuntimeException("Reference to IBPMOrganizationService is NULL. Test case runner not initialized.");
    }

    @Override
    public IBPMUserAuthenticationService getBPMUserAuthenticationService() {
        if (this.authService != null) {
            return this.authService;
        }
        throw new RuntimeException("Reference to IBPMUserAuthorizationService is NULL. Test case runner not initialized");
    }
}

