/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;

public class ExtendedUserPropertiesDemo {
    private ObjectFactory objectFactory = new ObjectFactory();
    private IBPMOrganizationService orgService;
    private IBPMUserAuthenticationService authService;
    private IBPMContext ctx;
    private final String USER_JSTEIN = "jstein";
    private final String PASSWORD_JSTEIN = "welcome1";
    private final String USER_JCOOPER = "jcooper";
    private final String IDTTY_CTXT = "jazn.com";

    public static void main(String[] args) throws Exception {
        ExtendedUserPropertiesDemo demo = new ExtendedUserPropertiesDemo();
        System.out.println("As part of this demo we will create 2 FREEFORM_STRING properties called Performance_Rating and Customer_Feedback.\n Press <enter> to continue...");
        System.in.read();
        demo.addMultiValuedFreeformStringProperties();
        System.out.println("\n\n\nProperties created successfully\n");
        System.out.println("\n\n\nNext step is to assign these properties to participants. Press <enter> to continue...");
        System.in.read();
        demo.setFreeformStringPropertiesOnParticipants();
        System.out.println("\n\n\nNext step is to search for participants with certain property values. Press <enter> to continue...");
        System.in.read();
        System.out.println("\n\n\n Displaying property names in Polish locale to demonstrate i18n support. Press <enter> to continue...");
        System.in.read();
        demo.getAllDefinedProperties();
    }

    public ExtendedUserPropertiesDemo() throws BPMException {
        IBPMServiceClient svcClient;
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, "t3://stadb72.us.oracle.com:7001");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, "weblogic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, "weblogic1");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        if (bpmServiceClientFactory != null) {
            System.out.println("\nRemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated BPMServiceClientFactory.\n");
        }
        if ((svcClient = bpmServiceClientFactory.getBPMServiceClient()) != null) {
            System.out.println("\nRemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated IBPMServiceClient.\n");
        }
        this.orgService = svcClient.getBPMOrganizationService();
        if (this.orgService != null) {
            System.out.println("\nRemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated IBPMOrganizationService.\n");
        }
        this.authService = bpmServiceClientFactory.getBPMUserAuthenticationService();
        if (this.authService != null) {
            System.out.println("\nRemoteExtendedUserPropertiesPersistenceTest() CTOR >> Successfully instantiated IBPMUserAuthenticationService.\n");
        }
        this.ctx = this.authService.authenticate("jstein", "welcome1".toCharArray(), "jazn.com");
        System.out.println("\nSuccessfully authenticated with BPM application as user jstein.\n");
    }

    public IBPMOrganizationService getBPMOrganizationService() {
        if (this.orgService != null) {
            return this.orgService;
        }
        throw new RuntimeException("Reference to IBPMOrganizationService is NULL. Test case runner not initialized.");
    }

    public IBPMUserAuthenticationService getBPMUserAuthenticationService() {
        if (this.authService != null) {
            return this.authService;
        }
        throw new RuntimeException("Reference to IBPMUserAuthorizationService is NULL. Test case runner not initialized");
    }

    private static String getQualifiedClassAndMethodName() {
        StackTraceElement[] traceArray = Thread.currentThread().getStackTrace();
        if (traceArray.length == 4) {
            StackTraceElement element = traceArray[3];
            String className = element.getClassName();
            String methodName = element.getMethodName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(className).append(".").append(methodName).append(" >> ");
            element = traceArray[2];
            methodName = element.getMethodName();
            buffer.append(methodName).append(" >> ");
            return buffer.toString();
        }
        if (traceArray.length == 3) {
            StackTraceElement element = traceArray[2];
            String className = element.getClassName();
            String methodName = element.getMethodName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(className).append(".").append(methodName).append(" >> ");
            return buffer.toString();
        }
        return "AbstractExtendedUserPropertiesPersistenceTest >> ";
    }

    public void addMultiValuedFreeformStringProperties() throws Exception {
        try {
            ParticipantProperty partProp = this.objectFactory.createParticipantProperty();
            partProp.setName("Performance_Rating");
            partProp.setPropertyType("FREEFORM_STRING");
            partProp.setIsMultiValued(true);
            this.getBPMOrganizationService().createParticipantProperty(this.ctx, partProp);
            System.out.println("Successfully created FREEFORM_STRING property called Performance_Rating\n");
            partProp = this.objectFactory.createParticipantProperty();
            partProp.setName("Customer_Feedback");
            partProp.setPropertyType("FREEFORM_STRING");
            partProp.setIsMultiValued(true);
            this.getBPMOrganizationService().createParticipantProperty(this.ctx, partProp);
            System.out.println("Successfully created FREEFORM_STRING property called Customer_Feedback\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setFreeformStringPropertiesOnParticipants() throws BPMOrganizationException {
        try {
            PrincipleRefType part1 = this.objectFactory.createPrincipleRefType();
            part1.setName("jstein");
            part1.setType(ParticipantTypeEnum.USER);
            part1.setRealm("jazn.com");
            ParticipantProperty partProp = this.objectFactory.createParticipantProperty();
            partProp.setName("Performance_Rating");
            partProp.setPropertyType("FREEFORM_STRING");
            List values = partProp.getValue();
            values.add("Downright Lazy");
            values.add("Slacker");
            ParticipantProperty partProp2 = this.objectFactory.createParticipantProperty();
            partProp2.setName("Customer_Feedback");
            partProp2.setPropertyType("FREEFORM_STRING");
            values = partProp2.getValue();
            values.add("Poor Product");
            values.add("Couldn't get any worse");
            ParticipantProperties properties = this.objectFactory.createParticipantProperties();
            properties.setParticipant(part1);
            properties.getParticipantProperty().add(partProp);
            properties.getParticipantProperty().add(partProp2);
            PrincipleRefType part2 = this.objectFactory.createPrincipleRefType();
            part2.setName("jcooper");
            part2.setType(ParticipantTypeEnum.USER);
            part2.setRealm("jazn.com");
            partProp = this.objectFactory.createParticipantProperty();
            partProp.setName("Performance_Rating");
            partProp.setPropertyType("FREEFORM_STRING");
            values = partProp.getValue();
            values.add("Extremely Brilliant");
            values.add("Hard Working");
            partProp2 = this.objectFactory.createParticipantProperty();
            partProp2.setName("Customer_Feedback");
            partProp2.setPropertyType("FREEFORM_STRING");
            values = partProp2.getValue();
            values.add("Gold Standard in Extended User Properties");
            values.add("Par Excellence");
            ParticipantProperties properties2 = this.objectFactory.createParticipantProperties();
            properties2.setParticipant(part2);
            properties2.getParticipantProperty().add(partProp);
            properties2.getParticipantProperty().add(partProp2);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            inputParticipantPropertiesList.add(properties2);
            this.getBPMOrganizationService().setPropertiesOnParticipants(this.ctx, inputParticipantPropertiesList);
            System.out.println("Successfully set the following FREEFORM_STRING properties on jstein\n");
            System.out.println("Performance_Rating -> Downright Lazy || Slacker\n");
            System.out.println("Customer_Feedback -> Poor Product || Couldn't get any worse\n\n");
            System.out.println("Press <enter> to continue\n\n\n");
            System.in.read();
            System.out.println("Successfully set the following FREEFORM_STRING properties on jcooper\n");
            System.out.println("Performance_Rating -> Extremely Brilliant || Hard Working\n");
            System.out.println("Customer_Feedback -> Gold Standard in Extended User Properties || Par Excellence\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    public void getAllDefinedProperties() throws BPMOrganizationException {
        try {
            List properties = this.getBPMOrganizationService().searchExtendedUserProperties(this.ctx, "*");
            for (ParticipantProperty pp : properties) {
                System.out.println("Default original name of the property is " + pp.getName() + "\n");
                System.out.println("Translated name in the client's current locale is " + pp.getLocalizedName() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = this.objectFactory.createParticipantProperty();
                partProp.setName("Performance_Rating");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(this.ctx, partProp, true);
                System.out.println("Successfully deleted property Performance_Rating as part of exit cleanup");
            }
            catch (Exception e) {}
            try {
                partProp = this.objectFactory.createParticipantProperty();
                partProp.setName("Customer_Feedback");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(this.ctx, partProp, true);
                System.out.println("Successfully deleted property Customer_Feedback as part of exit cleanup");
            }
            catch (Exception e) {}
            try {
                partProp = this.objectFactory.createParticipantProperty();
                partProp.setName("Lottery_Numbers");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(this.ctx, partProp, true);
                System.out.println("Successfully deleted property Lottery_Numbers as part of exit cleanup");
            }
            catch (Exception e) {}
            try {
                partProp = this.objectFactory.createParticipantProperty();
                partProp.setName("Miles Earned");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(this.ctx, partProp, true);
                System.out.println("Successfully deleted property Miles Earned as part of exit cleanup");
            }
            catch (Exception e) {}
        }
    }
}

