/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.test.servertest.ServerTestCase;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.PeopleQueryUtil;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PrincipleRefType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractPeopleQueryTest
extends ServerTestCase {
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static final String DIR = "oracle/bpm/services/organization/test/data/";
    public static final String REALM_NAME = null;
    public static final String DEMOADMIN = "demoadmin";
    public static final String PASSWORD = "welcome1";

    public AbstractPeopleQueryTest(String name) {
        super(name);
    }

    public abstract IBPMUserAuthenticationService getBPMUserAuthenticationService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanTestData() throws Exception {
        block1: {
            Connection conn = null;
            Statement stmt = null;
            if (stmt != null) {
                stmt.close();
            }
            if (conn == null) break block1;
            conn.close();
        }
    }

    public void testSetupData() {
        try {
            System.out.println("Cleaning any existing data...");
            AbstractPeopleQueryTest.cleanTestData();
            System.out.println("...done cleaning data");
        }
        catch (Exception e) {
            System.out.println("Exception setting up test data: " + e.getMessage());
            e.printStackTrace();
            AbstractPeopleQueryTest.fail((String)("Exception setting up test data: " + e.getMessage()));
        }
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchByAttributeQuery() {
        try {
            System.out.println("testSearchByAttributeQuery begin");
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            PeopleQuery query = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/SearchUsersByAttributeQuery.xml");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("$arg1", "cn");
            ctxMap.put("$arg2", "jcooper");
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> list = PeopleQueryUtil.execute(ctx, query, peopleQueryCtx);
            if (list.size() == 1) {
                AbstractPeopleQueryTest.assertEquals((String)"jcooper", (String)((PrincipleRefType)list.get(0).getValue()).getName());
            } else {
                AbstractPeopleQueryTest.fail((String)"testSearchByAttributeQuery query fails");
            }
        }
        catch (Exception e) {
            System.out.println("testSearchByAttributeQuery failed with exception: " + e.getMessage());
            e.printStackTrace();
            AbstractPeopleQueryTest.fail((String)("Exception performing testSearchByAttributeQuery: " + e.getMessage()));
        }
        finally {
            System.out.println("testSearchByAttributeQuery end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchByFilterQuery() {
        try {
            System.out.println("testSearchByFilterQuery begin");
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            PeopleQuery query = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/SearchUsersByFilterQuery.xml");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("$arg1", "cn");
            ctxMap.put("$arg2", "j*");
            ctxMap.put("$arg3", "uid");
            ctxMap.put("$arg4", "j*r");
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> list = PeopleQueryUtil.execute(ctx, query, peopleQueryCtx);
            if (list.size() == 1) {
                AbstractPeopleQueryTest.assertEquals((String)"jcooper", (String)((PrincipleRefType)list.get(0).getValue()).getName());
            } else {
                AbstractPeopleQueryTest.fail((String)"testSearchByFilterQuery query fails");
            }
        }
        catch (Exception e) {
            System.out.println("testSearchByFilterQuery failed with exception: ");
            AbstractPeopleQueryTest.fail((String)("Exception performing testSearchByFilterQuery: " + e.getMessage()));
        }
        finally {
            System.out.println("testSearchByFilterQuery end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryWithUserManager() {
        try {
            System.out.println("testQueryWithUserManager begin");
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            PeopleQuery query = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/ManagerQuery.xml");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("$arg1", "jcooper");
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> list = PeopleQueryUtil.execute(ctx, query, peopleQueryCtx);
            if (list.size() == 1) {
                AbstractPeopleQueryTest.assertEquals((String)"jstein", (String)((PrincipleRefType)list.get(0).getValue()).getName());
            } else {
                AbstractPeopleQueryTest.fail((String)"testQueryWithUserManager query fails");
            }
        }
        catch (Exception e) {
            System.out.println("testQueryWithUserManager failed with exception");
            AbstractPeopleQueryTest.fail((String)("Exception performing testQueryWithUserManager: " + e.getMessage()));
        }
        finally {
            System.out.println("testQueryWithUserManager end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserManagementChainQuery() {
        try {
            System.out.println("testUserManagementChainQuery begin");
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            PeopleQuery query = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/UserManagementChainQuery.xml");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("$arg1", "jcooper");
            ctxMap.put("$arg2", "wfaulk");
            ctxMap.put("$arg3", "CEO");
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> list = PeopleQueryUtil.execute(ctx, query, peopleQueryCtx);
            if (list.size() == 2) {
                AbstractPeopleQueryTest.assertEquals((String)"jstein", (String)((PrincipleRefType)list.get(0).getValue()).getName());
                AbstractPeopleQueryTest.assertEquals((String)"wfaulk", (String)((PrincipleRefType)list.get(1).getValue()).getName());
            } else {
                AbstractPeopleQueryTest.fail((String)"testUserManagementChainQuery query fails");
            }
        }
        catch (Exception e) {
            System.out.println("testUserManagementChainQuery failed with exception");
            AbstractPeopleQueryTest.fail((String)("Exception performing testUserManagementChainQuery: " + e.getMessage()));
        }
        finally {
            System.out.println("testUserManagementChainQuery end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReporteesQuery() {
        try {
            System.out.println("testReporteesQuery begin");
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            PeopleQuery query = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/ReporteesQuery.xml");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("$arg1", "jstein");
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> list = PeopleQueryUtil.execute(ctx, query, peopleQueryCtx);
            System.out.println("testReporteesQuery list=" + list);
            if (list.size() != 3) {
                AbstractPeopleQueryTest.fail((String)"testReporteesQuery query fails");
            }
            AbstractPeopleQueryTest.assertEquals((int)3, (int)list.size());
        }
        catch (Exception e) {
            System.out.println("testReporteesQuery failed with exception");
            AbstractPeopleQueryTest.fail((String)("Exception performing testReporteesQuery: " + e.getMessage()));
        }
        finally {
            System.out.println("testReporteesQuery end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppRoleGranteesQuery() {
        try {
            System.out.println("testAppRoleGranteesQuery begin");
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            PeopleQuery query = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/AppRoleGranteesQuery.xml");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("$arg1", "BPMWorkflowAdmin");
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> list = PeopleQueryUtil.execute(ctx, query, peopleQueryCtx);
            String user = null;
            boolean isAdminFound = false;
            System.out.print("testAppRoleGranteesQuery found the following users:");
            for (int i = 0; i < list.size(); ++i) {
                user = ((PrincipleRefType)list.get(i).getValue()).getName();
                System.out.println("      user[" + i + "]=" + user);
                if (!DEMOADMIN.equals(user)) continue;
                isAdminFound = true;
                break;
            }
            if (isAdminFound) {
                System.out.println("Admin is found");
                AbstractPeopleQueryTest.assertEquals((String)DEMOADMIN, (String)user);
            } else {
                AbstractPeopleQueryTest.fail((String)"testAppRoleGranteesQuery query fails. Admin is not found");
            }
        }
        catch (Exception e) {
            System.out.println("testAppRoleGranteesQuery failed with exception");
            AbstractPeopleQueryTest.fail((String)("Exception performing testAppRoleGranteesQuery: " + e.getMessage()));
        }
        finally {
            System.out.println("testAppRoleGranteesQuery end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupGranteesQuery() {
        try {
            System.out.println("testGroupGranteesQuery begin");
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            PeopleQuery peopleQuery = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/GroupGranteesQuery.xml");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("$arg1", "LoanAgentGroup");
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> list = PeopleQueryUtil.execute(ctx, peopleQuery, peopleQueryCtx);
            if (list.size() != 9) {
                AbstractPeopleQueryTest.fail((String)("testGroupGranteesQuery query fails. Gets " + list.size() + " assignees. Expected 9 assignee"));
            }
            AbstractPeopleQueryTest.assertEquals((int)9, (int)list.size());
        }
        catch (Exception e) {
            System.out.println("testGroupGranteesQuery failed with exception");
            AbstractPeopleQueryTest.fail((String)("Exception performing testAppRoleGranteesQuery: " + e.getMessage()));
        }
        finally {
            System.out.println("testGroupGranteesQuery end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPeopleQuery() {
        try {
            System.out.println("testPeopleQuery begin");
            String peopleQueryXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<peopleQuery xmlns=\"http://xmlns.oracle.com/bpm/lpg/peopleQuery\" timeout=\"0 0/1 * * *  ?\">\n      <reportees>\n          <user>jstein</user>\n          <level>1</level>\n      </reportees>\n</peopleQuery>";
            IBPMContext ctx = this.createWFContext(DEMOADMIN, PASSWORD, REALM_NAME);
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            List<Participant> list = PeopleQueryUtil.execute(ctx, peopleQueryXML, ctxMap);
            System.out.println("testPeopleQuery ends, list=" + list);
        }
        catch (Exception e) {
            System.out.println("testPeopleQuery failed with exception");
            AbstractPeopleQueryTest.fail((String)("Exception performing testPeopleQuery: " + e.getMessage()));
        }
        finally {
            System.out.println("testPeopleQuery end");
        }
    }

    public static PeopleQuery createReporteePeopleQuery() throws BPMOrganizationException {
        String peopleQueryXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<peopleQuery xmlns=\"http://xmlns.oracle.com/bpm/lpg/peopleQuery\" timeout=\"0 0/1 * * *  ?\">\n      <reportees>\n          <user>jstein</user>\n          <level>1</level>\n      </reportees>\n</peopleQuery>";
        return PeopleQueryUtil.getPeopleQueryFromXMLString(peopleQueryXML);
    }

    public static PeopleQuery createGranteePeopleQuery() throws BPMOrganizationException {
        PeopleQuery peopleQuery = AbstractPeopleQueryTest.getPeopleQuery("oracle/bpm/services/organization/test/data/GroupGranteesQuery.xml");
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        ctxMap.put("$arg1", "LoanAgentGroup");
        PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
        return PeopleQueryUtil.resolveRuntimeContext(peopleQuery, peopleQueryCtx);
    }

    public static Node createNodeFromFile(String file) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(AbstractPeopleQueryTest.getInputStreamFromClassLoader(file)));
        StringBuffer fileString = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            fileString.append(line);
            fileString.append("\n");
        }
        reader.close();
        Document doc = XMLUtil.parseDocumentFromXMLString((String)fileString.toString());
        return doc.getDocumentElement();
    }

    public static InputStream getInputStreamFromClassLoader(String fileName) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null) {
            throw new Exception("Can't read " + fileName);
        }
        return is;
    }

    public static PeopleQuery getPeopleQuery(String fileName) throws BPMOrganizationException {
        InputStream is = null;
        try {
            PeopleQuery peopleQuery;
            Node node = AbstractPeopleQueryTest.createNodeFromFile(fileName);
            PeopleQuery peopleQuery2 = peopleQuery = PeopleQueryUtil.getPeopleQuery(node);
            return peopleQuery2;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private IBPMContext createWFContext(String user, String password, String realm) throws BPMException {
        return this.getBPMUserAuthenticationService().authenticate(user, password.toCharArray(), realm);
    }
}

