/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.query.impl.QueryUtil;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.PeopleQueryUtil;
import oracle.bpm.services.organization.model.ClauseType;
import oracle.bpm.services.organization.model.ColumnType;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.Predicate;
import oracle.bpm.services.organization.model.PredicateJoinOperatorEnum;
import oracle.bpm.services.organization.model.PredicateOperationEnum;
import oracle.bpm.services.organization.model.PredicateType;
import oracle.bpm.services.organization.model.PrincipleListType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.persistency.BPMOrganizationServiceTableColumnDefinitions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractLogicalPeopleGroupTest
extends TestCase {
    private IBPMContext mBpmContext;
    private static final String TEST_DATA_DIR = "oracle/bpel/services/bpm/organization/test/data/";
    private static final String USER_JSTEIN = "jstein";
    private static final String USER_FKAFKA = "fkafka";
    private static final String USER_JCOOPER = "jcooper";
    private static final String IDTTY_CTXT = "jazn.com";
    private static ObjectFactory objectFactory = new ObjectFactory();

    public AbstractLogicalPeopleGroupTest(String testName) {
        super(testName);
    }

    public abstract IBPMOrganizationService getBPMOrganizationService();

    public abstract IBPMUserAuthenticationService getBPMUserAuthenticationService();

    protected void setUp() {
        try {
            this.mBpmContext = this.getBpmContext();
            this.purgeAllDefinedLogicalPeopleGroup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        try {
            this.mBpmContext = this.getBpmContext();
            this.purgeAllDefinedLogicalPeopleGroup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateLogicalPeopleGroup() {
        try {
            System.out.println("testCreateLogicalPeopleGroup begin");
            PeopleQuery peopleQuery = AbstractLogicalPeopleGroupTest.createReporteePeopleQuery();
            String name = "LPG-testCreateLogicalPeopleGroup";
            LogicalPeopleGroup lpg = this.createLogicalPeopleGroup(name, (PeopleQueryType)peopleQuery.getValue(), false);
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"Id is null", (Object)lpg.getId());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"CreatedDate is null", (Object)lpg.getCreatedDate());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"CreatedBy is null", (Object)lpg.getCreatedBy());
            System.out.println("testCreateLogicalPeopleGroup: get LPG By Id= " + lpg.getId());
            LogicalPeopleGroup doubleCheck = this.getBPMOrganizationService().getLogicalPeopleGroup(this.getBpmContext(), lpg.getId());
            System.out.println("testCreateLogicalPeopleGroup: got LPG By Id= " + doubleCheck.getId());
            AbstractLogicalPeopleGroupTest.assertEquals((String)lpg.getId(), (String)doubleCheck.getId());
            PrincipleListType plt = doubleCheck.getMembers();
            if (plt == null || plt != null && plt.getParticipant().size() == 0) {
                AbstractLogicalPeopleGroupTest.fail((String)"query fails. PeopleQuery is not executed by quartz");
            } else {
                List prtl = plt.getParticipant();
                System.out.println("LPG members: ");
                for (PrincipleRefType prt : prtl) {
                    System.out.println("  user:" + prt.getName() + "  realm: " + prt.getRealm());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("testCreateLogicalPeopleGroup failed with exception");
            AbstractLogicalPeopleGroupTest.fail((String)("testCreateLogicalPeopleGroup fails: " + e.getMessage()));
        }
        finally {
            System.out.println("testCreateLogicalPeopleGroup end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateLogicalPeopleGroup() {
        try {
            System.out.println("testUpdateLogicalPeopleGroup begin");
            PeopleQuery peopleQuery = AbstractLogicalPeopleGroupTest.createGranteePeopleQuery();
            String name = "LPG-testUpdateLogicalPeopleGroup";
            LogicalPeopleGroup lpg = this.createLogicalPeopleGroup(name, (PeopleQueryType)peopleQuery.getValue(), true);
            PrincipleListType plt = lpg.getMembers();
            if (plt == null || plt != null && plt.getParticipant().size() == 0) {
                AbstractLogicalPeopleGroupTest.fail((String)"Query fails. PeopleQuery is not executed");
            } else {
                List prtl = plt.getParticipant();
                System.out.println("      PeopelQuery members (LoanAgentGroupGrantees):");
                for (PrincipleRefType prt : prtl) {
                    System.out.println("   user:" + prt.getName() + "  realm: " + prt.getRealm());
                }
            }
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"Id is null", (Object)lpg.getId());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"CreatedDate is null", (Object)lpg.getCreatedDate());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"CreatedBy is null", (Object)lpg.getCreatedBy());
            LogicalPeopleGroup lpgForUpdate = this.getBPMOrganizationService().getLogicalPeopleGroup(this.getBpmContext(), lpg.getId());
            peopleQuery = AbstractLogicalPeopleGroupTest.createReporteePeopleQuery();
            lpgForUpdate.setPeopleQuery((PeopleQueryType)peopleQuery.getValue());
            LogicalPeopleGroup updatedLpg = this.getBPMOrganizationService().updateLogicalPeopleGroup(this.getBpmContext(), lpgForUpdate, true);
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"Updated LogicalPeopleGroup object is null ", (Object)updatedLpg);
            PeopleQueryUtil.print("Updated LogicalPeopleGroup", updatedLpg);
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"Id is null", (Object)updatedLpg.getId());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"CreatedDate is null", (Object)updatedLpg.getCreatedDate());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"CreatedBy is null", (Object)updatedLpg.getCreatedBy());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"UpdatedDate is null", (Object)updatedLpg.getLastUpdatedDate());
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"UpdatedBy is null", (Object)updatedLpg.getLastUpdatedBy());
            plt = updatedLpg.getMembers();
            if (plt == null || plt != null && plt.getParticipant().size() == 0) {
                AbstractLogicalPeopleGroupTest.fail((String)"Qery fails. PeopleQuery is not executed");
            } else {
                List prtl = plt.getParticipant();
                System.out.println("PeopelQuery members after update (jstein reportees):");
                for (PrincipleRefType prt : prtl) {
                    System.out.println("  user: " + prt.getName() + "  realm: " + prt.getRealm());
                }
            }
        }
        catch (Exception e) {
            System.out.println("testUpdateLogicalPeopleGroup failed with exception: " + e.getMessage());
            e.printStackTrace();
            AbstractLogicalPeopleGroupTest.fail((String)("Exception performing testUpdateLogicalPeopleGroup: " + e.getMessage()));
        }
        finally {
            System.out.println("testUpdateLogicalPeopleGroup end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteLogicalPeopleGroup() {
        try {
            System.out.println("testDeleteLogicalPeopleGroup begin");
            PeopleQuery peopleQuery = AbstractLogicalPeopleGroupTest.createGranteePeopleQuery();
            String name = "LPG-testDeleteLogicalPeopleGroup";
            LogicalPeopleGroup lpg = this.createLogicalPeopleGroup(name, (PeopleQueryType)peopleQuery.getValue(), true);
            this.getBPMOrganizationService().deleteLogicalPeopleGroup(this.mBpmContext, lpg.getId(), false);
            LogicalPeopleGroup lpgNotFound = null;
            try {
                System.out.println("testDeleteLogicalPeopleGroup find lpg:" + lpg.getId());
                lpgNotFound = this.getBPMOrganizationService().getLogicalPeopleGroup(this.getBpmContext(), lpg.getId());
            }
            catch (Exception e) {
                AbstractLogicalPeopleGroupTest.assertNull(lpgNotFound);
                System.out.println("testDeleteLogicalPeopleGroup  indeed no such gpoup:" + lpg.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("testDeleteLogicalPeopleGroup failed with exception");
            AbstractLogicalPeopleGroupTest.fail((String)("Exception performing testDeleteLogicalPeopleGroup: " + e.getMessage()));
        }
        finally {
            System.out.println("testDeleteLogicalPeopleGroup end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllLogicalPeopleGroups() {
        try {
            System.out.println("testGetAllLogicalPeopleGroups begin");
            PeopleQuery peopleQuery = AbstractLogicalPeopleGroupTest.createGranteePeopleQuery();
            String name = "LPG-testGetAllLogicalPeopleGroups";
            for (int i = 0; i < 2; ++i) {
                String lpgName = name + "-" + i;
                LogicalPeopleGroup lpg = this.createLogicalPeopleGroup(lpgName, (PeopleQueryType)peopleQuery.getValue(), true);
                PrincipleListType plt = lpg.getMembers();
                if (plt == null || plt != null && plt.getParticipant().size() == 0) {
                    AbstractLogicalPeopleGroupTest.fail((String)"query fails. PeopleQuery is not executed");
                    continue;
                }
                List prtl = plt.getParticipant();
                System.out.println("PeopelQuery members:");
                for (PrincipleRefType prt : prtl) {
                    System.out.println("  user:" + prt.getName() + "  realm: " + prt.getRealm());
                }
            }
            System.out.println("testGetAllLogicalPeopleGroups: get all  LPGs");
            List list = this.getBPMOrganizationService().searchLogicalPeopleGroups(this.getBpmContext(), SearchModeTypeEnum.LIKE, "%", 0, -1);
            System.out.println("Found the following LogicalPeopleGroups , size=" + list.size());
            for (LogicalPeopleGroup l : list) {
                PeopleQueryUtil.print("Found registred LogicalPeoleGroup", l);
            }
            AbstractLogicalPeopleGroupTest.assertEquals((String)"List size is not 2", (int)2, (int)list.size());
            System.out.println("testGetAllLogicalPeopleGroups: get all LPG is done");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("testGetAllLogicalPeopleGroups failed with exception");
            AbstractLogicalPeopleGroupTest.fail((String)("testGetAllLogicalPeopleGroups fails: " + e.getMessage()));
        }
        finally {
            System.out.println("testGetAllLogicalPeopleGroups end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchLogicalPeopleGroups() {
        try {
            System.out.println("testSearchLogicalPeopleGroups begin");
            PeopleQuery peopleQuery = AbstractLogicalPeopleGroupTest.createReporteePeopleQuery();
            String name = "LPG-testSearchLogicalPeopleGroups";
            for (int i = 0; i < 2; ++i) {
                String lpgName = name + "-" + i;
                LogicalPeopleGroup lpg = this.createLogicalPeopleGroup(lpgName, (PeopleQueryType)peopleQuery.getValue(), true);
                PrincipleListType plt = lpg.getMembers();
                if (plt == null || plt != null && plt.getParticipant().size() == 0) {
                    AbstractLogicalPeopleGroupTest.fail((String)"query fails. PeopleQuery is not executed");
                    continue;
                }
                List prtl = plt.getParticipant();
                System.out.println("PeopelQuery members:");
                for (PrincipleRefType prt : prtl) {
                    System.out.println("  user:" + prt.getName() + "  realm: " + prt.getRealm());
                }
            }
            LogicalPeopleGroup lpg = this.createLogicalPeopleGroup("Different-" + name, (PeopleQueryType)peopleQuery.getValue(), true);
            System.out.println("testSearchLogicalPeopleGroups: get all LPGs");
            List list = this.getBPMOrganizationService().searchLogicalPeopleGroups(this.getBpmContext(), SearchModeTypeEnum.STARTS_WITH, name, 0, -1);
            System.out.println("Found the following LogicalPeopleGroups , size=:" + list.size());
            for (LogicalPeopleGroup l : list) {
                PeopleQueryUtil.print("          ", l);
            }
            AbstractLogicalPeopleGroupTest.assertEquals((String)"Result list size is not 2", (int)2, (int)list.size());
            System.out.println("testSearchLogicalPeopleGroups is done. Found " + list.size() + " lpgs");
        }
        catch (Exception e) {
            System.out.println("testSearchLogicalPeopleGroups failed with exception");
            AbstractLogicalPeopleGroupTest.fail((String)("testSearchLogicalPeopleGroups fails: " + e.getMessage()));
        }
        finally {
            System.out.println("testSearchLogicalPeopleGroups end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLogicalPeopleGroupsForUser() {
        try {
            System.out.println("testGetLogicalPeopleGroupsForUser begin");
            PeopleQuery peopleQuery = AbstractLogicalPeopleGroupTest.createReporteePeopleQuery();
            PrincipleRefType byUser = null;
            String name = "LPG-testGetLogicalPeopleGroupsForUser";
            for (int i = 0; i < 2; ++i) {
                String lpgName = name + "-" + i;
                LogicalPeopleGroup lpg = this.createLogicalPeopleGroup(lpgName, (PeopleQueryType)peopleQuery.getValue(), true);
                PrincipleListType plt = lpg.getMembers();
                if (plt == null || plt != null && plt.getParticipant().size() == 0) {
                    AbstractLogicalPeopleGroupTest.fail((String)"query fails. PeopleQuery is not executed");
                    continue;
                }
                List prtl = plt.getParticipant();
                System.out.println("PeopelQuery members:");
                for (PrincipleRefType prt : prtl) {
                    System.out.println("  user:" + prt.getName() + "  realm: " + prt.getRealm());
                    if (!prt.getName().equals(USER_JCOOPER)) continue;
                    byUser = prt;
                }
            }
            AbstractLogicalPeopleGroupTest.assertNotNull((String)"byUser is not found", byUser);
            System.out.println("testGetLogicalPeopleGroupsForUser: get LPG for user" + byUser.getName());
            List list = this.getBPMOrganizationService().getLogicalPeopleGroupsForUser(this.getBpmContext(), byUser);
            System.out.println("Found the following LogicalPeopleGroups , size=:" + list.size());
            for (LogicalPeopleGroup l : list) {
                PeopleQueryUtil.print("     ", l);
            }
            AbstractLogicalPeopleGroupTest.assertEquals((String)"Result list size is not 2", (int)2, (int)list.size());
            System.out.println("testGetLogicalPeopleGroupsForUser: get LPG is done");
        }
        catch (Exception e) {
            System.out.println("testGetLogicalPeopleGroupsForUser failed with exception");
            AbstractLogicalPeopleGroupTest.fail((String)("testGetLogicalPeopleGroupsForUser fails: " + e.getMessage()));
        }
        finally {
            System.out.println("testGetLogicalPeopleGroupsForUser end");
        }
    }

    public void testSearchParticipantsWithStringProperties() throws BPMOrganizationException {
        try {
            System.out.println("testSearchParticipantsWithStringProperties begin");
            this.createStringPropertiesOnParticipants(this.getBpmContext());
            if (this.getBpmContext() == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            Predicate predicate = AbstractLogicalPeopleGroupTest.createPredicate();
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jstein = objectFactory.createPrincipleRefType();
            jstein.setName(USER_JSTEIN);
            jstein.setRealm(IDTTY_CTXT);
            jstein.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            inputParticipantList.add(new Participant(jstein));
            inputParticipantList.add(new Participant(jcooper));
            List outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(this.getBpmContext(), inputParticipantList, predicate, 1, 1000);
            if (outputPartList.size() == 0) {
                System.out.println("In testSearchParticipantsWithStringProperties  Size of List<Participant> is 0");
                AbstractLogicalPeopleGroupTest.fail((String)"Size of retrieved Participant list is 0. Test failed.");
            }
            System.out.println("testSearchParticipantsWithStringProperties found the following users " + outputPartList + " who has specified properties");
            ArrayList<Participant> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(jstein));
            expectedParticipantList.add(new Participant(jcooper));
            AbstractLogicalPeopleGroupTest.assertEqualityOfParticipants("testSearchParticipantsWithStringProperties", expectedParticipantList, outputPartList);
            System.out.println("testSearchParticipantsWithStringProperties found " + outputPartList.size() + " users with properties");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("testSearchParticipantsWithStringProperties >> " + e.getMessage());
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                this.deleteStringProperties();
            }
            catch (Exception e) {}
            System.out.println("testSearchParticipantsWithStringProperties end");
        }
    }

    public void testLPGAppRoleAndExtProperties() throws BPMOrganizationException {
        try {
            System.out.println("testLPGAppRoleAndExtProperties begin");
            this.createStringPropertiesOnParticipants(this.getBpmContext());
            if (this.getBpmContext() == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            PeopleQuery peopleQuery = AbstractLogicalPeopleGroupTest.createAppRoleWithPropertyPeopleQuery();
            System.out.println("testLPGAppRoleAndExtProperties peopleQuery: \n" + BPMOrganizationUtil.getJaxbObjectXMLAsString(peopleQuery));
            String name = "LPG-testLPGAppRoleAndExtProperties";
            LogicalPeopleGroup lpg = this.createLogicalPeopleGroup(name, (PeopleQueryType)peopleQuery.getValue(), true);
            System.out.println("testLPGAppRoleAndExtProperties: get LPG By Id= " + lpg.getId());
            LogicalPeopleGroup doubleCheck = this.getBPMOrganizationService().getLogicalPeopleGroup(this.getBpmContext(), lpg.getId());
            System.out.println("testLPGAppRoleAndExtProperties: doubleCheck's Id= " + doubleCheck.getId());
            AbstractLogicalPeopleGroupTest.assertEquals((String)lpg.getId(), (String)doubleCheck.getId());
            PrincipleListType plt = doubleCheck.getMembers();
            if (plt == null || plt != null && plt.getParticipant().size() == 0) {
                AbstractLogicalPeopleGroupTest.fail((String)"query fails. PeopleQuery is not executed");
            }
            ArrayList<Participant> outputPartList = new ArrayList<Participant>();
            List prtl = plt.getParticipant();
            System.out.println("LPG Members:");
            for (PrincipleRefType prt : prtl) {
                System.out.println("  user:" + prt.getName() + "  realm: " + prt.getRealm());
                outputPartList.add(new Participant(prt));
            }
            PrincipleRefType fkafka = objectFactory.createPrincipleRefType();
            fkafka.setName(USER_FKAFKA);
            fkafka.setRealm(IDTTY_CTXT);
            fkafka.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            if (outputPartList.size() == 0) {
                System.out.println("In testLPGAppRoleAndExtProperties  Size of List<Participant> is 0");
                AbstractLogicalPeopleGroupTest.fail((String)"Size of retrieved Participant list is 0. Test failed.");
            }
            System.out.println("testLPGAppRoleAndExtProperties found the following users " + outputPartList + " who has specified properties");
            ArrayList<Participant> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(fkafka));
            expectedParticipantList.add(new Participant(jcooper));
            AbstractLogicalPeopleGroupTest.assertEqualityOfParticipants("testLPGAppRoleAndExtProperties", expectedParticipantList, outputPartList);
            System.out.println("testLPGAppRoleAndExtProperties found the following users " + outputPartList + " who has specified properties");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("testLPGAppRoleAndExtProperties >> " + e.getMessage());
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                this.deleteStringProperties();
            }
            catch (Exception e) {}
            System.out.println("testLPGAppRoleAndExtProperties end");
        }
    }

    private static Predicate createPredicate() {
        ColumnType skillColumn = objectFactory.createColumnType();
        skillColumn.setColumnName("SKILL");
        skillColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
        ColumnType locationColumn = objectFactory.createColumnType();
        locationColumn.setColumnName("LOCATION");
        locationColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
        ClauseType skillJavaClause = objectFactory.createClauseType();
        skillJavaClause.setColumn(skillColumn);
        skillJavaClause.setOperator(PredicateOperationEnum.LIKE);
        skillJavaClause.setValue("%Java%");
        ClauseType skillCobolClause = objectFactory.createClauseType();
        skillCobolClause.setColumn(skillColumn);
        skillCobolClause.setOperator(PredicateOperationEnum.EQ);
        skillCobolClause.setValue("COBOL");
        skillCobolClause.setJoinOperator(PredicateJoinOperatorEnum.OR);
        ClauseType locationBostonClause = objectFactory.createClauseType();
        locationBostonClause.setColumn(locationColumn);
        locationBostonClause.setOperator(PredicateOperationEnum.LIKE);
        locationBostonClause.setValue("%Boston%");
        locationBostonClause.setJoinOperator(PredicateJoinOperatorEnum.OR);
        PredicateType predicateType = objectFactory.createPredicateType();
        List listOfClauses = predicateType.getClause();
        listOfClauses.add(skillJavaClause);
        listOfClauses.add(skillCobolClause);
        listOfClauses.add(locationBostonClause);
        Predicate predicate = new Predicate(predicateType);
        System.out.println("BPM Predicate: \n" + BPMOrganizationUtil.getJaxbObjectXMLAsString(predicate));
        return predicate;
    }

    private void purgeAllDefinedLogicalPeopleGroup() {
        try {
            List list = this.getBPMOrganizationService().searchLogicalPeopleGroups(this.mBpmContext, SearchModeTypeEnum.LIKE, "%", 0, -1);
            for (LogicalPeopleGroup lpg : list) {
                System.out.println("AbstractLogicalPeopleGroupTest::purgeAllDefinedLogicalPeopleGroup deleting lpd with name: " + lpg.getName() + " Id: " + lpg.getId());
                this.getBPMOrganizationService().deleteLogicalPeopleGroup(this.mBpmContext, lpg.getId(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("purgeAllDefinedLogicalPeopleGroup error");
        }
    }

    private void reportError(String errorMessage) {
        AbstractLogicalPeopleGroupTest.fail((String)errorMessage);
    }

    private void reportException(Exception exception) {
        AbstractLogicalPeopleGroupTest.fail((String)exception.toString());
    }

    private void print(LogicalPeopleGroup lpg) throws BPMOrganizationException {
        if (lpg != null) {
            System.out.println("Id:" + lpg.getId());
            System.out.println("Name:" + lpg.getName());
            System.out.println("PeopleQuery:" + PeopleQueryUtil.getPeopleQueryAsString(new PeopleQuery(lpg.getPeopleQuery())));
            PrincipleListType plt = lpg.getMembers();
            System.out.println("Member's List Size:" + (plt != null ? Integer.valueOf(plt.getParticipant().size()) : null));
            if (plt != null) {
                String msg = null;
                List list = plt.getParticipant();
                for (PrincipleRefType p : list) {
                    if (msg == null) {
                        msg = p.getName();
                        continue;
                    }
                    msg = msg + ", " + p.getName();
                }
                System.out.println("Members: " + msg);
            }
            System.out.println("CreatedBy         :" + lpg.getCreatedBy());
            System.out.println("CreatedByIdCxt    :" + lpg.getCreatedByIdentityContext());
            System.out.println("CreatedDate       :" + lpg.getCreatedDate());
            System.out.println("LastUpdatedBy     :" + lpg.getLastUpdatedBy());
            System.out.println("LastUpdatedByIdCxt:" + lpg.getLastUpdatedByIdentityContext());
            System.out.println("LastUpdatedDate   :" + lpg.getLastUpdatedDate());
        }
    }

    public IBPMContext getContext(String user) {
        try {
            return this.getBPMUserAuthenticationService().authenticate(user, "welcome1".toCharArray(), IDTTY_CTXT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LogicalPeopleGroup createLogicalPeopleGroup(String name, PeopleQueryType peopleQueryType, boolean isExecute) throws Exception {
        LogicalPeopleGroup lpg = objectFactory.createLogicalPeopleGroup();
        String id = Util.getGuid();
        lpg.setName(name);
        lpg.setPeopleQuery(peopleQueryType);
        lpg = this.getBPMOrganizationService().createLogicalPeopleGroup(this.mBpmContext, lpg, true);
        this.print(lpg);
        return lpg;
    }

    private IBPMContext getBpmContext() {
        if (this.mBpmContext != null) {
            return this.mBpmContext;
        }
        try {
            this.mBpmContext = this.getContext(TestUtil.TEST_SYSTEM_USER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mBpmContext;
    }

    private void createStringPropertiesOnParticipants(IBPMContext ctx) throws BPMOrganizationException {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.createMultiValuedStringProperties(ctx);
            PrincipleRefType participant1 = objectFactory.createPrincipleRefType();
            participant1.setName(USER_JSTEIN);
            participant1.setType(ParticipantTypeEnum.USER);
            participant1.setRealm(IDTTY_CTXT);
            ParticipantProperty participantProperty1 = objectFactory.createParticipantProperty();
            participantProperty1.setName("SKILL");
            participantProperty1.setPropertyType("STRING");
            participantProperty1.getValue().add("Java");
            participantProperty1.getValue().add("Fortran");
            ParticipantProperty participantProperty2 = objectFactory.createParticipantProperty();
            participantProperty2.setName("LOCATION");
            participantProperty2.setPropertyType("STRING");
            participantProperty2.getValue().add("San Francisco");
            participantProperty2.getValue().add("New York");
            ParticipantProperties properties1 = objectFactory.createParticipantProperties();
            properties1.setParticipant(participant1);
            properties1.getParticipantProperty().add(participantProperty1);
            properties1.getParticipantProperty().add(participantProperty2);
            PrincipleRefType participant2 = objectFactory.createPrincipleRefType();
            participant2.setName(USER_JCOOPER);
            participant2.setType(ParticipantTypeEnum.USER);
            participant2.setRealm(IDTTY_CTXT);
            ParticipantProperty participantProperty3 = objectFactory.createParticipantProperty();
            participantProperty3.setName("SKILL");
            participantProperty3.setPropertyType("STRING");
            participantProperty3.getValue().add("Fortran");
            ParticipantProperty participantProperty4 = objectFactory.createParticipantProperty();
            participantProperty4.setName("LOCATION");
            participantProperty4.setPropertyType("STRING");
            participantProperty4.getValue().add("Dallas");
            participantProperty4.getValue().add("Boston");
            ParticipantProperties properties2 = objectFactory.createParticipantProperties();
            properties2.setParticipant(participant2);
            properties2.getParticipantProperty().add(participantProperty3);
            properties2.getParticipantProperty().add(participantProperty4);
            PrincipleRefType participant3 = objectFactory.createPrincipleRefType();
            participant3.setName(USER_FKAFKA);
            participant3.setType(ParticipantTypeEnum.USER);
            participant3.setRealm(IDTTY_CTXT);
            ParticipantProperty participantProperty5 = objectFactory.createParticipantProperty();
            participantProperty5.setName("SKILL");
            participantProperty5.setPropertyType("STRING");
            participantProperty5.getValue().add("Oracle");
            ParticipantProperty participantProperty6 = objectFactory.createParticipantProperty();
            participantProperty6.setName("LOCATION");
            participantProperty6.setPropertyType("STRING");
            participantProperty6.getValue().add("Boston");
            participantProperty6.getValue().add("San Francisco");
            ParticipantProperties properties3 = objectFactory.createParticipantProperties();
            properties3.setParticipant(participant3);
            properties3.getParticipantProperty().add(participantProperty5);
            properties3.getParticipantProperty().add(participantProperty6);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties1);
            inputParticipantPropertiesList.add(properties2);
            inputParticipantPropertiesList.add(properties3);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    private void createMultiValuedStringProperties(IBPMContext ctx) throws Exception {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("Skill");
            partProp.setPropertyType("STRING");
            List values = partProp.getValue();
            values.add("Java");
            values.add("COBOL");
            values.add("Fortran");
            values.add("Oracle");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Location");
            partProp.setPropertyType("STRING");
            values = partProp.getValue();
            values.add("San Francisco");
            values.add("Dallas");
            values.add("Boston");
            values.add("New York");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractLogicalPeopleGroupTest.fail((String)e.getMessage());
        }
    }

    private void deleteStringProperties() throws Exception {
        try {
            ParticipantProperty partProp1 = objectFactory.createParticipantProperty();
            partProp1.setName("SKILL");
            partProp1.setPropertyType("STRING");
            this.getBPMOrganizationService().deleteParticipantProperty(this.getBpmContext(), partProp1, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("LOCATION");
            partProp2.setPropertyType("STRING");
            this.getBPMOrganizationService().deleteParticipantProperty(this.getBpmContext(), partProp2, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void assertEqualityOfParticipants(String test, List<Participant> expectedList, List<Participant> resultList) {
        HashMap<String, Object> expParticipantMap = new HashMap<String, Object>();
        HashMap<String, Object> actParticipantMap = new HashMap<String, Object>();
        System.out.println("Expected participant names: ");
        for (Participant pp : expectedList) {
            expParticipantMap.put(((PrincipleRefType)pp.getValue()).getName(), pp.getValue());
            System.out.println("                       " + ((PrincipleRefType)pp.getValue()).getName() + "\n");
        }
        System.out.println("Actual participant names: ");
        for (Participant pp : resultList) {
            actParticipantMap.put(((PrincipleRefType)pp.getValue()).getName(), pp.getValue());
            System.out.println("                       " + ((PrincipleRefType)pp.getValue()).getName() + "\n");
        }
        for (String name : expParticipantMap.keySet()) {
            PrincipleRefType actualParticipant = (PrincipleRefType)actParticipantMap.get(name);
            if (actualParticipant == null) {
                AbstractLogicalPeopleGroupTest.fail((String)("Expected Participant " + name + " not found in the result."));
                continue;
            }
            PrincipleRefType expectedParticipant = (PrincipleRefType)expParticipantMap.get(name);
            AbstractLogicalPeopleGroupTest.assertEquals((String)(test + ": participant realm mismatch"), (String)expectedParticipant.getRealm(), (String)actualParticipant.getRealm());
            AbstractLogicalPeopleGroupTest.assertEquals((String)(test + ": participant type mismatch"), (Object)expectedParticipant.getType(), (Object)actualParticipant.getType());
        }
    }

    public static String getPredicateAsString(Predicate predicate) throws BPMOrganizationException {
        try {
            Element element = QueryUtil.getElementFromJAXBObject((String)"query", (Object)predicate);
            return XMLUtil.toString((Node)element);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    private static PeopleQuery createReporteePeopleQuery() throws BPMOrganizationException {
        String peopleQueryXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<peopleQuery xmlns=\"http://xmlns.oracle.com/bpm/lpg/peopleQuery\" timeout=\"0 0/1 * * *  ?\">\n      <reportees>\n          <user>jstein</user>\n          <level>1</level>\n      </reportees>\n</peopleQuery>";
        return PeopleQueryUtil.getPeopleQueryFromXMLString(peopleQueryXML);
    }

    private static PeopleQuery createGranteePeopleQuery() throws BPMOrganizationException {
        String peopleQueryXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<peopleQuery xmlns=\"http://xmlns.oracle.com/bpm/lpg/peopleQuery\" timeout=\"0 0/1 * * *  ?\">\n      <grantees>\n          <group>LoanAgentGroup</group>\n          <direct>false</direct>\n      </grantees>\n</peopleQuery>";
        return PeopleQueryUtil.getPeopleQueryFromXMLString(peopleQueryXML);
    }

    private static PeopleQuery createAppRoleWithPropertyPeopleQuery() throws BPMOrganizationException {
        String peopleQueryXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<peopleQuery xmlns=\"http://xmlns.oracle.com/bpm/lpg/peopleQuery\"\n             xmlns:tq=\"http://xmlns.oracle.com/bpel/workflow/taskQuery\" timeout=\"0 0/1 * * *  ?\">\n      <grantees>\n        <role>DevTeam</role>\n        <application>SOATestDemoApp</application>\n        <direct>false</direct>\n      </grantees>\n      <tq:predicate>\n         <tq:clause ignoreCase=\"false\">\n           <tq:column tableName=\"BPM_EXT_USER_PROPERTY_VALUE\">\n              <tq:columnName>LOCATION</tq:columnName>\n          </tq:column>\n          <tq:operator>EQ</tq:operator>\n          <tq:value>Boston</tq:value>\n         </tq:clause>\n      </tq:predicate>\n</peopleQuery>";
        return PeopleQueryUtil.getPeopleQueryFromXMLString(peopleQueryXML);
    }
}

