/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.ClauseType;
import oracle.bpm.services.organization.model.ColumnType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.Predicate;
import oracle.bpm.services.organization.model.PredicateJoinOperatorEnum;
import oracle.bpm.services.organization.model.PredicateOperationEnum;
import oracle.bpm.services.organization.model.PredicateType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.ValueListType;
import oracle.bpm.services.organization.persistency.BPMOrganizationServiceTableColumnDefinitions;
import oracle.bpm.services.organization.persistency.PropertyValueTypeEnum;

public abstract class AbstractExtendedUserPropertiesPersistenceTest
extends TestCase {
    private static IBPMContext ctx;
    private static final String USER_JSTEIN = "demoadmin";
    private static final String PASSWORD_JSTEIN = "welcome1";
    private static final String USER_JCOOPER = "jcooper";
    private static final String IDTTY_CTXT = "jazn.com";
    private static ObjectFactory objectFactory;

    public AbstractExtendedUserPropertiesPersistenceTest(String name) {
        super(name);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName());
        System.setProperty("javax.xml.datatype.DatatypeFactory", "com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
    }

    public abstract IBPMOrganizationService getBPMOrganizationService();

    public abstract IBPMUserAuthenticationService getBPMUserAuthenticationService();

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractExtendedUserPropertiesPersistenceTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(AbstractExtendedUserPropertiesPersistenceTest.class);
        return suite;
    }

    public void setUp() throws Exception {
        try {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + " Creating Workflow context"));
            ctx = this.createContext(USER_JSTEIN);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + " Successfully created Workflow context"));
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            this.tearDown();
            throw e;
        }
    }

    public void tearDown() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddStringProperty() throws BPMOrganizationException {
        ParticipantProperty partProp1 = null;
        ParticipantProperty partProp2 = null;
        System.out.println("Entered testAddStringProperty() ...");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            partProp1 = objectFactory.createParticipantProperty();
            partProp1.setName("SKILL");
            partProp1.setPropertyType("STRING");
            List values = partProp1.getValue();
            values.add("Java");
            values.add("COBOL");
            values.add("C#");
            ArrayList<ParticipantProperty> properties = new ArrayList<ParticipantProperty>();
            properties.add(partProp1);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp1);
            partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("LOCATION");
            partProp2.setPropertyType("STRING");
            values = partProp2.getValue();
            values.add("California");
            values.add("Bangalore");
            values.add("Bombay");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp2);
            properties.add(partProp2);
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            if (result == null || result.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + "Retrieved list of Properties from the global table is 0"));
            }
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfStringParticipantProperty("testAddStringProperty", properties, result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
                throw new BPMOrganizationException(e);
            }
            catch (Throwable throwable) {
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
                }
                catch (Exception e1) {
                    // empty catch block
                }
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
                    throw throwable;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddFreeformStringProperty() throws BPMOrganizationException {
        ParticipantProperty partProp1 = null;
        ParticipantProperty partProp2 = null;
        System.out.println("Entered testAddFreeformStringProperty()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            partProp1 = objectFactory.createParticipantProperty();
            partProp1.setName("SKILL");
            partProp1.setPropertyType("FREEFORM_STRING");
            partProp1.setIsMultiValued(true);
            ArrayList<ParticipantProperty> properties = new ArrayList<ParticipantProperty>();
            properties.add(partProp1);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp1);
            partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("LOCATION");
            partProp2.setPropertyType("FREEFORM_STRING");
            partProp2.setIsMultiValued(false);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp2);
            properties.add(partProp2);
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            if (result == null || result.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + "Retrieved list of Properties from the global table is 0"));
            }
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfNumberDateAndFreeformStringParticipantProperty("testAddFreeformStringProperty", properties, result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
                throw new BPMOrganizationException(e);
            }
            catch (Throwable throwable) {
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
                    throw throwable;
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddNumberProperty() throws BPMOrganizationException {
        ParticipantProperty partProp1 = null;
        ParticipantProperty partProp2 = null;
        System.out.println("Entered testAddNumberProperty()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            partProp1 = objectFactory.createParticipantProperty();
            partProp1.setName("LICENSES_SOLD");
            partProp1.setPropertyType("NUMBER");
            ArrayList<ParticipantProperty> properties = new ArrayList<ParticipantProperty>();
            properties.add(partProp1);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp1);
            partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("EMPLOYEES_TERMINATED");
            partProp2.setPropertyType("NUMBER");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp2);
            properties.add(partProp2);
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfNumberDateAndFreeformStringParticipantProperty("testAddNumberProperty", properties, result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
                throw new BPMOrganizationException(e);
            }
            catch (Throwable throwable) {
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
                    throw throwable;
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddDateProperty() throws BPMOrganizationException {
        ParticipantProperty partProp1 = null;
        ParticipantProperty partProp2 = null;
        System.out.println("Entered testAddDateProperty()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            partProp1 = objectFactory.createParticipantProperty();
            partProp1.setName("HIRE_DATE");
            partProp1.setPropertyType("DATE");
            ArrayList<ParticipantProperty> properties = new ArrayList<ParticipantProperty>();
            properties.add(partProp1);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp1);
            partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("FIRE_DATE");
            partProp2.setPropertyType("DATE");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp2);
            properties.add(partProp2);
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfNumberDateAndFreeformStringParticipantProperty("testAddDateProperty", properties, result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
                throw new BPMOrganizationException(e);
            }
            catch (Throwable throwable) {
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
                    throw throwable;
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    public void testUpdatePropertyName() throws BPMOrganizationException {
        try {
            System.out.println("Entered testUpdatePropertyName()");
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddProperties();
            this.getBPMOrganizationService().updateParticipantPropertyName(ctx, "SKILL", "PROFICIENCY");
            this.getBPMOrganizationService().updateParticipantPropertyName(ctx, "LOCATION", "GEOGRAPHY");
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            ArrayList<ParticipantProperty> expectedList = new ArrayList<ParticipantProperty>();
            ParticipantProperty prop1 = objectFactory.createParticipantProperty();
            prop1.setName("PROFICIENCY");
            prop1.setPropertyType("STRING");
            List values = prop1.getValue();
            values.add("Java");
            expectedList.add(prop1);
            ParticipantProperty prop2 = objectFactory.createParticipantProperty();
            prop2.setName("GEOGRAPHY");
            prop2.setPropertyType("STRING");
            values = prop2.getValue();
            values.add("California");
            expectedList.add(prop2);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfStringParticipantProperty("testUpdatePropertName", expectedList, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("PROFICIENCY");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("GEOGRAPHY");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    public void testUpdatePropertyValue() throws BPMOrganizationException {
        try {
            System.out.println("Entered testUpdatePropertyValue()");
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateSetStringPropertiesOnParticipants();
            this.getBPMOrganizationService().updateParticipantPropertyValue(ctx, "SKILL", "Java", "Eiffel");
            this.getBPMOrganizationService().updateParticipantPropertyValue(ctx, "LOCATION", "California", "Hyderabad");
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            ArrayList<ParticipantProperty> expectedList = new ArrayList<ParticipantProperty>();
            ParticipantProperty prop1 = objectFactory.createParticipantProperty();
            prop1.setName("SKILL");
            prop1.setPropertyType("STRING");
            List values = prop1.getValue();
            values.add("COBOL");
            values.add("C#");
            values.add("Eiffel");
            expectedList.add(prop1);
            ParticipantProperty prop2 = objectFactory.createParticipantProperty();
            prop2.setName("LOCATION");
            prop2.setPropertyType("STRING");
            values = prop2.getValue();
            values.add("Bangalore");
            values.add("Bombay");
            values.add("Hyderabad");
            expectedList.add(prop2);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfStringParticipantProperty("testUpdatePropertyValue", expectedList, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Skill");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Location");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    public void testForceDeleteProperty() throws BPMOrganizationException {
        System.out.println("Entered testForceDeleteProperty()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddProperties();
            ParticipantProperty prop1 = objectFactory.createParticipantProperty();
            prop1.setName("SKILL");
            prop1.setPropertyType("STRING");
            List values = prop1.getValue();
            values.add("Java");
            ParticipantProperty prop2 = objectFactory.createParticipantProperty();
            prop2.setName("LOCATION");
            prop2.setPropertyType("STRING");
            values = prop2.getValue();
            values.add("California");
            PrincipleRefType part = objectFactory.createPrincipleRefType();
            part.setName(USER_JSTEIN);
            part.setType(ParticipantTypeEnum.USER);
            part.setRealm(IDTTY_CTXT);
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(prop1);
            properties.getParticipantProperty().add(prop2);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
            this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop1, true);
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            ArrayList<ParticipantProperty> expectedList = new ArrayList<ParticipantProperty>();
            expectedList.add(prop2);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfStringParticipantProperty("testForceDeleteProperty", expectedList, result);
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            inputParticipantList.add(new Participant(part));
            List retrievedParticipantPropertiesList = this.getBPMOrganizationService().getPropertiesOfParticipants(ctx, inputParticipantList);
            if (retrievedParticipantPropertiesList.size() == 0) {
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)"Participant has 1 property defined but none were retrieved successfully.");
            }
            properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(prop2);
            inputParticipantPropertiesList = new ArrayList();
            inputParticipantPropertiesList.add(properties);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties("testForceDeleteProperty", inputParticipantPropertiesList, retrievedParticipantPropertiesList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty prop1 = objectFactory.createParticipantProperty();
                prop1.setName("SKILL");
                prop1.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop1, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty prop2 = objectFactory.createParticipantProperty();
                prop2.setName("LOCATION");
                prop2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testGentleDeleteProperty() throws BPMOrganizationException {
        System.out.println("Entered testGentleDeleteProperty()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddProperties();
            ParticipantProperty prop1 = objectFactory.createParticipantProperty();
            prop1.setName("SKILL");
            prop1.setPropertyType("STRING");
            List values = prop1.getValue();
            values.add("Java");
            ParticipantProperty prop2 = objectFactory.createParticipantProperty();
            prop2.setName("LOCATION");
            prop2.setPropertyType("STRING");
            values = prop2.getValue();
            values.add("California");
            PrincipleRefType part = objectFactory.createPrincipleRefType();
            part.setName(USER_JSTEIN);
            part.setType(ParticipantTypeEnum.USER);
            part.setRealm(IDTTY_CTXT);
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(prop1);
            properties.getParticipantProperty().add(prop2);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
            try {
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop1, false);
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)"AbstractExtendedUserPropertiesPersistenceTest.testGentleDeleteProperty() >> Assigned property got deleted with force flag set to false.");
            }
            catch (Exception e) {
                List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
                ArrayList<ParticipantProperty> expectedList = new ArrayList<ParticipantProperty>();
                expectedList.add(prop1);
                expectedList.add(prop2);
                AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfStringParticipantProperty("testGentleDeleteProperty", expectedList, result);
                ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
                inputParticipantList.add(new Participant(part));
                List retrievedParticipantPropertiesList = this.getBPMOrganizationService().getPropertiesOfParticipants(ctx, inputParticipantList);
                if (retrievedParticipantPropertiesList.size() == 0) {
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)"Participant has 1 property defined but none were retrieved successfully.");
                }
                AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties("testGentleDeleteProperty", inputParticipantPropertiesList, retrievedParticipantPropertiesList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty prop1 = objectFactory.createParticipantProperty();
                prop1.setName("SKILL");
                prop1.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop1, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty prop2 = objectFactory.createParticipantProperty();
                prop2.setName("LOCATION");
                prop2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testForceDeletePropertyValue() throws BPMOrganizationException {
        System.out.println("Entered testForceDeletePropertyValue()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddMultiValuedStringProperties();
            ParticipantProperty prop1 = objectFactory.createParticipantProperty();
            prop1.setName("Skill");
            prop1.setPropertyType("STRING");
            List values = prop1.getValue();
            values.add("Java");
            ParticipantProperty prop2 = objectFactory.createParticipantProperty();
            prop2.setName("Location");
            prop2.setPropertyType("STRING");
            values = prop2.getValue();
            values.add("California");
            PrincipleRefType part = objectFactory.createPrincipleRefType();
            part.setName(USER_JSTEIN);
            part.setType(ParticipantTypeEnum.USER);
            part.setRealm(IDTTY_CTXT);
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(prop1);
            properties.getParticipantProperty().add(prop2);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
            this.getBPMOrganizationService().deleteParticipantPropertyValue(ctx, prop1, true);
            List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
            ArrayList<ParticipantProperty> expectedList = new ArrayList<ParticipantProperty>();
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("SKILL");
            partProp.setPropertyType("STRING");
            values = partProp.getValue();
            values.add("COBOL");
            values.add("C#");
            expectedList.add(partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("LOCATION");
            partProp.setPropertyType("STRING");
            values = partProp.getValue();
            values.add("California");
            values.add("Bangalore");
            values.add("Bombay");
            expectedList.add(partProp);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfMultiValuedParticipantProperty("testForceDeletePropertyValue", expectedList, result);
            System.out.println("Global property definitions match. Trying to match participants properties...");
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            inputParticipantList.add(new Participant(part));
            List retrievedParticipantPropertiesList = this.getBPMOrganizationService().getPropertiesOfParticipants(ctx, inputParticipantList);
            if (retrievedParticipantPropertiesList.size() == 0) {
                System.out.println("Participant has 1 property defined but none were retrieved successfully.");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)"Participant has 1 property defined but none were retrieved successfully.");
            }
            properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            prop2.setName("LOCATION");
            properties.getParticipantProperty().add(prop2);
            inputParticipantPropertiesList = new ArrayList();
            inputParticipantPropertiesList.add(properties);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties("testSetPropertiesOnParticipants", inputParticipantPropertiesList, retrievedParticipantPropertiesList);
            System.out.println("Properties on participants match.");
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty prop1 = objectFactory.createParticipantProperty();
                prop1.setName("Skill");
                prop1.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop1, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty prop2 = objectFactory.createParticipantProperty();
                prop2.setName("Location");
                prop2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testGentleDeletePropertyValue() throws BPMOrganizationException {
        System.out.println("Entered testGentleDeletePropertyValue()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddMultiValuedStringProperties();
            ParticipantProperty prop1 = objectFactory.createParticipantProperty();
            prop1.setName("SKILL");
            prop1.setPropertyType("STRING");
            List values = prop1.getValue();
            values.add("Java");
            ParticipantProperty prop2 = objectFactory.createParticipantProperty();
            prop2.setName("LOCATION");
            prop2.setPropertyType("STRING");
            values = prop2.getValue();
            values.add("California");
            PrincipleRefType part = objectFactory.createPrincipleRefType();
            part.setName(USER_JSTEIN);
            part.setType(ParticipantTypeEnum.USER);
            part.setRealm(IDTTY_CTXT);
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(prop1);
            properties.getParticipantProperty().add(prop2);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
            try {
                this.getBPMOrganizationService().deleteParticipantPropertyValue(ctx, prop1, false);
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)"AbstractExtendedUserPropertiesPersistenceTest.testGentleDeletePropertyValue() >> Assigned Property value got deleted with force flag set to false");
            }
            catch (Exception e) {
                List result = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "*");
                ArrayList<ParticipantProperty> expectedList = new ArrayList<ParticipantProperty>();
                ParticipantProperty partProp = objectFactory.createParticipantProperty();
                partProp.setName("SKILL");
                partProp.setPropertyType("STRING");
                values = partProp.getValue();
                values.add("Java");
                values.add("COBOL");
                expectedList.add(partProp);
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("LOCATION");
                partProp.setPropertyType("STRING");
                values = partProp.getValue();
                values.add("California");
                values.add("Bangalore");
                expectedList.add(partProp);
                AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfMultiValuedParticipantProperty("testGentleDeletePropertyValue", expectedList, result);
                ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
                inputParticipantList.add(new Participant(part));
                List retrievedParticipantPropertiesList = this.getBPMOrganizationService().getPropertiesOfParticipants(ctx, inputParticipantList);
                if (retrievedParticipantPropertiesList.size() == 0) {
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)"Participant has 1 property defined but none were retrieved successfully.");
                }
                properties = objectFactory.createParticipantProperties();
                properties.setParticipant(part);
                properties.getParticipantProperty().add(prop1);
                properties.getParticipantProperty().add(prop2);
                inputParticipantPropertiesList = new ArrayList();
                inputParticipantPropertiesList.add(properties);
                AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties("testSetPropertiesOnParticipants", inputParticipantPropertiesList, retrievedParticipantPropertiesList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty prop1 = objectFactory.createParticipantProperty();
                prop1.setName("SKILL");
                prop1.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop1, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty prop2 = objectFactory.createParticipantProperty();
                prop2.setName("LOCATION");
                prop2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, prop2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSetPropertiesOnParticipants() throws BPMOrganizationException {
        System.out.println("Entered testSetPropertiesOnParticipants()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddProperties();
            PrincipleRefType part = objectFactory.createPrincipleRefType();
            part.setName(USER_JSTEIN);
            part.setType(ParticipantTypeEnum.USER);
            part.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("SKILL");
            partProp.setPropertyType("STRING");
            partProp.getValue().add("Java");
            ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("LOCATION");
            partProp2.setPropertyType("STRING");
            partProp2.getValue().add("California");
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(partProp);
            properties.getParticipantProperty().add(partProp2);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            inputParticipantList.add(new Participant(part));
            List ParticipantPropertiesList2 = this.getBPMOrganizationService().getPropertiesOfParticipants(ctx, inputParticipantList);
            if (ParticipantPropertiesList2.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + "Size of retrieved list of properties is 0. Test failed."));
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + " Size of retrieved property list is 0. Test failed."));
            }
            for (ParticipantProperties partProps : ParticipantPropertiesList2) {
                List propList = partProps.getParticipantProperty();
                for (ParticipantProperty prop : propList) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + "Value of property " + prop.getName() + " is " + prop.getValue().get(0)));
                }
            }
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties("testSetPropertiesOnParticipants", inputParticipantPropertiesList, ParticipantPropertiesList2);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty partProp1 = objectFactory.createParticipantProperty();
                partProp1.setName("SKILL");
                partProp1.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp1, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
                partProp2.setName("LOCATION");
                partProp2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testGetPropertiesOfParticipants() throws BPMOrganizationException {
        System.out.println("Entered testGetPropertiesOfParticipants()");
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateSetStringPropertiesOnParticipants();
            PrincipleRefType part = objectFactory.createPrincipleRefType();
            part.setName(USER_JSTEIN);
            part.setType(ParticipantTypeEnum.USER);
            part.setRealm(IDTTY_CTXT);
            PrincipleRefType part2 = objectFactory.createPrincipleRefType();
            part2.setName(USER_JCOOPER);
            part2.setType(ParticipantTypeEnum.USER);
            part2.setRealm(IDTTY_CTXT);
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            inputParticipantList.add(new Participant(part));
            inputParticipantList.add(new Participant(part2));
            List retrievedParticipantPropertiesList = this.getBPMOrganizationService().getPropertiesOfParticipants(ctx, inputParticipantList);
            if (retrievedParticipantPropertiesList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + "Size of List<ParticipantProperties> is 0"));
                Exception e = new Exception(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + " Size of retrieved property list is 0. Test failed.");
                throw new BPMOrganizationException(e);
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("SKILL");
            partProp.setPropertyType("STRING");
            partProp.getValue().add("Java");
            partProp.getValue().add("C#");
            ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("LOCATION");
            partProp2.setPropertyType("STRING");
            partProp2.getValue().add("California");
            partProp2.getValue().add("Bangalore");
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(partProp);
            properties.getParticipantProperty().add(partProp2);
            ParticipantProperty partProp3 = objectFactory.createParticipantProperty();
            partProp3.setName("SKILL");
            partProp3.setPropertyType("STRING");
            partProp3.getValue().add("COBOL");
            partProp3.getValue().add("C#");
            ParticipantProperty partProp4 = objectFactory.createParticipantProperty();
            partProp4.setName("LOCATION");
            partProp4.setPropertyType("STRING");
            partProp4.getValue().add("Bangalore");
            partProp4.getValue().add("Bombay");
            ParticipantProperties properties2 = objectFactory.createParticipantProperties();
            properties2.setParticipant(part2);
            properties2.getParticipantProperty().add(partProp3);
            properties2.getParticipantProperty().add(partProp4);
            ArrayList<ParticipantProperties> expectedParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            expectedParticipantPropertiesList.add(properties);
            expectedParticipantPropertiesList.add(properties2);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties("testGetPropertiesOfParticipants", expectedParticipantPropertiesList, retrievedParticipantPropertiesList);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> Successfully verified properties of Participant JSTEIN");
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty partProp = objectFactory.createParticipantProperty();
                partProp.setName("SKILL");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
                partProp2.setName("LOCATION");
                partProp2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSearchParticipantsWithStringProperties() throws BPMOrganizationException {
        System.out.println("Entered testSearchParticipantsWithStringProperties()");
        try {
            this.privateSetStringPropertiesOnParticipants();
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ColumnType skillColumn = objectFactory.createColumnType();
            skillColumn.setColumnName("SKILL");
            skillColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType locationColumn = objectFactory.createColumnType();
            locationColumn.setColumnName("LOCATION");
            locationColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ClauseType skillJavaClause = objectFactory.createClauseType();
            skillJavaClause.setColumn(skillColumn);
            skillJavaClause.setOperator(PredicateOperationEnum.LIKE);
            skillJavaClause.setValue("%Java%");
            ClauseType skillCobolClause = objectFactory.createClauseType();
            skillCobolClause.setColumn(skillColumn);
            skillCobolClause.setOperator(PredicateOperationEnum.EQ);
            skillCobolClause.setValue("COBOL");
            skillCobolClause.setJoinOperator(PredicateJoinOperatorEnum.OR);
            ClauseType locationBangaloreClause = objectFactory.createClauseType();
            locationBangaloreClause.setColumn(locationColumn);
            locationBangaloreClause.setOperator(PredicateOperationEnum.LIKE);
            locationBangaloreClause.setValue("%Bangalore%");
            locationBangaloreClause.setJoinOperator(PredicateJoinOperatorEnum.OR);
            PredicateType predicateType = objectFactory.createPredicateType();
            List listOfClauses = predicateType.getClause();
            listOfClauses.add(skillJavaClause);
            listOfClauses.add(skillCobolClause);
            listOfClauses.add(locationBangaloreClause);
            Predicate predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jstein = objectFactory.createPrincipleRefType();
            jstein.setName(USER_JSTEIN);
            jstein.setRealm(IDTTY_CTXT);
            jstein.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            inputParticipantList.add(new Participant(jstein));
            inputParticipantList.add(new Participant(jcooper));
            List outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            ArrayList<Participant> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(jstein));
            expectedParticipantList.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithStringProperties", expectedParticipantList, outputPartList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty partProp = objectFactory.createParticipantProperty();
                partProp.setName("SKILL");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
                partProp2.setName("LOCATION");
                partProp2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSearchParticipantsBug9410894String() throws BPMOrganizationException {
        System.out.println("Entered testSearchParticipantsBug9410894String()");
        try {
            this.privateSetStringPropertiesOnParticipants();
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ColumnType locationColumn = objectFactory.createColumnType();
            locationColumn.setColumnName("LOCATION");
            locationColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ClauseType locationBombayClause = objectFactory.createClauseType();
            locationBombayClause.setColumn(locationColumn);
            locationBombayClause.setOperator(PredicateOperationEnum.EQ);
            locationBombayClause.setValue("Bombay");
            PredicateType predicateType = objectFactory.createPredicateType();
            List listOfClauses = predicateType.getClause();
            listOfClauses.add(locationBombayClause);
            Predicate predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jstein = objectFactory.createPrincipleRefType();
            jstein.setName(USER_JSTEIN);
            jstein.setRealm(IDTTY_CTXT);
            jstein.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            inputParticipantList.add(new Participant(jstein));
            inputParticipantList.add(new Participant(jcooper));
            List outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() != 1) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testSearchParticipantsBug9410894String() >> Size of List<Participant> is not 1");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testSearchParticipantsBug9410894String() >> Size of retrieved Participant list is not 1. Test failed."));
            }
            for (Participant outPartcpnt : outputPartList) {
                System.out.println("Output Participant : " + ((PrincipleRefType)outPartcpnt.getValue()).getName());
            }
            ArrayList<Participant> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsBug9410894String", expectedParticipantList, outputPartList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testSearchParticipantsBug9410894String() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                ParticipantProperty partProp = objectFactory.createParticipantProperty();
                partProp.setName("SKILL");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
                partProp2.setName("LOCATION");
                partProp2.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp2, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSearchParticipantsWithFreeformStringProperties() throws BPMOrganizationException {
        System.out.println("Entered testSearchParticipantsWithFreeformStringProperties()");
        try {
            this.privateSetFreeformStringPropertiesOnParticipants();
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jstein = objectFactory.createPrincipleRefType();
            jstein.setName(USER_JSTEIN);
            jstein.setRealm(IDTTY_CTXT);
            jstein.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            inputParticipantList.add(new Participant(jstein));
            inputParticipantList.add(new Participant(jcooper));
            ColumnType perfRatingColumn = objectFactory.createColumnType();
            perfRatingColumn.setColumnName("Performance Rating");
            perfRatingColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType custFeedbackColumn = objectFactory.createColumnType();
            custFeedbackColumn.setColumnName("Customer Feedback");
            custFeedbackColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType lotteryNumbersColumn = objectFactory.createColumnType();
            lotteryNumbersColumn.setColumnName("Lottery Numbers");
            lotteryNumbersColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType milesEarnedColumn = objectFactory.createColumnType();
            milesEarnedColumn.setColumnName("Miles Earned");
            milesEarnedColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ClauseType perfRatingLazyClause = objectFactory.createClauseType();
            perfRatingLazyClause.setColumn(perfRatingColumn);
            perfRatingLazyClause.setOperator(PredicateOperationEnum.LIKE);
            perfRatingLazyClause.setValue("%lazy");
            ClauseType milesEarned10000Clause = objectFactory.createClauseType();
            milesEarned10000Clause.setColumn(milesEarnedColumn);
            milesEarned10000Clause.setOperator(PredicateOperationEnum.GTE);
            milesEarned10000Clause.setValue("10000");
            milesEarned10000Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            PredicateType predicateType1 = objectFactory.createPredicateType();
            List listOfClauses1 = predicateType1.getClause();
            listOfClauses1.add(perfRatingLazyClause);
            listOfClauses1.add(milesEarned10000Clause);
            ClauseType custFeedbackPoorClause = objectFactory.createClauseType();
            custFeedbackPoorClause.setColumn(custFeedbackColumn);
            custFeedbackPoorClause.setOperator(PredicateOperationEnum.LIKE);
            custFeedbackPoorClause.setValue("poor%");
            custFeedbackPoorClause.setIgnoreCase(true);
            ClauseType lotteryNumbers4934732Clause = objectFactory.createClauseType();
            lotteryNumbers4934732Clause.setColumn(lotteryNumbersColumn);
            lotteryNumbers4934732Clause.setOperator(PredicateOperationEnum.EQ);
            lotteryNumbers4934732Clause.setValue("4934732");
            lotteryNumbers4934732Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            PredicateType predicateType2 = objectFactory.createPredicateType();
            List listOfClauses2 = predicateType2.getClause();
            listOfClauses2.add(custFeedbackPoorClause);
            listOfClauses2.add(lotteryNumbers4934732Clause);
            PredicateType finalPredicateType = objectFactory.createPredicateType();
            finalPredicateType.setLhs(predicateType1);
            finalPredicateType.setRhs(predicateType2);
            finalPredicateType.setLogicalOperator(PredicateJoinOperatorEnum.OR);
            Predicate finalPredicate = new Predicate(finalPredicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + finalPredicate.toString()));
            System.out.println("Selecting participants with the following predicate\n" + finalPredicate.toString() + "\n");
            System.out.println("\nExpected participant name is demoadmin\n");
            List outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, finalPredicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            for (Participant p : outputPartList) {
                System.out.println("\nActual participant name retrieved from the database is " + ((PrincipleRefType)p.getValue()).getName() + "\n");
            }
            ArrayList<Object> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(jstein));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithStringProperties", expectedParticipantList, outputPartList);
            ClauseType perfRatingBrilliantClause = objectFactory.createClauseType();
            perfRatingBrilliantClause.setColumn(perfRatingColumn);
            perfRatingBrilliantClause.setOperator(PredicateOperationEnum.LIKE);
            perfRatingBrilliantClause.setValue("%brilliant");
            perfRatingBrilliantClause.setIgnoreCase(true);
            ClauseType milesEarned98767Clause = objectFactory.createClauseType();
            milesEarned98767Clause.setColumn(milesEarnedColumn);
            milesEarned98767Clause.setOperator(PredicateOperationEnum.LIKE);
            milesEarned98767Clause.setValue("98767%");
            milesEarned98767Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType1 = objectFactory.createPredicateType();
            listOfClauses1 = predicateType1.getClause();
            listOfClauses1.add(perfRatingBrilliantClause);
            listOfClauses1.add(milesEarned98767Clause);
            ClauseType custFeedbackGoldClause = objectFactory.createClauseType();
            custFeedbackGoldClause.setColumn(custFeedbackColumn);
            custFeedbackGoldClause.setOperator(PredicateOperationEnum.LIKE);
            custFeedbackGoldClause.setValue("%Standard%");
            ClauseType lotteryNumbersABC24432324Clause = objectFactory.createClauseType();
            lotteryNumbersABC24432324Clause.setColumn(lotteryNumbersColumn);
            lotteryNumbersABC24432324Clause.setOperator(PredicateOperationEnum.IN);
            lotteryNumbersABC24432324Clause.setValue("ABC24432324");
            lotteryNumbersABC24432324Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType2 = objectFactory.createPredicateType();
            listOfClauses2 = predicateType2.getClause();
            listOfClauses2.add(custFeedbackGoldClause);
            listOfClauses2.add(lotteryNumbersABC24432324Clause);
            finalPredicateType = objectFactory.createPredicateType();
            finalPredicateType.setLhs(predicateType1);
            finalPredicateType.setRhs(predicateType2);
            finalPredicateType.setLogicalOperator(PredicateJoinOperatorEnum.OR);
            finalPredicate = new Predicate(finalPredicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + finalPredicate.toString()));
            System.out.println("Selecting participants with the following predicate\n" + finalPredicate.toString() + "\n");
            System.out.println("\nExpected participant name is jcooper\n");
            outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, finalPredicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            for (Participant p : outputPartList) {
                System.out.println("\nActual participant name retrieved from the database is " + ((PrincipleRefType)p.getValue()).getName() + "\n");
            }
            expectedParticipantList = new ArrayList();
            expectedParticipantList.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithStringProperties", expectedParticipantList, outputPartList);
            ClauseType perfRatingSlackerClause = objectFactory.createClauseType();
            perfRatingSlackerClause.setColumn(perfRatingColumn);
            perfRatingSlackerClause.setOperator(PredicateOperationEnum.LIKE);
            perfRatingSlackerClause.setValue("%slacker%");
            ClauseType perfRatingHard_WorkingClause = objectFactory.createClauseType();
            perfRatingHard_WorkingClause.setColumn(perfRatingColumn);
            perfRatingHard_WorkingClause.setOperator(PredicateOperationEnum.EQ);
            perfRatingHard_WorkingClause.setValue("hard working");
            perfRatingHard_WorkingClause.setJoinOperator(PredicateJoinOperatorEnum.OR);
            predicateType1 = objectFactory.createPredicateType();
            listOfClauses1 = predicateType1.getClause();
            listOfClauses1.add(perfRatingSlackerClause);
            listOfClauses1.add(perfRatingHard_WorkingClause);
            Predicate finalPredicate2 = new Predicate(predicateType1);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + finalPredicate2.toString()));
            System.out.println("Selecting participants with the following predicate\n" + finalPredicate2.toString() + "\n");
            System.out.println("\nExpected participant name is demoadmin and jcooper\n");
            List outputPartList2 = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, finalPredicate2, 1, Integer.MAX_VALUE);
            if (outputPartList2.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            for (Participant p : outputPartList2) {
                System.out.println("\nActual participant name retrieved from the database is " + ((PrincipleRefType)p.getValue()).getName() + "\n");
            }
            ArrayList<Object> expectedParticipantList2 = new ArrayList<Participant>();
            expectedParticipantList2.add(new Participant(jstein));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithStringProperties", expectedParticipantList2, outputPartList2);
            ClauseType custFeedbackPoorClause2 = objectFactory.createClauseType();
            custFeedbackPoorClause2.setColumn(custFeedbackColumn);
            custFeedbackPoorClause2.setOperator(PredicateOperationEnum.LIKE);
            custFeedbackPoorClause2.setValue("%Product");
            ClauseType custFeedbackGoldClause2 = objectFactory.createClauseType();
            custFeedbackGoldClause2.setColumn(custFeedbackColumn);
            custFeedbackGoldClause2.setOperator(PredicateOperationEnum.LIKE);
            custFeedbackGoldClause2.setValue("Par%");
            custFeedbackGoldClause2.setJoinOperator(PredicateJoinOperatorEnum.OR);
            PredicateType finalPredicateType2 = objectFactory.createPredicateType();
            List listOfClauses = finalPredicateType2.getClause();
            listOfClauses.add(custFeedbackPoorClause2);
            listOfClauses.add(custFeedbackGoldClause2);
            finalPredicate2 = new Predicate(finalPredicateType2);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + finalPredicate2.toString()));
            System.out.println("Selecting participants with the following predicate\n" + finalPredicate2.toString() + "\n");
            System.out.println("\nExpected participant name is demoadmin and jcooper\n");
            outputPartList2 = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, finalPredicate2, 1, Integer.MAX_VALUE);
            if (outputPartList2.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            for (Participant p : outputPartList2) {
                System.out.println("\nActual participant name retrieved from the database is " + ((PrincipleRefType)p.getValue()).getName() + "\n");
            }
            expectedParticipantList2 = new ArrayList();
            expectedParticipantList2.add(new Participant(jstein));
            expectedParticipantList2.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithStringProperties", expectedParticipantList2, outputPartList2);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Performance Rating");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Customer Feedback");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Lottery Numbers");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Miles Earned");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSearchParticipantsWithFreeformStringPropertiesUsingIN_NOTIN_OPERATORS2() throws BPMOrganizationException {
        System.out.println("Entered testSearchParticipantsWithFreeformStringPropertiesUsingIN_NOTIN_OPERATORS2()");
        try {
            this.privateSetFreeformStringPropertiesOnParticipants();
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jstein = objectFactory.createPrincipleRefType();
            jstein.setName(USER_JSTEIN);
            jstein.setRealm(IDTTY_CTXT);
            jstein.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            inputParticipantList.add(new Participant(jstein));
            inputParticipantList.add(new Participant(jcooper));
            ColumnType perfRatingColumn = objectFactory.createColumnType();
            perfRatingColumn.setColumnName("Performance Rating");
            perfRatingColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType custFeedbackColumn = objectFactory.createColumnType();
            custFeedbackColumn.setColumnName("Customer Feedback");
            custFeedbackColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType lotteryNumbersColumn = objectFactory.createColumnType();
            lotteryNumbersColumn.setColumnName("Lottery Numbers");
            lotteryNumbersColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType milesEarnedColumn = objectFactory.createColumnType();
            milesEarnedColumn.setColumnName("Miles Earned");
            milesEarnedColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ClauseType perfRatingClause = objectFactory.createClauseType();
            perfRatingClause.setColumn(perfRatingColumn);
            perfRatingClause.setOperator(PredicateOperationEnum.IN);
            ValueListType valueListType1 = objectFactory.createValueListType();
            valueListType1.getValue().add("Slacker");
            valueListType1.getValue().add("Downright Lazy");
            perfRatingClause.setValueList(valueListType1);
            PredicateType predicateType1 = objectFactory.createPredicateType();
            List listOfClauses1 = predicateType1.getClause();
            listOfClauses1.add(perfRatingClause);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate in the test case class is \n" + new Predicate(predicateType1).toString()));
            System.out.println("Selecting participants with the following predicate\n" + new Predicate(predicateType1).toString() + "\n");
            System.out.println("\nExpected participant name is demoadmin\n");
            List outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, new Predicate(predicateType1), 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testSearchParticipantsWithFreeformStringPropertiesUsingIN_NOTIN_OPERATORS() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testSearchParticipantsWithFreeformStringPropertiesUsingIN_NOTIN_OPERATORS() >> Size of retrieved Participant list is 0. Test failed."));
            }
            for (Participant p : outputPartList) {
                System.out.println("\nActual participant name retrieved from the database is " + ((PrincipleRefType)p.getValue()).getName() + "\n");
            }
            ArrayList<Participant> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(jstein));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithStringProperties", expectedParticipantList, outputPartList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Performance Rating");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Customer Feedback");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Lottery Numbers");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Miles Earned");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSearchParticipantsWithDateProperties() throws BPMOrganizationException {
        System.out.println("Entered testSearchParticipantsWithDateProperties()");
        String datatypeFactory = System.getProperty("javax.xml.datatype.DatatypeFactory");
        System.out.println(datatypeFactory);
        try {
            this.privateSetDatePropertiesOnParticipants();
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ColumnType hireDateColumn = objectFactory.createColumnType();
            hireDateColumn.setColumnName("HIRE_DATE");
            hireDateColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType fireDateColumn = objectFactory.createColumnType();
            fireDateColumn.setColumnName("FIRE_DATE");
            fireDateColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jstein = objectFactory.createPrincipleRefType();
            jstein.setName(USER_JSTEIN);
            jstein.setRealm(IDTTY_CTXT);
            jstein.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            inputParticipantList.add(new Participant(jstein));
            inputParticipantList.add(new Participant(jcooper));
            ClauseType hireDate01_01_1800_Clause = objectFactory.createClauseType();
            hireDate01_01_1800_Clause.setColumn(hireDateColumn);
            hireDate01_01_1800_Clause.setOperator(PredicateOperationEnum.GT);
            XMLGregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar.setYear(1800);
            calendar.setMonth(1);
            calendar.setDay(1);
            hireDate01_01_1800_Clause.setDateValue(calendar);
            PredicateType predicateType = objectFactory.createPredicateType();
            List listOfClauses = predicateType.getClause();
            listOfClauses.add(hireDate01_01_1800_Clause);
            Predicate predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            List outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            ArrayList<Object> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(jstein));
            expectedParticipantList.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList, outputPartList);
            hireDate01_01_1800_Clause = objectFactory.createClauseType();
            hireDate01_01_1800_Clause.setColumn(hireDateColumn);
            hireDate01_01_1800_Clause.setOperator(PredicateOperationEnum.LT);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar.setYear(1800);
            calendar.setMonth(1);
            calendar.setDay(1);
            hireDate01_01_1800_Clause.setDateValue(calendar);
            predicateType = objectFactory.createPredicateType();
            listOfClauses = predicateType.getClause();
            listOfClauses.add(hireDate01_01_1800_Clause);
            predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            expectedParticipantList = new ArrayList();
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList, outputPartList);
            ClauseType hireDate05_05_2003_Clause = objectFactory.createClauseType();
            hireDate05_05_2003_Clause.setColumn(hireDateColumn);
            hireDate05_05_2003_Clause.setOperator(PredicateOperationEnum.GT);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar.setYear(2003);
            calendar.setMonth(5);
            calendar.setDay(5);
            hireDate05_05_2003_Clause.setDateValue(calendar);
            predicateType = objectFactory.createPredicateType();
            listOfClauses = predicateType.getClause();
            listOfClauses.add(hireDate05_05_2003_Clause);
            predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            expectedParticipantList = new ArrayList();
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList, outputPartList);
            ClauseType fireDate10_10_1990_Clause = objectFactory.createClauseType();
            fireDate10_10_1990_Clause.setColumn(fireDateColumn);
            fireDate10_10_1990_Clause.setOperator(PredicateOperationEnum.GTE);
            XMLGregorianCalendar calendar1 = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar1.setYear(1990);
            calendar1.setMonth(10);
            calendar1.setDay(10);
            fireDate10_10_1990_Clause.setDateValue(calendar1);
            ClauseType fireDate12_12_2020_Clause = objectFactory.createClauseType();
            fireDate12_12_2020_Clause.setColumn(fireDateColumn);
            fireDate12_12_2020_Clause.setOperator(PredicateOperationEnum.LTE);
            XMLGregorianCalendar calendar2 = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar2.setYear(2020);
            calendar2.setMonth(12);
            calendar2.setDay(12);
            fireDate12_12_2020_Clause.setDateValue(calendar2);
            fireDate12_12_2020_Clause.setJoinOperator(PredicateJoinOperatorEnum.OR);
            PredicateType predicateType2 = objectFactory.createPredicateType();
            List listOfClauses2 = predicateType2.getClause();
            listOfClauses2.add(fireDate10_10_1990_Clause);
            listOfClauses2.add(fireDate12_12_2020_Clause);
            Predicate predicate2 = new Predicate(predicateType2);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate2.toString()));
            List outputPartList2 = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate2, 1, Integer.MAX_VALUE);
            ArrayList<Object> expectedParticipantList2 = new ArrayList<Participant>();
            expectedParticipantList2.add(new Participant(jstein));
            expectedParticipantList2.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList2, outputPartList2);
            ClauseType hireDate11_11_1945_Clause = objectFactory.createClauseType();
            hireDate11_11_1945_Clause.setColumn(hireDateColumn);
            hireDate11_11_1945_Clause.setOperator(PredicateOperationEnum.GT);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar.setYear(1945);
            calendar.setMonth(11);
            calendar.setDay(11);
            hireDate11_11_1945_Clause.setDateValue(calendar);
            ClauseType fireDate01_01_2000_Clause = objectFactory.createClauseType();
            fireDate01_01_2000_Clause.setColumn(fireDateColumn);
            fireDate01_01_2000_Clause.setOperator(PredicateOperationEnum.LT);
            calendar2 = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar2.setYear(2000);
            calendar2.setMonth(1);
            calendar2.setDay(1);
            fireDate01_01_2000_Clause.setDateValue(calendar2);
            fireDate01_01_2000_Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType2 = objectFactory.createPredicateType();
            listOfClauses2 = predicateType2.getClause();
            listOfClauses2.add(fireDate01_01_2000_Clause);
            listOfClauses2.add(fireDate01_01_2000_Clause);
            predicate2 = new Predicate(predicateType2);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate2.toString()));
            outputPartList2 = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate2, 1, Integer.MAX_VALUE);
            expectedParticipantList2 = new ArrayList();
            expectedParticipantList2.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList2, outputPartList2);
            ClauseType hireDate01_01_1950_Clause = objectFactory.createClauseType();
            hireDate01_01_1950_Clause.setColumn(hireDateColumn);
            hireDate01_01_1950_Clause.setOperator(PredicateOperationEnum.EQ);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar.setYear(1950);
            calendar.setMonth(1);
            calendar.setDay(1);
            hireDate01_01_1950_Clause.setDateValue(calendar);
            ClauseType fireDate10_10_1990_Clause2 = objectFactory.createClauseType();
            fireDate10_10_1990_Clause2.setColumn(fireDateColumn);
            fireDate10_10_1990_Clause2.setOperator(PredicateOperationEnum.EQ);
            calendar2 = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar2.setYear(1990);
            calendar2.setMonth(10);
            calendar2.setDay(10);
            fireDate10_10_1990_Clause2.setDateValue(calendar2);
            fireDate10_10_1990_Clause2.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType2 = objectFactory.createPredicateType();
            listOfClauses2 = predicateType2.getClause();
            listOfClauses2.add(hireDate01_01_1950_Clause);
            listOfClauses2.add(fireDate10_10_1990_Clause2);
            predicate2 = new Predicate(predicateType2);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate2.toString()));
            outputPartList2 = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate2, 1, Integer.MAX_VALUE);
            expectedParticipantList2 = new ArrayList();
            expectedParticipantList2.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList2, outputPartList2);
            ClauseType hireDate12_12_2000_Clause = objectFactory.createClauseType();
            hireDate12_12_2000_Clause.setColumn(hireDateColumn);
            hireDate12_12_2000_Clause.setOperator(PredicateOperationEnum.EQ);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar.setYear(2000);
            calendar.setMonth(12);
            calendar.setDay(12);
            hireDate12_12_2000_Clause.setDateValue(calendar);
            fireDate12_12_2020_Clause = objectFactory.createClauseType();
            fireDate12_12_2020_Clause.setColumn(fireDateColumn);
            fireDate12_12_2020_Clause.setOperator(PredicateOperationEnum.EQ);
            calendar2 = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar2.setYear(2020);
            calendar2.setMonth(12);
            calendar2.setDay(12);
            fireDate12_12_2020_Clause.setDateValue(calendar2);
            fireDate12_12_2020_Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType2 = objectFactory.createPredicateType();
            listOfClauses2 = predicateType2.getClause();
            listOfClauses2.add(hireDate12_12_2000_Clause);
            listOfClauses2.add(fireDate12_12_2020_Clause);
            predicate2 = new Predicate(predicateType2);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate2.toString()));
            outputPartList2 = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate2, 1, Integer.MAX_VALUE);
            expectedParticipantList2 = new ArrayList();
            expectedParticipantList2.add(new Participant(jstein));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList2, outputPartList2);
            hireDate12_12_2000_Clause = objectFactory.createClauseType();
            hireDate12_12_2000_Clause.setColumn(hireDateColumn);
            hireDate12_12_2000_Clause.setOperator(PredicateOperationEnum.LT);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar.setYear(2000);
            calendar.setMonth(12);
            calendar.setDay(12);
            hireDate12_12_2000_Clause.setDateValue(calendar);
            ClauseType fireDate09_09_1990_Clause = objectFactory.createClauseType();
            fireDate09_09_1990_Clause.setColumn(fireDateColumn);
            fireDate09_09_1990_Clause.setOperator(PredicateOperationEnum.GT);
            calendar2 = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            calendar2.setYear(1990);
            calendar2.setMonth(9);
            calendar2.setDay(9);
            fireDate09_09_1990_Clause.setDateValue(calendar2);
            fireDate09_09_1990_Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType2 = objectFactory.createPredicateType();
            listOfClauses2 = predicateType2.getClause();
            listOfClauses2.add(hireDate12_12_2000_Clause);
            listOfClauses2.add(fireDate09_09_1990_Clause);
            predicate2 = new Predicate(predicateType2);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate2.toString()));
            outputPartList2 = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate2, 1, Integer.MAX_VALUE);
            expectedParticipantList2 = new ArrayList();
            expectedParticipantList2.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithDateProperties", expectedParticipantList2, outputPartList2);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("HIRE_DATE");
                partProp.setPropertyType("DATE");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("FIRE_DATE");
                partProp.setPropertyType("DATE");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSearchPropertyDefinitions() throws BPMOrganizationException {
        System.out.println("Entered testSearchPropertyDefinitions()");
        try {
            this.privateAddMultiValuedStringProperties2();
            List outputPartList = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "Skill");
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testSearchPropertyDefinitions() >> Size of List<ParticipantProperty> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testSearchPropertyDefinitions() >> Size of retrieved ParticipantProperty list is 0. Test failed."));
            }
            for (ParticipantProperty p : outputPartList) {
                System.out.println("\nActual ParticipantProperty name retrieved from the database is " + p.getName() + "\n");
            }
            ArrayList<Object> expectedParticipantPropertyList = new ArrayList<ParticipantProperty>();
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("PROGRAMATICALLYSKILLEDPERSON");
            partProp.setPropertyType("STRING");
            List values = partProp.getValue();
            values.add("Java");
            values.add("COBOL");
            values.add("C#");
            expectedParticipantPropertyList.add(partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("ORATORIALLY SKILLED PERSON");
            partProp.setPropertyType("STRING");
            values = partProp.getValue();
            values.add("Public Speaker");
            values.add("Public Convincer");
            values.add("Public Manipulator");
            expectedParticipantPropertyList.add(partProp);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfStringParticipantProperty("testSearchPropertyDefinitions", expectedParticipantPropertyList, outputPartList);
            outputPartList = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "LICENCES");
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testSearchPropertyDefinitions() >> Size of List<ParticipantProperty> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testSearchPropertyDefinitions() >> Size of retrieved ParticipantProperty list is 0. Test failed."));
            }
            for (ParticipantProperty p : outputPartList) {
                System.out.println("\nActual ParticipantProperty name retrieved from the database is " + p.getName() + "\n");
            }
            expectedParticipantPropertyList = new ArrayList();
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("LICENCES_SOLD");
            partProp.setPropertyType("NUMBER");
            expectedParticipantPropertyList.add(partProp);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfNumberDateAndFreeformStringParticipantProperty("testSearchPropertyDefinitions", expectedParticipantPropertyList, outputPartList);
            outputPartList = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "date");
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testSearchPropertyDefinitions() >> Size of List<ParticipantProperty> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testSearchPropertyDefinitions() >> Size of retrieved ParticipantProperty list is 0. Test failed."));
            }
            for (ParticipantProperty p : outputPartList) {
                System.out.println("\nActual ParticipantProperty name retrieved from the database is " + p.getName() + "\n");
            }
            expectedParticipantPropertyList = new ArrayList();
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("EXHIBITION DATE");
            partProp.setPropertyType("DATE");
            expectedParticipantPropertyList.add(partProp);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfNumberDateAndFreeformStringParticipantProperty("testSearchPropertyDefinitions", expectedParticipantPropertyList, outputPartList);
            outputPartList = this.getBPMOrganizationService().searchExtendedUserProperties(ctx, "feedback");
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testSearchPropertyDefinitions() >> Size of List<ParticipantProperty> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testSearchPropertyDefinitions() >> Size of retrieved ParticipantProperty list is 0. Test failed."));
            }
            for (ParticipantProperty p : outputPartList) {
                System.out.println("\nActual ParticipantProperty name retrieved from the database is " + p.getName() + "\n");
            }
            expectedParticipantPropertyList = new ArrayList();
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("CUSTOMER FEEDBACK");
            partProp.setPropertyType("FREEFORM_STRING");
            expectedParticipantPropertyList.add(partProp);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfNumberDateAndFreeformStringParticipantProperty("testSearchPropertyDefinitions", expectedParticipantPropertyList, outputPartList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("PROGRAMATICALLYSKILLEDPERSON");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("ORATORIALLY SKILLED PERSON");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("LICENCES_SOLD");
                partProp.setPropertyType("NUMBER");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("EXHIBITION DATE");
                partProp.setPropertyType("DATE");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("CUSTOMER FEEDBACK");
                partProp.setPropertyType("FREEFORM_STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    public void testGetParticipantsWithStringProperties() throws BPMOrganizationException {
        System.out.println("Entered testGetParticipantsWithStringProperties()");
        try {
            this.privateSetStringPropertiesOnParticipants();
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ArrayList<ParticipantProperty> inputPropertiesList = new ArrayList<ParticipantProperty>();
            ParticipantProperty prop1 = objectFactory.createParticipantProperty();
            ParticipantProperty prop3 = objectFactory.createParticipantProperty();
            prop1.setName("SKILL");
            prop1.getValue().add("Java");
            prop1.getValue().add("COBOL");
            prop3.setName("LOCATION");
            prop3.getValue().add("California");
            prop3.getValue().add("Bangalore");
            inputPropertiesList.add(prop1);
            inputPropertiesList.add(prop3);
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jsteinPrincipleRefType = objectFactory.createPrincipleRefType();
            jsteinPrincipleRefType.setName(USER_JSTEIN);
            jsteinPrincipleRefType.setRealm(IDTTY_CTXT);
            jsteinPrincipleRefType.setType(ParticipantTypeEnum.USER);
            Participant jstein = new Participant(jsteinPrincipleRefType);
            PrincipleRefType jcooperPrincipleRefType = objectFactory.createPrincipleRefType();
            jcooperPrincipleRefType.setName(USER_JCOOPER);
            jcooperPrincipleRefType.setRealm(IDTTY_CTXT);
            jcooperPrincipleRefType.setType(ParticipantTypeEnum.USER);
            Participant jcooper = new Participant(jcooperPrincipleRefType);
            inputParticipantList.add(jstein);
            inputParticipantList.add(jcooper);
            List outputPartList = this.getBPMOrganizationService().getParticipantsWithProperties(ctx, inputParticipantList, inputPropertiesList, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            ArrayList<Participant> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(jstein);
            expectedParticipantList.add(jcooper);
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testGetParticipantsWithProperties", expectedParticipantList, outputPartList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Skill");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("Location");
                partProp.setPropertyType("STRING");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    public void testSearchParticipantsWithNumberProperties() throws BPMOrganizationException {
        System.out.println("Entered testSearchParticipantsWithNumberProperties()");
        try {
            this.privateSetNumberPropertiesOnParticipants();
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ColumnType noOfSWCompaniesStartedColumn = objectFactory.createColumnType();
            noOfSWCompaniesStartedColumn.setColumnName("NO_OF_SOFTWARE_COMPANIES_STARTED");
            noOfSWCompaniesStartedColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType noOfCarsColumn = objectFactory.createColumnType();
            noOfCarsColumn.setColumnName("NO_OF_CARS_OWNED");
            noOfCarsColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType noOfHWCompaniesStartedColumn = objectFactory.createColumnType();
            noOfHWCompaniesStartedColumn.setColumnName("NO_OF_HARDWARE_COMPANIES_STARTED");
            noOfHWCompaniesStartedColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ColumnType noOfJetsOwnedColumn = objectFactory.createColumnType();
            noOfJetsOwnedColumn.setColumnName("NO_OF_JETS_OWNED");
            noOfJetsOwnedColumn.setTableName(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE.getName());
            ArrayList<Participant> inputParticipantList = new ArrayList<Participant>();
            PrincipleRefType jstein = objectFactory.createPrincipleRefType();
            jstein.setName(USER_JSTEIN);
            jstein.setRealm(IDTTY_CTXT);
            jstein.setType(ParticipantTypeEnum.USER);
            PrincipleRefType jcooper = objectFactory.createPrincipleRefType();
            jcooper.setName(USER_JCOOPER);
            jcooper.setRealm(IDTTY_CTXT);
            jcooper.setType(ParticipantTypeEnum.USER);
            inputParticipantList.add(new Participant(jstein));
            inputParticipantList.add(new Participant(jcooper));
            ClauseType noOfSWCompaniesStartedGT1Clause = objectFactory.createClauseType();
            noOfSWCompaniesStartedGT1Clause.setColumn(noOfSWCompaniesStartedColumn);
            noOfSWCompaniesStartedGT1Clause.setOperator(PredicateOperationEnum.GT);
            noOfSWCompaniesStartedGT1Clause.setValue("1");
            ClauseType noOfHWCompaniesStartedGT2Clause = objectFactory.createClauseType();
            noOfHWCompaniesStartedGT2Clause.setColumn(noOfHWCompaniesStartedColumn);
            noOfHWCompaniesStartedGT2Clause.setOperator(PredicateOperationEnum.GT);
            noOfHWCompaniesStartedGT2Clause.setValue("2");
            noOfHWCompaniesStartedGT2Clause.setJoinOperator(PredicateJoinOperatorEnum.OR);
            PredicateType predicateType = objectFactory.createPredicateType();
            List listOfClauses = predicateType.getClause();
            listOfClauses.add(noOfSWCompaniesStartedGT1Clause);
            listOfClauses.add(noOfHWCompaniesStartedGT2Clause);
            Predicate predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            List outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            ArrayList<Object> expectedParticipantList = new ArrayList<Participant>();
            expectedParticipantList.add(new Participant(jstein));
            expectedParticipantList.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithNumberProperties", expectedParticipantList, outputPartList);
            ClauseType noOfCarsLT10Clause = objectFactory.createClauseType();
            noOfCarsLT10Clause.setColumn(noOfCarsColumn);
            noOfCarsLT10Clause.setOperator(PredicateOperationEnum.LT);
            noOfCarsLT10Clause.setValue("10");
            ClauseType noOfJetsOwnedLT4Clause = objectFactory.createClauseType();
            noOfJetsOwnedLT4Clause.setColumn(noOfJetsOwnedColumn);
            noOfJetsOwnedLT4Clause.setOperator(PredicateOperationEnum.LT);
            noOfJetsOwnedLT4Clause.setValue("4");
            noOfJetsOwnedLT4Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType = objectFactory.createPredicateType();
            listOfClauses = predicateType.getClause();
            listOfClauses.add(noOfCarsLT10Clause);
            listOfClauses.add(noOfJetsOwnedLT4Clause);
            predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            expectedParticipantList = new ArrayList();
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithNumberProperties", expectedParticipantList, outputPartList);
            noOfSWCompaniesStartedGT1Clause = objectFactory.createClauseType();
            noOfSWCompaniesStartedGT1Clause.setColumn(noOfSWCompaniesStartedColumn);
            noOfSWCompaniesStartedGT1Clause.setOperator(PredicateOperationEnum.GT);
            noOfSWCompaniesStartedGT1Clause.setValue("1");
            ClauseType noOfCarsGT10Clause = objectFactory.createClauseType();
            noOfCarsGT10Clause.setColumn(noOfCarsColumn);
            noOfCarsGT10Clause.setOperator(PredicateOperationEnum.GT);
            noOfCarsGT10Clause.setValue("10");
            noOfCarsGT10Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType = objectFactory.createPredicateType();
            listOfClauses = predicateType.getClause();
            listOfClauses.add(noOfSWCompaniesStartedGT1Clause);
            listOfClauses.add(noOfCarsGT10Clause);
            predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            expectedParticipantList = new ArrayList();
            expectedParticipantList.add(new Participant(jstein));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithNumberProperties", expectedParticipantList, outputPartList);
            ClauseType noOfHWCompaniesStartedGT4Clause = objectFactory.createClauseType();
            noOfHWCompaniesStartedGT4Clause.setColumn(noOfHWCompaniesStartedColumn);
            noOfHWCompaniesStartedGT4Clause.setOperator(PredicateOperationEnum.GT);
            noOfHWCompaniesStartedGT4Clause.setValue("4");
            ClauseType noOfJetsOwnedGT10Clause = objectFactory.createClauseType();
            noOfJetsOwnedGT10Clause.setColumn(noOfJetsOwnedColumn);
            noOfJetsOwnedGT10Clause.setOperator(PredicateOperationEnum.GT);
            noOfJetsOwnedGT10Clause.setValue("10");
            noOfJetsOwnedGT10Clause.setJoinOperator(PredicateJoinOperatorEnum.AND);
            predicateType = objectFactory.createPredicateType();
            listOfClauses = predicateType.getClause();
            listOfClauses.add(noOfHWCompaniesStartedGT4Clause);
            listOfClauses.add(noOfJetsOwnedGT10Clause);
            predicate = new Predicate(predicateType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Constructed predicate is \n" + predicate.toString()));
            outputPartList = this.getBPMOrganizationService().searchParticipantsWithProperties(ctx, inputParticipantList, predicate, 1, Integer.MAX_VALUE);
            if (outputPartList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOnParticipants() >> Size of List<Participant> is 0");
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)(((Object)((Object)this)).getClass().getCanonicalName() + ".testGetParticipantsWithPropertiesUsing() >> Size of retrieved Participant list is 0. Test failed."));
            }
            expectedParticipantList = new ArrayList();
            expectedParticipantList.add(new Participant(jcooper));
            AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipants("testSearchParticipantsWithNumberProperties", expectedParticipantList, outputPartList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("In AbstractExtendedUserPropertiesPersistenceTest.testGetPropertiesOfParticipants() >> " + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
        finally {
            ParticipantProperty partProp;
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("NO_OF_SOFTWARE_COMPANIES_STARTED");
                partProp.setPropertyType("NUMBER");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("NO_OF_HARDWARE_COMPANIES_STARTED");
                partProp.setPropertyType("NUMBER");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("NO_OF_CARS_OWNED");
                partProp.setPropertyType("NUMBER");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
            try {
                partProp = objectFactory.createParticipantProperty();
                partProp.setName("NO_OF_JETS_OWNED");
                partProp.setPropertyType("NUMBER");
                this.getBPMOrganizationService().deleteParticipantProperty(ctx, partProp, true);
            }
            catch (Exception e) {}
        }
    }

    private static String getQualifiedClassAndMethodName() {
        StackTraceElement[] traceArray = Thread.currentThread().getStackTrace();
        if (traceArray.length == 4) {
            StackTraceElement element = traceArray[3];
            String className = element.getClassName();
            String methodName = element.getMethodName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(className).append(".").append(methodName).append(" >> ");
            element = traceArray[2];
            methodName = element.getMethodName();
            buffer.append(methodName).append(" >> ");
            return buffer.toString();
        }
        if (traceArray.length == 3) {
            StackTraceElement element = traceArray[2];
            String className = element.getClassName();
            String methodName = element.getMethodName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(className).append(".").append(methodName).append(" >> ");
            return buffer.toString();
        }
        return "AbstractExtendedUserPropertiesPersistenceTest >> ";
    }

    private static void assertEqualityOfStringParticipantProperty(String test, List<ParticipantProperty> expectedList, List<ParticipantProperty> resultList) {
        if (expectedList.size() != resultList.size()) {
            String msg = "Expected property list size does not match actual property list size";
            StringBuffer buffer = new StringBuffer(msg);
            buffer.append("\nExpected Property List is \n");
            for (ParticipantProperty prop : expectedList) {
                buffer.append("Property Name ").append(prop.getName()).append("\n");
            }
            buffer.append("\nActual Property List is \n");
            for (ParticipantProperty prop : resultList) {
                buffer.append("Property Name ").append(prop.getName()).append("\n");
            }
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)buffer.toString());
        } else {
            HashMap<String, ParticipantProperty> expPropName_ParticipantPropertyMap = new HashMap<String, ParticipantProperty>();
            HashMap<String, ParticipantProperty> actPropName_ParticipantPropertyMap = new HashMap<String, ParticipantProperty>();
            for (ParticipantProperty pp : expectedList) {
                expPropName_ParticipantPropertyMap.put(pp.getName(), pp);
            }
            for (ParticipantProperty pp : resultList) {
                actPropName_ParticipantPropertyMap.put(pp.getName(), pp);
            }
            for (String propName : expPropName_ParticipantPropertyMap.keySet()) {
                ParticipantProperty act = (ParticipantProperty)actPropName_ParticipantPropertyMap.get(propName);
                if (act == null) {
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + propName + " not found in the retrieved list of properties."));
                    continue;
                }
                ParticipantProperty exp = (ParticipantProperty)expPropName_ParticipantPropertyMap.get(propName);
                AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": type mismatch"), (String)exp.getPropertyType(), (String)act.getPropertyType());
                AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": value mismatch"), exp.getValue().get(0), act.getValue().get(0));
            }
        }
    }

    private static void assertEqualityOfNumberDateAndFreeformStringParticipantProperty(String test, List<ParticipantProperty> expectedList, List<ParticipantProperty> resultList) {
        if (expectedList.size() != resultList.size()) {
            String msg = "Expected property list size does not match actual property list size";
            StringBuffer buffer = new StringBuffer(msg);
            buffer.append("\nExpected Property List is \n");
            for (ParticipantProperty prop : expectedList) {
                buffer.append("Property Name ").append(prop.getName()).append("\n");
            }
            buffer.append("\nActual Property List is \n");
            for (ParticipantProperty prop : resultList) {
                buffer.append("Property Name ").append(prop.getName()).append("\n");
            }
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)buffer.toString());
        } else {
            HashMap<String, ParticipantProperty> expPropName_ParticipantPropertyMap = new HashMap<String, ParticipantProperty>();
            HashMap<String, ParticipantProperty> actPropName_ParticipantPropertyMap = new HashMap<String, ParticipantProperty>();
            for (ParticipantProperty pp : expectedList) {
                expPropName_ParticipantPropertyMap.put(pp.getName(), pp);
            }
            for (ParticipantProperty pp : resultList) {
                actPropName_ParticipantPropertyMap.put(pp.getName(), pp);
            }
            for (String propName : expPropName_ParticipantPropertyMap.keySet()) {
                ParticipantProperty act = (ParticipantProperty)actPropName_ParticipantPropertyMap.get(propName);
                if (act == null) {
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + propName + " not found in the retrieved list of properties."));
                    continue;
                }
                ParticipantProperty exp = (ParticipantProperty)expPropName_ParticipantPropertyMap.get(propName);
                AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": type mismatch"), (String)exp.getPropertyType(), (String)act.getPropertyType());
            }
        }
    }

    private static void assertEqualityOfMultiValuedParticipantProperty(String test, List<ParticipantProperty> expectedList, List<ParticipantProperty> resultList) {
        System.out.println("In assertEqualityOfMultiValuedParticipantProperty()...");
        if (expectedList.size() != resultList.size()) {
            String msg = "Expected property list size does not match actual property list size";
            StringBuffer buffer = new StringBuffer(msg);
            buffer.append("\nExpected Property List is \n");
            for (ParticipantProperty prop : expectedList) {
                buffer.append("Property Name ").append(prop.getName()).append("\n");
            }
            buffer.append("\nActual Property List is \n");
            for (ParticipantProperty prop : resultList) {
                buffer.append("Property Name ").append(prop.getName()).append("\n");
            }
            System.out.println(buffer.toString());
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)buffer.toString());
        } else {
            HashMap<String, ParticipantProperty> expPropName_ParticipantPropertyMap = new HashMap<String, ParticipantProperty>();
            HashMap<String, ParticipantProperty> actPropName_ParticipantPropertyMap = new HashMap<String, ParticipantProperty>();
            for (ParticipantProperty pp : expectedList) {
                expPropName_ParticipantPropertyMap.put(pp.getName(), pp);
            }
            for (ParticipantProperty pp : resultList) {
                actPropName_ParticipantPropertyMap.put(pp.getName(), pp);
            }
            block10: for (String propName : expPropName_ParticipantPropertyMap.keySet()) {
                PropertyValueTypeEnum actpropType;
                ParticipantProperty act = (ParticipantProperty)actPropName_ParticipantPropertyMap.get(propName);
                if (act == null) {
                    System.out.println(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + propName + " not found in the retrieved list of properties.");
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + propName + " not found in the retrieved list of properties."));
                    continue;
                }
                ParticipantProperty exp = (ParticipantProperty)expPropName_ParticipantPropertyMap.get(propName);
                PropertyValueTypeEnum exppropType = PropertyValueTypeEnum.valueOf(exp.getPropertyType());
                if (!exppropType.equals((Object)(actpropType = PropertyValueTypeEnum.valueOf(act.getPropertyType())))) {
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)"AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfMultiValuedParticipantProperty() >> Actual and Expected property types do not match.");
                }
                switch (exppropType) {
                    case DATE: {
                        break;
                    }
                    case NUMBER: {
                        break;
                    }
                    case FREEFORM_STRING: {
                        break;
                    }
                    case STRING: {
                        for (int i1 = 0; i1 < exp.getValue().size(); ++i1) {
                            AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": Property value mismatch"), exp.getValue().get(i1), act.getValue().get(i1));
                        }
                        continue block10;
                    }
                    default: {
                        System.out.println("AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfMultiValuedParticipantProperty() >> Property type" + (Object)((Object)exppropType) + " defined is unknown.");
                        AbstractExtendedUserPropertiesPersistenceTest.fail((String)("AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfMultiValuedParticipantProperty() >> Property type" + (Object)((Object)exppropType) + " defined is unknown."));
                    }
                }
            }
        }
    }

    private static void assertEqualityOfParticipantProperties(String test, List<ParticipantProperties> expectedList, List<ParticipantProperties> resultList) {
        if (expectedList.size() != resultList.size()) {
            System.out.println("AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties() >> Expected ParticipantProperties list size and actual ParticipantProperties list size do not match");
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)"AbstractExtendedUserPropertiesPersistenceTest.assertEqualityOfParticipantProperties() >> Expected ParticipantProperties list size and actual ParticipantProperties list size do not match");
        } else {
            HashMap<String, PrincipleRefType> expParticipantMap = new HashMap<String, PrincipleRefType>();
            HashMap<PartNamePartTypePartRealmCompositeKey, ParticipantProperties> expParticipant_ParticipantPropertiesMap = new HashMap<PartNamePartTypePartRealmCompositeKey, ParticipantProperties>();
            HashMap<String, PrincipleRefType> actParticipantMap = new HashMap<String, PrincipleRefType>();
            HashMap<PartNamePartTypePartRealmCompositeKey, ParticipantProperties> actParticipant_ParticipantPropertiesMap = new HashMap<PartNamePartTypePartRealmCompositeKey, ParticipantProperties>();
            for (ParticipantProperties pp : expectedList) {
                PartNamePartTypePartRealmCompositeKey expKey = new PartNamePartTypePartRealmCompositeKey(pp.getParticipant().getName(), pp.getParticipant().getType().value(), pp.getParticipant().getRealm());
                expParticipant_ParticipantPropertiesMap.put(expKey, pp);
                expParticipantMap.put(pp.getParticipant().getName(), pp.getParticipant());
            }
            for (ParticipantProperties pp : resultList) {
                PartNamePartTypePartRealmCompositeKey actKey = new PartNamePartTypePartRealmCompositeKey(pp.getParticipant().getName(), pp.getParticipant().getType().value(), pp.getParticipant().getRealm());
                actParticipant_ParticipantPropertiesMap.put(actKey, pp);
                actParticipantMap.put(pp.getParticipant().getName(), pp.getParticipant());
            }
            for (String name : expParticipantMap.keySet()) {
                PrincipleRefType actualParticipant = (PrincipleRefType)actParticipantMap.get(name);
                if (actualParticipant == null) {
                    System.out.println("Expected Participant " + name + " not found in the result.");
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)("Expected Participant " + name + " not found in the result."));
                    continue;
                }
                System.out.println("Participant name found. Trying to match realm and type");
                PrincipleRefType expectedParticipant = (PrincipleRefType)expParticipantMap.get(name);
                AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": participant realm mismatch"), (String)expectedParticipant.getRealm(), (String)actualParticipant.getRealm());
                System.out.println("Participant realms match. Moving on to match participant types.");
                AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": participant type mismatch"), (Object)expectedParticipant.getType(), (Object)actualParticipant.getType());
                System.out.println("Participant types match.");
            }
            for (PartNamePartTypePartRealmCompositeKey compositeKey : expParticipant_ParticipantPropertiesMap.keySet()) {
                ParticipantProperty act;
                ParticipantProperty exp;
                ParticipantProperties expectedProperties = (ParticipantProperties)expParticipant_ParticipantPropertiesMap.get(compositeKey);
                ParticipantProperties actualProperties = (ParticipantProperties)actParticipant_ParticipantPropertiesMap.get(compositeKey);
                if (expectedProperties.getParticipantProperty().size() != actualProperties.getParticipantProperty().size()) {
                    ParticipantProperty property;
                    ParticipantProperty prop;
                    String msg = "Expected property list size does not match actual property list size for participant " + compositeKey.toString();
                    StringBuffer buffer = new StringBuffer(msg);
                    buffer.append("\nExpected Property List is \n");
                    Iterator i$ = expectedProperties.getParticipantProperty().iterator();
                    while (i$.hasNext()) {
                        property = prop = (ParticipantProperty)i$.next();
                        buffer.append("Property Name ").append(property.getName()).append("\n");
                    }
                    buffer.append("\nActual Property List is \n");
                    i$ = actualProperties.getParticipantProperty().iterator();
                    while (i$.hasNext()) {
                        property = prop = (ParticipantProperty)i$.next();
                        buffer.append("Property Name ").append(property.getName()).append("\n");
                    }
                    System.out.println(buffer.toString());
                    AbstractExtendedUserPropertiesPersistenceTest.fail((String)buffer.toString());
                }
                HashMap<String, ParticipantProperty> expectedMap = new HashMap<String, ParticipantProperty>();
                HashMap<String, ParticipantProperty> actualMap = new HashMap<String, ParticipantProperty>();
                for (int j = 0; j < expectedProperties.getParticipantProperty().size(); ++j) {
                    exp = (ParticipantProperty)expectedProperties.getParticipantProperty().get(j);
                    expectedMap.put(exp.getName(), exp);
                    act = (ParticipantProperty)actualProperties.getParticipantProperty().get(j);
                    actualMap.put(act.getName(), act);
                }
                for (String propName : expectedMap.keySet()) {
                    act = (ParticipantProperty)actualMap.get(propName);
                    if (act == null) {
                        System.out.println(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + propName + " not found in the retrieved list of properties.");
                        AbstractExtendedUserPropertiesPersistenceTest.fail((String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + propName + " not found in the retrieved list of properties."));
                        continue;
                    }
                    System.out.println("Property name found. Trying to match type and values");
                    exp = (ParticipantProperty)expectedMap.get(propName);
                    AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": type mismatch"), (String)exp.getPropertyType(), (String)act.getPropertyType());
                    System.out.println("Property types match. Moving on to match values.");
                    AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": value mismatch"), exp.getValue().get(0), act.getValue().get(0));
                    System.out.println("Property values match.");
                }
            }
        }
    }

    private static void assertEqualityOfParticipants(String test, List<Participant> expectedList, List<Participant> resultList) {
        HashMap<String, Object> expParticipantMap = new HashMap<String, Object>();
        HashMap<String, Object> actParticipantMap = new HashMap<String, Object>();
        for (Participant pp : expectedList) {
            expParticipantMap.put(((PrincipleRefType)pp.getValue()).getName(), pp.getValue());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Expected participant name is " + ((PrincipleRefType)pp.getValue()).getName() + "\n"));
        }
        for (Participant pp : resultList) {
            actParticipantMap.put(((PrincipleRefType)pp.getValue()).getName(), pp.getValue());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("Actual participant name is " + ((PrincipleRefType)pp.getValue()).getName() + "\n"));
        }
        for (String name : expParticipantMap.keySet()) {
            PrincipleRefType actualParticipant = (PrincipleRefType)actParticipantMap.get(name);
            if (actualParticipant == null) {
                AbstractExtendedUserPropertiesPersistenceTest.fail((String)("Expected Participant " + name + " not found in the result."));
                continue;
            }
            PrincipleRefType expectedParticipant = (PrincipleRefType)expParticipantMap.get(name);
            AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": participant realm mismatch"), (String)expectedParticipant.getRealm(), (String)actualParticipant.getRealm());
            AbstractExtendedUserPropertiesPersistenceTest.assertEquals((String)(test + ": participant type mismatch"), (Object)expectedParticipant.getType(), (Object)actualParticipant.getType());
        }
    }

    private IBPMContext createContext(String user) throws Exception {
        return this.getBPMUserAuthenticationService().authenticate(user, PASSWORD_JSTEIN.toCharArray(), IDTTY_CTXT);
    }

    private void privateAddMultiValuedStringProperties() throws Exception {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("Skill");
            partProp.setPropertyType("STRING");
            List values = partProp.getValue();
            values.add("Java");
            values.add("COBOL");
            values.add("C#");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Location");
            partProp.setPropertyType("STRING");
            values = partProp.getValue();
            values.add("California");
            values.add("Bangalore");
            values.add("Bombay");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            e.printStackTrace();
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)e.getMessage());
        }
    }

    private void privateAddNumberProperties() throws Exception {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("NO_OF_SOFTWARE_COMPANIES_STARTED");
            partProp.setPropertyType("NUMBER");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("NO_OF_HARDWARE_COMPANIES_STARTED");
            partProp.setPropertyType("NUMBER");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("NO_OF_CARS_OWNED");
            partProp.setPropertyType("NUMBER");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("NO_OF_JETS_OWNED");
            partProp.setPropertyType("NUMBER");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            e.printStackTrace();
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)e.getMessage());
        }
    }

    private void privateAddDateProperties() throws Exception {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("HIRE_DATE");
            partProp.setPropertyType("DATE");
            ArrayList<ParticipantProperty> properties = new ArrayList<ParticipantProperty>();
            properties.add(partProp);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("FIRE_DATE");
            partProp.setPropertyType("DATE");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            properties.add(partProp);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
    }

    private void privateAddMultiValuedFreeformStringProperties() throws Exception {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("Performance Rating");
            partProp.setPropertyType("FREEFORM_STRING");
            partProp.setIsMultiValued(true);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            System.out.println("Successfully created FREEFORM_STRING property called Performance Rating");
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Customer Feedback");
            partProp.setPropertyType("FREEFORM_STRING");
            partProp.setIsMultiValued(true);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            System.out.println("Successfully created FREEFORM_STRING property called Customer Feedback");
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Lottery Numbers");
            partProp.setPropertyType("FREEFORM_STRING");
            partProp.setIsMultiValued(true);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            System.out.println("Successfully created FREEFORM_STRING property called Lottery Numbers");
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Miles Earned");
            partProp.setPropertyType("FREEFORM_STRING");
            partProp.setIsMultiValued(false);
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            System.out.println("Successfully created FREEFORM_STRING property called Miles Earned");
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            e.printStackTrace();
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)e.getMessage());
        }
    }

    private void privateAddProperties() throws Exception {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("SKILL");
            partProp.setPropertyType("STRING");
            List values = partProp.getValue();
            values.add("Java");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("LOCATION");
            partProp.setPropertyType("STRING");
            values = partProp.getValue();
            values.add("California");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            e.printStackTrace();
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)e.getMessage());
        }
    }

    private void privateSetDatePropertiesOnParticipants() throws BPMOrganizationException {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddDateProperties();
            PrincipleRefType part1 = objectFactory.createPrincipleRefType();
            part1.setName(USER_JSTEIN);
            part1.setType(ParticipantTypeEnum.USER);
            part1.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("HIRE_DATE");
            partProp.setPropertyType("DATE");
            partProp.getValue().add("12/12/2000");
            ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("FIRE_DATE");
            partProp2.setPropertyType("DATE");
            partProp2.getValue().add("12/12/2020");
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part1);
            properties.getParticipantProperty().add(partProp);
            properties.getParticipantProperty().add(partProp2);
            PrincipleRefType part2 = objectFactory.createPrincipleRefType();
            part2.setName(USER_JCOOPER);
            part2.setType(ParticipantTypeEnum.USER);
            part2.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp3 = objectFactory.createParticipantProperty();
            partProp3.setName("HIRE_DATE");
            partProp3.setPropertyType("DATE");
            partProp3.getValue().add("01/01/1950");
            ParticipantProperty partProp4 = objectFactory.createParticipantProperty();
            partProp4.setName("FIRE_DATE");
            partProp4.setPropertyType("DATE");
            partProp4.getValue().add("10/10/1990");
            ParticipantProperties properties2 = objectFactory.createParticipantProperties();
            properties2.setParticipant(part2);
            properties2.getParticipantProperty().add(partProp3);
            properties2.getParticipantProperty().add(partProp4);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            inputParticipantPropertiesList.add(properties2);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
    }

    private void privateSetStringPropertiesOnParticipants() throws BPMOrganizationException {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddMultiValuedStringProperties();
            PrincipleRefType part1 = objectFactory.createPrincipleRefType();
            part1.setName(USER_JSTEIN);
            part1.setType(ParticipantTypeEnum.USER);
            part1.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("SKILL");
            partProp.setPropertyType("STRING");
            partProp.getValue().add("Java");
            partProp.getValue().add("C#");
            ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("LOCATION");
            partProp2.setPropertyType("STRING");
            partProp2.getValue().add("California");
            partProp2.getValue().add("Bangalore");
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part1);
            properties.getParticipantProperty().add(partProp);
            properties.getParticipantProperty().add(partProp2);
            PrincipleRefType part2 = objectFactory.createPrincipleRefType();
            part2.setName(USER_JCOOPER);
            part2.setType(ParticipantTypeEnum.USER);
            part2.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp3 = objectFactory.createParticipantProperty();
            partProp3.setName("SKILL");
            partProp3.setPropertyType("STRING");
            partProp3.getValue().add("COBOL");
            partProp3.getValue().add("C#");
            ParticipantProperty partProp4 = objectFactory.createParticipantProperty();
            partProp4.setName("LOCATION");
            partProp4.setPropertyType("STRING");
            partProp4.getValue().add("Bangalore");
            partProp4.getValue().add("Bombay");
            ParticipantProperties properties2 = objectFactory.createParticipantProperties();
            properties2.setParticipant(part2);
            properties2.getParticipantProperty().add(partProp3);
            properties2.getParticipantProperty().add(partProp4);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            inputParticipantPropertiesList.add(properties2);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
    }

    private void privateSetFreeformStringPropertiesOnParticipants() throws BPMOrganizationException {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddMultiValuedFreeformStringProperties();
            PrincipleRefType part1 = objectFactory.createPrincipleRefType();
            part1.setName(USER_JSTEIN);
            part1.setType(ParticipantTypeEnum.USER);
            part1.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("Performance Rating");
            partProp.setPropertyType("FREEFORM_STRING");
            List values = partProp.getValue();
            values.add("Downright Lazy");
            values.add("Slacker");
            ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("Customer Feedback");
            partProp2.setPropertyType("FREEFORM_STRING");
            values = partProp2.getValue();
            values.add("Poor Product");
            values.add("Couldn't get any worse");
            ParticipantProperty partProp3 = objectFactory.createParticipantProperty();
            partProp3.setName("Lottery Numbers");
            partProp3.setPropertyType("FREEFORM_STRING");
            values = partProp3.getValue();
            values.add("4934732");
            values.add("7598436");
            ParticipantProperty partProp4 = objectFactory.createParticipantProperty();
            partProp4.setName("Miles Earned");
            partProp4.setPropertyType("FREEFORM_STRING");
            values = partProp4.getValue();
            values.add("167890");
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part1);
            properties.getParticipantProperty().add(partProp);
            properties.getParticipantProperty().add(partProp2);
            properties.getParticipantProperty().add(partProp3);
            properties.getParticipantProperty().add(partProp4);
            PrincipleRefType part2 = objectFactory.createPrincipleRefType();
            part2.setName(USER_JCOOPER);
            part2.setType(ParticipantTypeEnum.USER);
            part2.setRealm(IDTTY_CTXT);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Performance Rating");
            partProp.setPropertyType("FREEFORM_STRING");
            values = partProp.getValue();
            values.add("Extremely Brilliant");
            values.add("Hard Working");
            partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("Customer Feedback");
            partProp2.setPropertyType("FREEFORM_STRING");
            values = partProp2.getValue();
            values.add("Gold Standard in Extended User Properties");
            values.add("Par Excellence");
            partProp3 = objectFactory.createParticipantProperty();
            partProp3.setName("Lottery Numbers");
            partProp3.setPropertyType("FREEFORM_STRING");
            values = partProp3.getValue();
            values.add("ABC24432324");
            values.add("XYZ34324324");
            partProp4 = objectFactory.createParticipantProperty();
            partProp4.setName("Miles Earned");
            partProp4.setPropertyType("FREEFORM_STRING");
            values = partProp4.getValue();
            values.add(98767786);
            ParticipantProperties properties2 = objectFactory.createParticipantProperties();
            properties2.setParticipant(part2);
            properties2.getParticipantProperty().add(partProp);
            properties2.getParticipantProperty().add(partProp2);
            properties2.getParticipantProperty().add(partProp3);
            properties2.getParticipantProperty().add(partProp4);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            inputParticipantPropertiesList.add(properties2);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
            System.out.println("Successfully set the following FREEFORM_STRING properties on demoadmin\n");
            System.out.println("Performance Rating -> Downright Lazy || Slacker\n");
            System.out.println("Customer Feedback -> Poor Product || Couldn't get any worse\n");
            System.out.println("Lottery Numbers -> 4934732 || 7598436\n");
            System.out.println("Miles Earned -> 167890\n\n\n");
            System.out.println("Successfully set the following FREEFORM_STRING properties on jcooper\n");
            System.out.println("Performance Rating -> Extremely Brilliant || Hard Working\n");
            System.out.println("Customer Feedback -> Gold Standard in Extended User Properties || Par Excellence\n");
            System.out.println("Lottery Numbers -> ABC24432324 || XYZ34324324\n");
            System.out.println("Miles Earned -> 98767786\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
    }

    private void privateSetNumberPropertiesOnParticipants() throws BPMOrganizationException {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            this.privateAddNumberProperties();
            PrincipleRefType part1 = objectFactory.createPrincipleRefType();
            part1.setName(USER_JSTEIN);
            part1.setType(ParticipantTypeEnum.USER);
            part1.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("NO_OF_SOFTWARE_COMPANIES_STARTED");
            partProp.setPropertyType("NUMBER");
            List values = partProp.getValue();
            values.add(2);
            ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
            partProp2.setName("NO_OF_CARS_OWNED");
            partProp2.setPropertyType("NUMBER");
            values = partProp2.getValue();
            values.add(20);
            ParticipantProperties properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part1);
            properties.getParticipantProperty().add(partProp);
            properties.getParticipantProperty().add(partProp2);
            PrincipleRefType part2 = objectFactory.createPrincipleRefType();
            part2.setName(USER_JCOOPER);
            part2.setType(ParticipantTypeEnum.USER);
            part2.setRealm(IDTTY_CTXT);
            ParticipantProperty partProp3 = objectFactory.createParticipantProperty();
            partProp3.setName("NO_OF_HARDWARE_COMPANIES_STARTED");
            partProp3.setPropertyType("NUMBER");
            values = partProp3.getValue();
            values.add(6);
            ParticipantProperty partProp4 = objectFactory.createParticipantProperty();
            partProp4.setName("NO_OF_JETS_OWNED");
            partProp4.setPropertyType("NUMBER");
            values = partProp4.getValue();
            values.add(12);
            ParticipantProperties properties2 = objectFactory.createParticipantProperties();
            properties2.setParticipant(part2);
            properties2.getParticipantProperty().add(partProp3);
            properties2.getParticipantProperty().add(partProp4);
            ArrayList<ParticipantProperties> inputParticipantPropertiesList = new ArrayList<ParticipantProperties>();
            inputParticipantPropertiesList.add(properties);
            inputParticipantPropertiesList.add(properties2);
            this.getBPMOrganizationService().setPropertiesOnParticipants(ctx, inputParticipantPropertiesList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            throw new BPMOrganizationException(e);
        }
    }

    private void privateAddMultiValuedStringProperties2() {
        try {
            if (ctx == null) {
                throw new Exception("Workflow Context not created. Setup failed. Unable to run test");
            }
            ParticipantProperty partProp = objectFactory.createParticipantProperty();
            partProp.setName("ProgramaticallySkilledPerson");
            partProp.setPropertyType("STRING");
            List values = partProp.getValue();
            values.add("Java");
            values.add("COBOL");
            values.add("C#");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Oratorially Skilled Person");
            partProp.setPropertyType("STRING");
            values = partProp.getValue();
            values.add("Public Speaker");
            values.add("Public Convincer");
            values.add("Public Manipulator");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("LICENCES_Sold");
            partProp.setPropertyType("NUMBER");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("EXHIBITION DATE");
            partProp.setPropertyType("DATE");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("Customer FEEDBACK");
            partProp.setPropertyType("FREEFORM_STRING");
            this.getBPMOrganizationService().createParticipantProperty(ctx, partProp);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)(AbstractExtendedUserPropertiesPersistenceTest.getQualifiedClassAndMethodName() + e.getMessage()));
            e.printStackTrace();
            AbstractExtendedUserPropertiesPersistenceTest.fail((String)e.getMessage());
        }
    }

    static {
        objectFactory = new ObjectFactory();
    }

    private static class PartNamePartTypePartRealmCompositeKey {
        private String name;
        private String realm;
        private String type;

        public PartNamePartTypePartRealmCompositeKey(String name, String type, String realm) throws IllegalArgumentException {
            this.name = name.trim();
            this.type = type.trim();
            this.realm = realm.trim();
        }

        public int hashCode() {
            String temp = this.name + this.type + this.realm;
            return temp.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getRealm() {
            return this.realm;
        }

        public boolean equals(Object obj) {
            PartNamePartTypePartRealmCompositeKey partObj = (PartNamePartTypePartRealmCompositeKey)obj;
            return this.name.equals(partObj.getName().trim()) && this.type.equals(partObj.getType().trim()) && this.realm.equals(partObj.getRealm().trim());
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Participant Name ").append(this.getName());
            buffer.append("\n Participant Type ").append(this.getType());
            buffer.append("\n Participant Realm ").append(this.getRealm());
            return buffer.toString();
        }
    }
}

