/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.persistency;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMOrganizationPersistency;
import oracle.bpm.services.organization.persistency.ExtendedUserPropertiesPersistencyDriver;
import oracle.bpm.services.organization.persistency.PropertyValueTypeEnum;
import oracle.bpm.services.organization.persistency.model.BpmExtUserPropAvlblCol;
import oracle.bpm.services.organization.persistency.model.BpmExtUserPropertyGlobal;
import oracle.bpm.services.organization.persistency.model.BpmExtUserPropertyValue;

public class ParticipantProperty_JAXB_to_Toplink_Converter {
    private static ObjectFactory objectFactory = new ObjectFactory();

    public static BpmExtUserPropertyGlobal convertParticipantPropertyToBpmExtUserPropertyGlobal(ParticipantProperty partProp, BpmExtUserPropAvlblCol avlblColRow, BpmExtUserPropertyGlobal globalProperty) throws BPMOrganizationException {
        globalProperty.setCreatedBy(partProp.getCreatedBy());
        globalProperty.setCreatedByIdctx(partProp.getCreatedByIdentityContext());
        Timestamp timestamp = AbstractPersistencyDriver.convertToTimestamp(partProp.getCreatedDate());
        globalProperty.setCreatedDate(timestamp);
        globalProperty.setLastUpdatedBy(partProp.getLastUpdatedBy());
        globalProperty.setLastUpdatedByIdctx(partProp.getLastUpdatedByIdentityContext());
        globalProperty.setLastUpdatedDate(timestamp);
        globalProperty.setGuid(Util.getGuid());
        globalProperty.setPropertyName(partProp.getName().toUpperCase());
        String valueType = partProp.getPropertyType();
        if (valueType != null && !valueType.equals("")) {
            valueType = valueType.toUpperCase().trim();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> valueType of the property is " + valueType));
            try {
                PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(valueType);
                switch (valueTypeEnum) {
                    case STRING: {
                        globalProperty.setPropValueColumnName(avlblColRow.getStringColName());
                        globalProperty.setPropertyDataType(PropertyValueTypeEnum.STRING.name());
                        List values = partProp.getValue();
                        if (values == null || values.size() == 0) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> String property must be created with at least 1 value.");
                            Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> String property must be created with at least 1 value."};
                            throw new BPMOrganizationException(70679, objs);
                        }
                        if (values.size() == 1) {
                            try {
                                String value = (String)values.get(0);
                                if (ParticipantProperty_JAXB_to_Toplink_Converter.doesValueContainDelimiter(value)) {
                                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> String property value must not contain the value delimiter || in it.");
                                    Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> String property value must not contain the value delimiter || in it."};
                                    throw new BPMOrganizationException(70680, objs);
                                }
                                globalProperty.setPropertyStringValue("||" + value + "||");
                                globalProperty.setMultiValuedProperty(new BigDecimal(0));
                                break;
                            }
                            catch (ClassCastException cce) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Value provided for property " + partProp.getName() + " is not of type STRING."));
                                Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Value provided for property " + partProp.getName() + " is not of type STRING."};
                                throw new BPMOrganizationException(70689, objs, (Exception)cce);
                            }
                        }
                        StringBuffer buffer = new StringBuffer();
                        for (Object value : values) {
                            try {
                                if (ParticipantProperty_JAXB_to_Toplink_Converter.doesValueContainDelimiter((String)value)) {
                                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> String property value must not contain the value delimiter || in it.");
                                    Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> String property value must not contain the value delimiter || in it."};
                                    throw new BPMOrganizationException(70680, objs);
                                }
                                buffer.append("||");
                                buffer.append((String)value);
                            }
                            catch (ClassCastException cce) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)("ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Value provided for property " + partProp.getName() + " is not of type STRING."));
                                Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Value provided for property " + partProp.getName() + " is not of type STRING."};
                                throw new BPMOrganizationException(70689, objs, (Exception)cce);
                            }
                        }
                        buffer.append("||");
                        globalProperty.setPropertyStringValue(buffer.toString());
                        globalProperty.setMultiValuedProperty(new BigDecimal(1));
                        break;
                    }
                    case NUMBER: {
                        globalProperty.setPropValueColumnName(avlblColRow.getNumberColName());
                        List values = partProp.getValue();
                        if (values != null && values.size() > 0) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Number properties do not support enumerated values.");
                            Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Number properties do not support enumerated values."};
                            throw new BPMOrganizationException(70611, objs);
                        }
                        globalProperty.setPropertyDataType(PropertyValueTypeEnum.NUMBER.name());
                        globalProperty.setMultiValuedProperty(new BigDecimal(0));
                        break;
                    }
                    case FREEFORM_STRING: {
                        globalProperty.setPropValueColumnName(avlblColRow.getStringColName());
                        if (partProp.isIsMultiValued()) {
                            globalProperty.setMultiValuedProperty(new BigDecimal(1));
                        } else {
                            globalProperty.setMultiValuedProperty(new BigDecimal(0));
                        }
                        List values = partProp.getValue();
                        if (values != null && values.size() > 0) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Freeform String properties do not support enumerated values.");
                            Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Freeform String  properties do not support enumerated values."};
                            throw new BPMOrganizationException(70611, objs);
                        }
                        globalProperty.setPropertyDataType(PropertyValueTypeEnum.FREEFORM_STRING.name());
                        break;
                    }
                    case DATE: {
                        globalProperty.setPropValueColumnName(avlblColRow.getDateColName());
                        List values = partProp.getValue();
                        if (values != null && values.size() > 0) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Date properties do not support enumerated values.");
                            Object[] objs = new Object[]{"ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal() >> Date properties do not support enumerated values."};
                            throw new BPMOrganizationException(70611, objs);
                        }
                        globalProperty.setPropertyDataType(PropertyValueTypeEnum.DATE.name());
                        globalProperty.setMultiValuedProperty(new BigDecimal(0));
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Object[] objs = new Object[]{partProp.getClass().getName(), "Property value is of data type that is not supported. Supported types are STRING, FREEFORM_STRING, NUMBER and DATE"};
                throw new BPMOrganizationException(70611, objs);
            }
        } else {
            Object[] objs = new Object[]{"ExtendedUserPropertiesPersistencyDriver", "addProperties() >> Value Type of the property has not been provided. Cannot add the property. Supported types are STRING, NUMBER and DATE."};
            throw new BPMOrganizationException(70611, objs);
        }
        return globalProperty;
    }

    public static List<Participant> convertListOfBpmExtUserPropertyValueToListOfParticipant(List<BpmExtUserPropertyValue> propertyValues) throws BPMOrganizationException {
        ArrayList<Participant> resultList = new ArrayList<Participant>();
        for (BpmExtUserPropertyValue valueRow : propertyValues) {
            PrincipleRefType principleRefType = objectFactory.createPrincipleRefType();
            principleRefType.setName(valueRow.getParticipantId());
            principleRefType.setRealm(valueRow.getIdentityContext());
            principleRefType.setType(ParticipantTypeEnum.valueOf((String)valueRow.getParticipantType()));
            Participant participant = objectFactory.createParticipant(principleRefType);
            resultList.add(participant);
        }
        return resultList;
    }

    public static Map<PrincipleRefType, BpmExtUserPropertyValue> convertListOfBpmExtUserPropertyValueToParticipantValueRowMap(List<BpmExtUserPropertyValue> valueTableRows) throws BPMOrganizationException {
        Comparator<PrincipleRefType> prtComparator = new Comparator<PrincipleRefType>(){

            @Override
            public int compare(PrincipleRefType o1, PrincipleRefType o2) {
                String partID1 = o1.getName();
                String partID2 = o2.getName();
                Comparator strComp = String.CASE_INSENSITIVE_ORDER;
                return strComp.compare(partID1, partID2);
            }
        };
        TreeMap<PrincipleRefType, BpmExtUserPropertyValue> resultMap = new TreeMap<PrincipleRefType, BpmExtUserPropertyValue>(prtComparator);
        try {
            for (BpmExtUserPropertyValue valueRow : valueTableRows) {
                PrincipleRefType prt = objectFactory.createPrincipleRefType();
                prt.setName(valueRow.getParticipantId());
                prt.setRealm(valueRow.getIdentityContext());
                String partTypeEnumString = valueRow.getParticipantType();
                ParticipantTypeEnum typeEnum = ParticipantTypeEnum.valueOf((String)partTypeEnumString);
                prt.setType(typeEnum);
                resultMap.put(prt, valueRow);
            }
            return resultMap;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new BPMOrganizationException((Exception)e);
        }
    }

    public static List<ParticipantProperty> convertListOfBpmExtUserPropertyGlobalToListOfParticipantProperty(List<BpmExtUserPropertyGlobal> globalTableRows) throws BPMOrganizationException {
        ArrayList<ParticipantProperty> resultList = new ArrayList<ParticipantProperty>();
        ParticipantProperty partProp = null;
        try {
            for (BpmExtUserPropertyGlobal globalRow : globalTableRows) {
                partProp = objectFactory.createParticipantProperty();
                partProp.setCreatedBy(globalRow.getCreatedBy());
                partProp.setCreatedByIdentityContext(globalRow.getCreatedByIdctx());
                Timestamp createdByTS = globalRow.getCreatedDate();
                long time = createdByTS.getTime();
                Calendar createdByCal = Calendar.getInstance();
                createdByCal.setTimeInMillis(time);
                partProp.setCreatedDate(BPMOrganizationPersistency.getXMLGregorianCalendar(createdByCal));
                partProp.setLastUpdatedBy(globalRow.getLastUpdatedBy());
                partProp.setLastUpdatedByIdentityContext(globalRow.getLastUpdatedByIdctx());
                Timestamp updatedByTS = globalRow.getLastUpdatedDate();
                time = updatedByTS.getTime();
                Calendar updatedByCal = Calendar.getInstance();
                updatedByCal.setTimeInMillis(time);
                partProp.setLastUpdatedDate(BPMOrganizationPersistency.getXMLGregorianCalendar(updatedByCal));
                partProp.setName(globalRow.getPropertyName());
                partProp.setPropertyType(globalRow.getPropertyDataType());
                List values = partProp.getValue();
                PropertyValueTypeEnum type = Enum.valueOf(PropertyValueTypeEnum.class, globalRow.getPropertyDataType());
                switch (type) {
                    case DATE: {
                        break;
                    }
                    case NUMBER: {
                        break;
                    }
                    case FREEFORM_STRING: {
                        String value = globalRow.getPropertyStringValue();
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ParticipantProperty_JAXB_to_Toplink_Converter.convertListOfBpmExtUserPropertyGlobalToListOfParticipantProperty() >> Retrieved String value from the DB is " + value));
                        List<String> stringValueList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(value);
                        values.addAll(stringValueList);
                        break;
                    }
                    case STRING: {
                        String value = globalRow.getPropertyStringValue();
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ParticipantProperty_JAXB_to_Toplink_Converter.convertListOfBpmExtUserPropertyGlobalToListOfParticipantProperty() >> Retrieved String value from the DB is " + value));
                        List<String> stringValueList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(value);
                        values.addAll(stringValueList);
                        break;
                    }
                }
                resultList.add(partProp);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    private static boolean doesValueContainDelimiter(String v) {
        if (v == null || v.equals("")) {
            return false;
        }
        int indexOf = v.indexOf("||");
        return indexOf != -1;
    }
}

