/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.persistency;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.impl.QueryUtil;
import oracle.bpel.services.workflow.query.model.ClauseType;
import oracle.bpel.services.workflow.query.model.ColumnType;
import oracle.bpel.services.workflow.query.model.OrderingClauseType;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.PredicateConstants;
import oracle.bpel.services.workflow.repos.PredicateImpl;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMOrganizationServiceTableAndColumnNameConstants;
import oracle.bpm.services.organization.persistency.BPMOrganizationServiceTableColumnDefinitions;
import oracle.bpm.services.organization.persistency.ParticipantProperty_JAXB_to_Toplink_Converter;
import oracle.bpm.services.organization.persistency.PropertyValueTypeEnum;
import oracle.bpm.services.organization.persistency.model.BpmExtUserPropAvlblCol;
import oracle.bpm.services.organization.persistency.model.BpmExtUserPropertyGlobal;
import oracle.bpm.services.organization.persistency.model.BpmExtUserPropertyValue;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.DataReadQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.ScrollableCursor;
import oracle.toplink.queryframework.ScrollableCursorPolicy;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.Record;
import oracle.toplink.sessions.UnitOfWork;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.Server;

public class ExtendedUserPropertiesPersistencyDriver
extends AbstractPersistencyDriver {
    public static final String SESSION_PATH = "oracle/bpm/services/organization/persistency/ExtendedUserPropertiesSession.xml";
    public static final String MULTI_VALUED_PROPERTY_DELIMETER = "||";
    public static final String TOPLINK_MAP_FILE_PATH = "oracle/bpm/services/organization/persistency/ExtendedUserPropertiesMap.xml";
    public static final String POJO_MODEL_PACKAGE = "oracle.bpm.services.organization.persistency.model";
    private static ObjectFactory objectFactory;
    public static final Map<String, Column> columnNameColumnInstanceMap;
    private static final List<String> auditAttributeNames;

    private ExtendedUserPropertiesPersistencyDriver() {
    }

    public static ExtendedUserPropertiesPersistencyDriver getInstance() {
        return new ExtendedUserPropertiesPersistencyDriver();
    }

    public static List<String> convertDelimitedStringToListOfStrings(String s) {
        if (s == null || s.equals("")) {
            return new ArrayList<String>();
        }
        ArrayList<String> splits = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, MULTI_VALUED_PROPERTY_DELIMETER, false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null || token.equals("")) continue;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings() >> Token is " + token));
            splits.add(token);
        }
        return splits;
    }

    @Override
    public Object convertToTopLink(IBPMContext ctx, AbstractPersistencyDriver.OPERATION operation, Object jaxbObject, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        return null;
    }

    @Override
    public Object convertToTopLink(Object object) throws BPMOrganizationException {
        return null;
    }

    public ClientSession getClientSession() throws BPMOrganizationException {
        Server ss = this.getServerSession();
        if (ss == null) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70615, objs);
        }
        return ss.acquireClientSession();
    }

    @Override
    public String getPOJOModelPackage() {
        return POJO_MODEL_PACKAGE;
    }

    public List<ParticipantProperties> getPropertiesOfParticipants(List<Participant> participants) throws BPMOrganizationException {
        try {
            ClientSession session = this.getClientSession();
            HashMap participant_ValueRowObjMap = new HashMap();
            ArrayList<ParticipantProperties> resultList = new ArrayList<ParticipantProperties>();
            ReadAllQuery retrieveAllGLobalTableRowsQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            List globalTableObjectList = (List)session.executeQuery((DatabaseQuery)retrieveAllGLobalTableRowsQuery);
            if (globalTableObjectList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.getPropertiesOfParticipants() >> Retrieved list of List<BpmExtUserPropertyGlobal> is size 0");
                return new ArrayList<ParticipantProperties>();
            }
            HashMap<String, BpmExtUserPropertyGlobal> columnNameBpmExtUserPropertyGlobalMap = new HashMap<String, BpmExtUserPropertyGlobal>();
            for (BpmExtUserPropertyGlobal globalTblRowObj : globalTableObjectList) {
                columnNameBpmExtUserPropertyGlobalMap.put(globalTblRowObj.getPropValueColumnName(), globalTblRowObj);
            }
            for (Participant part : participants) {
                ReadAllQuery existingValueRowsQuery = new ReadAllQuery(BpmExtUserPropertyValue.class);
                ExpressionBuilder expBldr = existingValueRowsQuery.getExpressionBuilder();
                Expression partIDExp = expBldr.get("participantId").equal((Object)((PrincipleRefType)part.getValue()).getName());
                Expression idCtxExp = expBldr.get("identityContext").equal((Object)((PrincipleRefType)part.getValue()).getRealm());
                Expression partTypeExp = expBldr.get("participantType").equal((Object)((PrincipleRefType)part.getValue()).getType());
                Expression combinedExp = partIDExp.and(idCtxExp).and(partTypeExp);
                existingValueRowsQuery.setSelectionCriteria(combinedExp);
                List existingValueRows = (List)session.executeQuery((DatabaseQuery)existingValueRowsQuery);
                if (existingValueRows != null && existingValueRows.size() > 0) {
                    participant_ValueRowObjMap.put(part, existingValueRows.get(0));
                    continue;
                }
                participant_ValueRowObjMap.put(part, null);
            }
            for (Participant part : participant_ValueRowObjMap.keySet()) {
                ParticipantProperties partProperties = objectFactory.createParticipantProperties();
                partProperties.setParticipant((PrincipleRefType)part.getValue());
                BpmExtUserPropertyValue participantPropertiesValueTableRow = (BpmExtUserPropertyValue)participant_ValueRowObjMap.get(part);
                if (participantPropertiesValueTableRow == null) {
                    resultList.add(partProperties);
                    continue;
                }
                Map<String, Object> columnNamePropertyValueMap = this.fetchColumnNamesAndPropertyValuesFrom(participantPropertiesValueTableRow);
                List participantPropertiesList = partProperties.getParticipantProperty();
                for (String columnName : columnNamePropertyValueMap.keySet()) {
                    BpmExtUserPropertyGlobal globalTableRowObj = (BpmExtUserPropertyGlobal)columnNameBpmExtUserPropertyGlobalMap.get(columnName);
                    ParticipantProperty partProp = objectFactory.createParticipantProperty();
                    partProp.setName(globalTableRowObj.getPropertyName());
                    partProp.setPropertyType(globalTableRowObj.getPropertyDataType());
                    partProp.setCreatedBy(globalTableRowObj.getCreatedBy());
                    partProp.setCreatedByIdentityContext(globalTableRowObj.getCreatedByIdctx());
                    partProp.setCreatedDate(ExtendedUserPropertiesPersistencyDriver.convertToCalendar(globalTableRowObj.getCreatedDate()));
                    partProp.setLastUpdatedBy(globalTableRowObj.getLastUpdatedBy());
                    partProp.setLastUpdatedByIdentityContext(globalTableRowObj.getLastUpdatedByIdctx());
                    partProp.setLastUpdatedDate(ExtendedUserPropertiesPersistencyDriver.convertToCalendar(globalTableRowObj.getLastUpdatedDate()));
                    List valueList = partProp.getValue();
                    try {
                        PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(globalTableRowObj.getPropertyDataType());
                        switch (valueTypeEnum) {
                            case DATE: {
                                valueList.add(columnNamePropertyValueMap.get(columnName));
                                break;
                            }
                            case NUMBER: {
                                valueList.add(columnNamePropertyValueMap.get(columnName));
                                break;
                            }
                            case FREEFORM_STRING: {
                                List<String> stringValues;
                                BigDecimal isMultiValuedProperty = globalTableRowObj.getMultiValuedProperty();
                                if (isMultiValuedProperty.intValue() == 1) {
                                    stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                    valueList.addAll(stringValues);
                                    break;
                                }
                                stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                valueList.add(stringValues.get(0));
                                break;
                            }
                            case STRING: {
                                List<String> stringValues;
                                BigDecimal isMultiValuedProperty = globalTableRowObj.getMultiValuedProperty();
                                if (isMultiValuedProperty.intValue() == 1) {
                                    stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                    valueList.addAll(stringValues);
                                    break;
                                }
                                stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                valueList.add(stringValues.get(0));
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Object[] objs = new Object[]{globalTableRowObj.getPropertyDataType()};
                        throw new BPMOrganizationException(70611, objs);
                    }
                    participantPropertiesList.add(partProp);
                }
                resultList.add(partProperties);
            }
            return resultList;
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    public List<ParticipantProperties> getAllParticipantProperties() throws BPMOrganizationException {
        try {
            ClientSession session = this.getClientSession();
            ArrayList<ParticipantProperties> resultList = new ArrayList<ParticipantProperties>();
            ReadAllQuery retrieveAllGLobalTableRowsQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            List globalTableObjectList = (List)session.executeQuery((DatabaseQuery)retrieveAllGLobalTableRowsQuery);
            if (globalTableObjectList.size() == 0) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.getPropertiesOfParticipants() >> Retrieved list of List<BpmExtUserPropertyGlobal> is size 0");
                return new ArrayList<ParticipantProperties>();
            }
            HashMap<String, BpmExtUserPropertyGlobal> columnNameBpmExtUserPropertyGlobalMap = new HashMap<String, BpmExtUserPropertyGlobal>();
            for (BpmExtUserPropertyGlobal globalTblRowObj : globalTableObjectList) {
                columnNameBpmExtUserPropertyGlobalMap.put(globalTblRowObj.getPropValueColumnName(), globalTblRowObj);
            }
            ReadAllQuery retrieveAllValueTableRowsQuery = new ReadAllQuery(BpmExtUserPropertyValue.class);
            ExpressionBuilder expbldr = retrieveAllValueTableRowsQuery.getExpressionBuilder();
            retrieveAllValueTableRowsQuery.addOrdering(expbldr.get("participantId").ascending());
            List valueTableObjectList = (List)session.executeQuery((DatabaseQuery)retrieveAllValueTableRowsQuery);
            Map<PrincipleRefType, BpmExtUserPropertyValue> participant_ValueRowObjMap = ParticipantProperty_JAXB_to_Toplink_Converter.convertListOfBpmExtUserPropertyValueToParticipantValueRowMap(valueTableObjectList);
            for (PrincipleRefType part : participant_ValueRowObjMap.keySet()) {
                ParticipantProperties partProperties = objectFactory.createParticipantProperties();
                partProperties.setParticipant(part);
                BpmExtUserPropertyValue participantPropertiesValueTableRow = participant_ValueRowObjMap.get(part);
                if (participantPropertiesValueTableRow == null) {
                    resultList.add(partProperties);
                    continue;
                }
                Map<String, Object> columnNamePropertyValueMap = this.fetchColumnNamesAndPropertyValuesFrom(participantPropertiesValueTableRow);
                List participantPropertiesList = partProperties.getParticipantProperty();
                for (String columnName : columnNamePropertyValueMap.keySet()) {
                    BpmExtUserPropertyGlobal globalTableRowObj = (BpmExtUserPropertyGlobal)columnNameBpmExtUserPropertyGlobalMap.get(columnName);
                    ParticipantProperty partProp = objectFactory.createParticipantProperty();
                    partProp.setName(globalTableRowObj.getPropertyName());
                    partProp.setPropertyType(globalTableRowObj.getPropertyDataType());
                    partProp.setCreatedBy(globalTableRowObj.getCreatedBy());
                    partProp.setCreatedByIdentityContext(globalTableRowObj.getCreatedByIdctx());
                    partProp.setCreatedDate(ExtendedUserPropertiesPersistencyDriver.convertToCalendar(globalTableRowObj.getCreatedDate()));
                    partProp.setLastUpdatedBy(globalTableRowObj.getLastUpdatedBy());
                    partProp.setLastUpdatedByIdentityContext(globalTableRowObj.getLastUpdatedByIdctx());
                    partProp.setLastUpdatedDate(ExtendedUserPropertiesPersistencyDriver.convertToCalendar(globalTableRowObj.getLastUpdatedDate()));
                    List valueList = partProp.getValue();
                    try {
                        PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(globalTableRowObj.getPropertyDataType());
                        switch (valueTypeEnum) {
                            case DATE: {
                                valueList.add(columnNamePropertyValueMap.get(columnName));
                                break;
                            }
                            case NUMBER: {
                                valueList.add(columnNamePropertyValueMap.get(columnName));
                                break;
                            }
                            case FREEFORM_STRING: {
                                List<String> stringValues;
                                BigDecimal isMultiValuedProperty = globalTableRowObj.getMultiValuedProperty();
                                if (isMultiValuedProperty.intValue() == 1) {
                                    stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                    valueList.addAll(stringValues);
                                    break;
                                }
                                stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                valueList.add(stringValues.get(0));
                                break;
                            }
                            case STRING: {
                                List<String> stringValues;
                                BigDecimal isMultiValuedProperty = globalTableRowObj.getMultiValuedProperty();
                                if (isMultiValuedProperty.intValue() == 1) {
                                    stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                    valueList.addAll(stringValues);
                                    break;
                                }
                                stringValues = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings((String)columnNamePropertyValueMap.get(columnName));
                                valueList.add(stringValues.get(0));
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Object[] objs = new Object[]{globalTableRowObj.getPropertyDataType()};
                        throw new BPMOrganizationException(70611, objs);
                    }
                    participantPropertiesList.add(partProp);
                }
                resultList.add(partProperties);
            }
            return resultList;
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    private UnitOfWork getOrCreateUnitOfWork(UnitOfWork externalUoW, boolean[] localUoW) throws BPMOrganizationException {
        if (externalUoW == null) {
            ClientSession session = this.getClientSession();
            UnitOfWork uow = session.getActiveUnitOfWork();
            if (uow == null) {
                uow = session.acquireUnitOfWork();
                localUoW[0] = true;
                return uow;
            }
            localUoW[0] = false;
            return uow;
        }
        localUoW[0] = false;
        return externalUoW;
    }

    public void addProperty(ParticipantProperty property, UnitOfWork externalUoW) throws BPMOrganizationException {
        try {
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            Vector allAvailableColumns = uow.readAllObjects(BpmExtUserPropAvlblCol.class);
            ArrayList<BpmExtUserPropAvlblCol> unavlblColumnsToBeDeletedList = new ArrayList<BpmExtUserPropAvlblCol>();
            String valueType = property.getPropertyType();
            if (valueType != null && !valueType.equals("")) {
                valueType = valueType.toUpperCase().trim();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.addProperties >> valueType of the property is " + valueType));
                try {
                    PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(valueType);
                    int avlblColNameIndex = this.findAvailableColumnNameFrom(valueTypeEnum, allAvailableColumns);
                    BpmExtUserPropAvlblCol avlblColRow = (BpmExtUserPropAvlblCol)allAvailableColumns.elementAt(avlblColNameIndex);
                    allAvailableColumns.remove(avlblColNameIndex);
                    unavlblColumnsToBeDeletedList.add(avlblColRow);
                    BpmExtUserPropertyGlobal rowForInsertion = new BpmExtUserPropertyGlobal();
                    BpmExtUserPropertyGlobal rowForInsertionClone = (BpmExtUserPropertyGlobal)uow.registerNewObject((Object)rowForInsertion);
                    ParticipantProperty_JAXB_to_Toplink_Converter.convertParticipantPropertyToBpmExtUserPropertyGlobal(property, avlblColRow, rowForInsertionClone);
                }
                catch (IllegalArgumentException e) {
                    Object[] objs = new Object[]{valueType};
                    throw new BPMOrganizationException(70611, objs);
                }
            } else {
                Object[] objs = new Object[]{"NULL"};
                throw new BPMOrganizationException(70611, objs);
            }
            for (BpmExtUserPropAvlblCol row : unavlblColumnsToBeDeletedList) {
                uow.deleteObject((Object)row);
            }
            if (localUoW[0]) {
                uow.commit();
            }
        }
        catch (DatabaseException dbe) {
            Throwable realCause = dbe.getInternalException();
            if (realCause instanceof SQLIntegrityConstraintViolationException) {
                Object[] objs = new Object[]{property.getName()};
                throw new BPMOrganizationException(70663, objs, (Exception)((Object)dbe));
            }
            Object[] objs = new Object[]{dbe.getMessage()};
            throw new BPMOrganizationException(70616, objs, (Exception)((Object)dbe));
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    public void addPropertyValue(ParticipantProperty property, UnitOfWork externalUoW) throws BPMOrganizationException {
        try {
            if (property == null) {
                Object[] msgs = new String[]{};
                throw new BPMOrganizationException(70669, msgs);
            }
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            ReadAllQuery retrieveGLobalTableRowForPropertyQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            ExpressionBuilder gblTblRowRetrievalExpBldr = retrieveGLobalTableRowForPropertyQuery.getExpressionBuilder();
            Expression expression = gblTblRowRetrievalExpBldr.get("propertyName").equal((Object)property.getName().toUpperCase());
            retrieveGLobalTableRowForPropertyQuery.setSelectionCriteria(expression);
            List globalTableObjectList = (List)uow.executeQuery((DatabaseQuery)retrieveGLobalTableRowForPropertyQuery);
            if (globalTableObjectList == null || globalTableObjectList.size() == 0) {
                Object[] msgs = new String[]{property.getName().toUpperCase()};
                throw new BPMOrganizationException(70614, msgs);
            }
            BpmExtUserPropertyGlobal globalTblRowObj = (BpmExtUserPropertyGlobal)globalTableObjectList.get(0);
            String dataType = globalTblRowObj.getPropertyDataType();
            try {
                PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(dataType);
                switch (valueTypeEnum) {
                    case DATE: {
                        Object[] msgs = new String[]{};
                        throw new BPMOrganizationException(70666, msgs);
                    }
                    case NUMBER: {
                        Object[] msgs = new String[]{};
                        throw new BPMOrganizationException(70667, msgs);
                    }
                    case FREEFORM_STRING: {
                        Object[] msgs = new String[]{};
                        throw new BPMOrganizationException(70668, msgs);
                    }
                    case STRING: {
                        String existingValuesAsString = globalTblRowObj.getPropertyStringValue();
                        List<String> existingValuesAsList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(existingValuesAsString);
                        List newValueList = property.getValue();
                        for (String s : existingValuesAsList) {
                            if (!newValueList.contains(s)) continue;
                            newValueList.remove(s);
                        }
                        for (String s : newValueList) {
                            existingValuesAsList.add(s);
                        }
                        String newStringValue = ExtendedUserPropertiesPersistencyDriver.convertStringListIntoSingleDelimitedString(existingValuesAsList);
                        globalTblRowObj.setPropertyStringValue(newStringValue);
                        globalTblRowObj.setLastUpdatedBy(property.getLastUpdatedBy());
                        globalTblRowObj.setLastUpdatedByIdctx(property.getLastUpdatedByIdentityContext());
                        globalTblRowObj.setLastUpdatedDate(ExtendedUserPropertiesPersistencyDriver.convertToTimestamp(property.getLastUpdatedDate()));
                        uow.registerExistingObject((Object)globalTblRowObj);
                        if (!localUoW[0]) break;
                        uow.commit();
                        break;
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                Object[] msgs = new String[]{dataType};
                throw new BPMOrganizationException(70662, msgs);
            }
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    public void deleteProperty(ParticipantProperty property, boolean force, UnitOfWork externalUoW) throws BPMOrganizationException {
        try {
            Field[] valueObjFields;
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            ReadAllQuery retrieveGLobalTableRowForPropertyQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            ExpressionBuilder gblTblRowRetrievalExpBldr = retrieveGLobalTableRowForPropertyQuery.getExpressionBuilder();
            Expression expression = gblTblRowRetrievalExpBldr.get("propertyName").equal((Object)property.getName().toUpperCase());
            retrieveGLobalTableRowForPropertyQuery.setSelectionCriteria(expression);
            List globalTableObjectList = (List)uow.executeQuery((DatabaseQuery)retrieveGLobalTableRowForPropertyQuery);
            if (globalTableObjectList == null || globalTableObjectList.size() == 0) {
                Object[] msgs = new String[]{property.getName().toUpperCase()};
                throw new BPMOrganizationException(70614, msgs);
            }
            BpmExtUserPropertyGlobal globalTblRowObj = (BpmExtUserPropertyGlobal)globalTableObjectList.get(0);
            String propertyDataType = globalTblRowObj.getPropertyDataType();
            String mappedColumnName = globalTblRowObj.getPropValueColumnName();
            String attributeName = this.generateAttributeNameFromColumnName(mappedColumnName);
            HashMap<String, Field> attributeNameToFieldMap = new HashMap<String, Field>();
            for (Field f : valueObjFields = BpmExtUserPropertyValue.class.getDeclaredFields()) {
                attributeNameToFieldMap.put(f.getName(), f);
            }
            ReadAllQuery retrieveValueTableRowsWithValueInColumnQuery = new ReadAllQuery(BpmExtUserPropertyValue.class);
            ExpressionBuilder valueTblRetrievealExpBldr = retrieveValueTableRowsWithValueInColumnQuery.getExpressionBuilder();
            Expression mappedColumnIsNotNull = valueTblRetrievealExpBldr.get(attributeName).notNull();
            retrieveValueTableRowsWithValueInColumnQuery.setSelectionCriteria(mappedColumnIsNotNull);
            List valueRowList = (List)uow.executeQuery((DatabaseQuery)retrieveValueTableRowsWithValueInColumnQuery);
            if (valueRowList == null || valueRowList.size() == 0) {
                uow.deleteObject((Object)globalTblRowObj);
                BpmExtUserPropAvlblCol availableColumnObj = new BpmExtUserPropAvlblCol();
                BpmExtUserPropAvlblCol availableColumnObjClone = (BpmExtUserPropAvlblCol)uow.registerNewObject((Object)availableColumnObj);
                availableColumnObjClone.setGuid(Util.getGuid());
                try {
                    PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(propertyDataType);
                    switch (valueTypeEnum) {
                        case DATE: {
                            availableColumnObjClone.setDateColName(mappedColumnName);
                            break;
                        }
                        case NUMBER: {
                            availableColumnObjClone.setNumberColName(mappedColumnName);
                            break;
                        }
                        case FREEFORM_STRING: {
                            availableColumnObjClone.setStringColName(mappedColumnName);
                            break;
                        }
                        case STRING: {
                            availableColumnObjClone.setStringColName(mappedColumnName);
                        }
                    }
                    if (localUoW[0]) {
                        uow.commit();
                    }
                    return;
                }
                catch (IllegalArgumentException iae) {
                    Object[] msgs = new String[]{propertyDataType};
                    throw new BPMOrganizationException(70662, msgs);
                }
            }
            if (force) {
                for (BpmExtUserPropertyValue valueTblRowObj : valueRowList) {
                    this.setPrivateField((Field)attributeNameToFieldMap.get(attributeName), valueTblRowObj, null);
                    try {
                        if (this.participantHasAtLeastOnePropertyDefined(valueTblRowObj)) {
                            uow.registerExistingObject((Object)valueTblRowObj);
                            continue;
                        }
                        uow.deleteObject((Object)valueTblRowObj);
                    }
                    catch (Exception e) {
                        throw new BPMOrganizationException(e);
                    }
                }
                uow.deleteObject((Object)globalTblRowObj);
                BpmExtUserPropAvlblCol availableColumnObj = new BpmExtUserPropAvlblCol();
                BpmExtUserPropAvlblCol availableColumnObjClone = (BpmExtUserPropAvlblCol)uow.registerNewObject((Object)availableColumnObj);
                availableColumnObjClone.setGuid(Util.getGuid());
                try {
                    PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(propertyDataType);
                    switch (valueTypeEnum) {
                        case DATE: {
                            availableColumnObjClone.setDateColName(mappedColumnName);
                            break;
                        }
                        case NUMBER: {
                            availableColumnObjClone.setNumberColName(mappedColumnName);
                            break;
                        }
                        case FREEFORM_STRING: {
                            availableColumnObjClone.setStringColName(mappedColumnName);
                            break;
                        }
                        case STRING: {
                            availableColumnObjClone.setStringColName(mappedColumnName);
                        }
                    }
                    if (localUoW[0]) {
                        uow.commit();
                    }
                    return;
                }
                catch (IllegalArgumentException iae) {
                    Object[] msgs = new String[]{propertyDataType};
                    throw new BPMOrganizationException(70662, msgs);
                }
            }
            Object[] msgs = new String[]{property.getName().toUpperCase()};
            throw new BPMOrganizationException(70664, msgs);
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    /*
     * Exception decompiling
     */
    public void deletePropertyValue(ParticipantProperty property, boolean force, UnitOfWork externalUoW) throws BPMOrganizationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updatePropertyName(IBPMContext ctx, String oldName, String newName, UnitOfWork externalUoW) throws BPMOrganizationException {
        try {
            if (oldName == null || newName == null || oldName.trim().equals("") || newName.trim().equals("")) {
                Object[] msgs = new String[]{};
                throw new BPMOrganizationException(70669, msgs);
            }
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            ReadAllQuery retrieveGLobalTableRowForPropertyQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            ExpressionBuilder gblTblRowRetrievalExpBldr = retrieveGLobalTableRowForPropertyQuery.getExpressionBuilder();
            Expression expression = gblTblRowRetrievalExpBldr.get("propertyName").equal((Object)oldName.toUpperCase());
            retrieveGLobalTableRowForPropertyQuery.setSelectionCriteria(expression);
            List globalTableObjectList = (List)uow.executeQuery((DatabaseQuery)retrieveGLobalTableRowForPropertyQuery);
            if (globalTableObjectList == null || globalTableObjectList.size() == 0) {
                Object[] msgs = new String[]{oldName};
                throw new BPMOrganizationException(70614, msgs);
            }
            BpmExtUserPropertyGlobal globalTblRowObj = (BpmExtUserPropertyGlobal)globalTableObjectList.get(0);
            globalTblRowObj.setPropertyName(newName.toUpperCase());
            globalTblRowObj.setLastUpdatedBy(ctx.getUser());
            globalTblRowObj.setLastUpdatedByIdctx(ctx.getIdentityContext());
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            globalTblRowObj.setLastUpdatedDate(ts);
            uow.registerExistingObject((Object)globalTblRowObj);
            if (localUoW[0]) {
                uow.commit();
            }
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    public void updatePropertyValue(IBPMContext ctx, String propertyName, String oldValue, String newValue, UnitOfWork externalUoW) throws BPMOrganizationException {
        try {
            Field[] valueObjFields;
            if (oldValue == null || newValue == null || oldValue.trim().equals("") || newValue.trim().equals("") || propertyName == null || propertyName.trim().equals("")) {
                Object[] msgs = new String[]{};
                throw new BPMOrganizationException(70669, msgs);
            }
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            ReadAllQuery retrieveGLobalTableRowForPropertyQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            ExpressionBuilder gblTblRowRetrievalExpBldr = retrieveGLobalTableRowForPropertyQuery.getExpressionBuilder();
            Expression expression = gblTblRowRetrievalExpBldr.get("propertyName").equal((Object)propertyName);
            retrieveGLobalTableRowForPropertyQuery.setSelectionCriteria(expression);
            List globalTableObjectList = (List)uow.executeQuery((DatabaseQuery)retrieveGLobalTableRowForPropertyQuery);
            if (globalTableObjectList == null || globalTableObjectList.size() == 0) {
                String msg = "ExtendedUserPropertiesPersistencyDriver.updatePropertyValue() >> No property by the name " + propertyName + "defined in the repository.";
                Object[] msgs = new String[]{msg};
                throw new BPMOrganizationException(70614, msgs);
            }
            BpmExtUserPropertyGlobal globalTblRowObj = (BpmExtUserPropertyGlobal)globalTableObjectList.get(0);
            String propertyDataType = globalTblRowObj.getPropertyDataType();
            try {
                PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(propertyDataType);
                switch (valueTypeEnum) {
                    case DATE: {
                        Object[] msgs = new String[]{propertyName};
                        throw new BPMOrganizationException(70672, msgs);
                    }
                    case NUMBER: {
                        Object[] msgs = new String[]{propertyName};
                        throw new BPMOrganizationException(70673, msgs);
                    }
                    case FREEFORM_STRING: {
                        Object[] msgs = new String[]{propertyName};
                        throw new BPMOrganizationException(70674, msgs);
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                Object[] msgs = new String[]{propertyDataType};
                throw new BPMOrganizationException(70662, msgs, (Exception)iae);
            }
            String mappedColumnName = globalTblRowObj.getPropValueColumnName();
            String attributeName = this.generateAttributeNameFromColumnName(mappedColumnName);
            HashMap<String, Field> attributeNameToFieldMap = new HashMap<String, Field>();
            for (Field f : valueObjFields = BpmExtUserPropertyValue.class.getDeclaredFields()) {
                attributeNameToFieldMap.put(f.getName(), f);
            }
            ArrayList<ParticipantProperty> propertyList = new ArrayList<ParticipantProperty>();
            ParticipantProperty property = objectFactory.createParticipantProperty();
            property.setName(propertyName);
            property.getValue().add(oldValue);
            propertyList.add(property);
            List<Participant> participantsWithValueAssigned = this.getParticipantsWithProperties(null, propertyList, 1, Integer.MAX_VALUE);
            if (participantsWithValueAssigned == null || participantsWithValueAssigned.size() == 0) {
                String msg = "ExtendedUserPropertiesPersistencyDriver.updatePropertyValue() >> Property " + propertyName + "not assigned to any participants.";
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)msg);
                String definedStringValues = globalTblRowObj.getPropertyStringValue();
                List<String> definedStringValuesAsList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(definedStringValues);
                if (!definedStringValuesAsList.contains(oldValue)) {
                    Object[] msgs = new Object[]{property.getValue().get(0)};
                    throw new BPMOrganizationException(70614, msgs);
                }
                definedStringValuesAsList.remove(oldValue);
                definedStringValuesAsList.add(newValue);
                String newStringValue = ExtendedUserPropertiesPersistencyDriver.convertStringListIntoSingleDelimitedString(definedStringValuesAsList);
                globalTblRowObj.setPropertyStringValue(newStringValue);
                globalTblRowObj.setLastUpdatedBy(ctx.getUser());
                globalTblRowObj.setLastUpdatedByIdctx(ctx.getIdentityContext());
                Calendar cal = Calendar.getInstance();
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                globalTblRowObj.setLastUpdatedDate(ts);
                uow.registerExistingObject((Object)globalTblRowObj);
                if (localUoW[0]) {
                    uow.commit();
                }
                return;
            }
            String msg2 = "ExtendedUserPropertiesPersistencyDriver.updatePropertyValue() >> Value " + property.getValue().get(0) + " of property " + propertyName + " has been assigned to participants.";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)msg2);
            ArrayList valueRowObjectsOfAllParticipants = new ArrayList();
            for (Participant part : participantsWithValueAssigned) {
                ReadAllQuery existingValueRowsQuery = new ReadAllQuery(BpmExtUserPropertyValue.class);
                ExpressionBuilder expBldr = existingValueRowsQuery.getExpressionBuilder();
                Expression partIDExp = expBldr.get("participantId").equal((Object)part.getName());
                Expression idCtxExp = expBldr.get("identityContext").equal((Object)((PrincipleRefType)part.getValue()).getRealm());
                Expression partTypeExp = expBldr.get("participantType").equal((Object)((PrincipleRefType)part.getValue()).getType());
                Expression combinedExp = partIDExp.and(idCtxExp).and(partTypeExp);
                existingValueRowsQuery.setSelectionCriteria(combinedExp);
                List existingValueRows = (List)uow.executeQuery((DatabaseQuery)existingValueRowsQuery);
                if (existingValueRows == null || existingValueRows.size() <= 0) continue;
                valueRowObjectsOfAllParticipants.add(existingValueRows.get(0));
            }
            for (BpmExtUserPropertyValue valueRowObj : valueRowObjectsOfAllParticipants) {
                Field stringValueField = (Field)attributeNameToFieldMap.get(attributeName);
                String value = (String)this.getPrivateField(stringValueField, valueRowObj);
                List<String> existingStringValuesAsList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(value);
                if (existingStringValuesAsList.contains(oldValue)) {
                    existingStringValuesAsList.remove(oldValue);
                    existingStringValuesAsList.add(newValue);
                    value = ExtendedUserPropertiesPersistencyDriver.convertStringListIntoSingleDelimitedString(existingStringValuesAsList);
                    String msg3 = "ExtendedUserPropertiesPersistencyDriver.updatePropertyValue() >> New Value " + value + " being set on property " + propertyName + " on participant " + valueRowObj.getParticipantId();
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)msg3);
                    this.setPrivateField(stringValueField, valueRowObj, value);
                    valueRowObj.setLastUpdatedBy(ctx.getUser());
                    valueRowObj.setLastUpdatedByIdctx(ctx.getIdentityContext());
                    Calendar cal = Calendar.getInstance();
                    Timestamp ts = new Timestamp(cal.getTimeInMillis());
                    valueRowObj.setLastUpdatedDate(ts);
                    uow.registerExistingObject((Object)valueRowObj);
                    continue;
                }
                Object[] msgs = new String[]{oldValue, propertyName};
                throw new BPMOrganizationException(70676, msgs);
            }
            String definedStringValues = globalTblRowObj.getPropertyStringValue();
            List<String> definedStringValuesAsList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(definedStringValues);
            definedStringValuesAsList.remove(oldValue);
            definedStringValuesAsList.add(newValue);
            String newStringValue = ExtendedUserPropertiesPersistencyDriver.convertStringListIntoSingleDelimitedString(definedStringValuesAsList);
            globalTblRowObj.setPropertyStringValue(newStringValue);
            globalTblRowObj.setLastUpdatedBy(ctx.getUser());
            globalTblRowObj.setLastUpdatedByIdctx(ctx.getIdentityContext());
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            globalTblRowObj.setLastUpdatedDate(ts);
            uow.registerExistingObject((Object)globalTblRowObj);
            if (localUoW[0]) {
                uow.commit();
            }
            return;
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    public void deleteAllPropertiesOnParticipants(List<Participant> participants, UnitOfWork externalUoW) throws BPMOrganizationException {
        try {
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            SQLCall sqlCall = new SQLCall("DELETE FROM BPM_EXT_USER_PROPERTY_VALUE WHERE PARTICIPANT_ID = #PARTICIPANT_ID AND PARTICIPANT_TYPE = #PARTICIPANT_TYPE AND IDENTITY_CONTEXT = #IDENTITY_CONTEXT");
            DataModifyQuery query = new DataModifyQuery();
            query.setCall((Call)sqlCall);
            query.addArgument("PARTICIPANT_ID");
            query.addArgument("PARTICIPANT_TYPE");
            query.addArgument("IDENTITY_CONTEXT");
            for (Participant participant : participants) {
                Vector<String> argValues = new Vector<String>();
                argValues.add(((PrincipleRefType)participant.getValue()).getName());
                argValues.add(((PrincipleRefType)participant.getValue()).getType().value());
                argValues.add(((PrincipleRefType)participant.getValue()).getRealm());
                uow.executeQuery((DatabaseQuery)query, argValues);
            }
            if (localUoW[0]) {
                uow.commit();
            }
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<Participant> getParticipantsWithProperties(List<Participant> setOfParticipants, List<ParticipantProperty> props, int startRow, int endRow) throws BPMOrganizationException {
        try {
            propertyNameList = new ArrayList<String>();
            for (ParticipantProperty partProp : props) {
                propertyNameList.add(partProp.getName().toUpperCase());
            }
            inParamArray = new String[propertyNameList.size()];
            inParamArray = propertyNameList.toArray(inParamArray);
            readGlobalTableQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            propRetrievalExpBldr = readGlobalTableQuery.getExpressionBuilder();
            readGlobalTableQuery.setSelectionCriteria(propRetrievalExpBldr.get("propertyName").in(inParamArray));
            session = this.getClientSession();
            globalPropertyTableRows = (List)session.executeQuery((DatabaseQuery)readGlobalTableQuery);
            propertyNameBpmGlobalTblRowObjMap = new HashMap<String, BpmExtUserPropertyGlobal>();
            for (BpmExtUserPropertyGlobal globalTableRow : globalPropertyTableRows) {
                propName = globalTableRow.getPropertyName();
                propertyNameBpmGlobalTblRowObjMap.put(propName, globalTableRow);
            }
            globalANDPredicate = null;
            tempPredicate = null;
            tempORPredicate = null;
            for (ParticipantProperty partProp : props) {
                propertyValues = partProp.getValue();
                if (propertyValues.size() == 0) continue;
                if (propertyValues.size() == 1) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Property " + partProp.getName().toUpperCase() + " has only 1 value in its list."));
                    value = propertyValues.get(0);
                    propertyName = partProp.getName().toUpperCase();
                    if (propertyNameBpmGlobalTblRowObjMap.get(propertyName) == null) {
                        objs = new Object[]{propertyName};
                        throw new BPMOrganizationException(70614, objs);
                    }
                    propertyDataType = ((BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName)).getPropertyDataType();
                    mappedColumnName = ((BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName)).getPropValueColumnName();
                    if (mappedColumnName == null || mappedColumnName.trim().equals("")) {
                        objs = new Object[]{propertyName};
                        throw new BPMOrganizationException(70614, objs);
                    }
                    col = ExtendedUserPropertiesPersistencyDriver.columnNameColumnInstanceMap.get(mappedColumnName);
                    try {
                        valueTypeEnum = PropertyValueTypeEnum.valueOf(propertyDataType);
                        switch (1.$SwitchMap$oracle$bpm$services$organization$persistency$PropertyValueTypeEnum[valueTypeEnum.ordinal()]) {
                            case 1: {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Property " + partProp.getName().toUpperCase() + " is of type DATE."));
                                try {
                                    if (value instanceof java.util.Date) {
                                        tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), value);
                                        ** break;
                                    }
                                    if (value instanceof String) {
                                        try {
                                            df = DateFormat.getDateInstance(3, Locale.getDefault());
                                            sdf = (SimpleDateFormat)df;
                                            tempDate = sdf.parse((String)value);
                                            tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                        }
                                        catch (ParseException e) {
                                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.SHORT format. Attempting MEDIUM format.");
                                            try {
                                                df = DateFormat.getDateInstance(2, Locale.getDefault());
                                                sdf = (SimpleDateFormat)df;
                                                tempDate = sdf.parse((String)value);
                                                tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                            }
                                            catch (ParseException e2) {
                                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.MEDIUM format. Attempting LONG format.");
                                                try {
                                                    df = DateFormat.getDateInstance(1, Locale.getDefault());
                                                    sdf = (SimpleDateFormat)df;
                                                    tempDate = sdf.parse((String)value);
                                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                                }
                                                catch (ParseException e3) {
                                                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.LONG format. Attempting FULL format.");
                                                    try {
                                                        df = DateFormat.getDateInstance(0, Locale.getDefault());
                                                        sdf = (SimpleDateFormat)df;
                                                        tempDate = sdf.parse((String)value);
                                                        tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                                    }
                                                    catch (ParseException e4) {
                                                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.FULL format. Raising exception.");
                                                        throw e4;
                                                    }
                                                }
                                            }
                                        }
                                    } else {
                                        objs = new Object[]{value.toString(), propertyName};
                                        throw new BPMOrganizationException(70613, objs);
                                    }
lbl84:
                                    // 1 sources

                                    break;
                                }
                                catch (ParseException e) {
                                    objs = new Object[]{value.toString(), propertyName};
                                    throw new BPMOrganizationException(70613, objs, (Exception)e);
                                }
                            }
                            case 2: {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Property " + partProp.getName().toUpperCase() + " is of type NUMBER."));
                                try {
                                    if (value instanceof Integer) {
                                        tempNum = new BigDecimal((Integer)value);
                                        tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempNum);
                                        ** break;
                                    }
                                    if (value instanceof BigDecimal) {
                                        numValue = (BigDecimal)value;
                                        tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)numValue);
                                        ** break;
                                    }
                                    if (value instanceof String) {
                                        tempNum = new BigDecimal((String)value);
                                        tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempNum);
                                        ** break;
                                    }
                                    objs = new String[]{value.toString(), propertyName};
                                    throw new BPMOrganizationException(70612, objs);
lbl105:
                                    // 3 sources

                                    break;
                                }
                                catch (NumberFormatException e) {
                                    objs = new Object[]{value.toString(), propertyName};
                                    throw new BPMOrganizationException(70612, objs, (Exception)e);
                                }
                            }
                            case 3: {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Property " + partProp.getName().toUpperCase() + " is of type FREEFORM_STRING."));
                                searchString = value.toString();
                                searchString.replaceAll("%", "");
                                searchString = "%" + searchString + "%";
                                searchString = "%||" + searchString.toLowerCase() + "||" + "%";
                                globalTblRowObj = (BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName);
                                tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"LIKE"), (Object)searchString, true);
                                break;
                            }
                            case 4: {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Property " + partProp.getName().toUpperCase() + " is of type STRING."));
                                searchString = value.toString();
                                searchString.replaceAll("%", "");
                                globalTblRowObj = (BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName);
                                multiValuedProperty = globalTblRowObj.getMultiValuedProperty();
                                if (multiValuedProperty.intValue() == 1) {
                                    searchString = "%" + searchString + "%";
                                    searchString = "||" + searchString + "||";
                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"LIKE"), (Object)("%" + searchString + "%"));
                                    break;
                                }
                                searchString = "||" + searchString + "||";
                                tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)searchString);
                                break;
                            }
                        }
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Expression generated fpr property " + partProp.getName().toUpperCase() + " is \n" + tempPredicate));
                        if (globalANDPredicate == null) {
                            globalANDPredicate = tempPredicate;
                            continue;
                        }
                        globalANDPredicate = new Predicate(globalANDPredicate, 7, tempPredicate);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        objs = new Object[]{propertyDataType};
                        throw new BPMOrganizationException(70611, objs, (Exception)e);
                    }
                }
                tempORPredicate = null;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Property " + partProp.getName().toUpperCase() + " has multiple values provided in its list."));
                propertyName = partProp.getName().toUpperCase();
                propertyDataType = ((BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName)).getPropertyDataType();
                mappedColumnName = ((BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName)).getPropValueColumnName();
                if (mappedColumnName == null || mappedColumnName.trim().equals("")) {
                    objs = new Object[]{propertyName};
                    throw new BPMOrganizationException(70614, objs);
                }
                col = ExtendedUserPropertiesPersistencyDriver.columnNameColumnInstanceMap.get(mappedColumnName);
                try {
                    valueTypeEnum = PropertyValueTypeEnum.valueOf(propertyDataType);
                    switch (1.$SwitchMap$oracle$bpm$services$organization$persistency$PropertyValueTypeEnum[valueTypeEnum.ordinal()]) {
                        case 1: {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Property " + partProp.getName().toUpperCase() + " is of type DATE."));
                            tempPredicate = null;
                            for (E value : propertyValues) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Processing value " + value.toString()));
                                try {
                                    if (!(value instanceof java.util.Date)) ** GOTO lbl164
                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), value);
                                    ** GOTO lbl203
lbl164:
                                    // 1 sources

                                    if (!(value instanceof String)) ** GOTO lbl198
                                    try {
                                        df = DateFormat.getDateInstance(3, Locale.getDefault());
                                        sdf = (SimpleDateFormat)df;
                                        tempDate = sdf.parse((String)value);
                                        tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                        ** GOTO lbl203
                                    }
                                    catch (ParseException e) {
                                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.SHORT format. Attempting MEDIUM format.");
                                        try {
                                            df = DateFormat.getDateInstance(2, Locale.getDefault());
                                            sdf = (SimpleDateFormat)df;
                                            tempDate = sdf.parse((String)value);
                                            tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                            ** GOTO lbl203
                                        }
                                        catch (ParseException e2) {
                                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.MEDIUM format. Attempting LONG format.");
                                            try {
                                                df = DateFormat.getDateInstance(1, Locale.getDefault());
                                                sdf = (SimpleDateFormat)df;
                                                tempDate = sdf.parse((String)value);
                                                tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                                ** GOTO lbl203
                                            }
                                            catch (ParseException e3) {
                                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.LONG format. Attempting FULL format.");
                                                try {
                                                    df = DateFormat.getDateInstance(0, Locale.getDefault());
                                                    sdf = (SimpleDateFormat)df;
                                                    tempDate = sdf.parse((String)value);
                                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempDate);
                                                    ** GOTO lbl203
                                                }
                                                catch (ParseException e4) {
                                                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithProperties() >>  Unable to parse date string using DateFormat.FULL format. Raising exception.");
                                                    throw e4;
                                                }
                                            }
                                        }
                                    }
lbl198:
                                    // 1 sources

                                    objs = new String[]{value.toString(), propertyName};
                                    throw new BPMOrganizationException(70613, objs);
                                }
                                catch (ParseException e) {
                                    objs = new Object[]{value.toString(), propertyName};
                                    throw new BPMOrganizationException(70613, objs, (Exception)e);
                                }
lbl203:
                                // 5 sources

                                if (tempORPredicate == null) {
                                    tempORPredicate = tempPredicate;
                                    continue;
                                }
                                tempORPredicate = new Predicate(tempORPredicate, 8, tempPredicate);
                            }
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Expression generated for property " + partProp.getName().toUpperCase() + " is \n" + tempORPredicate));
                            break;
                        }
                        case 2: {
                            tempPredicate = null;
                            for (E value : propertyValues) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Processing value " + value.toString()));
                                try {
                                    if (!(value instanceof Integer)) ** GOTO lbl219
                                    tempNum = new BigDecimal((Integer)value);
                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempNum);
                                    ** GOTO lbl232
lbl219:
                                    // 1 sources

                                    if (!(value instanceof BigDecimal)) ** GOTO lbl223
                                    numValue = (BigDecimal)value;
                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)numValue);
                                    ** GOTO lbl232
lbl223:
                                    // 1 sources

                                    if (!(value instanceof String)) ** GOTO lbl227
                                    tempNum = new BigDecimal((String)value);
                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)tempNum);
                                    ** GOTO lbl232
lbl227:
                                    // 1 sources

                                    objs = new String[]{value.toString(), propertyName};
                                    throw new BPMOrganizationException(70612, objs);
                                }
                                catch (NumberFormatException e) {
                                    objs = new Object[]{value.toString(), propertyName};
                                    throw new BPMOrganizationException(70612, objs, (Exception)e);
                                }
lbl232:
                                // 3 sources

                                if (tempORPredicate == null) {
                                    tempORPredicate = tempPredicate;
                                    continue;
                                }
                                tempORPredicate = new Predicate(tempORPredicate, 8, tempPredicate);
                            }
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Expression generated for property " + partProp.getName().toUpperCase() + " is \n" + tempORPredicate));
                            break;
                        }
                        case 3: {
                            tempPredicate = null;
                            globalTblRowObj = (BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName);
                            multiValuedProperty = globalTblRowObj.getMultiValuedProperty();
                            for (E value : propertyValues) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Processing value " + value.toString()));
                                searchString = value.toString();
                                searchString.replaceAll("%", "");
                                searchString = "%" + searchString + "%";
                                searchString = "%||" + searchString.toLowerCase() + "||" + "%";
                                tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"LIKE"), (Object)searchString, true);
                                if (tempORPredicate == null) {
                                    tempORPredicate = tempPredicate;
                                    continue;
                                }
                                tempORPredicate = new Predicate(tempORPredicate, 8, tempPredicate);
                            }
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Expression generated for property " + partProp.getName().toUpperCase() + " is \n" + tempORPredicate));
                            break;
                        }
                        case 4: {
                            tempPredicate = null;
                            globalTblRowObj = (BpmExtUserPropertyGlobal)propertyNameBpmGlobalTblRowObjMap.get(propertyName);
                            multiValuedProperty = globalTblRowObj.getMultiValuedProperty();
                            for (E value : propertyValues) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Processing value " + value.toString()));
                                searchString = value.toString();
                                searchString.replaceAll("%", "");
                                if (multiValuedProperty.intValue() == 1) {
                                    searchString = "%" + searchString + "%";
                                    searchString = "||" + searchString + "||";
                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"LIKE"), (Object)("%" + searchString + "%"));
                                } else {
                                    searchString = "||" + searchString + "||";
                                    tempPredicate = new Predicate(col, Predicate.getOperationNumber((String)"EQ"), (Object)searchString);
                                }
                                if (tempORPredicate == null) {
                                    tempORPredicate = tempPredicate;
                                    continue;
                                }
                                tempORPredicate = new Predicate(tempORPredicate, 8, tempPredicate);
                            }
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("getParticipantsWithProperties() >> Expression generated for property " + partProp.getName().toUpperCase() + " is \n" + tempORPredicate));
                            break;
                        }
                    }
                    if (globalANDPredicate == null) {
                        globalANDPredicate = tempORPredicate;
                        continue;
                    }
                    globalANDPredicate = new Predicate(globalANDPredicate, 7, tempORPredicate);
                }
                catch (IllegalArgumentException e) {
                    objs = new Object[]{propertyDataType};
                    throw new BPMOrganizationException(70611, objs, (Exception)e);
                }
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistenceTest.getParticipantsWithProperties() >> Final Expression without list of participants is \n" + globalANDPredicate));
            participantIDList = new ArrayList<String>();
            if (setOfParticipants != null && setOfParticipants.size() > 0) {
                for (Participant participant : setOfParticipants) {
                    participantIDList.add(((PrincipleRefType)participant.getValue()).getName());
                }
                participantIDColumn = ExtendedUserPropertiesPersistencyDriver.columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_ID_COLUMN);
                globalANDPredicate.addClause(7, participantIDColumn, Predicate.getOperationNumber((String)"IN"), participantIDList);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistenceTest.getParticipantsWithProperties() >> Final Expression with list of participants is \n" + globalANDPredicate));
            }
            columnList = new ArrayList<Column>();
            columnList.add(ExtendedUserPropertiesPersistencyDriver.columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_ID_COLUMN));
            columnList.add(ExtendedUserPropertiesPersistencyDriver.columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_TYPE_COLUMN));
            columnList.add(ExtendedUserPropertiesPersistencyDriver.columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.IDENTITY_CONTEXT_COLUMN));
            ordering = this.createOrderingOnValueTableParticipantIDColumn();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithPropertiesUsing() >> Transformed ordering is " + ordering.toString()));
            return this.retrieveListofParticipantsUsing(columnList, globalANDPredicate, ordering, session, startRow, endRow);
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    public List<ParticipantProperty> searchExtendedUserProperties(String propertyName) throws BPMOrganizationException {
        if (propertyName == null || propertyName.equals("") || propertyName.equals("*")) {
            return this.getAllProperties();
        }
        try {
            ClientSession session = this.getClientSession();
            Predicate predicate = null;
            propertyName.replaceAll("\\*", "");
            propertyName.replaceAll("%", "");
            String searchString = "%" + propertyName.toUpperCase() + "%";
            predicate = new Predicate(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_NAME_COLUMN, Predicate.getOperationNumber((String)"LIKE"), (Object)searchString);
            Ordering ordering = this.createOrderingOnGlobalTablePropertyNameColumn();
            ArrayList<Column> columnList = new ArrayList<Column>();
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_NAME_COLUMN);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_STRING_VALUE);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_CREATED_BY);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_DATA_TYPE_COLUMN);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_CREATED_BY_IDCTX);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_CREATED_DATE);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_LAST_UPDATED_BY);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_LAST_UPDATED_BY_IDCTX);
            columnList.add(BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE_PROPERTY_LAST_UPDATED_DATE);
            return this.retrieveListofParticipantPropertyUsing(columnList, predicate, ordering, session);
        }
        catch (WorkflowException e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, (Exception)((Object)e));
        }
    }

    public List<Participant> getParticipantsWithProperties(List<Participant> setOfParticipants, Predicate predicate, int startRow, int endRow) throws BPMOrganizationException {
        ReadAllQuery retrieveAllGLobalTableRowsQuery;
        ClientSession session = this.getClientSession();
        List globalTableObjectList = (List)session.executeQuery((DatabaseQuery)(retrieveAllGLobalTableRowsQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class)));
        if (globalTableObjectList == null || globalTableObjectList.size() == 0) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70677, objs);
        }
        HashMap<String, BpmExtUserPropertyGlobal> customCompositeKeyToBpmExtUserPropertyGlobalMap = new HashMap<String, BpmExtUserPropertyGlobal>();
        for (BpmExtUserPropertyGlobal globalTblRowObj : globalTableObjectList) {
            customCompositeKeyToBpmExtUserPropertyGlobalMap.put(globalTblRowObj.getPropertyName(), globalTblRowObj);
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        Predicate finalPredicate = null;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithPropertiesUsing() >> Predicate before flex-field transformation is " + predicate.toString()));
        if (predicate != null) {
            this.transformPredicate(predicate.getPredicateType(), customCompositeKeyToBpmExtUserPropertyGlobalMap, columnList);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithPropertiesUsing() >> Transformed predicate is " + predicate.toString()));
            if (setOfParticipants != null && setOfParticipants.size() > 0) {
                Column participantIDColumn = columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_ID_COLUMN);
                ArrayList<String> participantIDList = new ArrayList<String>();
                for (Participant participant : setOfParticipants) {
                    participantIDList.add(((PrincipleRefType)participant.getValue()).getName());
                }
                try {
                    Predicate orderingPredicate = new Predicate(participantIDColumn, Predicate.getOperationNumber((String)"IN"), participantIDList);
                    finalPredicate = new Predicate(predicate, 7, orderingPredicate);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithPropertiesUsing() >> Final predicate with ordering clause is:\n " + finalPredicate.toString()));
                }
                catch (WorkflowException e) {
                    throw new BPMOrganizationException((Exception)((Object)e));
                }
            } else {
                finalPredicate = predicate;
            }
        } else {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        columnList.add(columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_ID_COLUMN));
        columnList.add(columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_TYPE_COLUMN));
        columnList.add(columnNameColumnInstanceMap.get(BPMOrganizationServiceTableAndColumnNameConstants.IDENTITY_CONTEXT_COLUMN));
        Ordering ordering = this.createOrderingOnValueTableParticipantIDColumn();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.getParticipantsWithPropertiesUsing() >> Transformed ordering is " + ordering.toString()));
        List<Participant> participantList = this.retrieveListofParticipantsUsing(columnList, finalPredicate, ordering, session, startRow, endRow);
        return participantList;
    }

    @Override
    public Object convertFromTopLink(Object object) {
        BpmExtUserPropertyValue valueRow = (BpmExtUserPropertyValue)object;
        PrincipleRefType principleRefType = objectFactory.createPrincipleRefType();
        principleRefType.setName(valueRow.getParticipantId());
        principleRefType.setRealm(valueRow.getIdentityContext());
        principleRefType.setType(ParticipantTypeEnum.valueOf((String)valueRow.getParticipantType()));
        Participant participant = objectFactory.createParticipant(principleRefType);
        return participant;
    }

    public void setPropertiesOnParticipants(List<ParticipantProperties> participantPropertiesList, UnitOfWork externalUoW) throws BPMOrganizationException {
        if (participantPropertiesList == null || participantPropertiesList.size() == 0) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        try {
            Field[] valueObjFields;
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            boolean isSystemCaseAgnostic = !WorkflowUtil.isUserNameCaseSensitive();
            ReadAllQuery retrieveAllGLobalTableRowsQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            List globalTableObjectList = (List)uow.executeQuery((DatabaseQuery)retrieveAllGLobalTableRowsQuery);
            HashMap<String, BpmExtUserPropertyGlobal> propertyNameToBpmExtUserPropertyGlobalMap = new HashMap<String, BpmExtUserPropertyGlobal>();
            for (BpmExtUserPropertyGlobal globalTblRowObj : globalTableObjectList) {
                propertyNameToBpmExtUserPropertyGlobalMap.put(globalTblRowObj.getPropertyName(), globalTblRowObj);
            }
            HashMap<String, Field> attributeNameToFieldMap = new HashMap<String, Field>();
            for (Field f : valueObjFields = BpmExtUserPropertyValue.class.getDeclaredFields()) {
                attributeNameToFieldMap.put(f.getName(), f);
            }
            for (ParticipantProperties participantPropertiesObject : participantPropertiesList) {
                if (participantPropertiesObject.getParticipant() == null) {
                    Object[] objs = new String[]{};
                    throw new BPMOrganizationException(70669, objs);
                }
                BpmExtUserPropertyValue existingValueTblRowObj = this.deleteAllPropertiesOnAParticipant(participantPropertiesObject.getParticipant(), uow);
                BpmExtUserPropertyValue valueTableRowObject = new BpmExtUserPropertyValue();
                valueTableRowObject = (BpmExtUserPropertyValue)uow.registerNewObject((Object)valueTableRowObject);
                if (isSystemCaseAgnostic) {
                    valueTableRowObject.setParticipantId(participantPropertiesObject.getParticipant().getName().toLowerCase());
                } else {
                    valueTableRowObject.setParticipantId(participantPropertiesObject.getParticipant().getName());
                }
                valueTableRowObject.setIdentityContext(participantPropertiesObject.getParticipant().getRealm());
                valueTableRowObject.setParticipantType(participantPropertiesObject.getParticipant().getType().value());
                valueTableRowObject.setGuid(Util.getGuid());
                if (existingValueTblRowObj != null) {
                    valueTableRowObject.setCreatedBy(existingValueTblRowObj.getCreatedBy());
                    valueTableRowObject.setCreatedByIdctx(existingValueTblRowObj.getCreatedByIdctx());
                    valueTableRowObject.setCreatedDate(existingValueTblRowObj.getCreatedDate());
                } else {
                    valueTableRowObject.setCreatedBy(participantPropertiesObject.getCreatedBy());
                    valueTableRowObject.setCreatedByIdctx(participantPropertiesObject.getCreatedByIdentityContext());
                    valueTableRowObject.setCreatedDate(ExtendedUserPropertiesPersistencyDriver.convertToTimestamp(participantPropertiesObject.getCreatedDate()));
                }
                valueTableRowObject.setLastUpdatedBy(participantPropertiesObject.getLastUpdatedBy());
                valueTableRowObject.setLastUpdatedByIdctx(participantPropertiesObject.getLastUpdatedByIdentityContext());
                valueTableRowObject.setLastUpdatedDate(ExtendedUserPropertiesPersistencyDriver.convertToTimestamp(participantPropertiesObject.getLastUpdatedDate()));
                List propertyList = participantPropertiesObject.getParticipantProperty();
                if (propertyList == null || propertyList.size() == 0) {
                    Object[] objs = new String[]{};
                    throw new BPMOrganizationException(70669, objs);
                }
                for (ParticipantProperty property : propertyList) {
                    Object[] objs;
                    String propName = property.getName().toUpperCase();
                    BpmExtUserPropertyGlobal globalTableRowObj = (BpmExtUserPropertyGlobal)propertyNameToBpmExtUserPropertyGlobalMap.get(propName);
                    if (globalTableRowObj == null) {
                        Object[] objs2 = new String[]{propName};
                        throw new BPMOrganizationException(70614, objs2);
                    }
                    String propType = globalTableRowObj.getPropertyDataType();
                    PropertyValueTypeEnum valueTypeEnum = null;
                    try {
                        valueTypeEnum = Enum.valueOf(PropertyValueTypeEnum.class, propType);
                    }
                    catch (IllegalArgumentException e) {
                        objs = new String[]{propType};
                        throw new BPMOrganizationException(70662, objs);
                    }
                    catch (NullPointerException npe) {
                        objs = new String[]{"NULL"};
                        throw new BPMOrganizationException(70611, objs);
                    }
                    switch (valueTypeEnum) {
                        case DATE: {
                            Object[] objs3;
                            String assignedColumnName = globalTableRowObj.getPropValueColumnName();
                            String objAttributeName = this.generateAttributeNameFromColumnName(assignedColumnName);
                            Field f = (Field)attributeNameToFieldMap.get(objAttributeName);
                            List propertyValues = property.getValue();
                            if (propertyValues == null || propertyValues.size() == 0 || propertyValues.size() > 1) {
                                objs3 = new String[]{"NULL", propName};
                                throw new BPMOrganizationException(70613, objs3);
                            }
                            Object propValue2 = propertyValues.get(0);
                            if (propValue2 instanceof java.util.Date) {
                                this.setPrivateField(f, valueTableRowObject, propValue2);
                                break;
                            }
                            if (propValue2 instanceof String) {
                                java.util.Date tempDate;
                                try {
                                    DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
                                    SimpleDateFormat sdf = (SimpleDateFormat)df;
                                    tempDate = sdf.parse((String)propValue2);
                                    this.setPrivateField(f, valueTableRowObject, tempDate);
                                    break;
                                }
                                catch (ParseException e) {
                                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.setPropertiesOnParticipants() >>  Unable to parse date string using DateFormat.SHORT format. Attempting MEDIUM format.");
                                    try {
                                        DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
                                        tempDate = df.parse((String)propValue2);
                                        this.setPrivateField(f, valueTableRowObject, tempDate);
                                        break;
                                    }
                                    catch (ParseException e2) {
                                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.setPropertiesOnParticipants() >>  Unable to parse date string using DateFormat.MEDIUM format. Attempting LONG format.");
                                        try {
                                            DateFormat df = DateFormat.getDateInstance(1, Locale.getDefault());
                                            java.util.Date tempDate2 = df.parse((String)propValue2);
                                            this.setPrivateField(f, valueTableRowObject, tempDate2);
                                            break;
                                        }
                                        catch (ParseException e3) {
                                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.setPropertiesOnParticipants() >>  Unable to parse date string using DateFormat.LONG format. Attempting FULL format.");
                                            try {
                                                DateFormat df = DateFormat.getDateInstance(0, Locale.getDefault());
                                                java.util.Date tempDate3 = df.parse((String)propValue2);
                                                this.setPrivateField(f, valueTableRowObject, tempDate3);
                                                break;
                                            }
                                            catch (ParseException e4) {
                                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.setPropertiesOnParticipants() >>  Unable to parse date string using DateFormat.FULL format. Raising exception.");
                                                Object[] objs4 = new Object[]{propValue2, propName};
                                                throw new BPMOrganizationException(70613, objs4, (Exception)e4);
                                            }
                                        }
                                    }
                                }
                            }
                            Object[] objs5 = new Object[]{propValue2, propName};
                            throw new BPMOrganizationException(70613, objs5);
                        }
                        case NUMBER: {
                            Object[] objs6;
                            BigDecimal tempNum;
                            Object[] objs3;
                            String assignedColumnName = globalTableRowObj.getPropValueColumnName();
                            String objAttributeName = this.generateAttributeNameFromColumnName(assignedColumnName);
                            Field f = (Field)attributeNameToFieldMap.get(objAttributeName);
                            List propertyValues = property.getValue();
                            if (propertyValues == null || propertyValues.size() == 0 || propertyValues.size() > 1) {
                                objs3 = new String[]{"NULL", propName};
                                throw new BPMOrganizationException(70612, objs3);
                            }
                            Object propValue2 = propertyValues.get(0);
                            if (propValue2 instanceof Integer) {
                                try {
                                    tempNum = new BigDecimal((Integer)propValue2);
                                    this.setPrivateField(f, valueTableRowObject, tempNum);
                                    break;
                                }
                                catch (IllegalArgumentException e) {
                                    objs6 = new Object[]{propValue2, propName};
                                    throw new BPMOrganizationException(70612, objs6, (Exception)e);
                                }
                            }
                            if (propValue2 instanceof BigDecimal) {
                                this.setPrivateField(f, valueTableRowObject, propValue2);
                                break;
                            }
                            if (propValue2 instanceof String) {
                                try {
                                    tempNum = new BigDecimal((String)propValue2);
                                    this.setPrivateField(f, valueTableRowObject, tempNum);
                                    break;
                                }
                                catch (IllegalArgumentException e) {
                                    objs6 = new Object[]{propValue2, propName};
                                    throw new BPMOrganizationException(70612, objs6, (Exception)e);
                                }
                            }
                            Object[] objs5 = new Object[]{propValue2, propName};
                            throw new BPMOrganizationException(70612, objs5);
                        }
                        case FREEFORM_STRING: {
                            Object propValue2;
                            List propertyValues = property.getValue();
                            if (propertyValues == null || propertyValues.size() == 0) {
                                objs = new String[]{propName, "FREEFORM_STRING"};
                                throw new BPMOrganizationException(70661, objs);
                            }
                            BigDecimal multiValuedProperty = globalTableRowObj.getMultiValuedProperty();
                            if (multiValuedProperty.intValue() == 0) {
                                if (propertyValues.size() > 1) {
                                    Object[] objs7 = new String[]{propName};
                                    throw new BPMOrganizationException(70620, objs7);
                                }
                                String assignedColumnName = globalTableRowObj.getPropValueColumnName();
                                String objAttributeName = this.generateAttributeNameFromColumnName(assignedColumnName);
                                Field f = (Field)attributeNameToFieldMap.get(objAttributeName);
                                this.setPrivateField(f, valueTableRowObject, MULTI_VALUED_PROPERTY_DELIMETER + propertyValues.get(0).toString() + MULTI_VALUED_PROPERTY_DELIMETER);
                                break;
                            }
                            ArrayList<String> stringPropertyValues = new ArrayList<String>();
                            for (Object propValue2 : propertyValues) {
                                if (!(propValue2 instanceof String)) {
                                    stringPropertyValues.add(propValue2.toString());
                                    continue;
                                }
                                stringPropertyValues.add((String)propValue2);
                            }
                            String providedValuesAsSingleString = ExtendedUserPropertiesPersistencyDriver.convertStringListIntoSingleDelimitedString(stringPropertyValues);
                            String assignedColumnName = globalTableRowObj.getPropValueColumnName();
                            String objAttributeName = this.generateAttributeNameFromColumnName(assignedColumnName);
                            Field f = (Field)attributeNameToFieldMap.get(objAttributeName);
                            this.setPrivateField(f, valueTableRowObject, providedValuesAsSingleString);
                            break;
                        }
                        case STRING: {
                            Object[] objs5;
                            Object[] objs3;
                            List propertyValues = property.getValue();
                            if (propertyValues == null || propertyValues.size() == 0) {
                                objs = new String[]{propName, "STRING"};
                                throw new BPMOrganizationException(70661, objs);
                            }
                            String allowedStringValues = globalTableRowObj.getPropertyStringValue();
                            List<String> allowedStringValueList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(allowedStringValues);
                            BigDecimal multiValuedProperty = globalTableRowObj.getMultiValuedProperty();
                            if (multiValuedProperty.intValue() == 0) {
                                if (propertyValues.size() > 1) {
                                    objs3 = new String[]{propName};
                                    throw new BPMOrganizationException(70620, objs3);
                                }
                                String singleStringValue = allowedStringValueList.get(0);
                                if (singleStringValue.equals(propertyValues.get(0).toString())) {
                                    String assignedColumnName = globalTableRowObj.getPropValueColumnName();
                                    String objAttributeName = this.generateAttributeNameFromColumnName(assignedColumnName);
                                    Field f = (Field)attributeNameToFieldMap.get(objAttributeName);
                                    this.setPrivateField(f, valueTableRowObject, MULTI_VALUED_PROPERTY_DELIMETER + singleStringValue + MULTI_VALUED_PROPERTY_DELIMETER);
                                    break;
                                }
                                objs5 = new Object[]{propertyValues.get(0), propName};
                                throw new BPMOrganizationException(70621, objs5);
                            }
                            ArrayList<String> stringPropertyValues = new ArrayList<String>();
                            for (Object propValue : propertyValues) {
                                if (!(propValue instanceof String)) {
                                    stringPropertyValues.add(propValue.toString());
                                    continue;
                                }
                                stringPropertyValues.add((String)propValue);
                            }
                            if (ExtendedUserPropertiesPersistencyDriver.allProvidedValuesContainedInDefinedValues(allowedStringValueList, stringPropertyValues)) {
                                String providedValuesAsSingleString = ExtendedUserPropertiesPersistencyDriver.convertStringListIntoSingleDelimitedString(stringPropertyValues);
                                String assignedColumnName = globalTableRowObj.getPropValueColumnName();
                                String objAttributeName = this.generateAttributeNameFromColumnName(assignedColumnName);
                                Field f = (Field)attributeNameToFieldMap.get(objAttributeName);
                                this.setPrivateField(f, valueTableRowObject, providedValuesAsSingleString);
                                break;
                            }
                            StringBuffer buffer = new StringBuffer(" ");
                            for (String s : stringPropertyValues) {
                                buffer.append(s).append(" ");
                            }
                            Object[] objs6 = new String[]{buffer.toString(), propName};
                            throw new BPMOrganizationException(70621, objs6);
                        }
                    }
                }
            }
            if (localUoW[0]) {
                uow.commit();
            }
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    @Override
    public Object convertFromTopLink(IBPMContext ctx, AbstractPersistencyDriver.OPERATION operation, Object jaxbObject, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        return null;
    }

    private static boolean allProvidedValuesContainedInDefinedValues(List<String> allowedStringValues, List<String> providedStringValues) {
        if (providedStringValues == null && allowedStringValues == null) {
            return true;
        }
        if (providedStringValues.size() == 0 && allowedStringValues.size() == 0) {
            return true;
        }
        for (String s : providedStringValues) {
            if (allowedStringValues.contains(s)) continue;
            return false;
        }
        return true;
    }

    private static String convertStringListIntoSingleDelimitedString(List<String> stringList) {
        if (stringList == null || stringList.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(MULTI_VALUED_PROPERTY_DELIMETER);
        for (String s : stringList) {
            buffer.append(s);
            buffer.append(MULTI_VALUED_PROPERTY_DELIMETER);
        }
        return buffer.toString();
    }

    private Map<String, Object> fetchColumnNamesAndPropertyValuesFrom(BpmExtUserPropertyValue valueTableRow) throws BPMOrganizationException {
        Field[] fields = BpmExtUserPropertyValue.class.getDeclaredFields();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Field f : fields) {
            Object value;
            String name = f.getName();
            if (auditAttributeNames.contains(name) || (value = this.getPrivateField(f, valueTableRow)) == null || value instanceof String && (value = ((String)value).trim()).equals("")) continue;
            String columnName = this.generateColumnNameFromAttributeName(name);
            resultMap.put(columnName, value);
        }
        return resultMap;
    }

    private String generateColumnNameFromAttributeName(String attributeName) throws BPMOrganizationException, NumberFormatException {
        if (attributeName == null || attributeName.trim().equals("")) {
            Object[] objs = new Object[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        if (attributeName.startsWith("strCol")) {
            String numbString = attributeName.substring(6);
            Integer number = numbString == null || numbString.equals("") ? Integer.valueOf(0) : new Integer(numbString);
            return "STR_COL" + number;
        }
        if (attributeName.startsWith("numCol")) {
            String numbString = attributeName.substring(6);
            Integer number = numbString == null || numbString.equals("") ? Integer.valueOf(0) : new Integer(numbString);
            return "NUM_COL" + number;
        }
        if (attributeName.startsWith("dateCol")) {
            String numbString = attributeName.substring(7);
            Integer number = numbString == null || numbString.equals("") ? Integer.valueOf(0) : new Integer(numbString);
            return "DATE_COL" + number;
        }
        Object[] objs = new Object[]{attributeName};
        throw new BPMOrganizationException(70678, objs);
    }

    private List<ParticipantProperty> getAllProperties() throws BPMOrganizationException {
        try {
            ClientSession session = this.getClientSession();
            ReadAllQuery retrieveAllGLobalTableRowsQuery = new ReadAllQuery(BpmExtUserPropertyGlobal.class);
            ExpressionBuilder expbldr = retrieveAllGLobalTableRowsQuery.getExpressionBuilder();
            retrieveAllGLobalTableRowsQuery.addOrdering(expbldr.get("propertyName").toUpperCase().ascending());
            List globalTableObjectList = (List)session.executeQuery((DatabaseQuery)retrieveAllGLobalTableRowsQuery);
            List<ParticipantProperty> result = ParticipantProperty_JAXB_to_Toplink_Converter.convertListOfBpmExtUserPropertyGlobalToListOfParticipantProperty(globalTableObjectList);
            return result;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    private boolean participantHasAtLeastOnePropertyDefined(BpmExtUserPropertyValue valueTblRowObj) throws Exception {
        Method[] methods;
        for (Method method : methods = BpmExtUserPropertyValue.class.getDeclaredMethods()) {
            Object value;
            String methodName = method.getName();
            if (!methodName.startsWith("getDate") && !methodName.startsWith("getNum") && !methodName.startsWith("getStr") || (value = method.invoke((Object)valueTblRowObj, new Object[0])) == null) continue;
            if (value instanceof String) {
                String stringValue = ((String)value).trim();
                if (stringValue.equals("")) continue;
                return true;
            }
            return true;
        }
        String msg = "ExtendedUserPropertiesPersistencyDriver.participantHasAtLeastOnePropertyDefined() >> Participant has no properties defined. Returning false.";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)msg);
        return false;
    }

    private boolean propertyDefinitionHasAtLeastOneValueAssigned(BpmExtUserPropertyGlobal globalTblRowObj) throws Exception {
        String propertyType = globalTblRowObj.getPropertyDataType();
        try {
            PropertyValueTypeEnum type = PropertyValueTypeEnum.valueOf(propertyType);
            switch (type) {
                case DATE: {
                    return false;
                }
                case NUMBER: {
                    return false;
                }
                case FREEFORM_STRING: {
                    return false;
                }
                case STRING: {
                    String values = globalTblRowObj.getPropertyStringValue();
                    return values != null && !values.trim().equals("");
                }
            }
            Object[] msgs = new String[]{propertyType};
            throw new BPMOrganizationException(70662, msgs);
        }
        catch (IllegalArgumentException ile) {
            Object[] msgs = new String[]{propertyType};
            throw new BPMOrganizationException(70662, msgs);
        }
    }

    private int findAvailableColumnNameFrom(PropertyValueTypeEnum columnForType, Vector<BpmExtUserPropAvlblCol> allAvailableColumns) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)(this.getClass().getSimpleName() + ".findAvailableColumnNameFrom >> Size of Available columns list = " + allAvailableColumns.size()));
        switch (columnForType) {
            case DATE: {
                int i;
                for (i = 0; i < allAvailableColumns.size(); ++i) {
                    BpmExtUserPropAvlblCol colNameRow = allAvailableColumns.elementAt(i);
                    if (colNameRow.getDateColName() == null || colNameRow.getDateColName().trim().equals("")) continue;
                    return i;
                }
                break;
            }
            case NUMBER: {
                int i;
                for (i = 0; i < allAvailableColumns.size(); ++i) {
                    BpmExtUserPropAvlblCol colNameRow = allAvailableColumns.elementAt(i);
                    if (colNameRow.getNumberColName() == null || colNameRow.getNumberColName().trim().equals("")) continue;
                    return i;
                }
                break;
            }
            case FREEFORM_STRING: {
                int i;
                for (i = 0; i < allAvailableColumns.size(); ++i) {
                    BpmExtUserPropAvlblCol colNameRow = allAvailableColumns.elementAt(i);
                    if (colNameRow.getStringColName() == null || colNameRow.getStringColName().trim().equals("")) continue;
                    return i;
                }
                break;
            }
            case STRING: {
                int i;
                for (i = 0; i < allAvailableColumns.size(); ++i) {
                    BpmExtUserPropAvlblCol colNameRow = allAvailableColumns.elementAt(i);
                    if (colNameRow.getStringColName() == null || colNameRow.getStringColName().trim().equals("")) continue;
                    return i;
                }
                break;
            }
        }
        Object[] objs = new Object[]{"No column available in the BPM_EXT_USER_PROP_AVLBL_COL table to store new property of type " + columnForType.name()};
        throw new BPMOrganizationException(70660, objs);
    }

    private BpmExtUserPropertyValue deleteAllPropertiesOnAParticipant(PrincipleRefType participant, UnitOfWork externalUoW) throws BPMOrganizationException {
        try {
            boolean[] localUoW = new boolean[1];
            UnitOfWork uow = this.getOrCreateUnitOfWork(externalUoW, localUoW);
            ReadAllQuery readParticipantPropertiesQuery = new ReadAllQuery(BpmExtUserPropertyValue.class);
            ExpressionBuilder bldr = readParticipantPropertiesQuery.getExpressionBuilder();
            Expression participantIDExp = bldr.get("participantId").equal((Object)participant.getName());
            Expression participantRealmExp = bldr.get("identityContext").equal((Object)participant.getRealm());
            Expression participantTypeExp = bldr.get("participantType").equal((Object)participant.getType());
            Expression finalExp = participantIDExp.and(participantRealmExp).and(participantTypeExp);
            readParticipantPropertiesQuery.setSelectionCriteria(finalExp);
            List valueTblObjList = (List)uow.executeQuery((DatabaseQuery)readParticipantPropertiesQuery);
            if (valueTblObjList == null || valueTblObjList.size() == 0) {
                return null;
            }
            BpmExtUserPropertyValue participantPropertiesRowObj = (BpmExtUserPropertyValue)valueTblObjList.get(0);
            SQLCall sqlCall = new SQLCall("DELETE FROM BPM_EXT_USER_PROPERTY_VALUE WHERE PARTICIPANT_ID = #PARTICIPANT_ID AND PARTICIPANT_TYPE = #PARTICIPANT_TYPE AND IDENTITY_CONTEXT = #IDENTITY_CONTEXT");
            DataModifyQuery query = new DataModifyQuery();
            query.setCall((Call)sqlCall);
            query.addArgument("PARTICIPANT_ID");
            query.addArgument("PARTICIPANT_TYPE");
            query.addArgument("IDENTITY_CONTEXT");
            Vector<String> argValues = new Vector<String>();
            argValues.add(participant.getName());
            argValues.add(participant.getType().value());
            argValues.add(participant.getRealm());
            uow.executeQuery((DatabaseQuery)query, argValues);
            if (localUoW[0]) {
                uow.commit();
            }
            return participantPropertiesRowObj;
        }
        catch (DatabaseException e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, (Exception)((Object)e));
        }
        catch (OptimisticLockException e) {
            Object[] objs = new Object[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, (Exception)((Object)e));
        }
    }

    private List<Participant> retrieveListofParticipantsUsing(List columnList, Predicate predicate, Ordering ordering, ClientSession session, int startRow, int endRow) throws BPMOrganizationException {
        try {
            PredicateImpl predicateImpl = PredicateImpl.getPredicateImpl((Predicate)predicate);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.executeListQueryUsing() >> Repos predicate implementation is \n" + predicateImpl));
            String sqlQuery = Util.getSelectQuery((List)columnList, (Predicate)predicateImpl, (Ordering)ordering);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.executeListQueryUsing() >> SQL Query is " + sqlQuery));
            String transformedSQLQuery = this.bindValuesToPredicate(sqlQuery, predicateImpl);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.executeListQueryUsing() >> Transformed SQL Query is " + transformedSQLQuery));
            DataReadQuery query = new DataReadQuery();
            ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
            policy.setResultSetConcurrency(1007);
            policy.setResultSetType(1004);
            query.useScrollableCursor(policy);
            query.setSQLString(transformedSQLQuery);
            ScrollableCursor cursor = (ScrollableCursor)session.executeQuery((DatabaseQuery)query);
            ArrayList<Participant> listOfParticipants = new ArrayList<Participant>();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> Start Row as received from client is " + startRow));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> End Row as received from the client is " + endRow));
            if (startRow <= 0) {
                startRow = 1;
            }
            if (endRow <= 0) {
                endRow = 1;
            }
            if (startRow > endRow) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)"ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> Start Row value cannot be greater than End Row value.");
                Object[] objs = new String[]{};
                throw new BPMOrganizationException(70671, objs);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> Start Row now is " + startRow));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> End Row now is " + endRow));
            if (cursor.absolute(startRow - 1)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> Cursor has been set to startRow - 1 ");
                int currPos = startRow - 1;
                while (cursor.hasNext() && currPos < endRow) {
                    Participant part = this.createParticipantFromRecord((Record)cursor.next());
                    if (part != null) {
                        listOfParticipants.add(part);
                    }
                    currPos = cursor.getPosition();
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> Current Cursor position is " + currPos));
                }
                cursor.close();
                return listOfParticipants;
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> startRow is greater than the number of rows retrieved.");
            cursor.beforeFirst();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> Cursor has been set to before first");
            int currPos = 0;
            endRow = currPos + (endRow - startRow + 1);
            while (cursor.hasNext() && currPos < endRow) {
                Participant part = this.createParticipantFromRecord((Record)cursor.next());
                if (part != null) {
                    listOfParticipants.add(part);
                }
                currPos = cursor.getPosition();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.retrieveListofParticipantsUsing() >> Current Cursor position is " + currPos));
            }
            cursor.close();
            return listOfParticipants;
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new String[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    private List<ParticipantProperty> retrieveListofParticipantPropertyUsing(List columnList, Predicate predicate, Ordering ordering, ClientSession session) throws BPMOrganizationException {
        try {
            PredicateImpl predicateImpl = PredicateImpl.getPredicateImpl((Predicate)predicate);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.executeListQueryUsing() >> Got predicate implementation successfully.");
            String sqlQuery = Util.getSelectQuery((List)columnList, (Predicate)predicateImpl, (Ordering)ordering);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.executeListQueryUsing() >> SQL Query is " + sqlQuery));
            String transformedSQLQuery = this.bindValuesToPredicate(sqlQuery, predicateImpl);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.executeListQueryUsing() >> Transformed SQL Query is " + transformedSQLQuery));
            DataReadQuery query = new DataReadQuery();
            query.setSQLString(transformedSQLQuery);
            List queryResult = (List)session.executeQuery((DatabaseQuery)query);
            ArrayList<ParticipantProperty> listOfParticipantProperty = new ArrayList<ParticipantProperty>();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.executeListQueryUsing() >> Size of returned result list is " + queryResult.size()));
            for (int index = 0; index < queryResult.size(); ++index) {
                ParticipantProperty partProp = this.createParticipantPropertyFromRecord((Record)queryResult.get(index));
                if (partProp == null) continue;
                listOfParticipantProperty.add(partProp);
            }
            return listOfParticipantProperty;
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            Object[] objs = new String[]{e.getMessage()};
            throw new BPMOrganizationException(70616, objs, e);
        }
    }

    private Participant createParticipantFromRecord(Record record) {
        PrincipleRefType principlRefType = objectFactory.createPrincipleRefType();
        if (record.size() == 0) {
            return null;
        }
        DatabaseRecord dbrec = (DatabaseRecord)record;
        Enumeration keys = dbrec.keys();
        while (keys.hasMoreElements()) {
            DatabaseField field = (DatabaseField)keys.nextElement();
            String fieldName = field.getName().trim();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.createParticipantFromRecord() >> Field name is " + fieldName + " table name is " + field.getTableName() + " field type is " + field.getSqlType()));
            if (fieldName.equals("PARTICIPANT_ID")) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.createParticipantFromRecord() >> PARTICIPANT_ID is " + (String)dbrec.get(fieldName)));
                principlRefType.setName((String)dbrec.get(fieldName));
                continue;
            }
            if (fieldName.equals("PARTICIPANT_TYPE")) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.createParticipantFromRecord() >> PARTICIPANT_TYPE is " + (String)dbrec.get(fieldName)));
                principlRefType.setType(ParticipantTypeEnum.valueOf((String)((String)dbrec.get(fieldName))));
                continue;
            }
            if (!fieldName.equals("IDENTITY_CONTEXT")) continue;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.createParticipantFromRecord() >> IDENTITY_CONTEXT is " + (String)dbrec.get(fieldName)));
            principlRefType.setRealm((String)dbrec.get(fieldName));
        }
        return objectFactory.createParticipant(principlRefType);
    }

    private ParticipantProperty createParticipantPropertyFromRecord(Record record) {
        ParticipantProperty partProp = objectFactory.createParticipantProperty();
        if (record.size() == 0) {
            return null;
        }
        DatabaseRecord dbrec = (DatabaseRecord)record;
        Enumeration keys = dbrec.keys();
        while (keys.hasMoreElements()) {
            DatabaseField field = (DatabaseField)keys.nextElement();
            String fieldName = field.getName().trim();
            if (fieldName.equals("PROPERTY_NAME")) {
                partProp.setName((String)dbrec.get(fieldName));
                continue;
            }
            if (fieldName.equals("PROPERTY_STRING_VALUE")) {
                String stringValue = (String)dbrec.get(fieldName);
                List<String> valueList = ExtendedUserPropertiesPersistencyDriver.convertDelimitedStringToListOfStrings(stringValue);
                partProp.getValue().addAll(valueList);
                continue;
            }
            if (fieldName.equals("PROPERTY_DATA_TYPE")) {
                partProp.setPropertyType((String)dbrec.get(fieldName));
                continue;
            }
            if (fieldName.equals("CREATED_BY")) {
                partProp.setCreatedBy((String)dbrec.get(fieldName));
                continue;
            }
            if (fieldName.equals("CREATED_BY_IDCTX")) {
                partProp.setCreatedByIdentityContext((String)dbrec.get(fieldName));
                continue;
            }
            if (fieldName.equals("CREATED_DATE")) {
                partProp.setCreatedDate(ExtendedUserPropertiesPersistencyDriver.convertToCalendar((java.util.Date)dbrec.get(fieldName)));
                continue;
            }
            if (fieldName.equals("LAST_UPDATED_BY")) {
                partProp.setLastUpdatedBy((String)dbrec.get(fieldName));
                continue;
            }
            if (fieldName.equals("LAST_UPDATED_BY_IDCTX")) {
                partProp.setLastUpdatedByIdentityContext((String)dbrec.get(fieldName));
                continue;
            }
            if (!fieldName.equals("LAST_UPDATED_DATE")) continue;
            partProp.setLastUpdatedDate(ExtendedUserPropertiesPersistencyDriver.convertToCalendar((java.util.Date)dbrec.get(fieldName)));
        }
        return partProp;
    }

    private String bindValuesToPredicate(String sql, PredicateImpl pred) throws Exception {
        if (sql == null || sql.equals("")) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        if (pred == null) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        List valueList = pred.getValues();
        if (valueList.size() == 0) {
            return sql;
        }
        StringBuffer transformedSQL = new StringBuffer();
        int indexOfQsMark = sql.indexOf(63);
        int loopCounter = 0;
        while (indexOfQsMark > 0) {
            String sqlFragment = sql.substring(0, indexOfQsMark);
            transformedSQL.append(sqlFragment);
            Object value = valueList.get(loopCounter);
            if (value instanceof String) {
                transformedSQL.append("'" + (String)value + "'");
            } else if (value instanceof Date) {
                transformedSQL.append("'" + value.toString() + "'");
            } else if (value instanceof java.util.Date) {
                long time = ((java.util.Date)value).getTime();
                Date sqlDate = new Date(time);
                transformedSQL.append("'" + sqlDate.toString() + "'");
            } else if (value instanceof Calendar) {
                java.util.Date date = ((Calendar)value).getTime();
                DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
                SimpleDateFormat sdf = (SimpleDateFormat)df;
                sdf.applyPattern("yyyy-MM-dd");
                String dateString = sdf.format(date);
                transformedSQL.append("to_date('" + dateString + "', 'YYYY-MM-DD')");
            } else if (value instanceof Integer || value.getClass().equals(Integer.TYPE)) {
                transformedSQL.append(value);
            } else if (value instanceof Float || value.getClass().equals(Float.TYPE)) {
                transformedSQL.append(value);
            } else if (value instanceof Double || value.getClass().equals(Double.TYPE)) {
                transformedSQL.append(value);
            } else if (value instanceof Long || value.getClass().equals(Long.TYPE)) {
                transformedSQL.append(value);
            }
            sql = sql.substring(indexOfQsMark + 1);
            indexOfQsMark = sql.indexOf(63);
            ++loopCounter;
        }
        transformedSQL.append(sql);
        return transformedSQL.toString();
    }

    private Participant doConversionFromTopLink(BpmExtUserPropertyValue object) throws BPMOrganizationException {
        Participant result = (Participant)this.convertFromTopLink(object);
        if (result == null) {
            Object[] objs = new Object[]{this.getClass().getName(), object.getClass().getName()};
            throw new BPMOrganizationException(70617, objs);
        }
        return result;
    }

    private Ordering createOrderingOnValueTableParticipantIDColumn() throws BPMOrganizationException {
        oracle.bpel.services.workflow.query.model.ObjectFactory of = new oracle.bpel.services.workflow.query.model.ObjectFactory();
        OrderingClauseType orderingClauseType = of.createOrderingClauseType();
        orderingClauseType.setColumn(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_ID_COLUMN);
        orderingClauseType.setSortOrder("ASCENDING");
        orderingClauseType.setNullFirst(false);
        orderingClauseType.setTable(BPMOrganizationServiceTableAndColumnNameConstants.BPM_EXT_USER_PROPERTY_VALUE_TABLE);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.transformOrdering() >> Creating ordering clause to order on " + BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_ID_COLUMN + " in "));
        ArrayList<OrderingClauseType> clauses = new ArrayList<OrderingClauseType>();
        clauses.add(orderingClauseType);
        Ordering result = new Ordering(clauses);
        return result;
    }

    private Ordering createOrderingOnGlobalTablePropertyNameColumn() throws BPMOrganizationException {
        oracle.bpel.services.workflow.query.model.ObjectFactory of = new oracle.bpel.services.workflow.query.model.ObjectFactory();
        OrderingClauseType orderingClauseType = of.createOrderingClauseType();
        orderingClauseType.setColumn(BPMOrganizationServiceTableAndColumnNameConstants.PROPERTY_NAME_COLUMN);
        orderingClauseType.setSortOrder("ASCENDING");
        orderingClauseType.setNullFirst(false);
        orderingClauseType.setTable(BPMOrganizationServiceTableAndColumnNameConstants.BPM_EXT_USER_PROPERTY_GLOBAL_TABLE);
        ArrayList<OrderingClauseType> clauses = new ArrayList<OrderingClauseType>();
        clauses.add(orderingClauseType);
        Ordering result = new Ordering(clauses);
        return result;
    }

    private void transformPredicate(PredicateType predicateType, Map<String, BpmExtUserPropertyGlobal> propertyNameToBpmExtUserPropertyGlobalMap, List<Column> columnList) throws BPMOrganizationException {
        if (predicateType == null) {
            return;
        }
        List predicateClauses = predicateType.getClause();
        ArrayList<ClauseType> predicateClauseList = new ArrayList<ClauseType>(predicateClauses);
        if (predicateType.getLhs() != null) {
            this.transformPredicate(predicateType.getLhs(), propertyNameToBpmExtUserPropertyGlobalMap, columnList);
            this.transformPredicate(predicateType.getRhs(), propertyNameToBpmExtUserPropertyGlobalMap, columnList);
        }
        if (predicateClauseList.size() > 0) {
            int listSize = predicateClauseList.size();
            block14: for (int index = 0; index < listSize; ++index) {
                Object[] objs;
                ClauseType predicateClause = (ClauseType)predicateClauseList.get(index);
                ColumnType col = predicateClause.getColumn();
                String columnName = col.getColumnName().trim();
                BpmExtUserPropertyGlobal globalTableRowObj = propertyNameToBpmExtUserPropertyGlobalMap.get(columnName.toUpperCase());
                if (globalTableRowObj == null) {
                    objs = new String[]{columnName};
                    throw new BPMOrganizationException(70614, objs);
                }
                col.setTableName("BPM_EXT_USER_PROPERTY_VALUE");
                col.setColumnName(globalTableRowObj.getPropValueColumnName());
                if (predicateClause.getColumnValue() != null) {
                    objs = new Object[]{columnName.toUpperCase(), predicateClause.getColumnValue()};
                    throw new BPMOrganizationException(70618, objs);
                }
                String propertyDataType = globalTableRowObj.getPropertyDataType();
                PropertyValueTypeEnum valueTypeEnum = Enum.valueOf(PropertyValueTypeEnum.class, propertyDataType);
                switch (valueTypeEnum) {
                    case DATE: {
                        Column colInstance = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                        columnList.add(colInstance);
                        if (predicateClause.getValue() != null) {
                            Calendar cal;
                            java.util.Date tempDate;
                            String value = predicateClause.getValue();
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.transformPredicate() >> Column value is of type date and is " + value));
                            try {
                                DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
                                SimpleDateFormat sdf = (SimpleDateFormat)df;
                                tempDate = sdf.parse(value);
                                cal = Calendar.getInstance();
                                cal.setTime(tempDate);
                                predicateClause.setValue(null);
                                predicateClause.setDateValue(cal);
                                continue block14;
                            }
                            catch (ParseException e) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.transformPredicate() >>  Unable to parse date string using DateFormat.SHORT format. Attempting MEDIUM format.");
                                try {
                                    DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
                                    tempDate = df.parse(value);
                                    cal = Calendar.getInstance();
                                    cal.setTime(tempDate);
                                    predicateClause.setValue(null);
                                    predicateClause.setDateValue(cal);
                                    continue block14;
                                }
                                catch (ParseException e2) {
                                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.transformPredicate() >>  Unable to parse date string using DateFormat.MEDIUM format. Attempting LONG format.");
                                    try {
                                        DateFormat df = DateFormat.getDateInstance(1, Locale.getDefault());
                                        java.util.Date tempDate2 = df.parse(value);
                                        Calendar cal2 = Calendar.getInstance();
                                        cal2.setTime(tempDate2);
                                        predicateClause.setValue(null);
                                        predicateClause.setDateValue(cal2);
                                        continue block14;
                                    }
                                    catch (ParseException e3) {
                                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"\nExtendedUserPropertiesPersistencyDriver.transformPredicate() >>  Unable to parse date string using DateFormat.LONG format. Attempting FULL format.");
                                        try {
                                            DateFormat df = DateFormat.getDateInstance(0, Locale.getDefault());
                                            java.util.Date tempDate3 = df.parse(value);
                                            Calendar cal3 = Calendar.getInstance();
                                            cal3.setTime(tempDate3);
                                            predicateClause.setValue(null);
                                            predicateClause.setDateValue(cal3);
                                            continue block14;
                                        }
                                        catch (ParseException e4) {
                                            Object[] objs2 = new String[]{value, columnName};
                                            throw new BPMOrganizationException(70613, objs2, (Exception)e4);
                                        }
                                    }
                                }
                            }
                        }
                        if (predicateClause.getDateValue() != null) continue block14;
                        Object[] objs3 = new String[]{globalTableRowObj.getPropertyName()};
                        throw new BPMOrganizationException(70619, objs3);
                    }
                    case NUMBER: {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.transformPredicate() >> Column value is of type number and is " + predicateClause.getValue()));
                        Column colInstance = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                        columnList.add(colInstance);
                        continue block14;
                    }
                    case FREEFORM_STRING: {
                        Column colInstance;
                        List<ClauseType> newClauses;
                        String value = predicateClause.getValue();
                        if (value == null) {
                            value = predicateClause.getValueList().getValue().get(0).toString();
                        }
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.transformPredicate() >> Column value is of type string and is " + value));
                        if (value == null) {
                            BPMExceptionContext ctxt = new BPMExceptionContext();
                            ctxt.setClassName(this.getClass().getName());
                            ctxt.setErrorCode(70676);
                            ctxt.setSeverity(Severity.ERRORS);
                            ctxt.setMessageArguments((Object[])new String[]{"null"});
                            throw new BPMOrganizationException(ctxt);
                        }
                        int operation = PredicateConstants.getOperationNumber((String)predicateClause.getOperator());
                        if (operation == 9) {
                            newClauses = this.generateClausesForIN(predicateClause);
                            colInstance = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                            for (int j = 0; j < newClauses.size(); ++j) {
                                columnList.add(colInstance);
                                if (j == 0) {
                                    predicateClauseList.set(index, newClauses.get(j));
                                } else {
                                    predicateClauseList.ensureCapacity(predicateClauseList.size() + newClauses.size());
                                    predicateClauseList.add(++index, newClauses.get(j));
                                }
                                newClauses.get(j).setIgnoreCase(true);
                            }
                            listSize = listSize + newClauses.size() - 1;
                            continue block14;
                        }
                        if (operation == 10) {
                            newClauses = this.generateClausesForNOT_IN(predicateClause);
                            colInstance = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                            for (int j = 0; j < newClauses.size(); ++j) {
                                columnList.add(colInstance);
                                if (j == 0) {
                                    predicateClauseList.set(index, newClauses.get(j));
                                } else {
                                    predicateClauseList.ensureCapacity(predicateClauseList.size() + newClauses.size());
                                    predicateClauseList.add(++index, newClauses.get(j));
                                }
                                newClauses.get(j).setIgnoreCase(true);
                            }
                            listSize = listSize + newClauses.size() - 1;
                            continue block14;
                        }
                        Column colInstance2 = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                        columnList.add(colInstance2);
                        value = this.getWildcardStringValue(predicateClause, value);
                        predicateClause.setValue(value);
                        predicateClause.setIgnoreCase(true);
                        predicateClause.setOperator(this.getStringPropertyOperator(predicateClause));
                        continue block14;
                    }
                    case STRING: {
                        Column colInstance;
                        List<ClauseType> newClauses;
                        String value = predicateClause.getValue();
                        if (value == null) {
                            value = predicateClause.getValueList().getValue().get(0).toString();
                        }
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\nExtendedUserPropertiesPersistencyDriver.transformPredicate() >> Column value is of type string and is " + value));
                        if (value == null) {
                            BPMExceptionContext ctxt = new BPMExceptionContext();
                            ctxt.setClassName(this.getClass().getName());
                            ctxt.setErrorCode(70676);
                            ctxt.setSeverity(Severity.ERRORS);
                            ctxt.setMessageArguments((Object[])new String[]{"null"});
                            throw new BPMOrganizationException(ctxt);
                        }
                        int operation = PredicateConstants.getOperationNumber((String)predicateClause.getOperator());
                        if (operation == 9) {
                            newClauses = this.generateClausesForIN(predicateClause);
                            colInstance = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                            for (int j = 0; j < newClauses.size(); ++j) {
                                columnList.add(colInstance);
                                if (j == 0) {
                                    predicateClauseList.set(index, newClauses.get(j));
                                    continue;
                                }
                                predicateClauseList.ensureCapacity(predicateClauseList.size() + newClauses.size());
                                predicateClauseList.add(++index, newClauses.get(j));
                            }
                            listSize = listSize + newClauses.size() - 1;
                            continue block14;
                        }
                        if (operation == 10) {
                            newClauses = this.generateClausesForNOT_IN(predicateClause);
                            colInstance = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                            for (int j = 0; j < newClauses.size(); ++j) {
                                columnList.add(colInstance);
                                if (j == 0) {
                                    predicateClauseList.set(index, newClauses.get(j));
                                    continue;
                                }
                                predicateClauseList.ensureCapacity(predicateClauseList.size() + newClauses.size());
                                predicateClauseList.add(++index, newClauses.get(j));
                            }
                            listSize = listSize + newClauses.size() - 1;
                            continue block14;
                        }
                        Column colInstance2 = columnNameColumnInstanceMap.get(globalTableRowObj.getPropValueColumnName());
                        columnList.add(colInstance2);
                        value = this.getWildcardStringValue(predicateClause, value);
                        predicateClause.setValue(value);
                        predicateClause.setOperator(this.getStringPropertyOperator(predicateClause));
                        continue block14;
                    }
                }
            }
            predicateType.getClause().clear();
            predicateType.getClause().addAll(predicateClauseList);
        }
    }

    private List<ClauseType> generateClausesForIN(ClauseType originalClause) throws BPMOrganizationException {
        ColumnType oldCol = originalClause.getColumn();
        String oldColumnName = oldCol.getColumnName().trim();
        ArrayList<ClauseType> resultClauses = new ArrayList<ClauseType>();
        List valueList = originalClause.getValueList().getValue();
        try {
            for (Object value : valueList) {
                String valueString = "%||" + (String)value + MULTI_VALUED_PROPERTY_DELIMETER + "%";
                ClauseType newClause = QueryUtil.getQueryObjectFactory().createClauseType();
                ColumnType newColumn = QueryUtil.getQueryObjectFactory().createColumnType();
                newColumn.setTableName("BPM_EXT_USER_PROPERTY_VALUE");
                newColumn.setColumnName(oldColumnName);
                newClause.setOperator(PredicateConstants.getOperator((int)6));
                newClause.setColumn(newColumn);
                newClause.setValue(valueString);
                newClause.setJoinOperator(Predicate.getLogicalOperator((int)8));
                resultClauses.add(newClause);
            }
            return resultClauses;
        }
        catch (WorkflowException e) {
            Object[] objs = new String[]{e.getMessage()};
            throw new BPMOrganizationException(70693, objs, (Exception)((Object)e));
        }
    }

    private List<ClauseType> generateClausesForNOT_IN(ClauseType originalClause) throws BPMOrganizationException {
        ColumnType oldCol = originalClause.getColumn();
        String oldColumnName = oldCol.getColumnName().trim();
        ArrayList<ClauseType> resultClauses = new ArrayList<ClauseType>();
        List valueList = originalClause.getValueList().getValue();
        try {
            for (Object value : valueList) {
                String valueString = "%||" + (String)value + MULTI_VALUED_PROPERTY_DELIMETER + "%";
                ClauseType newClause = QueryUtil.getQueryObjectFactory().createClauseType();
                ColumnType newColumn = QueryUtil.getQueryObjectFactory().createColumnType();
                newColumn.setTableName("BPM_EXT_USER_PROPERTY_VALUE");
                newColumn.setColumnName(oldColumnName);
                newClause.setOperator(PredicateConstants.getOperator((int)11));
                newClause.setColumn(newColumn);
                newClause.setValue(valueString);
                newClause.setJoinOperator(Predicate.getLogicalOperator((int)7));
                resultClauses.add(newClause);
            }
            return resultClauses;
        }
        catch (WorkflowException e) {
            Object[] objs = new String[]{e.getMessage()};
            throw new BPMOrganizationException(70694, objs, (Exception)((Object)e));
        }
    }

    private String getStringPropertyOperator(ClauseType predicateClause) {
        try {
            if (PredicateConstants.getOperationNumber((String)predicateClause.getOperator()) == 0) {
                return PredicateConstants.getOperator((int)6);
            }
            if (PredicateConstants.getOperationNumber((String)predicateClause.getOperator()) == 1) {
                return PredicateConstants.getOperator((int)11);
            }
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        return predicateClause.getOperator();
    }

    private String getWildcardStringValue(ClauseType originalClause, String value) {
        if (!(value instanceof String)) {
            return value;
        }
        int operation = PredicateConstants.getOperationNumber((String)originalClause.getOperator());
        String valueString = value;
        if (operation == 14 || operation == 15) {
            valueString = "%||" + valueString + "%";
        } else if (operation == 16 || operation == 17) {
            valueString = "%" + valueString + MULTI_VALUED_PROPERTY_DELIMETER + "%";
        } else if (operation == 12 || operation == 13 || operation == 6 || operation == 11) {
            valueString = "%||%" + valueString + "%" + MULTI_VALUED_PROPERTY_DELIMETER + "%";
        } else if (operation == 0 || operation == 1) {
            valueString = "%||" + valueString + MULTI_VALUED_PROPERTY_DELIMETER + "%";
        }
        return valueString;
    }

    private String generateAttributeNameFromColumnName(String colName) throws BPMOrganizationException {
        if (colName == null || colName.trim().equals("")) {
            Object[] msg = new String[]{};
            throw new BPMOrganizationException(70669, msg);
        }
        if (colName.startsWith("STR_COL")) {
            String numbString = colName.substring(7);
            Integer number = numbString == null || numbString.equals("") ? Integer.valueOf(0) : new Integer(numbString);
            if (number == 0) {
                return "strCol";
            }
            return "strCol" + number;
        }
        if (colName.startsWith("NUM_COL")) {
            String numbString = colName.substring(7);
            Integer number = numbString == null || numbString.equals("") ? Integer.valueOf(0) : new Integer(numbString);
            if (number == 0) {
                return "numCol";
            }
            return "numCol" + number;
        }
        if (colName.startsWith("DATE_COL")) {
            String numbString = colName.substring(8);
            Integer number = numbString == null || numbString.equals("") ? Integer.valueOf(0) : new Integer(numbString);
            if (number == 0) {
                return "dateCol";
            }
            return "dateCol" + number;
        }
        Object[] msg = new String[]{};
        throw new BPMOrganizationException(70678, msg);
    }

    private void setPrivateField(Field field, BpmExtUserPropertyValue valueRow, Object value) throws BPMOrganizationException {
        try {
            char upperCasedFirstChar;
            String fieldName = field.getName();
            char[] fieldNameCharArray = fieldName.toCharArray();
            Character firstChar = Character.valueOf(fieldNameCharArray[0]);
            fieldNameCharArray[0] = upperCasedFirstChar = Character.toUpperCase(firstChar.charValue());
            String methodName = "set" + new String(fieldNameCharArray);
            try {
                ValueRowMethods methodEnum = ValueRowMethods.valueOf(methodName);
                methodEnum.invoke(valueRow, value);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.setPrivateField() >> Succesfully set value on BpmExtUserPropertyValue object");
            }
            catch (IllegalArgumentException iae) {
                Object[] msg = new String[]{};
                throw new BPMOrganizationException(70678, msg);
            }
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private Object getPrivateField(Field field, BpmExtUserPropertyValue valueRow) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.getPrivateField()");
        try {
            char upperCasedFirstChar;
            Class<?> valueTableClass = valueRow.getClass();
            String fieldName = field.getName();
            char[] fieldNameCharArray = fieldName.toCharArray();
            Character firstChar = Character.valueOf(fieldNameCharArray[0]);
            fieldNameCharArray[0] = upperCasedFirstChar = Character.toUpperCase(firstChar.charValue());
            String methodName = "get" + new String(fieldNameCharArray);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("ExtendedUserPropertiesPersistencyDriver.getPrivateField() >> Method name constructed is " + methodName));
            Method method = valueTableClass.getDeclaredMethod(methodName, new Class[0]);
            Object result = method.invoke((Object)valueRow, new Object[0]);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"ExtendedUserPropertiesPersistencyDriver.getPrivateField() >> Successfully got value of a private field.");
            return result;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    static {
        auditAttributeNames = new ArrayList<String>();
        auditAttributeNames.add("guid");
        auditAttributeNames.add("participantId");
        auditAttributeNames.add("participantType");
        auditAttributeNames.add("identityContext");
        auditAttributeNames.add("createdDate");
        auditAttributeNames.add("createdBy");
        auditAttributeNames.add("createdByIdctx");
        auditAttributeNames.add("lastUpdatedBy");
        auditAttributeNames.add("lastUpdatedDate");
        auditAttributeNames.add("lastUpdatedByIdctx");
        objectFactory = new ObjectFactory();
        columnNameColumnInstanceMap = new HashMap<String, Column>();
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.VALUE_TABLE_GUID_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_GUID_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_ID_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_PARTICIPANT_ID_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.PARTICIPANT_TYPE_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_PARTICIPANT_TYPE_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.IDENTITY_CONTEXT_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_IDENTITY_CONTEXT_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL0_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL0_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL1_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL1_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL2_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL2_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL3_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL3_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL4_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL4_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL5_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL5_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL6_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL6_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL7_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL7_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL8_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL8_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL9_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL9_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL10_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL10_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL11_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL11_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL12_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL12_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL13_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL13_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL14_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL14_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL15_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL15_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL16_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL16_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL17_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL17_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL18_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL18_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL19_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL19_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL20_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL20_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL21_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL21_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL22_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL22_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL23_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL23_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL24_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL24_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL25_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL25_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL26_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL26_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL27_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL27_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL28_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL28_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL29_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL29_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL30_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL30_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL31_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL31_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL32_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL32_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL33_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL33_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL34_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL34_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL35_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL35_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL36_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL36_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL37_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL37_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL38_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL38_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL39_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL39_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL40_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL40_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL41_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL41_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL42_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL42_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL43_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL43_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL44_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL44_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL45_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL45_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL46_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL46_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL47_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL47_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL48_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL48_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL49_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL49_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL50_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL50_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL51_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL51_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL52_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL52_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL53_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL53_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL54_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL54_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL55_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL55_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL56_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL56_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL57_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL57_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL58_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL58_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL59_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL59_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL60_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL60_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL61_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL61_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL62_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL62_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL63_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL63_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL64_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL64_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL65_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL65_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL66_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL66_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL67_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL67_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL68_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL68_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL69_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL69_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL70_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL70_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL71_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL71_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL72_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL72_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL73_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL73_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL74_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL74_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL75_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL75_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL76_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL76_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL77_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL77_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL78_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL78_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL79_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL79_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL80_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL80_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL81_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL81_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL82_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL82_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL83_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL83_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL84_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL84_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL85_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL85_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL86_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL86_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL87_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL87_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL88_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL88_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL89_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL89_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL90_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL90_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL91_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL91_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL92_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL92_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL93_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL93_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL94_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL94_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL95_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL95_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL96_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL96_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL97_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL97_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL98_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL98_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.STR_COL99_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_STR_COL99_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL0_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL0_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL1_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL1_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL2_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL2_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL3_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL3_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL4_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL4_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL5_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL5_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL6_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL6_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL7_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL7_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL8_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL8_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL9_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL9_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL10_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL10_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL11_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL11_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL12_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL12_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL13_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL13_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL14_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL14_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL15_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL15_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL16_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL16_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL17_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL17_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL18_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL18_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL19_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL19_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL20_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL20_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL21_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL21_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL22_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL22_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL23_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL23_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL24_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL24_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL25_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL25_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL26_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL26_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL27_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL27_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL28_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL28_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL29_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL29_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL30_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL30_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL31_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL31_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL32_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL32_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL33_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL33_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL34_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL34_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL35_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL35_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL36_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL36_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL37_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL37_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL38_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL38_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.NUM_COL39_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_NUM_COL39_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL0_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL0_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL1_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL1_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL2_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL2_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL3_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL3_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL4_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL4_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL5_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL5_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL6_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL6_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL7_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL7_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL8_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL8_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL9_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL9_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL10_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL10_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL11_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL11_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL12_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL12_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL13_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL13_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL14_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL14_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL15_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL15_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL16_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL16_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL17_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL17_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL18_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL18_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL19_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL19_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL20_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL20_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL21_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL21_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL22_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL22_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL23_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL23_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL24_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL24_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL25_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL25_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL26_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL26_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL27_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL27_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL28_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL28_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL29_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL29_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL30_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL30_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL31_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL31_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL32_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL32_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL33_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL33_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL34_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL34_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL35_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL35_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL36_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL36_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL37_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL37_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL38_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL38_COLUMN);
        columnNameColumnInstanceMap.put(BPMOrganizationServiceTableAndColumnNameConstants.DATE_COL39_COLUMN, BPMOrganizationServiceTableColumnDefinitions.BPM_EXT_USER_PROPERTY_VALUE_TABLE_DATE_COL39_COLUMN);
    }

    private static enum ValueRowMethods {
        setDateCol{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol((java.util.Date)value);
            }
        }
        ,
        setDateCol1{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol1((java.util.Date)value);
            }
        }
        ,
        setDateCol10{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol10((java.util.Date)value);
            }
        }
        ,
        setDateCol11{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol11((java.util.Date)value);
            }
        }
        ,
        setDateCol12{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol12((java.util.Date)value);
            }
        }
        ,
        setDateCol13{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol13((java.util.Date)value);
            }
        }
        ,
        setDateCol14{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol14((java.util.Date)value);
            }
        }
        ,
        setDateCol15{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol15((java.util.Date)value);
            }
        }
        ,
        setDateCol16{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol16((java.util.Date)value);
            }
        }
        ,
        setDateCol17{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol17((java.util.Date)value);
            }
        }
        ,
        setDateCol18{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol18((java.util.Date)value);
            }
        }
        ,
        setDateCol19{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol19((java.util.Date)value);
            }
        }
        ,
        setDateCol2{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol2((java.util.Date)value);
            }
        }
        ,
        setDateCol20{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol20((java.util.Date)value);
            }
        }
        ,
        setDateCol21{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol21((java.util.Date)value);
            }
        }
        ,
        setDateCol22{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol22((java.util.Date)value);
            }
        }
        ,
        setDateCol23{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol23((java.util.Date)value);
            }
        }
        ,
        setDateCol24{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol24((java.util.Date)value);
            }
        }
        ,
        setDateCol25{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol25((java.util.Date)value);
            }
        }
        ,
        setDateCol26{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol26((java.util.Date)value);
            }
        }
        ,
        setDateCol27{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol27((java.util.Date)value);
            }
        }
        ,
        setDateCol28{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol28((java.util.Date)value);
            }
        }
        ,
        setDateCol29{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol29((java.util.Date)value);
            }
        }
        ,
        setDateCol3{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol3((java.util.Date)value);
            }
        }
        ,
        setDateCol30{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol30((java.util.Date)value);
            }
        }
        ,
        setDateCol31{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol31((java.util.Date)value);
            }
        }
        ,
        setDateCol32{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol32((java.util.Date)value);
            }
        }
        ,
        setDateCol33{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol33((java.util.Date)value);
            }
        }
        ,
        setDateCol34{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol34((java.util.Date)value);
            }
        }
        ,
        setDateCol35{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol35((java.util.Date)value);
            }
        }
        ,
        setDateCol36{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol36((java.util.Date)value);
            }
        }
        ,
        setDateCol37{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol37((java.util.Date)value);
            }
        }
        ,
        setDateCol38{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol38((java.util.Date)value);
            }
        }
        ,
        setDateCol39{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol39((java.util.Date)value);
            }
        }
        ,
        setDateCol4{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol4((java.util.Date)value);
            }
        }
        ,
        setDateCol5{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol5((java.util.Date)value);
            }
        }
        ,
        setDateCol6{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol6((java.util.Date)value);
            }
        }
        ,
        setDateCol7{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol7((java.util.Date)value);
            }
        }
        ,
        setDateCol8{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol8((java.util.Date)value);
            }
        }
        ,
        setDateCol9{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setDateCol9((java.util.Date)value);
            }
        }
        ,
        setNumCol{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol((BigDecimal)value);
            }
        }
        ,
        setNumCol1{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol1((BigDecimal)value);
            }
        }
        ,
        setNumCol10{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol10((BigDecimal)value);
            }
        }
        ,
        setNumCol11{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol11((BigDecimal)value);
            }
        }
        ,
        setNumCol12{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol12((BigDecimal)value);
            }
        }
        ,
        setNumCol13{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol13((BigDecimal)value);
            }
        }
        ,
        setNumCol14{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol14((BigDecimal)value);
            }
        }
        ,
        setNumCol15{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol15((BigDecimal)value);
            }
        }
        ,
        setNumCol16{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol16((BigDecimal)value);
            }
        }
        ,
        setNumCol17{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol17((BigDecimal)value);
            }
        }
        ,
        setNumCol18{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol18((BigDecimal)value);
            }
        }
        ,
        setNumCol19{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol19((BigDecimal)value);
            }
        }
        ,
        setNumCol2{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol2((BigDecimal)value);
            }
        }
        ,
        setNumCol20{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol20((BigDecimal)value);
            }
        }
        ,
        setNumCol21{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol21((BigDecimal)value);
            }
        }
        ,
        setNumCol22{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol22((BigDecimal)value);
            }
        }
        ,
        setNumCol23{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol23((BigDecimal)value);
            }
        }
        ,
        setNumCol24{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol24((BigDecimal)value);
            }
        }
        ,
        setNumCol25{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol25((BigDecimal)value);
            }
        }
        ,
        setNumCol26{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol26((BigDecimal)value);
            }
        }
        ,
        setNumCol27{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol27((BigDecimal)value);
            }
        }
        ,
        setNumCol28{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol28((BigDecimal)value);
            }
        }
        ,
        setNumCol29{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol29((BigDecimal)value);
            }
        }
        ,
        setNumCol3{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol3((BigDecimal)value);
            }
        }
        ,
        setNumCol30{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol30((BigDecimal)value);
            }
        }
        ,
        setNumCol31{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol31((BigDecimal)value);
            }
        }
        ,
        setNumCol32{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol32((BigDecimal)value);
            }
        }
        ,
        setNumCol33{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol33((BigDecimal)value);
            }
        }
        ,
        setNumCol34{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol34((BigDecimal)value);
            }
        }
        ,
        setNumCol35{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol35((BigDecimal)value);
            }
        }
        ,
        setNumCol36{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol36((BigDecimal)value);
            }
        }
        ,
        setNumCol37{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol37((BigDecimal)value);
            }
        }
        ,
        setNumCol38{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol38((BigDecimal)value);
            }
        }
        ,
        setNumCol39{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol39((BigDecimal)value);
            }
        }
        ,
        setNumCol4{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol4((BigDecimal)value);
            }
        }
        ,
        setNumCol5{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol5((BigDecimal)value);
            }
        }
        ,
        setNumCol6{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol6((BigDecimal)value);
            }
        }
        ,
        setNumCol7{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol7((BigDecimal)value);
            }
        }
        ,
        setNumCol8{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol8((BigDecimal)value);
            }
        }
        ,
        setNumCol9{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setNumCol9((BigDecimal)value);
            }
        }
        ,
        setStrCol{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol((String)value);
            }
        }
        ,
        setStrCol1{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol1((String)value);
            }
        }
        ,
        setStrCol10{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol10((String)value);
            }
        }
        ,
        setStrCol11{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol11((String)value);
            }
        }
        ,
        setStrCol12{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol12((String)value);
            }
        }
        ,
        setStrCol13{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol13((String)value);
            }
        }
        ,
        setStrCol14{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol14((String)value);
            }
        }
        ,
        setStrCol15{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol15((String)value);
            }
        }
        ,
        setStrCol16{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol16((String)value);
            }
        }
        ,
        setStrCol17{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol17((String)value);
            }
        }
        ,
        setStrCol18{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol18((String)value);
            }
        }
        ,
        setStrCol19{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol19((String)value);
            }
        }
        ,
        setStrCol2{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol2((String)value);
            }
        }
        ,
        setStrCol20{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol20((String)value);
            }
        }
        ,
        setStrCol21{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol21((String)value);
            }
        }
        ,
        setStrCol22{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol22((String)value);
            }
        }
        ,
        setStrCol23{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol23((String)value);
            }
        }
        ,
        setStrCol24{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol24((String)value);
            }
        }
        ,
        setStrCol25{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol25((String)value);
            }
        }
        ,
        setStrCol26{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol26((String)value);
            }
        }
        ,
        setStrCol27{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol27((String)value);
            }
        }
        ,
        setStrCol28{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol28((String)value);
            }
        }
        ,
        setStrCol29{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol29((String)value);
            }
        }
        ,
        setStrCol3{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol3((String)value);
            }
        }
        ,
        setStrCol30{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol30((String)value);
            }
        }
        ,
        setStrCol31{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol31((String)value);
            }
        }
        ,
        setStrCol32{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol32((String)value);
            }
        }
        ,
        setStrCol33{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol33((String)value);
            }
        }
        ,
        setStrCol34{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol34((String)value);
            }
        }
        ,
        setStrCol35{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol35((String)value);
            }
        }
        ,
        setStrCol36{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol36((String)value);
            }
        }
        ,
        setStrCol37{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol37((String)value);
            }
        }
        ,
        setStrCol38{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol38((String)value);
            }
        }
        ,
        setStrCol39{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol39((String)value);
            }
        }
        ,
        setStrCol4{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol4((String)value);
            }
        }
        ,
        setStrCol40{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol40((String)value);
            }
        }
        ,
        setStrCol41{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol41((String)value);
            }
        }
        ,
        setStrCol42{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol42((String)value);
            }
        }
        ,
        setStrCol43{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol43((String)value);
            }
        }
        ,
        setStrCol44{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol44((String)value);
            }
        }
        ,
        setStrCol45{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol45((String)value);
            }
        }
        ,
        setStrCol46{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol46((String)value);
            }
        }
        ,
        setStrCol47{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol47((String)value);
            }
        }
        ,
        setStrCol48{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol48((String)value);
            }
        }
        ,
        setStrCol49{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol49((String)value);
            }
        }
        ,
        setStrCol5{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol5((String)value);
            }
        }
        ,
        setStrCol50{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol50((String)value);
            }
        }
        ,
        setStrCol51{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol51((String)value);
            }
        }
        ,
        setStrCol52{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol52((String)value);
            }
        }
        ,
        setStrCol53{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol53((String)value);
            }
        }
        ,
        setStrCol54{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol54((String)value);
            }
        }
        ,
        setStrCol55{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol55((String)value);
            }
        }
        ,
        setStrCol56{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol56((String)value);
            }
        }
        ,
        setStrCol57{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol57((String)value);
            }
        }
        ,
        setStrCol58{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol58((String)value);
            }
        }
        ,
        setStrCol59{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol59((String)value);
            }
        }
        ,
        setStrCol6{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol6((String)value);
            }
        }
        ,
        setStrCol60{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol60((String)value);
            }
        }
        ,
        setStrCol61{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol61((String)value);
            }
        }
        ,
        setStrCol62{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol62((String)value);
            }
        }
        ,
        setStrCol63{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol63((String)value);
            }
        }
        ,
        setStrCol64{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol64((String)value);
            }
        }
        ,
        setStrCol65{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol65((String)value);
            }
        }
        ,
        setStrCol66{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol66((String)value);
            }
        }
        ,
        setStrCol67{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol67((String)value);
            }
        }
        ,
        setStrCol68{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol68((String)value);
            }
        }
        ,
        setStrCol69{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol69((String)value);
            }
        }
        ,
        setStrCol7{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol7((String)value);
            }
        }
        ,
        setStrCol70{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol70((String)value);
            }
        }
        ,
        setStrCol71{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol71((String)value);
            }
        }
        ,
        setStrCol72{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol72((String)value);
            }
        }
        ,
        setStrCol73{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol73((String)value);
            }
        }
        ,
        setStrCol74{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol74((String)value);
            }
        }
        ,
        setStrCol75{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol75((String)value);
            }
        }
        ,
        setStrCol76{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol76((String)value);
            }
        }
        ,
        setStrCol77{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol77((String)value);
            }
        }
        ,
        setStrCol78{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol78((String)value);
            }
        }
        ,
        setStrCol79{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol79((String)value);
            }
        }
        ,
        setStrCol8{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol8((String)value);
            }
        }
        ,
        setStrCol80{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol80((String)value);
            }
        }
        ,
        setStrCol81{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol81((String)value);
            }
        }
        ,
        setStrCol82{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol82((String)value);
            }
        }
        ,
        setStrCol83{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol83((String)value);
            }
        }
        ,
        setStrCol84{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol84((String)value);
            }
        }
        ,
        setStrCol85{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol85((String)value);
            }
        }
        ,
        setStrCol86{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol86((String)value);
            }
        }
        ,
        setStrCol87{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol87((String)value);
            }
        }
        ,
        setStrCol88{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol88((String)value);
            }
        }
        ,
        setStrCol89{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol89((String)value);
            }
        }
        ,
        setStrCol9{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol9((String)value);
            }
        }
        ,
        setStrCol90{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol90((String)value);
            }
        }
        ,
        setStrCol91{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol91((String)value);
            }
        }
        ,
        setStrCol92{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol92((String)value);
            }
        }
        ,
        setStrCol93{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol93((String)value);
            }
        }
        ,
        setStrCol94{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol94((String)value);
            }
        }
        ,
        setStrCol95{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol95((String)value);
            }
        }
        ,
        setStrCol96{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol96((String)value);
            }
        }
        ,
        setStrCol97{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol97((String)value);
            }
        }
        ,
        setStrCol98{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol98((String)value);
            }
        }
        ,
        setStrCol99{

            @Override
            public void invoke(BpmExtUserPropertyValue valueRow, Object value) {
                valueRow.setStrCol99((String)value);
            }
        };


        public abstract void invoke(BpmExtUserPropertyValue var1, Object var2);
    }
}

