/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.persistency;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.CommonUtil;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.AppRoleUtil;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PeopleQueryMemberType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMCalendarHolidayPersistency;
import oracle.bpm.services.organization.persistency.model.BpmAppRoleOuCalAssoc;
import oracle.bpm.services.organization.persistency.model.BpmCalendarRule;
import oracle.bpm.services.organization.persistency.model.BpmHolidayRule;
import oracle.bpm.services.organization.persistency.model.BpmOrganizationalUnit;
import oracle.bpm.services.organization.persistency.model.BpmOuManager;
import oracle.bpm.services.organization.persistency.model.BpmOuUser;

public class BPMOrganizationPersistency
extends AbstractPersistencyDriver {
    ObjectFactory objectFactory = new ObjectFactory();
    private BPMCalendarHolidayPersistency calHolPersist = new BPMCalendarHolidayPersistency();
    private static final String CLASS_NAME = "BPMOrganizationPersistency";
    private static String DEFAULT_REALM_NAME = AppRoleUtil.getInstance().getDefaultRealmName();
    private static BPMOrganizationService bpmOrganizationService = new BPMOrganizationService();
    private static final String POJO_MODEL_PACKAGE = "oracle.bpm.services.organization.persistency.model";

    public static BPMOrganizationPersistency getInstance() {
        return new BPMOrganizationPersistency();
    }

    public static void print(Object toplinkObject) {
        if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            return;
        }
        StringBuffer messageBuffer = new StringBuffer();
        BPMOrganizationPersistency.print(messageBuffer, toplinkObject);
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "print", messageBuffer.toString());
        }
    }

    @Override
    public String getPOJOModelPackage() {
        return POJO_MODEL_PACKAGE;
    }

    @Override
    public Object convertToTopLink(Object object) throws BPMOrganizationException {
        return null;
    }

    @Override
    public Object convertFromTopLink(Object object) throws BPMOrganizationException {
        return null;
    }

    @Override
    public Object convertFromTopLink(IBPMContext ctx, AbstractPersistencyDriver.OPERATION operation, Object jaxbObject, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "convertFromTopLink";
        if (jaxbObject instanceof BpmOrganizationalUnit) {
            int index;
            BpmOrganizationalUnit bpmOrganizationalUnit = (BpmOrganizationalUnit)jaxbObject;
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "convertFromTopLink", "convertFromTopLink called for:");
                BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "convertFromTopLink", bpmOrganizationalUnit);
            }
            OrganizationalUnit organizationalUnit = this.objectFactory.createOrganizationalUnit();
            organizationalUnit.setOrganizationalUnitId(bpmOrganizationalUnit.getOrganizationalUnitId());
            organizationalUnit.setOrganizationalUnitName(bpmOrganizationalUnit.getOrganizationalUnitName());
            organizationalUnit.setDescription(bpmOrganizationalUnit.getDescription());
            if (bpmOrganizationalUnit.getParentOrganizationalUnit() != null) {
                organizationalUnit.setParentOrganizationalUnitId(bpmOrganizationalUnit.getParentOrganizationalUnit().getOrganizationalUnitId());
                organizationalUnit.setParentOrganizationalUnitName(bpmOrganizationalUnit.getParentOrganizationalUnit().getOrganizationalUnitName());
            }
            organizationalUnit.setHierarchyPath(bpmOrganizationalUnit.getHierarchyPath());
            if (bpmOrganizationalUnit.getCalendarRule() != null) {
                organizationalUnit.setCalendarRuleId(bpmOrganizationalUnit.getCalendarRule().getId());
                organizationalUnit.setCalendarRuleName(bpmOrganizationalUnit.getCalendarRule().getName());
            }
            organizationalUnit.setCreatedBy(bpmOrganizationalUnit.getCreatedBy());
            organizationalUnit.setCreatedByIdentityContext(bpmOrganizationalUnit.getCreatedByIdentityContext());
            organizationalUnit.setCreatedDate(BPMOrganizationPersistency.convertToCalendar(bpmOrganizationalUnit.getCreatedDate()));
            organizationalUnit.setLastUpdatedBy(bpmOrganizationalUnit.getLastUpdatedBy());
            organizationalUnit.setLastUpdatedDate(BPMOrganizationPersistency.convertToCalendar(bpmOrganizationalUnit.getLastUpdatedDate()));
            organizationalUnit.setLastUpdatedByIdentityContext(bpmOrganizationalUnit.getLastUpdatedByIdencontext());
            if (!CommonUtil.isListNullOrEmpty(bpmOrganizationalUnit.getBpmOuManagerCollection())) {
                List<BpmOuManager> bpmOuManagers = bpmOrganizationalUnit.getBpmOuManagerCollection();
                for (index = 0; index < bpmOuManagers.size(); ++index) {
                    BpmOuManager bpmOuManager = bpmOuManagers.get(index);
                    MemberType manager = this.objectFactory.createMemberType();
                    manager.setMemberId(bpmOuManager.getId());
                    manager.setName(bpmOuManager.getUserId());
                    manager.setType(ParticipantTypeEnum.fromValue((String)bpmOuManager.getUserType()));
                    manager.setRealm(bpmOuManager.getIdentityContext());
                    manager.setApplicationContext(bpmOuManager.getApplicationContext());
                    manager.setCreatedBy(bpmOuManager.getCreatedBy());
                    manager.setCreatedByIdentityContext(bpmOuManager.getCreatedByIdentityContext());
                    Timestamp managerCreatedDateTimeStamp = bpmOuManager.getCreatedDate();
                    XMLGregorianCalendar managerCreatedDatecalendar = BPMOrganizationPersistency.convertToCalendar(managerCreatedDateTimeStamp);
                    manager.setCreatedDate(managerCreatedDatecalendar);
                    manager.setLastUpdatedBy(bpmOuManager.getLastUpdatedBy());
                    Timestamp managerLastUpdatedTimeStamp = bpmOuManager.getLastUpdatedDate();
                    XMLGregorianCalendar managerLastUpdatedDatecalendar = BPMOrganizationPersistency.convertToCalendar(managerLastUpdatedTimeStamp);
                    manager.setLastUpdatedDate(managerLastUpdatedDatecalendar);
                    manager.setLastUpdatedByIdentityContext(bpmOuManager.getLastUpdatedByIdencontext());
                    organizationalUnit.getManagedByMember().add(manager);
                }
            }
            if (!CommonUtil.isListNullOrEmpty(bpmOrganizationalUnit.getBpmOuUserCollection())) {
                List<BpmOuUser> bpmOuUsers = bpmOrganizationalUnit.getBpmOuUserCollection();
                for (index = 0; index < bpmOuUsers.size(); ++index) {
                    BpmOuUser bpmOuUser = bpmOuUsers.get(index);
                    boolean isPeopleQueryUser = false;
                    MemberType user = null;
                    PeopleQueryMemberType peopleQueryUser = null;
                    if (bpmOuUser.getPeopleQuery() != null) {
                        isPeopleQueryUser = true;
                    }
                    Timestamp userCreatedDateTimestamp = bpmOuUser.getCreatedDate();
                    XMLGregorianCalendar userCreatedDateCalendar = BPMOrganizationPersistency.convertToCalendar(userCreatedDateTimestamp);
                    Timestamp userLastUpdatedTimestamp = bpmOuUser.getLastUpdatedDate();
                    XMLGregorianCalendar userLastUpdatedDateCalendar = BPMOrganizationPersistency.convertToCalendar(userLastUpdatedTimestamp);
                    if (isPeopleQueryUser) {
                        peopleQueryUser = this.objectFactory.createPeopleQueryMemberType();
                        peopleQueryUser.setMemberId(bpmOuUser.getId());
                        peopleQueryUser.setPeopleQueryId(bpmOuUser.getLogicalPeopleQueryId());
                        peopleQueryUser.setPeopleQueryId(bpmOuUser.getPeopleQuery());
                        peopleQueryUser.setCreatedBy(bpmOuUser.getCreatedBy());
                        peopleQueryUser.setCreatedByIdentityContext(bpmOuUser.getCreatedByIdentityContext());
                        peopleQueryUser.setCreatedDate(userCreatedDateCalendar);
                        peopleQueryUser.setLastUpdatedBy(bpmOuUser.getLastUpdatedBy());
                        peopleQueryUser.setLastUpdatedDate(userLastUpdatedDateCalendar);
                        peopleQueryUser.setLastUpdatedByIdentityContext(bpmOuUser.getLastUpdatedByIdencontext());
                        LogicalPeopleGroup logicalPeopleGroup = null;
                        logicalPeopleGroup = bpmOrganizationService.getLogicalPeopleGroup(ctx, peopleQueryUser.getPeopleQueryId(), unitOfWorkHolder);
                        if (logicalPeopleGroup != null) {
                            peopleQueryUser.setPeopleQueryName(logicalPeopleGroup.getName());
                        }
                        if (logicalPeopleGroup != null && logicalPeopleGroup.getMembers() != null && logicalPeopleGroup.getMembers().getParticipant() != null) {
                            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                                BPMOrganizationUtil.debugLog(CLASS_NAME, "convertFromTopLink", "Evaluated PeopleQuery members:");
                            }
                            for (int innerIndex = 0; innerIndex < logicalPeopleGroup.getMembers().getParticipant().size(); ++innerIndex) {
                                PrincipleRefType participant = (PrincipleRefType)logicalPeopleGroup.getMembers().getParticipant().get(innerIndex);
                                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                                    BPMOrganizationUtil.debugLog(CLASS_NAME, "convertFromTopLink", "PeopleQuery evaluated participant:" + participant.getName());
                                }
                                user = this.objectFactory.createMemberType();
                                user.setMemberId(Util.getGuid());
                                user.setName(participant.getName());
                                user.setType(participant.getType());
                                user.setRealm(participant.getRealm());
                                user.setApplicationContext(participant.getApplicationContext());
                                user.setIsPeopleQueryEvaluatedMember(Boolean.valueOf(true));
                                user.setCreatedBy(bpmOuUser.getCreatedBy());
                                user.setCreatedByIdentityContext(bpmOuUser.getCreatedByIdentityContext());
                                user.setCreatedDate(userCreatedDateCalendar);
                                user.setLastUpdatedBy(bpmOuUser.getLastUpdatedBy());
                                user.setLastUpdatedDate(userLastUpdatedDateCalendar);
                                user.setLastUpdatedByIdentityContext(bpmOuUser.getLastUpdatedByIdencontext());
                                organizationalUnit.getMember().add(user);
                            }
                        }
                        organizationalUnit.getPeopleQueryMember().add(peopleQueryUser);
                        continue;
                    }
                    user = this.objectFactory.createMemberType();
                    user.setMemberId(bpmOuUser.getId());
                    user.setName(bpmOuUser.getUserId());
                    user.setType(ParticipantTypeEnum.fromValue((String)bpmOuUser.getUserType()));
                    user.setRealm(bpmOuUser.getIdentityContext());
                    user.setApplicationContext(bpmOuUser.getApplicationContext());
                    user.setCreatedBy(bpmOuUser.getCreatedBy());
                    user.setCreatedByIdentityContext(bpmOuUser.getCreatedByIdentityContext());
                    user.setCreatedDate(userCreatedDateCalendar);
                    user.setLastUpdatedBy(bpmOuUser.getLastUpdatedBy());
                    user.setLastUpdatedDate(userLastUpdatedDateCalendar);
                    user.setLastUpdatedByIdentityContext(bpmOuUser.getLastUpdatedByIdencontext());
                    organizationalUnit.getMember().add(user);
                }
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "convertFromTopLink", "convertFromTopLink returned:");
                BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "convertFromTopLink", organizationalUnit);
            }
            return organizationalUnit;
        }
        if (jaxbObject instanceof BpmAppRoleOuCalAssoc) {
            BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc = (BpmAppRoleOuCalAssoc)jaxbObject;
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "convertFromTopLink", "convertFromTopLink called for:");
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "convertFromTopLink", bpmAppRoleOuCalAssoc);
            }
            ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociation();
            applicationRoleOrgUnitCalendarAssociation.setApplicationRoleOrgUnitCalendarAssociationId(bpmAppRoleOuCalAssoc.getId());
            applicationRoleOrgUnitCalendarAssociation.setCalendarRuleId(bpmAppRoleOuCalAssoc.getCalendarRule().getId());
            applicationRoleOrgUnitCalendarAssociation.setCalendarRuleName(bpmAppRoleOuCalAssoc.getCalendarRule().getName());
            applicationRoleOrgUnitCalendarAssociation.setOrganizationalUnitId(bpmAppRoleOuCalAssoc.getOrganizationalUnit().getOrganizationalUnitId());
            applicationRoleOrgUnitCalendarAssociation.setOrganizationalUnitName(bpmAppRoleOuCalAssoc.getOrganizationalUnit().getOrganizationalUnitName());
            RoleProfileType applicationRole = this.objectFactory.createRoleProfileType();
            applicationRole.setName(bpmAppRoleOuCalAssoc.getApplicationRoleName());
            applicationRole.setIdentityContext(bpmAppRoleOuCalAssoc.getIdentityContext());
            applicationRole.setApplicationContext(bpmAppRoleOuCalAssoc.getApplicationContext());
            applicationRoleOrgUnitCalendarAssociation.setApplicationRole(applicationRole);
            applicationRoleOrgUnitCalendarAssociation.setCreatedBy(bpmAppRoleOuCalAssoc.getCreatedBy());
            applicationRoleOrgUnitCalendarAssociation.setCreatedByIdentityContext(bpmAppRoleOuCalAssoc.getCreatedByIdentityContext());
            Timestamp associationCreatedDateTimeStamp = bpmAppRoleOuCalAssoc.getCreatedDate();
            XMLGregorianCalendar associationCreatedDatecalendar = BPMOrganizationPersistency.convertToCalendar(associationCreatedDateTimeStamp);
            applicationRoleOrgUnitCalendarAssociation.setCreatedDate(associationCreatedDatecalendar);
            applicationRoleOrgUnitCalendarAssociation.setLastUpdatedBy(bpmAppRoleOuCalAssoc.getLastUpdatedBy());
            Timestamp associationLastUpdatedTimeStamp = bpmAppRoleOuCalAssoc.getLastUpdatedDate();
            XMLGregorianCalendar associationLastUpdatedDatecalendar = BPMOrganizationPersistency.convertToCalendar(associationLastUpdatedTimeStamp);
            applicationRoleOrgUnitCalendarAssociation.setLastUpdatedDate(associationLastUpdatedDatecalendar);
            applicationRoleOrgUnitCalendarAssociation.setLastUpdatedByIdentityContext(bpmAppRoleOuCalAssoc.getLastUpdatedByIdencontext());
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "convertFromTopLink", "convertFromTopLink returned:");
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "convertFromTopLink", applicationRoleOrgUnitCalendarAssociation);
            }
            return applicationRoleOrgUnitCalendarAssociation;
        }
        if (jaxbObject instanceof BpmHolidayRule) {
            return this.calHolPersist.convertHolidayFromToplink((BpmHolidayRule)jaxbObject);
        }
        if (jaxbObject instanceof BpmCalendarRule) {
            return this.calHolPersist.convertCalendarFromToplink((BpmCalendarRule)jaxbObject);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object convertToTopLink(IBPMContext ctx, AbstractPersistencyDriver.OPERATION operation, Object jaxbObject, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        METHOD = "convertToTopLink";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "convertToTopLink called for:");
            BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", BPMOrganizationUtil.getJaxbObjectXMLAsString(jaxbObject));
        }
        calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
        if (jaxbObject instanceof OrganizationalUnit) {
            organizationalUnit = (OrganizationalUnit)jaxbObject;
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.printOrganizationalUnit("BPMOrganizationPersistency", "convertToTopLink", organizationalUnit);
            }
            bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnit.getOrganizationalUnitId());
            if (operation == AbstractPersistencyDriver.OPERATION.CREATE) {
                bpmOrganizationalUnit = (BpmOrganizationalUnit)unitOfWorkHolder.registerNewObject(bpmOrganizationalUnit);
                unitOfWorkHolder.setShouldNewObjectsBeCached(true);
            } else if (operation == AbstractPersistencyDriver.OPERATION.UPDATE) {
                bpmOrganizationalUnit = (BpmOrganizationalUnit)unitOfWorkHolder.readObject(bpmOrganizationalUnit);
            } else if (operation == AbstractPersistencyDriver.OPERATION.DELETE) {
                bpmOrganizationalUnit = (BpmOrganizationalUnit)unitOfWorkHolder.readObject(bpmOrganizationalUnit);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "convertToTopLink returned:");
                    BPMOrganizationUtil.printOrganizationalUnit("BPMOrganizationPersistency", "convertToTopLink", bpmOrganizationalUnit);
                }
                return bpmOrganizationalUnit;
            }
            bpmOrganizationalUnit.setOrganizationalUnitName(organizationalUnit.getOrganizationalUnitName());
            bpmOrganizationalUnit.setDescription(organizationalUnit.getDescription());
            if (organizationalUnit.getCalendarRuleId() != null) {
                bpmCalendarRule = new BpmCalendarRule();
                bpmCalendarRule.setId(organizationalUnit.getCalendarRuleId());
                bpmCalendarRule = (BpmCalendarRule)unitOfWorkHolder.readObject(bpmCalendarRule);
                bpmOrganizationalUnit.setCalendarRule(bpmCalendarRule);
            }
            bpmOrganizationalUnit.setCreatedBy(organizationalUnit.getCreatedBy());
            if (organizationalUnit.getCreatedByIdentityContext() != null) {
                bpmOrganizationalUnit.setCreatedByIdentityContext(organizationalUnit.getCreatedByIdentityContext());
            } else {
                bpmOrganizationalUnit.setCreatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
            }
            bpmOrganizationalUnit.setCreatedDate(BPMOrganizationPersistency.convertToTimestamp(organizationalUnit.getCreatedDate()));
            bpmOrganizationalUnit.setLastUpdatedBy(organizationalUnit.getLastUpdatedBy());
            if (organizationalUnit.getLastUpdatedByIdentityContext() != null) {
                bpmOrganizationalUnit.setLastUpdatedByIdencontext(organizationalUnit.getLastUpdatedByIdentityContext());
            } else {
                bpmOrganizationalUnit.setLastUpdatedByIdencontext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
            }
            bpmOrganizationalUnit.setLastUpdatedDate(BPMOrganizationPersistency.convertToTimestamp(organizationalUnit.getLastUpdatedDate()));
            if (!WorkflowUtil.isNull((String)organizationalUnit.getParentOrganizationalUnitId())) {
                parentBpmOrganizationalUnit = new BpmOrganizationalUnit();
                parentBpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnit.getParentOrganizationalUnitId());
                parentBpmOrganizationalUnit = (BpmOrganizationalUnit)unitOfWorkHolder.readObject(parentBpmOrganizationalUnit);
                bpmOrganizationalUnit.setParentOrganizationalUnit(parentBpmOrganizationalUnit);
            }
            bpmOrganizationalUnit.setHierarchyPath(organizationalUnit.getHierarchyPath());
            existingManagersMap = new HashMap<String, BpmOuManager>();
            existingUsersMap = new HashMap<String, BpmOuUser>();
            if (operation == AbstractPersistencyDriver.OPERATION.UPDATE) {
                bpmOrganizationalUnitForQuery = (BpmOrganizationalUnit)unitOfWorkHolder.readObject(bpmOrganizationalUnit);
                existingManagers = bpmOrganizationalUnitForQuery.getBpmOuManagerCollection();
                existingManagers.toArray();
                for (index = 0; index < existingManagers.size(); ++index) {
                    existingManager = existingManagers.get(index);
                    existingManagersMap.put(existingManager.getId(), existingManager);
                    if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) continue;
                    BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "existingUsersMap entry:" + existingManager.getId() + ":" + existingManager.getUserId() + ":" + existingManager.getUserType());
                }
                existingUsers = bpmOrganizationalUnitForQuery.getBpmOuUserCollection();
                existingUsers.toArray();
                for (index = 0; index < existingUsers.size(); ++index) {
                    existingUser = existingUsers.get(index);
                    existingUsersMap.put(existingUser.getId(), existingUser);
                    if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) continue;
                    BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "existingUsersMap entry:" + existingUser.getId() + ":" + existingUser.getUserId() + ":" + existingUser.getUserType());
                }
            }
            if (!CommonUtil.isListNullOrEmpty((List)(managers = organizationalUnit.getManagedByMember()))) {
                for (index = 0; index < managers.size(); ++index) {
                    manager = (MemberType)managers.get(index);
                    isManagerExists = false;
                    bpmOuManager = new BpmOuManager();
                    bpmOuManager.setId(manager.getMemberId());
                    managerOperation = operation;
                    isManagerExists = existingManagersMap.get(manager.getMemberId()) != null;
                    managerOperation = isManagerExists == false ? AbstractPersistencyDriver.OPERATION.CREATE : AbstractPersistencyDriver.OPERATION.UPDATE;
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                        BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "Operation:" + managerOperation.name() + " for " + manager.getMemberId() + ":" + manager.getName() + ":" + manager.getType());
                    }
                    if (managerOperation == AbstractPersistencyDriver.OPERATION.CREATE) {
                        bpmOuManager = (BpmOuManager)unitOfWorkHolder.registerNewObject(bpmOuManager);
                        manager.setCreatedBy(ctx.getUser());
                        bpmOuManager.setCreatedBy(ctx.getUser());
                        if (ctx.getIdentityContext() != null) {
                            bpmOuManager.setCreatedByIdentityContext(ctx.getIdentityContext());
                            manager.setCreatedByIdentityContext(ctx.getIdentityContext());
                        } else {
                            bpmOuManager.setCreatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                            manager.setCreatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                        }
                        bpmOuManager.setCreatedDate(BPMOrganizationPersistency.convertToTimestamp(calendar));
                        manager.setCreatedDate(calendar);
                    } else if (operation == AbstractPersistencyDriver.OPERATION.UPDATE) {
                        bpmOuManager = (BpmOuManager)existingManagersMap.remove(manager.getMemberId());
                        bpmOuManager = (BpmOuManager)unitOfWorkHolder.readObject(bpmOuManager);
                    }
                    if (!WorkflowUtil.isNull((String)manager.getName())) {
                        bpmOuManager.setUserId(manager.getName());
                    } else if (!WorkflowUtil.isNull((String)manager.getRealm())) {
                        bpmOuManager.setUserId(manager.getRealm());
                    } else {
                        bpmOuManager.setUserId(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                    }
                    if (ParticipantTypeEnum.APPROLE == manager.getType()) {
                        bpmOuManager.setApplicationContext(manager.getApplicationContext());
                    }
                    if (!WorkflowUtil.isNull((String)manager.getRealm())) {
                        bpmOuManager.setIdentityContext(manager.getRealm());
                    } else {
                        bpmOuManager.setIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                    }
                    bpmOuManager.setUserType(manager.getType().value());
                    bpmOuManager.setLastUpdatedBy(ctx.getUser());
                    manager.setLastUpdatedBy(ctx.getUser());
                    if (ctx.getIdentityContext() != null) {
                        bpmOuManager.setLastUpdatedByIdencontext(ctx.getIdentityContext());
                        manager.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
                    } else {
                        bpmOuManager.setLastUpdatedByIdencontext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                        manager.setLastUpdatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                    }
                    bpmOuManager.setLastUpdatedDate(BPMOrganizationPersistency.convertToTimestamp(calendar));
                    manager.setLastUpdatedDate(calendar);
                    if (isManagerExists) continue;
                    bpmOrganizationalUnit.addBpmOuManager(bpmOuManager);
                }
            }
            if (operation == AbstractPersistencyDriver.OPERATION.UPDATE && !(set = existingManagersMap.keySet()).isEmpty()) {
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    existingManagerToBeDeleted = (BpmOuManager)existingManagersMap.get((String)iterator.next());
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                        BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "Delete for " + existingManagerToBeDeleted.getId() + ":" + existingManagerToBeDeleted.getUserId() + ":" + existingManagerToBeDeleted.getUserType());
                    }
                    bpmOrganizationalUnit.getBpmOuManagerCollection().remove(existingManagerToBeDeleted);
                }
            }
            users = new ArrayList<E>();
            newOrReevaluatedMembersFromPeopleQuery = new ArrayList<E>();
            if (!CommonUtil.isListNullOrEmpty((List)organizationalUnit.getMember())) {
                users.addAll(organizationalUnit.getMember());
            }
            if (!CommonUtil.isListNullOrEmpty((List)organizationalUnit.getPeopleQueryMember())) {
                users.addAll(organizationalUnit.getPeopleQueryMember());
            }
            if (!CommonUtil.isListNullOrEmpty(users)) {
                for (index = 0; index < users.size(); ++index) {
                    isPeopleQueryUser = false;
                    user = null;
                    peopleQueryUser = null;
                    memberOrPeopleQueryMember = users.get(index);
                    if (memberOrPeopleQueryMember instanceof MemberType) {
                        user = (MemberType)memberOrPeopleQueryMember;
                        if (user.isIsPeopleQueryEvaluatedMember() == null) {
                            user.setIsPeopleQueryEvaluatedMember(Boolean.FALSE);
                        }
                        isPeopleQueryUser = false;
                    } else {
                        peopleQueryUser = (PeopleQueryMemberType)memberOrPeopleQueryMember;
                        isPeopleQueryUser = true;
                    }
                    if (!isPeopleQueryUser && user.isIsPeopleQueryEvaluatedMember().booleanValue()) {
                        organizationalUnit.getMember().remove(existingUsersMap.get(user.getMemberId()));
                        continue;
                    }
                    isUserExists = false;
                    bpmOuUser = new BpmOuUser();
                    if (isPeopleQueryUser) {
                        bpmOuUser.setId(peopleQueryUser.getMemberId());
                    } else {
                        bpmOuUser.setId(user.getMemberId());
                    }
                    bpmOuUser.setOrganizationalUnit(bpmOrganizationalUnit);
                    userOperation = operation;
                    isUserExists = isPeopleQueryUser != false ? existingUsersMap.get(peopleQueryUser.getMemberId()) != null : existingUsersMap.get(user.getMemberId()) != null;
                    userOperation = isUserExists == false ? AbstractPersistencyDriver.OPERATION.CREATE : AbstractPersistencyDriver.OPERATION.UPDATE;
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                        BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "Operation:" + userOperation.name());
                        if (isPeopleQueryUser) {
                            BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", " User: " + peopleQueryUser.getMemberId() + ":" + peopleQueryUser.getPeopleQueryId() + ":" + peopleQueryUser.getPeopleQueryName());
                        } else {
                            BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", " User: " + user.getMemberId() + ":" + user.getName() + ":" + user.getType());
                        }
                    }
                    if (userOperation == AbstractPersistencyDriver.OPERATION.CREATE) {
                        bpmOuUser = (BpmOuUser)unitOfWorkHolder.registerNewObject(bpmOuUser);
                        if (isPeopleQueryUser) {
                            logicalPeopleGroup = BPMOrganizationPersistency.bpmOrganizationService.getLogicalPeopleGroup(ctx, peopleQueryUser.getPeopleQueryId(), unitOfWorkHolder);
                            if (logicalPeopleGroup == null) {
                                throw new BPMOrganizationException(Severity.ERRORS, 70906, (Object[])new String[]{peopleQueryUser.getPeopleQueryId()}, null);
                            }
                            if (logicalPeopleGroup.getMembers() != null) {
                                newOrReevaluatedMembersFromPeopleQuery.addAll(logicalPeopleGroup.getMembers().getParticipant());
                            }
                            peopleQueryUser.setCreatedBy(ctx.getUser());
                            if (ctx.getIdentityContext() != null) {
                                peopleQueryUser.setCreatedByIdentityContext(ctx.getIdentityContext());
                            } else {
                                peopleQueryUser.setCreatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                            }
                            peopleQueryUser.setCreatedDate(calendar);
                        } else {
                            user.setCreatedBy(ctx.getUser());
                            if (ctx.getIdentityContext() != null) {
                                user.setCreatedByIdentityContext(ctx.getIdentityContext());
                            } else {
                                user.setCreatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                            }
                            user.setCreatedDate(calendar);
                        }
                        bpmOuUser.setCreatedBy(ctx.getUser());
                        if (ctx.getIdentityContext() != null) {
                            bpmOuUser.setCreatedByIdentityContext(ctx.getIdentityContext());
                        } else {
                            bpmOuUser.setCreatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                        }
                        bpmOuUser.setCreatedDate(BPMOrganizationPersistency.convertToTimestamp(calendar));
                    } else if (userOperation == AbstractPersistencyDriver.OPERATION.UPDATE) {
                        if (isPeopleQueryUser) {
                            bpmOuUser = (BpmOuUser)existingUsersMap.remove(peopleQueryUser.getMemberId());
                            logicalPeopleGroup = BPMOrganizationPersistency.bpmOrganizationService.getLogicalPeopleGroup(ctx, peopleQueryUser.getPeopleQueryId(), unitOfWorkHolder);
                            if (logicalPeopleGroup == null) {
                                throw new BPMOrganizationException(Severity.ERRORS, 70906, (Object[])new String[]{peopleQueryUser.getPeopleQueryId()}, null);
                            }
                            if (logicalPeopleGroup.getMembers() == null) ** GOTO lbl226
                            newOrReevaluatedMembersFromPeopleQuery.addAll(logicalPeopleGroup.getMembers().getParticipant());
                        } else {
                            bpmOuUser = (BpmOuUser)existingUsersMap.remove(user.getMemberId());
                        }
lbl226:
                        // 3 sources

                        bpmOuUser = (BpmOuUser)unitOfWorkHolder.readObject(bpmOuUser);
                    }
                    if (isPeopleQueryUser) {
                        peopleQueryUser.setLastUpdatedBy(ctx.getUser());
                        if (ctx.getIdentityContext() != null) {
                            peopleQueryUser.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
                        } else {
                            peopleQueryUser.setLastUpdatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                        }
                        peopleQueryUser.setLastUpdatedDate(calendar);
                    } else {
                        user.setLastUpdatedBy(ctx.getUser());
                        if (ctx.getIdentityContext() != null) {
                            user.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
                        } else {
                            user.setLastUpdatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                        }
                        user.setLastUpdatedDate(calendar);
                    }
                    bpmOuUser.setLastUpdatedBy(ctx.getUser());
                    if (ctx.getIdentityContext() != null) {
                        bpmOuUser.setLastUpdatedByIdencontext(ctx.getIdentityContext());
                    } else {
                        bpmOuUser.setLastUpdatedByIdencontext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                    }
                    bpmOuUser.setLastUpdatedDate(BPMOrganizationPersistency.convertToTimestamp(calendar));
                    if (isPeopleQueryUser) {
                        bpmOuUser.setPeopleQuery(peopleQueryUser.getPeopleQueryId());
                        bpmOuUser.setLogicalPeopleQueryId(peopleQueryUser.getPeopleQueryId());
                    } else {
                        if (!WorkflowUtil.isNull((String)user.getName())) {
                            bpmOuUser.setUserId(user.getName());
                        } else if (!WorkflowUtil.isNull((String)user.getRealm())) {
                            bpmOuUser.setUserId(user.getRealm());
                        } else {
                            bpmOuUser.setUserId(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                        }
                        if (ParticipantTypeEnum.APPROLE == user.getType()) {
                            bpmOuUser.setApplicationContext(user.getApplicationContext());
                        }
                        if (!WorkflowUtil.isNull((String)user.getRealm())) {
                            bpmOuUser.setIdentityContext(user.getRealm());
                        } else {
                            bpmOuUser.setIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                        }
                        bpmOuUser.setUserType(user.getType().value());
                    }
                    if (isUserExists) continue;
                    bpmOrganizationalUnit.addBpmOuUser(bpmOuUser);
                }
            }
            if (operation == AbstractPersistencyDriver.OPERATION.UPDATE && !(set = existingUsersMap.keySet()).isEmpty()) {
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    existingUserToBeDeleted = (BpmOuUser)existingUsersMap.get((String)iterator.next());
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                        BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "Delete for " + existingUserToBeDeleted.getId() + ":" + existingUserToBeDeleted.getUserId() + ":" + existingUserToBeDeleted.getUserType());
                    }
                    bpmOrganizationalUnit.getBpmOuUserCollection().remove(existingUserToBeDeleted);
                }
            }
            for (PrincipleRefType principle : newOrReevaluatedMembersFromPeopleQuery) {
                newOrReevaluatedMember = this.objectFactory.createMemberType();
                newOrReevaluatedMember.setMemberId(Util.getGuid());
                newOrReevaluatedMember.setName(principle.getName());
                newOrReevaluatedMember.setRealm(principle.getRealm());
                newOrReevaluatedMember.setType(principle.getType());
                newOrReevaluatedMember.setIsPeopleQueryEvaluatedMember(Boolean.valueOf(true));
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "newOrReevaluatedMember " + newOrReevaluatedMember.getMemberId() + ":" + newOrReevaluatedMember.getName() + ":" + newOrReevaluatedMember.getRealm());
                }
                newOrReevaluatedMember.setCreatedBy(ctx.getUser());
                if (ctx.getIdentityContext() != null) {
                    newOrReevaluatedMember.setCreatedByIdentityContext(ctx.getIdentityContext());
                } else {
                    newOrReevaluatedMember.setCreatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                }
                newOrReevaluatedMember.setCreatedDate(calendar);
                newOrReevaluatedMember.setLastUpdatedBy(ctx.getUser());
                if (ctx.getIdentityContext() != null) {
                    newOrReevaluatedMember.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
                } else {
                    newOrReevaluatedMember.setLastUpdatedByIdentityContext(BPMOrganizationPersistency.DEFAULT_REALM_NAME);
                }
                newOrReevaluatedMember.setLastUpdatedDate(calendar);
                organizationalUnit.getMember().add(newOrReevaluatedMember);
            }
            childrens = organizationalUnit.getChildOrganizationalUnits();
            if (!CommonUtil.isListNullOrEmpty((List)childrens)) {
                for (OrganizationalUnit childOrganizationalUnit : childrens) {
                    this.convertToTopLink(ctx, operation, childOrganizationalUnit, unitOfWorkHolder);
                }
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "convertToTopLink returned:");
                BPMOrganizationUtil.printOrganizationalUnit("BPMOrganizationPersistency", "convertToTopLink", bpmOrganizationalUnit);
            }
            return bpmOrganizationalUnit;
        }
        if (jaxbObject instanceof ApplicationRoleOrgUnitCalendarAssociation) {
            applicationRoleOrgUnitCalendarAssociation = (ApplicationRoleOrgUnitCalendarAssociation)jaxbObject;
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation("BPMOrganizationPersistency", "convertToTopLink", applicationRoleOrgUnitCalendarAssociation);
            }
            bpmAppRoleOuCalAssoc = new BpmAppRoleOuCalAssoc();
            bpmAppRoleOuCalAssoc.setId(applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId());
            if (operation == AbstractPersistencyDriver.OPERATION.CREATE) {
                unitOfWorkHolder.setShouldNewObjectsBeCached(true);
                bpmAppRoleOuCalAssoc = (BpmAppRoleOuCalAssoc)unitOfWorkHolder.registerNewObject(bpmAppRoleOuCalAssoc);
            } else if (operation == AbstractPersistencyDriver.OPERATION.UPDATE) {
                bpmAppRoleOuCalAssoc = (BpmAppRoleOuCalAssoc)unitOfWorkHolder.registerObject(bpmAppRoleOuCalAssoc);
            } else if (operation == AbstractPersistencyDriver.OPERATION.DELETE) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "convertToTopLink returned:");
                    BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation("BPMOrganizationPersistency", "convertToTopLink", bpmAppRoleOuCalAssoc);
                }
                return bpmAppRoleOuCalAssoc;
            }
            bpmAppRoleOuCalAssoc.setApplicationRoleName(applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getName());
            bpmAppRoleOuCalAssoc.setIdentityContext(applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getIdentityContext());
            bpmAppRoleOuCalAssoc.setApplicationContext(applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getApplicationContext());
            bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId());
            bpmOrganizationalUnit = (BpmOrganizationalUnit)unitOfWorkHolder.readObject(bpmOrganizationalUnit);
            bpmAppRoleOuCalAssoc.setOrganizationalUnit(bpmOrganizationalUnit);
            bpmCalendarRule = new BpmCalendarRule();
            bpmCalendarRule.setId(applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId());
            bpmCalendarRule = (BpmCalendarRule)unitOfWorkHolder.readObject(bpmCalendarRule);
            bpmAppRoleOuCalAssoc.setCalendarRule(bpmCalendarRule);
            bpmAppRoleOuCalAssoc.setCreatedBy(applicationRoleOrgUnitCalendarAssociation.getCreatedBy());
            bpmAppRoleOuCalAssoc.setCreatedByIdentityContext(applicationRoleOrgUnitCalendarAssociation.getCreatedByIdentityContext());
            bpmAppRoleOuCalAssoc.setCreatedDate(BPMOrganizationPersistency.convertToTimestamp(applicationRoleOrgUnitCalendarAssociation.getCreatedDate()));
            bpmAppRoleOuCalAssoc.setLastUpdatedBy(applicationRoleOrgUnitCalendarAssociation.getLastUpdatedBy());
            bpmAppRoleOuCalAssoc.setLastUpdatedByIdencontext(applicationRoleOrgUnitCalendarAssociation.getLastUpdatedByIdentityContext());
            bpmAppRoleOuCalAssoc.setLastUpdatedDate(BPMOrganizationPersistency.convertToTimestamp(applicationRoleOrgUnitCalendarAssociation.getLastUpdatedDate()));
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog("BPMOrganizationPersistency", "convertToTopLink", "convertToTopLink returned:");
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation("BPMOrganizationPersistency", "convertToTopLink", bpmAppRoleOuCalAssoc);
            }
            return bpmAppRoleOuCalAssoc;
        }
        if (jaxbObject instanceof HolidayRule) {
            return this.calHolPersist.convertHolidayToToplink(operation, (HolidayRule)jaxbObject, unitOfWorkHolder);
        }
        if (jaxbObject instanceof CalendarRule) {
            return this.calHolPersist.convertCalendarToToplink(operation, (CalendarRule)jaxbObject, unitOfWorkHolder);
        }
        return null;
    }

    public void deleteOrganizationalUnit(IBPMContext ctx, BpmOrganizationalUnit bpmOrganizationalUnit, boolean includingChildren) throws BPMOrganizationException {
        AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(true);
        bpmOrganizationalUnit = (BpmOrganizationalUnit)unitOfWorkHolder.readObject(bpmOrganizationalUnit);
        this.deleteOrganizationalUnit(ctx, bpmOrganizationalUnit, includingChildren, unitOfWorkHolder, true);
        unitOfWorkHolder.completed();
    }

    public Vector getOrgUnitsReferringCalendar(String calId) throws BPMOrganizationException {
        StringBuffer sqlQuery = new StringBuffer("SELECT ORGANIZATIONAL_UNIT_ID, ORGANIZATIONAL_UNIT_NAME FROM BPM_ORGANIZATIONAL_UNIT WHERE CALENDAR_RULE_ID = '");
        sqlQuery.append(calId);
        sqlQuery.append("'");
        return this.executeQuery(null, BpmOrganizationalUnit.class, sqlQuery.toString());
    }

    public Vector getCalendarsReferringHolidayRule(String holId) throws BPMOrganizationException {
        StringBuffer sqlQuery = new StringBuffer("SELECT ID, NAME FROM BPM_CALENDAR_RULE WHERE HOLIDAY_RULE_ID = '");
        sqlQuery.append(holId);
        sqlQuery.append("'");
        return this.executeQuery(null, BpmCalendarRule.class, sqlQuery.toString());
    }

    private static void print(StringBuffer messageBuffer, Object toplinkObject) {
        block31: {
            block30: {
                if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    return;
                }
                if (!(toplinkObject instanceof OrganizationalUnit)) break block30;
                OrganizationalUnit organizationalUnit = (OrganizationalUnit)toplinkObject;
                messageBuffer.append("\n").append("Id:" + organizationalUnit.getOrganizationalUnitId());
                messageBuffer.append("\n").append("Name:" + organizationalUnit.getOrganizationalUnitName());
                messageBuffer.append("\n").append("Parent:" + organizationalUnit.getParentOrganizationalUnitName());
                messageBuffer.append("\n").append("Description:" + organizationalUnit.getDescription());
                messageBuffer.append("\n").append("CalendarRuleId:" + organizationalUnit.getCalendarRuleId());
                messageBuffer.append("\n").append("CreatedBy:" + organizationalUnit.getCreatedBy());
                messageBuffer.append("\n").append("CreatedByIdentityContext:" + organizationalUnit.getCreatedByIdentityContext());
                messageBuffer.append("\n").append("CreatedDate:" + organizationalUnit.getCreatedDate());
                messageBuffer.append("\n").append("LastUpdatedBy:" + organizationalUnit.getLastUpdatedBy());
                messageBuffer.append("\n").append("LastUpdatedByIdentityContext:" + organizationalUnit.getLastUpdatedByIdentityContext());
                messageBuffer.append("\n").append("LastUpdatedDate:" + organizationalUnit.getLastUpdatedDate());
                List managers = organizationalUnit.getManagedByMember();
                if (managers != null && managers.size() > 0) {
                    messageBuffer.append("\n").append("Managers:");
                    for (MemberType manager : managers) {
                        messageBuffer.append("\n").append("   Id: " + manager.getMemberId());
                        messageBuffer.append("\n").append("   Name: " + manager.getName());
                        messageBuffer.append("\n").append("   Type: " + manager.getType());
                        messageBuffer.append("\n").append("   Realm: " + manager.getRealm());
                        messageBuffer.append("\n").append("   CreatedBy:" + manager.getCreatedBy());
                        messageBuffer.append("\n").append("   CreatedByIdentityContext:" + manager.getCreatedByIdentityContext());
                        messageBuffer.append("\n").append("   CreatedDate:" + manager.getCreatedDate());
                        messageBuffer.append("\n").append("   LastUpdatedBy:" + manager.getLastUpdatedBy());
                        messageBuffer.append("\n").append("   LastUpdatedByIdentityContext:" + manager.getLastUpdatedByIdentityContext());
                        messageBuffer.append("\n").append("   LastUpdatedDate:" + manager.getLastUpdatedDate());
                    }
                } else if (managers == null) {
                    messageBuffer.append("\n").append("Managers: <null Manager list>");
                } else {
                    messageBuffer.append("\n").append("Managers: <No Managers>");
                }
                List users = organizationalUnit.getMember();
                if (users != null && users.size() > 0) {
                    messageBuffer.append("\n").append("Users:");
                    for (MemberType user : users) {
                        messageBuffer.append("\n").append("   Id: " + user.getMemberId());
                        messageBuffer.append("\n").append("   Name: " + user.getName());
                        messageBuffer.append("\n").append("   Type: " + user.getType());
                        messageBuffer.append("\n").append("   Realm: " + user.getRealm());
                        messageBuffer.append("\n").append("   CreatedBy:" + user.getCreatedBy());
                        messageBuffer.append("\n").append("   CreatedByIdentityContext:" + user.getCreatedByIdentityContext());
                        messageBuffer.append("\n").append("   CreatedDate:" + user.getCreatedDate());
                        messageBuffer.append("\n").append("   LastUpdatedBy:" + user.getLastUpdatedBy());
                        messageBuffer.append("\n").append("   LastUpdatedByIdentityContext:" + user.getLastUpdatedByIdentityContext());
                        messageBuffer.append("\n").append("   LastUpdatedDate:" + user.getLastUpdatedDate());
                    }
                } else if (users == null) {
                    messageBuffer.append("\n").append("Users: <null User list>");
                } else {
                    messageBuffer.append("\n").append("Users: <No Users>");
                }
                List peopleQueryMembers = organizationalUnit.getPeopleQueryMember();
                if (users != null && users.size() > 0) {
                    messageBuffer.append("\n").append("PeopleQueryUsers:");
                    for (PeopleQueryMemberType peopleQueryMember : peopleQueryMembers) {
                        messageBuffer.append("\n").append("   Id: " + peopleQueryMember.getMemberId());
                        messageBuffer.append("\n").append("   Name: " + peopleQueryMember.getPeopleQueryName());
                        messageBuffer.append("\n").append("   PeopleQueryId: " + peopleQueryMember.getPeopleQueryId());
                        messageBuffer.append("\n").append("   PeopleQuery: " + peopleQueryMember.getPeopleQuery());
                        messageBuffer.append("\n").append("   CreatedBy:" + peopleQueryMember.getCreatedBy());
                        messageBuffer.append("\n").append("   CreatedByIdentityContext:" + peopleQueryMember.getCreatedByIdentityContext());
                        messageBuffer.append("\n").append("   CreatedDate:" + peopleQueryMember.getCreatedDate());
                        messageBuffer.append("\n").append("   LastUpdatedBy:" + peopleQueryMember.getLastUpdatedBy());
                        messageBuffer.append("\n").append("   LastUpdatedByIdentityContext:" + peopleQueryMember.getLastUpdatedByIdentityContext());
                        messageBuffer.append("\n").append("   LastUpdatedDate:" + peopleQueryMember.getLastUpdatedDate());
                    }
                } else if (users == null) {
                    messageBuffer.append("\n").append("People Query Users: <null peopleQueryUser list>");
                } else {
                    messageBuffer.append("\n").append("People Query Users: <No People Query Users>");
                }
                List childrens = organizationalUnit.getChildOrganizationalUnits();
                if (CommonUtil.isListNullOrEmpty((List)childrens)) break block31;
                for (OrganizationalUnit childOrganizationalUnit : childrens) {
                    BPMOrganizationPersistency.print(messageBuffer, childOrganizationalUnit);
                }
                break block31;
            }
            if (toplinkObject instanceof BpmOrganizationalUnit) {
                BpmOrganizationalUnit bpmOrganizationalUnit = (BpmOrganizationalUnit)toplinkObject;
                messageBuffer.append("\n").append("Id:" + bpmOrganizationalUnit.getOrganizationalUnitId());
                messageBuffer.append("\n").append("Name:" + bpmOrganizationalUnit.getOrganizationalUnitName());
                messageBuffer.append("\n").append("Parent:" + bpmOrganizationalUnit.getParentOrganizationalUnit());
                messageBuffer.append("\n").append("Description:" + bpmOrganizationalUnit.getDescription());
                messageBuffer.append("\n").append("CalendarRuleId:" + bpmOrganizationalUnit.getCalendarRule());
                messageBuffer.append("\n").append("CreatedBy:" + bpmOrganizationalUnit.getCreatedBy());
                messageBuffer.append("\n").append("CreatedByIdentityContext:" + bpmOrganizationalUnit.getCreatedByIdentityContext());
                messageBuffer.append("\n").append("CreatedDate:" + bpmOrganizationalUnit.getCreatedDate());
                messageBuffer.append("\n").append("LastUpdatedBy:" + bpmOrganizationalUnit.getLastUpdatedBy());
                messageBuffer.append("\n").append("LastUpdatedByIdentityContext:" + bpmOrganizationalUnit.getLastUpdatedByIdencontext());
                messageBuffer.append("\n").append("LastUpdatedDate:" + bpmOrganizationalUnit.getLastUpdatedDate());
                List<BpmOuManager> managers = bpmOrganizationalUnit.getBpmOuManagerCollection();
                if (managers != null && managers.size() > 0) {
                    messageBuffer.append("\n").append("Managers:");
                    for (BpmOuManager manager : managers) {
                        messageBuffer.append("\n").append("   Id: " + manager.getId());
                        messageBuffer.append("\n").append("   Name: " + manager.getUserId());
                        messageBuffer.append("\n").append("   Type: " + manager.getUserType());
                        messageBuffer.append("\n").append("   Realm: " + manager.getIdentityContext());
                        messageBuffer.append("\n").append("   CreatedBy:" + manager.getCreatedBy());
                        messageBuffer.append("\n").append("   CreatedByIdentityContext:" + manager.getCreatedByIdentityContext());
                        messageBuffer.append("\n").append("   CreatedDate:" + manager.getCreatedDate());
                        messageBuffer.append("\n").append("   LastUpdatedBy:" + manager.getLastUpdatedBy());
                        messageBuffer.append("\n").append("   LastUpdatedByIdentityContext:" + manager.getLastUpdatedByIdencontext());
                        messageBuffer.append("\n").append("   LastUpdatedDate:" + manager.getLastUpdatedDate());
                    }
                } else if (managers == null) {
                    messageBuffer.append("\n").append("Managers: <null Manager list>");
                } else {
                    messageBuffer.append("\n").append("Managers: <No Managers>");
                }
                List<BpmOuUser> users = bpmOrganizationalUnit.getBpmOuUserCollection();
                if (users != null && users.size() > 0) {
                    messageBuffer.append("\n").append("Users:");
                    for (BpmOuUser user : users) {
                        messageBuffer.append("\n").append("   Id: " + user.getId());
                        messageBuffer.append("\n").append("   Name: " + user.getUserId());
                        messageBuffer.append("\n").append("   Type: " + user.getUserType());
                        messageBuffer.append("\n").append("   Realm: " + user.getIdentityContext());
                        messageBuffer.append("\n").append("   CreatedBy:" + user.getCreatedBy());
                        messageBuffer.append("\n").append("   CreatedByIdentityContext:" + user.getCreatedByIdentityContext());
                        messageBuffer.append("\n").append("   CreatedDate:" + user.getCreatedDate());
                        messageBuffer.append("\n").append("   LastUpdatedBy:" + user.getLastUpdatedBy());
                        messageBuffer.append("\n").append("   LastUpdatedByIdentityContext:" + user.getLastUpdatedByIdencontext());
                        messageBuffer.append("\n").append("   LastUpdatedDate:" + user.getLastUpdatedDate());
                    }
                } else if (users == null) {
                    messageBuffer.append("\n").append("Users: <null User list>");
                } else {
                    messageBuffer.append("\n").append("Users: <No Users>");
                }
                List<BpmOrganizationalUnit> childrens = bpmOrganizationalUnit.getBpmOrganizationalUnitCollection();
                if (!CommonUtil.isListNullOrEmpty(childrens)) {
                    for (BpmOrganizationalUnit childOrganizationalUnit : childrens) {
                        BPMOrganizationPersistency.print(messageBuffer, childOrganizationalUnit);
                    }
                }
            }
        }
    }

    private void deleteOrganizationalUnit(IBPMContext ctx, BpmOrganizationalUnit bpmOrganizationalUnit, boolean includingChildren, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder, boolean rootOrganizationUnit) throws BPMOrganizationException {
        String METHOD = "deleteOrganizationalUnit";
        bpmOrganizationalUnit.getBpmAppRoleOuCalAssocCollection().toArray();
        bpmOrganizationalUnit.getBpmOuManagerCollection().toArray();
        bpmOrganizationalUnit.getBpmOuUserCollection().toArray();
        bpmOrganizationalUnit.getBpmOrganizationalUnitCollection().toArray();
        String sqlQuery = "SELECT * FROM BPM_ORGANIZATIONAL_UNIT WHERE  PARENT_ORGANIZATIONAL_UNIT_ID = '" + bpmOrganizationalUnit.getOrganizationalUnitId() + "'";
        Vector<Object> children = unitOfWorkHolder.executeObjectQuery(BpmOrganizationalUnit.class, sqlQuery);
        if (children != null) {
            Enumeration<Object> iter = children.elements();
            ArrayList list = new ArrayList(children.size());
            while (iter.hasMoreElements()) {
                BpmOrganizationalUnit childBpmOrganizationalUnit = (BpmOrganizationalUnit)iter.nextElement();
                if (includingChildren) {
                    this.deleteOrganizationalUnit(ctx, childBpmOrganizationalUnit, includingChildren, unitOfWorkHolder, false);
                    continue;
                }
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "Setting the Parent OrganizationalUnit to Null for :" + bpmOrganizationalUnit.getOrganizationalUnitId() + ":" + bpmOrganizationalUnit.getOrganizationalUnitName());
                }
                childBpmOrganizationalUnit = (BpmOrganizationalUnit)unitOfWorkHolder.readObject(childBpmOrganizationalUnit);
                childBpmOrganizationalUnit.setParentOrganizationalUnit(null);
            }
        }
        bpmOrganizationalUnit.setParentOrganizationalUnit(null);
        unitOfWorkHolder.deleteObject(bpmOrganizationalUnit);
    }
}

