/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.persistency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.CommonUtil;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.PeopleQueryUtil;
import oracle.bpm.services.organization.model.LPGMember;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.PrincipleListType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.StatusTypeEnum;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.model.BpmLogicalPeopleGroup;
import oracle.bpm.services.organization.persistency.model.BpmLpgMember;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.SQLCall;

public class BPMLogicalPeopleGroupPersistency
extends AbstractPersistencyDriver {
    public static final String TOPLINK_MAP_FILE_PATH = "oracle/bpm/services/organization/persistency/BPMLogicalPeopleGroupMap.xml";
    private static final String POJO_MODEL_PACKAGE = "oracle.bpm.services.organization.persistency.model";
    ObjectFactory objectFactory = new ObjectFactory();

    private BPMLogicalPeopleGroupPersistency() {
    }

    public static BPMLogicalPeopleGroupPersistency getInstance() {
        return new BPMLogicalPeopleGroupPersistency();
    }

    public static void print(String message, Object object) {
        if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            return;
        }
        StringBuffer messageBuffer = new StringBuffer();
        if (message != null) {
            messageBuffer.append(message);
            messageBuffer.append(" - ");
        }
        if (object instanceof LogicalPeopleGroup) {
            LogicalPeopleGroup jaxbLogicalPeopleGroup = (LogicalPeopleGroup)object;
            messageBuffer.append("\n").append(message + "LogicalPeopleGroup (JAXB):");
            messageBuffer.append("\n").append("      id              : " + jaxbLogicalPeopleGroup.getId());
            messageBuffer.append("\n").append("      name            : " + jaxbLogicalPeopleGroup.getName());
            messageBuffer.append("\n").append("      timeout         : " + jaxbLogicalPeopleGroup.getTimeout());
            messageBuffer.append("\n").append("      status          : " + jaxbLogicalPeopleGroup.getStatus());
            messageBuffer.append("\n").append("      expirationTime  : " + jaxbLogicalPeopleGroup.getExpirationTime());
            messageBuffer.append("\n").append("      lastExecutedDate: " + jaxbLogicalPeopleGroup.getLastExecutedDate());
            messageBuffer.append("\n").append("      createdDate     : " + jaxbLogicalPeopleGroup.getCreatedDate());
            messageBuffer.append("\n").append("      lastUpdatedDate : " + jaxbLogicalPeopleGroup.getLastUpdatedDate());
            messageBuffer.append("\n").append("      createdBy       : " + jaxbLogicalPeopleGroup.getCreatedBy());
            messageBuffer.append("\n").append("      lastUpdatedBy   : " + jaxbLogicalPeopleGroup.getLastUpdatedBy());
            messageBuffer.append("\n").append("      createdByContext: " + jaxbLogicalPeopleGroup.getCreatedByIdentityContext());
            messageBuffer.append("\n").append("      updatedByContext: " + jaxbLogicalPeopleGroup.getLastUpdatedByIdentityContext());
        } else if (object instanceof BpmLogicalPeopleGroup) {
            BpmLogicalPeopleGroup tlLogicalPeopleGroup = (BpmLogicalPeopleGroup)object;
            messageBuffer.append("\n").append(message + "BpmLogicalPeopleGroup (TopLink):");
            messageBuffer.append("\n").append("      id              : " + tlLogicalPeopleGroup.getId());
            messageBuffer.append("\n").append("      name            : " + tlLogicalPeopleGroup.getName());
            messageBuffer.append("\n").append("      timeout         : " + tlLogicalPeopleGroup.getTimeout());
            messageBuffer.append("\n").append("      status          : " + tlLogicalPeopleGroup.getStatus());
            messageBuffer.append("\n").append("      expirationTime  : " + tlLogicalPeopleGroup.getExpirationTime());
            messageBuffer.append("\n").append("      lastExecutedDate: " + tlLogicalPeopleGroup.getLastExecutedDate());
            messageBuffer.append("\n").append("      createdDate     : " + tlLogicalPeopleGroup.getCreatedDate());
            messageBuffer.append("\n").append("      lastUpdatedDate : " + tlLogicalPeopleGroup.getLastUpdatedDate());
            messageBuffer.append("\n").append("      createdBy       : " + tlLogicalPeopleGroup.getCreatedBy());
            messageBuffer.append("\n").append("      lastUpdatedBy   : " + tlLogicalPeopleGroup.getLastUpdatedBy());
            messageBuffer.append("\n").append("      createdByContext: " + tlLogicalPeopleGroup.getCreatedByIdentityContext());
            messageBuffer.append("\n").append("      updatedByContext: " + tlLogicalPeopleGroup.getLastUpdatedByIdencontext());
        } else if (object instanceof LPGMember) {
            LPGMember jaxbLpgMemeber = (LPGMember)object;
            messageBuffer.append("\n").append(message + "LPGMember (JAXB):");
            messageBuffer.append("\n").append("      id:" + jaxbLpgMemeber.getId());
            messageBuffer.append("\n").append("      queryId:" + jaxbLpgMemeber.getQueryId());
            messageBuffer.append("\n").append("      userId:" + jaxbLpgMemeber.getUserId());
            messageBuffer.append("\n").append("      identityContext:" + jaxbLpgMemeber.getIdentityContext());
        } else if (object instanceof BpmLpgMember) {
            BpmLpgMember tlLpgMember = (BpmLpgMember)object;
            messageBuffer.append("\n").append(message + "BpmLpgMember (TopLink):");
            messageBuffer.append("\n").append("      id:" + tlLpgMember.getId());
            messageBuffer.append("\n").append("      queryId:" + (tlLpgMember.getQuery() == null ? null : tlLpgMember.getQuery().getId()));
            messageBuffer.append("\n").append("      userId:" + tlLpgMember.getUserId());
            messageBuffer.append("\n").append("      identityContext:" + tlLpgMember.getIdentityContext());
        } else if (object == null) {
            messageBuffer.append("\n").append(message + "Cannot print object details, object is null");
        } else {
            messageBuffer.append("\n").append(message + "Unidentified object type. Object's className=" + object.getClass().getName());
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"BPMLogicalPeopleGroupPersistency", (String)"print", (String)messageBuffer.toString());
        }
    }

    @Override
    public String getPOJOModelPackage() {
        return POJO_MODEL_PACKAGE;
    }

    @Override
    public Object convertToTopLink(Object object) throws BPMOrganizationException {
        return null;
    }

    @Override
    public Object convertFromTopLink(Object object) throws BPMOrganizationException {
        return null;
    }

    @Override
    public Object convertFromTopLink(IBPMContext ctx, AbstractPersistencyDriver.OPERATION operation, Object toplinkObject, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        return this.convertFromTopLink((BpmLogicalPeopleGroup)toplinkObject);
    }

    @Override
    public Object convertToTopLink(IBPMContext ctx, AbstractPersistencyDriver.OPERATION operation, Object jaxbObject, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        Object tlObject = this.createNewTopLink(jaxbObject);
        if (operation.equals((Object)AbstractPersistencyDriver.OPERATION.CREATE)) {
            tlObject = unitOfWorkHolder.registerNewObject(tlObject);
            this.copyToTopLink(jaxbObject, tlObject, unitOfWorkHolder);
        } else if (operation.equals((Object)AbstractPersistencyDriver.OPERATION.UPDATE)) {
            tlObject = unitOfWorkHolder.registerExistingObject(tlObject);
            tlObject = unitOfWorkHolder.readObject(tlObject);
            this.copyToTopLink(jaxbObject, tlObject, unitOfWorkHolder);
        } else {
            return tlObject;
        }
        return tlObject;
    }

    public Object createNewTopLink(Object object) throws BPMOrganizationException {
        BpmLogicalPeopleGroup result = null;
        if (object instanceof LogicalPeopleGroup) {
            result = this.createNewTopLink((LogicalPeopleGroup)object);
        }
        this.checkConversion(object, result);
        return result;
    }

    public Object copyToTopLink(Object jaxbOriginal, Object toplinkCopy, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        BpmLogicalPeopleGroup result = null;
        if (jaxbOriginal instanceof LogicalPeopleGroup) {
            result = this.copyToTopLink((LogicalPeopleGroup)jaxbOriginal, (BpmLogicalPeopleGroup)toplinkCopy, unitOfWorkHolder);
        }
        this.checkConversion(jaxbOriginal, result);
        return result;
    }

    public LogicalPeopleGroup readLogicalPeopleGroupById(String id) throws BPMOrganizationException {
        BpmLogicalPeopleGroup tlBpmLogicalPeopleGroup = new BpmLogicalPeopleGroup();
        tlBpmLogicalPeopleGroup.setId(id);
        return (LogicalPeopleGroup)this.read(null, tlBpmLogicalPeopleGroup);
    }

    public LogicalPeopleGroup readLogicalPeopleGroupByName(String name) throws BPMOrganizationException {
        BpmLogicalPeopleGroup tlBpmLogicalPeopleGroup = new BpmLogicalPeopleGroup();
        tlBpmLogicalPeopleGroup.setName(name);
        return (LogicalPeopleGroup)this.read(null, tlBpmLogicalPeopleGroup);
    }

    public void deleteLogicalPeopleGroup(String id) throws BPMOrganizationException {
        BpmLogicalPeopleGroup tlBpmLogicalPeopleGroup = new BpmLogicalPeopleGroup();
        tlBpmLogicalPeopleGroup.setId(id);
        this.deleteObject(null, tlBpmLogicalPeopleGroup);
    }

    public List<LogicalPeopleGroup> getAllLogicalPeopleGroups(IBPMContext ctx) throws BPMOrganizationException {
        String sqlQuery = "SELECT * FROM BPM_LOGICAL_PEOPLE_GROUP";
        ArrayList<LogicalPeopleGroup> list = new ArrayList<LogicalPeopleGroup>();
        Vector<Object> vector = this.executeObjectQuery(ctx, BpmLogicalPeopleGroup.class, sqlQuery);
        for (int index = 0; index < vector.size(); ++index) {
            list.add(this.convertFromTopLink((BpmLogicalPeopleGroup)vector.get(index)));
        }
        return list;
    }

    public List<LogicalPeopleGroup> getLogicalPeopleGroupsByUser(PrincipleRefType user) throws BPMOrganizationException {
        ArrayList<LogicalPeopleGroup> result = new ArrayList<LogicalPeopleGroup>();
        if (user == null) {
            return result;
        }
        Vector<String> paramValues = new Vector<String>();
        Vector<Integer> paramTypes = new Vector<Integer>();
        StringBuffer sql = new StringBuffer("SELECT lpg.ID from BPM_LOGICAL_PEOPLE_GROUP lpg, BPM_LPG_MEMBER member").append(" WHERE lpg.ID=member.QUERY_ID ");
        this.addUserSqlClauses(user, sql, "member", paramValues, paramTypes);
        SQLCall call = new SQLCall(sql.toString());
        call.setParameterTypes(paramTypes);
        call.setParameters(paramValues);
        ReadAllQuery query = new ReadAllQuery(BpmLogicalPeopleGroup.class, (Call)call);
        List tlLogicalPeopleGroupList = (List)this.getServerSession().acquireClientSession().executeQuery((DatabaseQuery)query);
        HashSet<String> peopleQueryIds = new HashSet<String>();
        for (BpmLogicalPeopleGroup tlBpmLogicalPeopleGroup : tlLogicalPeopleGroupList) {
            String id = tlBpmLogicalPeopleGroup.getId();
            if (peopleQueryIds.contains(id)) continue;
            peopleQueryIds.add(id);
            result.add(this.convertFromTopLink(tlBpmLogicalPeopleGroup));
        }
        return result;
    }

    public BpmLogicalPeopleGroup createNewTopLink(LogicalPeopleGroup jaxbLogicalPeopleGroup) {
        BpmLogicalPeopleGroup result = new BpmLogicalPeopleGroup();
        String id = jaxbLogicalPeopleGroup.getId();
        result.setId(id);
        return result;
    }

    public BpmLogicalPeopleGroup copyToTopLink(LogicalPeopleGroup jaxbLogicalPeopleGroup, BpmLogicalPeopleGroup tlBpmLogicalPeopleGroup, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String id = jaxbLogicalPeopleGroup.getId();
        tlBpmLogicalPeopleGroup.setId(id);
        tlBpmLogicalPeopleGroup.setName(jaxbLogicalPeopleGroup.getName());
        tlBpmLogicalPeopleGroup.setStatus(jaxbLogicalPeopleGroup.getStatus() != null ? jaxbLogicalPeopleGroup.getStatus().name() : StatusTypeEnum.ENABLED.name());
        tlBpmLogicalPeopleGroup.setTimeout(jaxbLogicalPeopleGroup.getTimeout());
        tlBpmLogicalPeopleGroup.setExpirationTime(BPMLogicalPeopleGroupPersistency.convertToTimestamp(jaxbLogicalPeopleGroup.getExpirationTime()));
        tlBpmLogicalPeopleGroup.setLastExecutedDate(BPMLogicalPeopleGroupPersistency.convertToTimestamp(jaxbLogicalPeopleGroup.getLastExecutedDate()));
        PeopleQuery peopleQuery = new PeopleQuery(jaxbLogicalPeopleGroup.getPeopleQuery());
        String peopleQueryAsXMLString = PeopleQueryUtil.getPeopleQueryAsString(peopleQuery);
        tlBpmLogicalPeopleGroup.setPeopleQuery(peopleQueryAsXMLString);
        tlBpmLogicalPeopleGroup.setCreatedBy(jaxbLogicalPeopleGroup.getCreatedBy());
        tlBpmLogicalPeopleGroup.setCreatedByIdentityContext(jaxbLogicalPeopleGroup.getCreatedByIdentityContext());
        tlBpmLogicalPeopleGroup.setCreatedDate(BPMLogicalPeopleGroupPersistency.convertToTimestamp(jaxbLogicalPeopleGroup.getCreatedDate()));
        tlBpmLogicalPeopleGroup.setLastUpdatedBy(jaxbLogicalPeopleGroup.getLastUpdatedBy());
        tlBpmLogicalPeopleGroup.setLastUpdatedByIdencontext(jaxbLogicalPeopleGroup.getLastUpdatedByIdentityContext());
        tlBpmLogicalPeopleGroup.setLastUpdatedDate(BPMLogicalPeopleGroupPersistency.convertToTimestamp(jaxbLogicalPeopleGroup.getLastUpdatedDate()));
        List<BpmLpgMember> memberList = tlBpmLogicalPeopleGroup.getBpmLpgMemberCollection();
        HashMap<String, BpmLpgMember> existingMembers = new HashMap<String, BpmLpgMember>(memberList.size());
        for (BpmLpgMember member : memberList) {
            String grantKey = this.createBpmLpgMemberKey(member);
            existingMembers.put(grantKey, member);
        }
        if (jaxbLogicalPeopleGroup.getMembers() != null) {
            List members = jaxbLogicalPeopleGroup.getMembers().getParticipant();
            for (PrincipleRefType member : members) {
                String grantKey = this.createPrincipleRefTypeKey(member);
                if (!existingMembers.containsKey(grantKey)) {
                    BpmLpgMember tlBpmLpgMember = this.convertToBpmLpgMember(member);
                    tlBpmLpgMember.setQuery(tlBpmLogicalPeopleGroup);
                    tlBpmLogicalPeopleGroup.addBpmLpgMember(tlBpmLpgMember);
                    continue;
                }
                existingMembers.remove(grantKey);
            }
        }
        for (BpmLpgMember member : existingMembers.values()) {
            memberList.remove(member);
            unitOfWorkHolder.deleteObject(member);
        }
        return tlBpmLogicalPeopleGroup;
    }

    public String createBpmLpgMemberKey(BpmLpgMember member) {
        StringBuffer key = new StringBuffer(member.getUserId()).append(":").append(member.getIdentityContext());
        return key.toString();
    }

    public String createPrincipleRefTypeKey(PrincipleRefType participant) {
        String name = participant.getName();
        String type = participant.getType().toString();
        StringBuffer key = new StringBuffer(name).append(":");
        key.append(participant.getRealm());
        return key.toString();
    }

    public LogicalPeopleGroup convertFromTopLink(BpmLogicalPeopleGroup tlLogicalPeopleGroup) throws BPMOrganizationException {
        LogicalPeopleGroup jaxbLogicalPeopleGroup = this.objectFactory.createLogicalPeopleGroup();
        jaxbLogicalPeopleGroup.setId(tlLogicalPeopleGroup.getId());
        jaxbLogicalPeopleGroup.setName(tlLogicalPeopleGroup.getName());
        jaxbLogicalPeopleGroup.setStatus(BPMLogicalPeopleGroupPersistency.getStatus(tlLogicalPeopleGroup.getStatus()));
        jaxbLogicalPeopleGroup.setTimeout(tlLogicalPeopleGroup.getTimeout());
        jaxbLogicalPeopleGroup.setExpirationTime(BPMLogicalPeopleGroupPersistency.convertToCalendar(tlLogicalPeopleGroup.getExpirationTime()));
        jaxbLogicalPeopleGroup.setLastExecutedDate(BPMLogicalPeopleGroupPersistency.convertToCalendar(tlLogicalPeopleGroup.getLastExecutedDate()));
        String query = tlLogicalPeopleGroup.getPeopleQuery();
        PeopleQuery peopleQuery = PeopleQueryUtil.getPeopleQueryFromXMLString(query);
        jaxbLogicalPeopleGroup.setPeopleQuery((PeopleQueryType)peopleQuery.getValue());
        jaxbLogicalPeopleGroup.setCreatedBy(tlLogicalPeopleGroup.getCreatedBy());
        jaxbLogicalPeopleGroup.setCreatedByIdentityContext(tlLogicalPeopleGroup.getCreatedByIdentityContext());
        jaxbLogicalPeopleGroup.setCreatedDate(BPMLogicalPeopleGroupPersistency.convertToCalendar(tlLogicalPeopleGroup.getCreatedDate()));
        jaxbLogicalPeopleGroup.setLastUpdatedBy(tlLogicalPeopleGroup.getLastUpdatedBy());
        jaxbLogicalPeopleGroup.setLastUpdatedDate(BPMLogicalPeopleGroupPersistency.convertToCalendar(tlLogicalPeopleGroup.getCreatedDate()));
        jaxbLogicalPeopleGroup.setLastUpdatedByIdentityContext(tlLogicalPeopleGroup.getLastUpdatedByIdencontext());
        PrincipleListType memberList = jaxbLogicalPeopleGroup.getMembers();
        List<BpmLpgMember> members = tlLogicalPeopleGroup.getBpmLpgMemberCollection();
        if (!CommonUtil.isListNullOrEmpty(members)) {
            for (BpmLpgMember member : members) {
                if (memberList == null) {
                    memberList = this.objectFactory.createPrincipleListType();
                    jaxbLogicalPeopleGroup.setMembers(memberList);
                }
                memberList.getParticipant().add(this.convertToPrincipleRefType(member));
            }
        }
        return jaxbLogicalPeopleGroup;
    }

    private static StatusTypeEnum getStatus(String status) {
        if (status == null) {
            return StatusTypeEnum.ENABLED;
        }
        return StatusTypeEnum.fromValue((String)status);
    }

    private void checkConversion(Object source, Object result) throws BPMOrganizationException {
        if (result == null) {
            Object[] objs = new Object[]{this.getClass().getName(), source.getClass().getName()};
            throw new BPMOrganizationException(70688, objs);
        }
    }

    private void addUserSqlClauses(PrincipleRefType user, StringBuffer sql, String grantTableAlias, Vector<String> paramValues, Vector<Integer> paramTypes) {
        if (user != null) {
            sql.append("AND ").append(grantTableAlias).append(".USER_ID = ? ");
            sql.append("AND ").append(grantTableAlias).append(".IDENTITY_CONTEXT = ? ");
            String userName = user.getName();
            paramValues.add(userName);
            paramTypes.add(SQLCall.LITERAL);
            paramValues.add(user.getRealm());
            paramTypes.add(SQLCall.LITERAL);
        }
    }

    private BpmLpgMember convertToBpmLpgMember(PrincipleRefType principle) throws BPMOrganizationException {
        BpmLpgMember tlLpgMember = new BpmLpgMember();
        tlLpgMember.setId(BPMLogicalPeopleGroupPersistency.getGuid());
        String name = principle.getName();
        tlLpgMember.setUserId(name);
        String identityContext = principle.getRealm();
        tlLpgMember.setIdentityContext(identityContext);
        return tlLpgMember;
    }

    private PrincipleRefType convertToPrincipleRefType(BpmLpgMember member) {
        PrincipleRefType principle = null;
        if (member != null) {
            principle = this.objectFactory.createPrincipleRefType();
            principle.setName(member.getUserId());
            principle.setRealm(member.getIdentityContext());
            principle.setType(ParticipantTypeEnum.USER);
        }
        return principle;
    }
}

