/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.persistency;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.expressions.Expression;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.Project;
import oracle.toplink.sessions.UnitOfWork;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.Server;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import oracle.toplink.tools.workbench.XMLProjectReader;

public abstract class AbstractPersistencyDriver {
    public static volatile Server serverSession = null;
    public static final String SESSION_NAME = "BPM_Organization";
    public static final String SESSION_PATH = "oracle/bpm/services/organization/persistency/BPMOrganizationSession.xml";
    protected static DatatypeFactory datatypeFactory = null;

    public abstract String getPOJOModelPackage();

    public abstract Object convertToTopLink(Object var1) throws BPMOrganizationException;

    public abstract Object convertFromTopLink(Object var1) throws BPMOrganizationException;

    public abstract Object convertFromTopLink(IBPMContext var1, OPERATION var2, Object var3, UnitOfWorkHolder var4) throws BPMOrganizationException;

    public abstract Object convertToTopLink(IBPMContext var1, OPERATION var2, Object var3, UnitOfWorkHolder var4) throws BPMOrganizationException;

    public static String getSessionPath() {
        return SESSION_PATH;
    }

    public static String getSessionName() {
        return SESSION_NAME;
    }

    public static String getGuid() {
        return UUID.randomUUID().toString();
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Calendar cal) throws BPMOrganizationException {
        try {
            if (cal instanceof GregorianCalendar) {
                return datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal);
            }
            return datatypeFactory.newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public List<Object> executeQuery(Class<?> objectClass, Expression expression) throws BPMOrganizationException {
        Vector<Object> objects = this.getUnitOfWorkHolder(false).executeObjectQuery(objectClass, expression);
        ArrayList<Object> bpmObjects = new ArrayList<Object>();
        if (objects == null) {
            return bpmObjects;
        }
        for (int index = 0; index < objects.size(); ++index) {
            bpmObjects.add(this.doConversionFromTopLink(objects.get(index)));
        }
        return bpmObjects;
    }

    public List<Object> executeQuery(Class<?> objectClass, List columnList, Predicate predicate, Ordering ordering) throws BPMOrganizationException {
        String sqlQuery;
        try {
            sqlQuery = Util.getSelectQuery((List)columnList, (Predicate)predicate, (Ordering)ordering);
        }
        catch (WorkflowException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
        Vector<Object> objects = this.getUnitOfWorkHolder(false).executeObjectQuery(objectClass, sqlQuery);
        ArrayList<Object> bpmObjects = new ArrayList<Object>();
        if (objects == null) {
            return bpmObjects;
        }
        for (int index = 0; index < objects.size(); ++index) {
            bpmObjects.add(this.doConversionFromTopLink(objects.get(index)));
        }
        return bpmObjects;
    }

    public boolean isPersistenceObject(Object object) {
        return object.getClass().getPackage().getName().equals(this.getPOJOModelPackage());
    }

    public void insert(IBPMContext ctx, Object jaxbObject) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(true);
        this.insert(ctx, jaxbObject, unitOfWorkHolder);
        unitOfWorkHolder.completed();
    }

    public void insert(IBPMContext ctx, Object jaxbObject, UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        if (unitOfWorkHolder == null) {
            this.insert(ctx, jaxbObject);
        } else {
            this.convertToTopLink(ctx, OPERATION.CREATE, jaxbObject, unitOfWorkHolder);
        }
    }

    public void update(IBPMContext ctx, Object jaxbObject) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(true);
        this.convertToTopLink(ctx, OPERATION.UPDATE, jaxbObject, unitOfWorkHolder);
        unitOfWorkHolder.completed();
    }

    public void update(IBPMContext ctx, Object jaxbObject, UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        if (unitOfWorkHolder == null) {
            this.update(ctx, jaxbObject);
        } else {
            this.convertToTopLink(ctx, OPERATION.UPDATE, jaxbObject, unitOfWorkHolder);
        }
    }

    public void delete(IBPMContext ctx, Object jaxbObject) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(true);
        Object topLinkObject = this.convertToTopLink(ctx, OPERATION.DELETE, jaxbObject, unitOfWorkHolder);
        unitOfWorkHolder.deleteObject(topLinkObject);
        unitOfWorkHolder.completed();
    }

    public void deleteObject(IBPMContext ctx, Object topLinkObject) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(true);
        topLinkObject = unitOfWorkHolder.deleteObject(topLinkObject);
        unitOfWorkHolder.completed();
    }

    public Object readObject(IBPMContext ctx, Object topLinkObject) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(false);
        return this.readObject(ctx, topLinkObject, unitOfWorkHolder);
    }

    public Object readObject(IBPMContext ctx, Object topLinkObject, UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        if (unitOfWorkHolder == null) {
            return this.readObject(ctx, topLinkObject);
        }
        return unitOfWorkHolder.readObject(topLinkObject);
    }

    public Object read(IBPMContext ctx, Object topLinkObject, UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        Object jaxbObject = this.readObject(ctx, topLinkObject, unitOfWorkHolder);
        if (jaxbObject != null) {
            jaxbObject = this.convertFromTopLink(ctx, OPERATION.READ, jaxbObject, unitOfWorkHolder);
        }
        return jaxbObject;
    }

    public Object read(IBPMContext ctx, Object topLinkObject) throws BPMOrganizationException {
        return this.read(ctx, topLinkObject, null);
    }

    public Vector<Object> executeObjectQuery(IBPMContext ctx, Class<?> topLinkObjectClass, Expression expression) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(false);
        Vector<Object> topLinkObjects = unitOfWorkHolder.executeObjectQuery(topLinkObjectClass, expression);
        return topLinkObjects;
    }

    public Vector<Object> executeQuery(IBPMContext ctx, Class<?> topLinkObjectClass, Expression expression) throws BPMOrganizationException {
        Vector<Object> topLinkObjects = this.executeObjectQuery(ctx, topLinkObjectClass, expression);
        Vector<Object> jaxbObjects = null;
        if (!topLinkObjects.isEmpty()) {
            jaxbObjects = new Vector<Object>();
            for (int index = 0; index < topLinkObjects.size(); ++index) {
                jaxbObjects.add(this.convertFromTopLink(ctx, OPERATION.READ, topLinkObjects.get(index), null));
            }
        } else {
            jaxbObjects = new Vector();
        }
        return jaxbObjects;
    }

    public Vector<Object> executeObjectQuery(IBPMContext ctx, Class<?> topLinkObjectClass, String sqlQuery) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(false);
        Vector<Object> topLinkObjects = unitOfWorkHolder.executeObjectQuery(topLinkObjectClass, sqlQuery);
        return topLinkObjects;
    }

    public Vector<DatabaseRecord> executeSQL(IBPMContext ctx, String sqlQuery) throws BPMOrganizationException {
        UnitOfWorkHolder unitOfWorkHolder = this.getUnitOfWorkHolder(false);
        Vector<DatabaseRecord> databaseRecords = unitOfWorkHolder.executeSQL(sqlQuery);
        return databaseRecords;
    }

    public Vector<Object> executeQuery(IBPMContext ctx, Class<?> topLinkObjectClass, String sqlQuery) throws BPMOrganizationException {
        Vector<Object> topLinkObjects = this.executeObjectQuery(ctx, topLinkObjectClass, sqlQuery);
        Vector<Object> jaxbObjects = null;
        if (!topLinkObjects.isEmpty()) {
            jaxbObjects = new Vector<Object>();
            for (int index = 0; index < topLinkObjects.size(); ++index) {
                jaxbObjects.add(this.convertFromTopLink(ctx, OPERATION.READ, topLinkObjects.get(index), null));
            }
        } else {
            jaxbObjects = new Vector();
        }
        return jaxbObjects;
    }

    public final UnitOfWorkHolder getUnitOfWorkHolder(boolean isParticipatingInTransaction) {
        return new UnitOfWorkHolder(isParticipatingInTransaction);
    }

    protected static Timestamp convertToTimestamp(XMLGregorianCalendar calendar) {
        Timestamp timestamp = null;
        if (calendar != null) {
            timestamp = new Timestamp(calendar.toGregorianCalendar().getTimeInMillis());
        }
        return timestamp;
    }

    protected static XMLGregorianCalendar convertToCalendar(Timestamp timestamp) {
        XMLGregorianCalendar xmlGregorianCalendar = null;
        if (timestamp != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(timestamp.getTime());
            xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(calendar);
        }
        return xmlGregorianCalendar;
    }

    protected static XMLGregorianCalendar convertToCalendar(Date dt) {
        if (dt == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(dt.getTime());
        XMLGregorianCalendar cal = datatypeFactory.newXMLGregorianCalendar(calendar);
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Server getServerSession() {
        if (serverSession == null || serverSession != null && !serverSession.isConnected()) {
            Class<AbstractPersistencyDriver> clazz = AbstractPersistencyDriver.class;
            // MONITORENTER : oracle.bpm.services.organization.persistency.AbstractPersistencyDriver.class
            if (serverSession == null || serverSession != null && !serverSession.isConnected()) {
                serverSession = this.createServerSession();
                this.debugLog("getNewServerSession", "New session has been created");
            }
            // MONITOREXIT : clazz
        }
        this.debugLog("getServerSession", "Thread name=" + Thread.currentThread().getName() + "\n\t serverSession name=" + serverSession.getName() + "\n\t isConnected " + serverSession.isConnected() + "\n\t project name=" + serverSession.getProject().getName());
        return serverSession;
    }

    protected Server createServerSession() {
        this.debugLog("createServerSession", "Create new serverSession. Begin");
        this.debugLog("createServerSession", "sessionPath : oracle/bpm/services/organization/persistency/BPMOrganizationSession.xml");
        this.debugLog("createServerSession", "sessionName : BPM_Organization");
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader(SESSION_PATH);
        SessionManager mgr = SessionManager.getManager();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.debugLog("createServerSession", "ClassLoader : " + classLoader);
        Server server = (Server)mgr.getSession(loader, SESSION_NAME, classLoader, true, false, true);
        Project project = XMLProjectReader.read((String)"oracle/bpm/services/organization/persistency/BPMLogicalPeopleGroupMap.xml", (ClassLoader)classLoader);
        server.addDescriptors(project);
        project = XMLProjectReader.read((String)"oracle/bpm/services/organization/persistency/ExtendedUserPropertiesMap.xml", (ClassLoader)classLoader);
        server.addDescriptors(project);
        this.debugLog("createServerSession", "Create new serverSession. End");
        return server;
    }

    protected void debugLog(String methodName, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"AbstractPersistencyDriver", (String)methodName, (String)msg);
        }
    }

    private Object doConversionFromTopLink(Object object) throws BPMOrganizationException {
        Object result = this.convertFromTopLink(object);
        if (result == null) {
            Object[] objs = new Object[]{this.getClass().getName(), object.getClass().getName()};
            throw new BPMOrganizationException(70688, objs);
        }
        return result;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final class UnitOfWorkHolder {
        private boolean isParticipatingInTransaction = false;
        private boolean isTransactionStarted = false;
        private UnitOfWork uow = null;

        public UnitOfWorkHolder(boolean isParticipatingInTransaction) {
            this.isParticipatingInTransaction = isParticipatingInTransaction;
            if (isParticipatingInTransaction) {
                ClientSession clientSession = AbstractPersistencyDriver.this.getServerSession().acquireClientSession();
                this.uow = clientSession.getActiveUnitOfWork();
                if (this.uow == null) {
                    AbstractPersistencyDriver.this.debugLog("UnitOfWorkHolder", "Starting external transaction....");
                    this.uow = clientSession.acquireUnitOfWork();
                    this.isTransactionStarted = true;
                }
                this.uow.setShouldNewObjectsBeCached(true);
            }
        }

        public Vector<Object> executeObjectQuery(Class<?> objectClass, Expression expression) throws BPMOrganizationException {
            Vector objects = null;
            objects = this.isParticipatingInTransaction ? this.uow.readAllObjects(objectClass, expression) : AbstractPersistencyDriver.this.getServerSession().acquireClientSession().readAllObjects(objectClass, expression);
            if (objects == null) {
                return new Vector<Object>();
            }
            return objects;
        }

        public Vector<DatabaseRecord> executeSQL(String sqlQuery) throws BPMOrganizationException {
            Vector databaseRecords = null;
            databaseRecords = this.isParticipatingInTransaction ? this.uow.executeSQL(sqlQuery) : AbstractPersistencyDriver.this.getServerSession().acquireClientSession().executeSQL(sqlQuery);
            return databaseRecords;
        }

        public Vector<Object> executeObjectQuery(Class<?> topLinkObjectClass, String sqlQuery) throws BPMOrganizationException {
            Vector topLinkObjects = null;
            topLinkObjects = this.isParticipatingInTransaction ? this.uow.readAllObjects(topLinkObjectClass, sqlQuery) : AbstractPersistencyDriver.this.getServerSession().acquireClientSession().readAllObjects(topLinkObjectClass, sqlQuery);
            if (topLinkObjects == null) {
                return new Vector<Object>();
            }
            return topLinkObjects;
        }

        public int executeNonSelectingCall(Call call) throws BPMOrganizationException {
            if (this.isParticipatingInTransaction) {
                return this.uow.executeNonSelectingCall(call);
            }
            return AbstractPersistencyDriver.this.getServerSession().acquireClientSession().executeNonSelectingCall(call);
        }

        public Object executeQuery(DatabaseQuery query, Vector argumentValues) throws BPMOrganizationException {
            Object result = null;
            result = this.isParticipatingInTransaction ? this.uow.executeQuery(query, argumentValues) : AbstractPersistencyDriver.this.getServerSession().acquireClientSession().executeQuery(query, argumentValues);
            if (result == null) {
                result = new Object();
            }
            return result;
        }

        public Object registerNewObject(Object topLinkObject) {
            return this.uow.registerNewObject(topLinkObject);
        }

        public Object registerExistingObject(Object topLinkObject) {
            return this.uow.registerExistingObject(topLinkObject);
        }

        public Object registerObject(Object topLinkObject) {
            return this.uow.registerObject(topLinkObject);
        }

        public Object deleteObject(Object topLinkObject) {
            return this.uow.deleteObject(topLinkObject);
        }

        public Object deepMergeClone(Object topLinkObject) {
            return this.uow.deepMergeClone(topLinkObject);
        }

        public Collection readAllObjects(Class<?> topLinkObjectClass) {
            if (this.isParticipatingInTransaction) {
                return this.uow.readAllObjects(topLinkObjectClass);
            }
            return AbstractPersistencyDriver.this.getServerSession().acquireClientSession().readAllObjects(topLinkObjectClass);
        }

        public Object readObject(Object topLinkObject) {
            if (this.isParticipatingInTransaction) {
                return this.uow.readObject(topLinkObject);
            }
            return AbstractPersistencyDriver.this.getServerSession().acquireClientSession().readObject(topLinkObject);
        }

        public void completed() {
            if (this.isTransactionStarted) {
                AbstractPersistencyDriver.this.debugLog("Completed", "Commiting external transaction....");
                this.uow.commit();
            }
        }

        public void setShouldNewObjectsBeCached(boolean shouldNewObjectsBeCached) {
            this.uow.setShouldNewObjectsBeCached(shouldNewObjectsBeCached);
        }

        public void shouldPerformDeletesFirst() {
            this.uow.setShouldPerformDeletesFirst(true);
        }

        public void shouldPerformDeletesLast() {
            this.uow.setShouldPerformDeletesFirst(false);
        }

        public void validateObjectSpace() {
            this.uow.validateObjectSpace();
        }

        public void setLogLevelAll() {
            this.uow.setLogLevel(0);
        }

        public void setLogLevelFINEST() {
            this.uow.setLogLevel(1);
        }

        public void setLogLevelFINER() {
            this.uow.setLogLevel(2);
        }

        public void setLogLevelFINE() {
            this.uow.setLogLevel(3);
        }

        public void setLogLevelCONFIG() {
            this.uow.setLogLevel(4);
        }

        public void setLogLevelINFO() {
            this.uow.setLogLevel(5);
        }

        public void setLogLevelWARNING() {
            this.uow.setLogLevel(6);
        }

        public void setLogLevelSEVERE() {
            this.uow.setLogLevel(7);
        }

        public void setLogLevelOFF() {
            this.uow.setLogLevel(8);
        }

        public ClassDescriptor getDescriptor(Class theClass) {
            return this.uow.getClassDescriptor(theClass);
        }

        public ClassDescriptor getDescriptor(Object domainObject) {
            return this.uow.getClassDescriptor(domainObject);
        }
    }

    public static enum OPERATION {
        READ,
        CREATE,
        UPDATE,
        DELETE;

    }
}

