/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.calendar;

import java.util.Calendar;
import java.util.List;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.impl.calendar.AbstractHolidayPattern;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.impl.calendar.ClosestWeekDayPattern;
import oracle.bpm.services.organization.impl.calendar.NthDayOfRefHolidayPattern;
import oracle.bpm.services.organization.impl.calendar.NthWeekDayOfMonthHolidayPattern;
import oracle.bpm.services.organization.impl.calendar.OnlyForCurrentYearHolidayPattern;
import oracle.bpm.services.organization.impl.calendar.SameDayEveryYearHolidayPattern;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayType;

public class HolidayMgr {
    AbstractHolidayPattern[] mHolidays = null;

    public HolidayMgr(HolidayRule holidayRules, CalendarMgr calMgr) {
        int i;
        if (holidayRules == null) {
            return;
        }
        List holidayList = holidayRules.getHolidays();
        if (holidayList != null && holidayList.size() > 0) {
            this.mHolidays = new AbstractHolidayPattern[holidayList.size()];
            for (i = 0; i < holidayList.size(); ++i) {
                HolidayType holiday = (HolidayType)holidayList.get(i);
                this.mHolidays[i] = this.createHolidayPattern(holiday, calMgr);
            }
        }
        if (this.mHolidays != null && this.mHolidays.length > 0) {
            for (i = 0; i < this.mHolidays.length; ++i) {
                this.mHolidays[i].setRefHoliday(this.mHolidays);
            }
        }
    }

    public boolean isHoliday(Calendar cal) {
        boolean isHoliday = false;
        if (this.mHolidays != null && this.mHolidays.length != 0) {
            for (int i = 0; i < this.mHolidays.length; ++i) {
                if (this.mHolidays[i] == null || !this.mHolidays[i].isHoliday(cal)) continue;
                isHoliday = true;
                break;
            }
        }
        return isHoliday;
    }

    protected void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"HolidayMgr", (String)method, (String)msg);
        }
    }

    private AbstractHolidayPattern createHolidayPattern(HolidayType holiday, CalendarMgr calMgr) {
        switch (holiday.getHolidayPattern()) {
            case SAME_DAY_EVERY_YEAR: {
                return new SameDayEveryYearHolidayPattern(holiday);
            }
            case ONLY_FOR_CURRENT_YEAR: {
                return new OnlyForCurrentYearHolidayPattern(holiday);
            }
            case NTH_WEEK_DAY_OF_MONTH: {
                return new NthWeekDayOfMonthHolidayPattern(holiday);
            }
            case NTH_DAY_OF_REF_HOLIDAY: {
                return new NthDayOfRefHolidayPattern(holiday);
            }
            case CLOSEST_WEEK_DAY: {
                return new ClosestWeekDayPattern(holiday, calMgr);
            }
        }
        return null;
    }
}

