/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.calendar;

import java.util.Calendar;
import oracle.bpm.services.organization.impl.calendar.AbstractHolidayPattern;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.model.HolidayType;

public class ClosestWeekDayPattern
extends AbstractHolidayPattern {
    Calendar mHoliday = null;
    CalendarMgr mCalMgr;

    public ClosestWeekDayPattern(HolidayType holiday, CalendarMgr calMgr) {
        super(holiday);
        this.mHoliday = holiday.getHolidayDate().toGregorianCalendar();
        this.mCalMgr = calMgr;
    }

    @Override
    public boolean isHoliday(Calendar cal) {
        Calendar cCalN = (Calendar)this.mHoliday.clone();
        cCalN.set(1, cal.get(1));
        int nextWorkingDay = 0;
        for (int i = 0; i < 365 && !this.mCalMgr.isWorkDay(cCalN); ++i) {
            ++nextWorkingDay;
            cCalN.add(5, 1);
        }
        Calendar cCalP = (Calendar)this.mHoliday.clone();
        cCalP.set(1, cal.get(1));
        int prevWorkingDay = 0;
        for (int i = 0; i < 365 && !this.mCalMgr.isWorkDay(cCalP); ++i) {
            ++prevWorkingDay;
            cCalP.add(5, -1);
        }
        Calendar closestHoliday = nextWorkingDay <= prevWorkingDay ? cCalN : cCalP;
        boolean isHoliday = false;
        if (cal.get(5) == closestHoliday.get(5) && cal.get(2) == closestHoliday.get(2)) {
            isHoliday = true;
        }
        this.debugLog("isHoliday", "day : " + cal.getTime() + " : ClosestWeekDayPattern : " + this.mHoliday.getTime() + ", ClosestWeekDayThisYear : " + closestHoliday.getTime() + ", isHoliday : " + isHoliday);
        return isHoliday;
    }

    private void debugLog(String method, String msg) {
        this.debugLog("ClosestWeekDayPattern", method, msg);
    }
}

