/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.calendar;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.calendar.CalendarUtil;
import oracle.bpm.services.organization.impl.calendar.HolidayMgr;
import oracle.bpm.services.organization.impl.calendar.WorkDayMgr;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;

public class CalendarMgr {
    CalendarRule mCal = null;
    TimeZone mCalTZ = null;
    HolidayMgr mHolidayMgr = null;
    WorkDayMgr mWdayMgr = null;

    public CalendarMgr(CalendarRule cal, HolidayRule holidays) throws BPMOrganizationException {
        this.mCal = cal;
        this.mHolidayMgr = new HolidayMgr(holidays, this);
        this.mWdayMgr = new WorkDayMgr(this.mCal);
        this.mCalTZ = TimeZone.getTimeZone(this.mCal.getTimeZone());
    }

    public long getCalendarDuration(Calendar pFromDate, Calendar pToDate) throws BPMOrganizationException {
        this.debugLog("getCalendarDuration", "IN");
        Calendar fromDate = Calendar.getInstance(this.mCalTZ);
        fromDate.setTimeInMillis(pFromDate.getTimeInMillis());
        Calendar toDate = Calendar.getInstance(this.mCalTZ);
        toDate.setTimeInMillis(pToDate.getTimeInMillis());
        boolean swap = false;
        if (fromDate.getTimeInMillis() > toDate.getTimeInMillis()) {
            swap = true;
            Calendar temp = fromDate;
            fromDate = toDate;
            toDate = temp;
        }
        long daysDiff = 0L;
        Calendar cal = (Calendar)fromDate.clone();
        while (!CalendarUtil.isSameDay(cal, toDate)) {
            if (this.isWorkDay(cal) && !this.isHoliday(cal)) {
                daysDiff += this.getWorkingDayDurationInMillis(cal);
            }
            cal.add(5, 1);
        }
        long elapsedFromTime = this.mWdayMgr.getElapsedWorkingDayDurationInMillis(cal);
        long elapsedToTime = this.mWdayMgr.getElapsedWorkingDayDurationInMillis(toDate);
        long timeDiff = elapsedToTime - elapsedFromTime;
        long duration = daysDiff + timeDiff;
        if (swap) {
            duration = -duration;
        }
        this.debugLog("getCalendarDuration", "FromDate : " + fromDate.getTime() + ", toDate : " + toDate.getTime() + ", duration : " + duration);
        this.debugLog("getCalendarDuration", "OUT");
        return duration;
    }

    public Calendar addCalendarDuration(Calendar pFromDate, Duration duration) {
        this.debugLog("addCalendarDuration", "IN : FromDate : " + pFromDate.getTime() + "Duration : " + duration);
        Calendar fromDate = Calendar.getInstance(this.mCalTZ);
        fromDate.setTimeInMillis(pFromDate.getTimeInMillis());
        Calendar cal = (Calendar)fromDate.clone();
        if (duration.getYears() != 0) {
            cal.add(1, duration.getYears());
        }
        if (duration.getMonths() != 0) {
            cal.add(2, duration.getMonths());
        }
        if (!this.isWorkDay(cal) || this.isHoliday(cal)) {
            this.skipNonWorkingDays(cal, 1);
            this.setTimeToWorkingDayStartTime(cal);
        }
        if (duration.getDays() != 0) {
            for (int dayDuration = duration.getDays(); dayDuration != 0; --dayDuration) {
                cal.add(5, 1);
                this.skipNonWorkingDays(cal, 1);
            }
        }
        long timeDuration = CalendarUtil.getTimeComponentInMillis(duration);
        this.debugLog("addCalendarDuration", "After Adding days : " + cal.getTime() + "Duration left : " + timeDuration);
        while (true) {
            long availableTime;
            if ((availableTime = this.getRestOfWorkingDayDurationInMillis(cal)) > timeDuration) break;
            timeDuration -= availableTime;
            cal.add(5, 1);
            this.skipNonWorkingDays(cal, 1);
            this.setTimeToWorkingDayStartTime(cal);
        }
        this.mWdayMgr.addWorkingDayTime(cal, timeDuration);
        this.debugLog("addCalendarDuration", "OUT : Added Calendar : " + cal.getTime());
        return cal;
    }

    public Calendar subtractCalendarDuration(Calendar pFromDate, Duration duration) {
        this.debugLog("subtractCalendarDuration", "IN : FromDate : " + pFromDate.getTime() + "Duration : " + duration);
        Calendar fromDate = Calendar.getInstance(this.mCalTZ);
        fromDate.setTimeInMillis(pFromDate.getTimeInMillis());
        Calendar cal = (Calendar)fromDate.clone();
        if (duration.getYears() != 0) {
            cal.add(1, -duration.getYears());
        }
        if (duration.getMonths() != 0) {
            cal.add(2, -duration.getMonths());
        }
        if (!this.isWorkDay(cal) || this.isHoliday(cal)) {
            this.skipNonWorkingDays(cal, -1);
            this.setTimeToWorkingDayEndTime(cal);
        }
        if (duration.getDays() != 0) {
            for (int dayDuration = duration.getDays(); dayDuration != 0; --dayDuration) {
                cal.add(5, -1);
                this.skipNonWorkingDays(cal, -1);
            }
        }
        long timeDuration = CalendarUtil.getTimeComponentInMillis(duration);
        this.debugLog("subtractCalendarDuration", "After considering days : " + cal.getTime() + "Duration left : " + timeDuration);
        while (true) {
            long availableTime;
            if ((availableTime = this.getElapsedWorkingDayDurationInMillis(cal)) > timeDuration) break;
            timeDuration -= availableTime;
            cal.add(5, -1);
            this.skipNonWorkingDays(cal, -1);
            this.setTimeToWorkingDayEndTime(cal);
        }
        this.mWdayMgr.subtractWorkingDayTime(cal, timeDuration);
        this.debugLog("subtractCalendarDuration", "OUT : Subtracted Calendar : " + cal.getTime());
        return cal;
    }

    public long getNextReminderDurationFromAssignedDate(Calendar now, Calendar assignedDate, Duration duration, int recurrence) {
        long nowInMillis = now.getTime().getTime();
        int index = 1;
        Calendar next = this.addCalendarDuration(assignedDate, duration);
        while (nowInMillis > next.getTimeInMillis()) {
            next = this.addCalendarDuration(next, duration);
            if (recurrence == -1 || ++index <= recurrence) continue;
        }
        if ((index <= recurrence || recurrence == -1) && next.getTimeInMillis() - nowInMillis >= 0L) {
            return next.getTimeInMillis() - nowInMillis;
        }
        return 0L;
    }

    public long getNextReminderDurationFromRelativeDate(Calendar now, Calendar relativeDate, Duration duration, int recurrence) {
        long nowInMillis = now.getTime().getTime();
        int index = 0;
        Calendar next = this.subtractCalendarDuration(relativeDate, duration);
        Calendar prev = null;
        while (nowInMillis <= next.getTimeInMillis()) {
            prev = next;
            next = this.subtractCalendarDuration(next, duration);
            if (recurrence == -1 || ++index < recurrence) continue;
        }
        next = prev;
        if (prev != null && (index <= recurrence || recurrence == -1) && next.getTimeInMillis() - nowInMillis >= 0L) {
            return next.getTimeInMillis() - nowInMillis;
        }
        return 0L;
    }

    public boolean isWorkDay(Calendar cal) {
        return this.mWdayMgr.isWorkDay(cal);
    }

    public long getWorkingDayDurationInMillis(Calendar cal) {
        return this.mWdayMgr.getWorkingDayDurationInMillis(cal);
    }

    public long getRestOfWorkingDayDurationInMillis(Calendar cal) {
        return this.mWdayMgr.getRestOfWorkingDayDurationInMillis(cal);
    }

    public long getElapsedWorkingDayDurationInMillis(Calendar cal) {
        return this.mWdayMgr.getElapsedWorkingDayDurationInMillis(cal);
    }

    public void setTimeToWorkingDayStartTime(Calendar cal) {
        this.mWdayMgr.setTimeToWorkingDayStartTime(cal);
    }

    public void setTimeToWorkingDayEndTime(Calendar cal) {
        this.mWdayMgr.setTimeToWorkingDayEndTime(cal);
    }

    public boolean isHoliday(Calendar cal) {
        return this.mHolidayMgr.isHoliday(cal);
    }

    protected void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"CalendarMgr", (String)method, (String)msg);
        }
    }

    private void skipNonWorkingDays(Calendar cal, int skipNDays) {
        while (!this.isWorkDay(cal) || this.isHoliday(cal)) {
            cal.add(5, skipNDays);
            this.debugLog("skipNonWorkingDays", "Holiday : " + cal.getTime());
        }
        this.debugLog("skipNonWorkingDays", "Working Day : " + cal.getTime());
    }
}

