/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.Jaxb20ContextFactory;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.PeopleQueryService;
import oracle.bpm.services.organization.model.ArgumentType;
import oracle.bpm.services.organization.model.AttributeType;
import oracle.bpm.services.organization.model.ConditionType;
import oracle.bpm.services.organization.model.GranteesType;
import oracle.bpm.services.organization.model.GroupManagersType;
import oracle.bpm.services.organization.model.GroupOwnersType;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PeopleQueryContextType;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.Predicate;
import oracle.bpm.services.organization.model.PredicateType;
import oracle.bpm.services.organization.model.PrincipleListType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.ReporteesType;
import oracle.bpm.services.organization.model.SearchFilterType;
import oracle.bpm.services.organization.model.SearchUserType;
import oracle.bpm.services.organization.model.StatusTypeEnum;
import oracle.bpm.services.organization.model.UserManagementChainType;
import oracle.bpm.services.organization.model.UserManagerType;
import oracle.bpm.services.organization.model.UsersWithPropertiesType;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMLogicalPeopleGroupPersistency;
import oracle.integration.platform.blocks.FabricConfigManager;
import oracle.soa.management.config.ConfigDefs;
import oracle.soa.management.config.bpmn.BPMNConfig;
import org.quartz.CronTrigger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PeopleQueryUtil {
    private static final String CLASSNAME = "PeopleQueryUtil";
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static JAXBContext jaxbContext;
    private static Unmarshaller unMarshaller;
    private static Marshaller marshaller;
    protected static final String CRON_EXPR = "0 0/10 * * * ?";

    public static PeopleQuery getPeopleQuery(String fileName, Logger logger) throws BPMOrganizationException {
        String METHOD = "getPeopleQuery";
        PeopleQueryUtil.debugLog("getPeopleQuery", "Begin");
        InputStream is = null;
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            is = classLoader.getResourceAsStream(fileName);
            if (is == null) {
                if (logger != null) {
                    logger.log(Level.FINE, "WorkflowServiceClientContext: Cannot find client configuration file: " + fileName);
                }
                PeopleQuery peopleQuery = null;
                return peopleQuery;
            }
            JAXBElement peopleQueryElement = (JAXBElement)unMarshaller.unmarshal(is);
            PeopleQuery peopleQuery = (PeopleQuery)peopleQueryElement.getValue();
            return peopleQuery;
        }
        catch (JAXBException e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getPeopleQuery");
            exCtx.setErrorCode(70912);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
            PeopleQueryUtil.debugLog("getPeopleQuery", "End");
        }
    }

    public static PeopleQuery getPeopleQuery(Node node) throws BPMOrganizationException {
        try {
            PeopleQuery peopleQuery = (PeopleQuery)unMarshaller.unmarshal(node);
            return peopleQuery;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    public static String getPeopleQueryAsString(PeopleQuery peopleQuery) throws BPMOrganizationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            marshaller.marshal((Object)peopleQuery, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    public static PeopleQuery getPeopleQueryFromXMLString(String peopleQueryXML) throws BPMOrganizationException {
        String METHOD = "getPeopleQueryFromXMLString";
        try {
            if (peopleQueryXML == null) {
                return null;
            }
            Document doc = XMLUtil.parseDocumentFromXMLString((String)peopleQueryXML);
            Element node = doc.getDocumentElement();
            PeopleQuery peopleQuery = (PeopleQuery)unMarshaller.unmarshal((Node)node);
            return peopleQuery;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (JAXBException e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getPeopleQueryFromXMLString");
            exCtx.setErrorCode(70912);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static PeopleQuery getPeopleQueryFromString(String queryString) throws BPMOrganizationException {
        String METHOD = "getPeopleQueryFromString";
        try {
            if (queryString == null) {
                return null;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(queryString.getBytes());
            PeopleQuery peopleQuery = (PeopleQuery)unMarshaller.unmarshal((InputStream)stream);
            return peopleQuery;
        }
        catch (JAXBException e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getPeopleQueryFromString");
            exCtx.setErrorCode(70912);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    public static LogicalPeopleGroup execute(IBPMContext ctx, LogicalPeopleGroup lpg) throws BPMOrganizationException {
        if (lpg == null) {
            throw new IllegalArgumentException();
        }
        PeopleQuery peopleQuery = new PeopleQuery(lpg.getPeopleQuery());
        PrincipleListType plt = objectFactory.createPrincipleListType();
        List<Participant> list = PeopleQueryUtil.execute(ctx, peopleQuery, null);
        List prt = plt.getParticipant();
        for (Participant participant : list) {
            prt.add(participant.getValue());
        }
        lpg.setMembers(plt);
        return lpg;
    }

    public static List<Participant> execute(IBPMContext ctx, String peopleQueryXML, Map<String, String> ctxMap) throws BPMOrganizationException {
        try {
            PeopleQuery peopleQuery = PeopleQueryUtil.getPeopleQueryFromXMLString(peopleQueryXML);
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            List<Participant> participantsList = PeopleQueryUtil.execute(ctx, peopleQuery, peopleQueryCtx);
            return participantsList;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static List<Participant> execute(IBPMContext ctx, PeopleQuery pq, PeopleQueryContext pqCtx) throws BPMOrganizationException {
        String METHOD = "execute";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            PeopleQueryUtil.debugLog("execute", "Begin");
        }
        try {
            Predicate predicate;
            PredicateType predicateType;
            UsersWithPropertiesType userWithProp;
            Participant participant;
            PeopleQueryUtil.debugLog("execute", "People Query original request: \n" + PeopleQueryUtil.getPeopleQueryAsString(pq));
            PeopleQuery peopleQuery = PeopleQueryUtil.resolveRuntimeContext(pq, pqCtx);
            PeopleQueryUtil.debugLog("execute", "People Query argument bind request: \n" + PeopleQueryUtil.getPeopleQueryAsString(peopleQuery));
            PeopleQueryService pqs = new PeopleQueryService();
            List<Participant> list = new ArrayList();
            SearchUserType sut = ((PeopleQueryType)peopleQuery.getValue()).getSearchUsers();
            GranteesType gt = ((PeopleQueryType)peopleQuery.getValue()).getGrantees();
            GroupManagersType gmt = ((PeopleQueryType)peopleQuery.getValue()).getGroupManagers();
            GroupOwnersType got = ((PeopleQueryType)peopleQuery.getValue()).getGroupOwners();
            ReporteesType rt = ((PeopleQueryType)peopleQuery.getValue()).getReportees();
            UserManagerType umt = ((PeopleQueryType)peopleQuery.getValue()).getUserManager();
            UserManagementChainType umct = ((PeopleQueryType)peopleQuery.getValue()).getUserManagementChain();
            if (sut != null) {
                list = pqs.searchUsers(sut);
            } else if (gt != null) {
                list = pqs.getGrantees(gt);
            } else if (umct != null) {
                list = pqs.getManagementChain(umct);
            } else if (gmt != null) {
                list = pqs.getGroupManagers(gmt);
            } else if (got != null) {
                list = pqs.getGroupOwners(got);
            } else if (rt != null) {
                list = pqs.getReportees(rt);
            } else if (umt != null && (participant = pqs.getUserManager(umt)) != null) {
                list.add(participant);
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryUtil.debugLog("execute", "People Query result size from Identity Provider :" + list.size());
                String msg = null;
                for (Participant p : list) {
                    if (msg == null) {
                        msg = ((PrincipleRefType)p.getValue()).getName();
                        continue;
                    }
                    msg = msg + ", " + ((PrincipleRefType)p.getValue()).getName();
                }
                PeopleQueryUtil.debugLog("execute", "List of participants from Identity Provider:" + msg);
            }
            if ((userWithProp = ((PeopleQueryType)peopleQuery.getValue()).getUsersWithProperties()) != null) {
                predicateType = userWithProp.getPredicate();
                if (predicateType != null) {
                    Object msg1;
                    predicate = new Predicate(predicateType);
                    list = PeopleQueryUtil.getParticipantsWithProperties(ctx, list, predicate);
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                        msg1 = "\nFinal People Query result size :" + list.size();
                        String msg2 = null;
                        for (Participant p : list) {
                            if (msg2 == null) {
                                msg2 = ((PrincipleRefType)p.getValue()).getName();
                                continue;
                            }
                            msg2 = msg2 + ", " + ((PrincipleRefType)p.getValue()).getName();
                        }
                        PeopleQueryUtil.debugLog("execute", (String)msg1 + "\n\t Participants:" + msg2);
                    }
                    msg1 = list;
                    return msg1;
                }
            } else if (((PeopleQueryType)peopleQuery.getValue()).getPredicate() != null) {
                predicateType = ((PeopleQueryType)peopleQuery.getValue()).getPredicate();
                predicate = new Predicate(predicateType);
                list = PeopleQueryUtil.getParticipantsWithProperties(ctx, list, predicate);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    String msg1 = "\nFinal People Query result size :" + list.size();
                    String msg2 = null;
                    for (Participant p : list) {
                        if (msg2 == null) {
                            msg2 = ((PrincipleRefType)p.getValue()).getName();
                            continue;
                        }
                        msg2 = msg2 + ", " + ((PrincipleRefType)p.getValue()).getName();
                    }
                    PeopleQueryUtil.debugLog("execute", msg1 + "\n\t Participants:" + msg2);
                }
                List<Participant> list2 = list;
                return list2;
            }
            List<Participant> list3 = list;
            return list3;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "execute");
            exCtx.setErrorCode(70907);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryUtil.debugLog("execute", "End");
            }
        }
    }

    public static PeopleQueryContext getPeopleQueryContextFromElem(Element elem) throws BPMOrganizationException {
        try {
            PeopleQueryContext peopleQueryCtx = (PeopleQueryContext)PeopleQueryUtil.unmarshallFromElement(elem, "peopleQueryContext", "http://xmlns.oracle.com/bpm/lpg/peopleQuery");
            return peopleQueryCtx;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static PeopleQuery getPeopleQueryFromElem(Element elem) throws BPMOrganizationException {
        try {
            PeopleQuery peopleQuery = (PeopleQuery)PeopleQueryUtil.unmarshallFromElement(elem, "peopleQuery", "http://xmlns.oracle.com/bpm/lpg/peopleQuery");
            return peopleQuery;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static Object unmarshallFromElement(Element parentElem, String elementName, String namespace) throws BPMOrganizationException {
        Object jaxbObj = null;
        try {
            Element elem = XMLUtil.getFirstChildElement((Element)parentElem, (String)namespace, (String)elementName);
            jaxbObj = unMarshaller.unmarshal((Node)elem);
        }
        catch (Exception e) {
            Object[] objs = new Object[]{namespace + ":" + elementName, PeopleQueryUtil.getJaxbContextString(), e.getMessage()};
            BPMOrganizationException wfe = new BPMOrganizationException(70920, objs, e);
            throw wfe;
        }
        return jaxbObj;
    }

    public static Document getNewDocument() throws Exception {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        return doc;
    }

    public static PeopleQueryContext getPeopleQueryContext(Map<String, String> map) {
        PeopleQueryContextType peopleQueryCtxType = objectFactory.createPeopleQueryContextType();
        List list = peopleQueryCtxType.getArgument();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            ArgumentType arg = objectFactory.createArgumentType();
            arg.setName(name);
            arg.setValue(value);
            list.add(arg);
        }
        return new PeopleQueryContext(peopleQueryCtxType);
    }

    public static PeopleQuery resolveRuntimeContext(PeopleQuery peopleQuery, PeopleQueryContext peopleQueryCtx) throws BPMOrganizationException {
        if (peopleQuery == null || peopleQueryCtx == null) {
            return peopleQuery;
        }
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        List list = ((PeopleQueryContextType)peopleQueryCtx.getValue()).getArgument();
        for (ArgumentType arg : list) {
            ctxMap.put(arg.getName(), arg.getValue());
        }
        PeopleQueryType nPeopleQueryType = objectFactory.createPeopleQueryType();
        nPeopleQueryType.setTimeout(((PeopleQueryType)peopleQuery.getValue()).getTimeout());
        SearchUserType sut = ((PeopleQueryType)peopleQuery.getValue()).getSearchUsers();
        GranteesType gt = ((PeopleQueryType)peopleQuery.getValue()).getGrantees();
        GroupManagersType gmt = ((PeopleQueryType)peopleQuery.getValue()).getGroupManagers();
        GroupOwnersType got = ((PeopleQueryType)peopleQuery.getValue()).getGroupOwners();
        ReporteesType rt = ((PeopleQueryType)peopleQuery.getValue()).getReportees();
        UserManagerType umt = ((PeopleQueryType)peopleQuery.getValue()).getUserManager();
        UsersWithPropertiesType userWithProp = ((PeopleQueryType)peopleQuery.getValue()).getUsersWithProperties();
        UserManagementChainType umct = ((PeopleQueryType)peopleQuery.getValue()).getUserManagementChain();
        if (sut != null) {
            AttributeType at = sut.getAttribute();
            SearchFilterType sft = sut.getFilter();
            SearchUserType nsut = objectFactory.createSearchUserType();
            nsut.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, sut.getIdentityContext()));
            if (at != null) {
                AttributeType nat = objectFactory.createAttributeType();
                String name = PeopleQueryUtil.getValue(ctxMap, at.getName());
                nat.setName(name);
                String value = PeopleQueryUtil.getValue(ctxMap, at.getValue());
                nat.setValue(value);
                nsut.setAttribute(nat);
            } else if (sft != null) {
                SearchFilterType nsft = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
                nsut.setFilter(nsft);
            }
            nPeopleQueryType.setSearchUsers(nsut);
        } else if (gt != null) {
            GranteesType ngt = objectFactory.createGranteesType();
            ngt.setGroup(PeopleQueryUtil.getValue(ctxMap, gt.getGroup()));
            SearchFilterType sft = gt.getFilter();
            SearchFilterType nsft = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
            ngt.setFilter(nsft);
            ngt.setRole(PeopleQueryUtil.getValue(ctxMap, gt.getRole()));
            ngt.setApplication(PeopleQueryUtil.getValue(ctxMap, gt.getApplication()));
            boolean direct = gt.isDirect();
            ngt.setDirect(direct);
            nPeopleQueryType.setGrantees(ngt);
        } else if (umct != null) {
            UserManagementChainType numtc = objectFactory.createUserManagementChainType();
            numtc.setUser(PeopleQueryUtil.getValue(ctxMap, umct.getUser()));
            numtc.setTitle(PeopleQueryUtil.getValue(ctxMap, umct.getTitle()));
            numtc.setUptoUser(PeopleQueryUtil.getValue(ctxMap, umct.getUptoUser()));
            numtc.setLevel(umct.getLevel());
            numtc.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, umct.getIdentityContext()));
            nPeopleQueryType.setUserManagementChain(numtc);
        } else if (gmt != null) {
            GroupManagersType ngmt = objectFactory.createGroupManagersType();
            ngmt.setGroup(PeopleQueryUtil.getValue(ctxMap, gmt.getGroup()));
            ngmt.setDirect(gmt.isDirect());
            SearchFilterType sft = gmt.getFilter();
            SearchFilterType nsft = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
            ngmt.setFilter(nsft);
            ngmt.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, gmt.getIdentityContext()));
            nPeopleQueryType.setGroupManagers(ngmt);
        } else if (((PeopleQueryType)peopleQuery.getValue()).getGroupOwners() != null) {
            GroupOwnersType ngot = objectFactory.createGroupOwnersType();
            ngot.setGroup(PeopleQueryUtil.getValue(ctxMap, got.getGroup()));
            ngot.setDirect(got.isDirect());
            SearchFilterType sft = got.getFilter();
            SearchFilterType nsft = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
            ngot.setFilter(nsft);
            ngot.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, got.getIdentityContext()));
            nPeopleQueryType.setGroupOwners(ngot);
        } else if (rt != null) {
            ReporteesType nrt = objectFactory.createReporteesType();
            nrt.setUser(PeopleQueryUtil.getValue(ctxMap, rt.getUser()));
            nrt.setLevel(rt.getLevel());
            nrt.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, rt.getIdentityContext()));
            nPeopleQueryType.setReportees(nrt);
        } else if (umt != null) {
            UserManagerType numt = objectFactory.createUserManagerType();
            numt.setUser(PeopleQueryUtil.getValue(ctxMap, umt.getUser()));
            numt.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, umt.getIdentityContext()));
            nPeopleQueryType.setUserManager(numt);
        } else if (userWithProp != null) {
            UsersWithPropertiesType nUserWithProp = objectFactory.createUsersWithPropertiesType();
            PredicateType predicateType = userWithProp.getPredicate();
            nUserWithProp.setPredicate(predicateType);
            nPeopleQueryType.setUsersWithProperties(nUserWithProp);
        }
        if (((PeopleQueryType)peopleQuery.getValue()).getPredicate() != null) {
            PredicateType predicateType = ((PeopleQueryType)peopleQuery.getValue()).getPredicate();
            nPeopleQueryType.setPredicate(predicateType);
        }
        return new PeopleQuery(nPeopleQueryType);
    }

    public static String getJaxbContextString() {
        return "oracle.bpel.services.bpm.lpg.model";
    }

    public static void debugLog(String method, String message) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)method, (String)message);
        }
    }

    public static void print(String message, Object object) {
        BPMLogicalPeopleGroupPersistency.print(message, object);
    }

    public static String getTimeout(LogicalPeopleGroup lpg) {
        String timeout = lpg.getTimeout();
        if (timeout == null) {
            timeout = lpg.getPeopleQuery().getTimeout();
        }
        if (timeout == null) {
            timeout = PeopleQueryUtil.getDefaultPeopleQueryTimeout();
        }
        if (timeout == null) {
            timeout = CRON_EXPR;
        }
        return timeout;
    }

    public static String getDefaultPeopleQueryTimeout() {
        try {
            BPMNConfig bpmnConfigObj = (BPMNConfig)FabricConfigManager.loadConfigObject((String)ConfigDefs.URL_BPMN_CONFIG);
            String peopleQueryTimeout = bpmnConfigObj.getPeopleQueryTimeout();
            if (peopleQueryTimeout == null || peopleQueryTimeout != null && peopleQueryTimeout.isEmpty()) {
                return CRON_EXPR;
            }
            return peopleQueryTimeout;
        }
        catch (Exception exception) {
            return CRON_EXPR;
        }
    }

    private static String getValue(Map<String, String> contextMap, String argName) {
        if (argName == null) {
            return null;
        }
        String value = argName;
        if (argName != null && argName.startsWith("$")) {
            value = contextMap.get(argName);
        }
        return value;
    }

    private static SearchFilterType createSearchFilterType(Map<String, String> ctxMap, SearchFilterType sft) {
        ConditionType ct;
        if (sft == null) {
            return null;
        }
        SearchFilterType nsft = objectFactory.createSearchFilterType();
        if (sft.getLhs() != null) {
            SearchFilterType nlht = PeopleQueryUtil.createSearchFilterType(ctxMap, sft.getLhs());
            nsft.setLhs(nlht);
        }
        nsft.setLogicalOperator(sft.getLogicalOperator());
        if (sft.getRhs() != null) {
            SearchFilterType nrht = PeopleQueryUtil.createSearchFilterType(ctxMap, sft.getRhs());
            nsft.setRhs(nrht);
        }
        if ((ct = sft.getCondition()) != null) {
            ConditionType nct = objectFactory.createConditionType();
            nct.setAttribute(PeopleQueryUtil.getValue(ctxMap, ct.getAttribute()));
            nct.setOperator(ct.getOperator());
            nct.setValue(PeopleQueryUtil.getValue(ctxMap, ct.getValue()));
            nsft.setCondition(nct);
        }
        return nsft;
    }

    private static List<Participant> getParticipantsWithProperties(IBPMContext ctx, List<Participant> participants, Predicate predicate) throws BPMOrganizationException {
        String METHOD = "getParticipantsWithProperties";
        PeopleQueryUtil.debugLog("getParticipantsWithProperties", "Begin");
        try {
            if (predicate == null) {
                List<Participant> list = participants;
                return list;
            }
            HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "LOCAL");
            BPMOrganizationService service = new BPMOrganizationService();
            List<Participant> list = service.searchParticipantsWithProperties(ctx, participants, predicate, 1, Integer.MAX_VALUE);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryUtil.debugLog("getParticipantsWithProperties", "Participants with properties, list size=" + list.size());
            }
            List<Participant> list2 = list;
            return list2;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getParticipantsWithProperties");
            exCtx.setErrorCode(70907);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            PeopleQueryUtil.debugLog("getParticipantsWithProperties", "End");
        }
    }

    public static void setCreateUpdateInfo(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isCreated, boolean isExecuted) throws BPMOrganizationException {
        String METHOD = "setCreateUpdateInfo";
        XMLGregorianCalendar calendar = AbstractPersistencyDriver.getXMLGregorianCalendar(Calendar.getInstance());
        if (isCreated) {
            lpg.setCreatedBy(ctx.getUser());
            lpg.setCreatedDate(calendar);
            lpg.setCreatedByIdentityContext(ctx.getIdentityContext());
        }
        lpg.setLastUpdatedBy(ctx.getUser());
        lpg.setLastUpdatedDate(calendar);
        lpg.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        if (isExecuted) {
            lpg.setLastExecutedDate(calendar);
        }
        if (StatusTypeEnum.ENABLED.equals((Object)lpg.getStatus())) {
            XMLGregorianCalendar gregExpCal = PeopleQueryUtil.getExpirationTime(lpg);
            if (gregExpCal != null) {
                lpg.setExpirationTime(gregExpCal);
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASSNAME, "setCreateUpdateInfo", "Cron Trigger Name=" + lpg.getName() + " trigger group=" + "PeopleQueryGroup" + " Timeout expression: " + PeopleQueryUtil.getTimeout(lpg) + " Next fire time: " + gregExpCal);
            }
        }
    }

    public static XMLGregorianCalendar getExpirationTime(LogicalPeopleGroup lpg) throws BPMOrganizationException {
        String METHOD = "getExpirationTime";
        try {
            String timeout = PeopleQueryUtil.getTimeout(lpg);
            CronTrigger ct = new CronTrigger(lpg.getId(), "PeopleQueryGroup", timeout);
            Calendar expCal = Calendar.getInstance();
            Date date = ct.getFireTimeAfter(expCal.getTime());
            XMLGregorianCalendar gregExpCal = null;
            if (date != null) {
                expCal.setTime(date);
                gregExpCal = AbstractPersistencyDriver.getXMLGregorianCalendar(expCal);
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASSNAME, "getExpirationTime", "Cron Trigger Name=" + lpg.getName() + " trigger group=" + "PeopleQueryGroup" + " Cron timeout expression: " + timeout + " Next fire time: " + date);
            }
            return gregExpCal;
        }
        catch (ParseException e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getExpirationTime");
            exCtx.setErrorCode(70918);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    static {
        try {
            jaxbContext = Jaxb20ContextFactory.getJAXBContext((String)"oracle.bpm.services.organization.model");
            unMarshaller = jaxbContext.createUnmarshaller();
            marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

