/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;

public class PeopleQueryPublisher {
    private TopicConnection m_connection = null;
    private TopicConnectionFactory m_connectionFactory;
    private Context m_jndiContext = null;
    private TopicPublisher m_publisher = null;
    private Topic m_topic;
    private TopicSession m_topicSession = null;
    private static final String CLASSNAME = "PeopleQueryPublisher";
    private static PeopleQueryPublisher s_peopleQueryPublisher = PeopleQueryPublisher.getInstance();
    public static String PROVIDER_URL = "t3://localhost:7001";
    public static final String INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final String CONNECTION_FACTORY_NAME = "jms/bpm/PeopleQueryTopicConnectionFactory";
    private static final String TOPIC_NAME = "jms/bpm/PeopleQueryTopic";

    private PeopleQueryPublisher() {
        this.initializeJMSResources();
    }

    public static PeopleQueryPublisher getInstance() {
        if (s_peopleQueryPublisher == null) {
            s_peopleQueryPublisher = new PeopleQueryPublisher();
        }
        return s_peopleQueryPublisher;
    }

    public void publishPeopleQueryMessage(String lpgId) throws BPMOrganizationException {
        String METHOD = "publishPeopleQueryMessage";
        try {
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "publishPeopleQueryMessage", "Publising People Query Message begin");
            if (lpgId == null) {
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "publishPeopleQueryMessage");
                exCtx.setErrorCode(70904);
                exCtx.setSeverity(Severity.ERRORS);
                throw new BPMOrganizationException(exCtx);
            }
            if (this.m_topicSession == null) {
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "publishPeopleQueryMessage");
                exCtx.setErrorCode(70917);
                exCtx.setSeverity(Severity.ERRORS);
                throw new BPMOrganizationException(exCtx);
            }
            ObjectMessage msg = this.m_topicSession.createObjectMessage((Serializable)((Object)lpgId));
            msg.setStringProperty("lpgId", lpgId);
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "publishPeopleQueryMessage", "Publishing  People Query Message lpgId=" + lpgId);
            this.m_publisher.publish((Message)msg);
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "publishPeopleQueryMessage", "People Query Message is published for lpgId=" + lpgId);
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "publishPeopleQueryMessage");
            exCtx.setErrorCode(70915);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgId});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "publishPeopleQueryMessage", "Publising Object Message end");
        }
    }

    private static void logDebugMessage(String className, String method, String message) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)className, (String)method, (String)message);
        }
    }

    private static void logErrorMessage(String className, String method, String message) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)className, (String)method, (String)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeJMSResources() {
        String METHOD = "initializeJMSResources";
        try {
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "begin");
            this.m_connectionFactory = this.getTopicConnectionFactory(CONNECTION_FACTORY_NAME);
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Getting JMS Topic ");
            this.m_topic = this.getTopic(TOPIC_NAME);
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Getting Topic Connection ");
            this.m_connection = this.m_connectionFactory.createTopicConnection();
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Getting Topic Session");
            this.m_topicSession = this.m_connection.createTopicSession(false, 1);
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Getting Publisher");
            this.m_publisher = this.m_topicSession.createPublisher(this.m_topic);
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Initialization has been done properly");
        }
        catch (Exception e) {
            PeopleQueryPublisher.logErrorMessage(CLASSNAME, "initializeJMSResources", "Error publishing PeopleQuery to Topic: jms/bpm/PeopleQueryTopic");
            if (this.m_publisher != null) {
                try {
                    this.m_publisher.close();
                    PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Close Topic Publisher");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (this.m_topicSession != null) {
                try {
                    this.m_topicSession.close();
                    PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Close Session");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                    PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "Close Connection");
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            PeopleQueryPublisher.logDebugMessage(CLASSNAME, "initializeJMSResources", "End");
        }
    }

    private TopicConnectionFactory getTopicConnectionFactory(String connectionFactoryName) throws BPMOrganizationException {
        String METHOD = "getTopicConnectionFactory";
        try {
            return (TopicConnectionFactory)this.jndiLookup(connectionFactoryName);
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getTopicConnectionFactory");
            exCtx.setErrorCode(70913);
            exCtx.setMessageArguments(new Object[]{connectionFactoryName});
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    private Topic getTopic(String topicName) throws BPMOrganizationException {
        String METHOD = "getTopic";
        try {
            return (Topic)this.jndiLookup(topicName);
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getTopic");
            exCtx.setErrorCode(70914);
            exCtx.setMessageArguments(new Object[]{topicName});
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    private Object jndiLookup(String name) throws BPMOrganizationException {
        String METHOD = "jndiLookup";
        try {
            this.m_jndiContext = new InitialContext();
            if (this.m_jndiContext == null) {
                PeopleQueryPublisher.logDebugMessage(CLASSNAME, "jndiLookup", "InitionContext is null");
                Hashtable<String, String> ht = new Hashtable<String, String>();
                ht.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
                ht.put("java.naming.provider.url", PROVIDER_URL);
                this.m_jndiContext = new InitialContext(ht);
            }
            Object obj = this.m_jndiContext.lookup(name);
            return obj;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "jndiLookup");
            exCtx.setErrorCode(70916);
            exCtx.setMessageArguments(new Object[]{name});
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }
}

