/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.common.util.CommonUtil;
import oracle.bpel.services.workflow.query.impl.QueryUtil;
import oracle.bpel.services.workflow.query.model.ColumnType;
import oracle.bpel.services.workflow.query.model.PredicateTypeImpl;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.ClauseType;
import oracle.bpm.services.organization.model.IdentityTypeValueListType;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.PeopleQueryMemberType;
import oracle.bpm.services.organization.model.PredicateJoinOperatorEnum;
import oracle.bpm.services.organization.model.PredicateOperationEnum;
import oracle.bpm.services.organization.model.PredicateType;
import oracle.bpm.services.organization.model.ValueListType;
import oracle.bpm.services.organization.persistency.model.BpmAppRoleOuCalAssoc;
import oracle.bpm.services.organization.persistency.model.BpmOrganizationalUnit;
import oracle.bpm.services.organization.persistency.model.BpmOuManager;
import oracle.bpm.services.organization.persistency.model.BpmOuUser;

public class BPMOrganizationUtil {
    private static final String IMPORT_ORGANIZATION_STR = "IMPORT_ORGANIZATION : ";

    public static void debugLog(String className, String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)className, (String)method, (String)msg);
        }
    }

    public static void infoLog(String className, String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)className, (String)method, (String)msg);
        }
    }

    public static void errorLog(String className, String method, String message, Exception e) {
        if (e instanceof BPMException) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)className, (String)method, (String)message);
        } else {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)className, (String)method, (String)message);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
        }
    }

    public static void infoLogImportData(String className, int level, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION)) {
            String message = "";
            for (int i = 0; i < level; ++i) {
                message = message + "\t";
            }
            message = IMPORT_ORGANIZATION_STR + message + msg;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)className, (String)"infoLogImportData", (String)message);
        }
    }

    public static String getJaxbObjectXMLAsString(Object jaxbObject) {
        if (jaxbObject == null) {
            return null;
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"oracle.bpm.services.organization.model");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter jaxbStringWriter = new StringWriter();
            marshaller.marshal(jaxbObject, (Writer)jaxbStringWriter);
            return jaxbStringWriter.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static oracle.bpel.services.workflow.query.model.PredicateType convertJAXB2PredicateIntoJAXB1Predicate(PredicateType jaxb20Predicate) throws Exception {
        if (jaxb20Predicate == null) {
            return new PredicateTypeImpl();
        }
        oracle.bpel.services.workflow.query.model.PredicateType resultPredicate = QueryUtil.getQueryObjectFactory().createPredicateType();
        PredicateType lhs = jaxb20Predicate.getLhs();
        PredicateType rhs = jaxb20Predicate.getRhs();
        PredicateJoinOperatorEnum logicalOperator = jaxb20Predicate.getLogicalOperator();
        List clauses = jaxb20Predicate.getClause();
        boolean foundLhs = false;
        if (lhs != null) {
            oracle.bpel.services.workflow.query.model.PredicateType jaxb10PredicateLhs = BPMOrganizationUtil.convertJAXB2PredicateIntoJAXB1Predicate(lhs);
            resultPredicate.setLhs(jaxb10PredicateLhs);
            foundLhs = true;
        }
        if (foundLhs && rhs != null) {
            oracle.bpel.services.workflow.query.model.PredicateType jaxb10PredicateRhs = BPMOrganizationUtil.convertJAXB2PredicateIntoJAXB1Predicate(rhs);
            resultPredicate.setRhs(jaxb10PredicateRhs);
            resultPredicate.setLogicalOperator(logicalOperator.name());
        } else if (foundLhs && rhs == null) {
            throw new Exception("Found LHS without RHS. Invalid Predicate");
        }
        if (clauses != null && clauses.size() > 0) {
            for (ClauseType clause : clauses) {
                oracle.bpm.services.organization.model.ColumnType column = clause.getColumn();
                PredicateOperationEnum operator = clause.getOperator();
                String value = clause.getValue();
                XMLGregorianCalendar dateValue = clause.getDateValue();
                ValueListType valueList = clause.getValueList();
                oracle.bpm.services.organization.model.ColumnType columnValue = clause.getColumnValue();
                oracle.bpm.services.organization.common.IdentityType identityTypeValue = clause.getIdentityTypeValue();
                IdentityTypeValueListType identityTypeValueListType = clause.getIdentityTypeValueList();
                PredicateJoinOperatorEnum joinOperator = clause.getJoinOperator();
                boolean ignoreCase = false;
                if (clause.isSetIgnoreCase()) {
                    ignoreCase = clause.isIgnoreCase();
                }
                oracle.bpel.services.workflow.query.model.ClauseType jaxb1Clause = QueryUtil.getQueryObjectFactory().createClauseType();
                ColumnType jaxb1Column = QueryUtil.getQueryObjectFactory().createColumnType();
                if (column == null) {
                    throw new Exception("Column inside a clause is null. Invalid Predicate.");
                }
                jaxb1Column.setColumnName(column.getColumnName());
                jaxb1Column.setTableName(column.getTableName());
                jaxb1Clause.setColumn(jaxb1Column);
                if (operator == null) {
                    throw new Exception("Operator inside a clause is null. Invalid Predicate.");
                }
                jaxb1Clause.setOperator(operator.name());
                jaxb1Clause.setValue(value);
                if (clause.isSetDateValue()) {
                    jaxb1Clause.setDateValue((Calendar)dateValue.toGregorianCalendar());
                }
                oracle.bpel.services.workflow.query.model.ValueListType jaxb1ValueListType = QueryUtil.getQueryObjectFactory().createValueListType();
                if (valueList != null) {
                    List stringList = valueList.getValue();
                    for (String s : stringList) {
                        jaxb1ValueListType.getValue().add(s);
                    }
                }
                jaxb1Clause.setValueList(jaxb1ValueListType);
                if (columnValue != null) {
                    ColumnType jaxb1JoinColumn = QueryUtil.getQueryObjectFactory().createColumnType();
                    jaxb1JoinColumn.setColumnName(columnValue.getColumnName());
                    jaxb1JoinColumn.setTableName(columnValue.getTableName());
                    jaxb1Clause.setColumnValue(jaxb1JoinColumn);
                }
                if (identityTypeValue != null) {
                    jaxb1Clause.setIdentityTypeValue(BPMOrganizationUtil.convertJAXB2IdentityTypeToJAXB1IdentityType(identityTypeValue));
                }
                if (identityTypeValueListType != null) {
                    List idttyTypeList = identityTypeValueListType.getValue();
                    oracle.bpel.services.workflow.query.model.IdentityTypeValueListType idttyTypeValueList = QueryUtil.getQueryObjectFactory().createIdentityTypeValueListType();
                    for (oracle.bpm.services.organization.common.IdentityType idt : idttyTypeList) {
                        idttyTypeValueList.getValue().add(BPMOrganizationUtil.convertJAXB2IdentityTypeToJAXB1IdentityType(idt));
                    }
                    jaxb1Clause.setIdentityTypeValueList(idttyTypeValueList);
                }
                if (joinOperator != null) {
                    jaxb1Clause.setJoinOperator(joinOperator.name());
                }
                jaxb1Clause.setIgnoreCase(ignoreCase);
                resultPredicate.getClause().add(jaxb1Clause);
            }
            return resultPredicate;
        }
        return resultPredicate;
    }

    public static void printOrganizationalUnit(String className, String methodName, OrganizationalUnit organizationalUnit) {
        BPMOrganizationUtil.debugLog(className, methodName, "Id:" + organizationalUnit.getOrganizationalUnitId());
        BPMOrganizationUtil.debugLog(className, methodName, "Name:" + organizationalUnit.getOrganizationalUnitName());
        BPMOrganizationUtil.debugLog(className, methodName, "Parent:" + organizationalUnit.getParentOrganizationalUnitName());
        BPMOrganizationUtil.debugLog(className, methodName, "Description:" + organizationalUnit.getDescription());
        BPMOrganizationUtil.debugLog(className, methodName, "CalendarRuleId:" + organizationalUnit.getCalendarRuleId());
        BPMOrganizationUtil.debugLog(className, methodName, "CreatedBy:" + organizationalUnit.getCreatedBy());
        BPMOrganizationUtil.debugLog(className, methodName, "CreatedByIdentityContext:" + organizationalUnit.getCreatedByIdentityContext());
        BPMOrganizationUtil.debugLog(className, methodName, "CreatedDate:" + organizationalUnit.getCreatedDate());
        BPMOrganizationUtil.debugLog(className, methodName, "LastUpdatedBy:" + organizationalUnit.getLastUpdatedBy());
        BPMOrganizationUtil.debugLog(className, methodName, "LastUpdatedByIdentityContext:" + organizationalUnit.getLastUpdatedByIdentityContext());
        BPMOrganizationUtil.debugLog(className, methodName, "LastUpdatedDate:" + organizationalUnit.getLastUpdatedDate());
        List managers = organizationalUnit.getManagedByMember();
        if (managers != null && managers.size() > 0) {
            BPMOrganizationUtil.debugLog(className, methodName, "Managers:");
            for (MemberType manager : managers) {
                BPMOrganizationUtil.debugLog(className, methodName, "   Id: " + manager.getMemberId());
                BPMOrganizationUtil.debugLog(className, methodName, "   Name: " + manager.getName());
                BPMOrganizationUtil.debugLog(className, methodName, "   Type: " + manager.getType());
                BPMOrganizationUtil.debugLog(className, methodName, "   Realm: " + manager.getRealm());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedBy:" + manager.getCreatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedByIdentityContext:" + manager.getCreatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedDate:" + manager.getCreatedDate());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedBy:" + manager.getLastUpdatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedByIdentityContext:" + manager.getLastUpdatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedDate:" + manager.getLastUpdatedDate());
            }
        } else if (managers == null) {
            BPMOrganizationUtil.debugLog(className, methodName, "Managers: <null Manager list>");
        } else {
            BPMOrganizationUtil.debugLog(className, methodName, "Managers: <No Managers>");
        }
        List users = organizationalUnit.getMember();
        if (users != null && users.size() > 0) {
            BPMOrganizationUtil.debugLog(className, methodName, "Users:");
            for (MemberType user : users) {
                BPMOrganizationUtil.debugLog(className, methodName, "   Id: " + user.getMemberId());
                BPMOrganizationUtil.debugLog(className, methodName, "   Name: " + user.getName());
                BPMOrganizationUtil.debugLog(className, methodName, "   Type: " + user.getType());
                BPMOrganizationUtil.debugLog(className, methodName, "   Realm: " + user.getRealm());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedBy:" + user.getCreatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedByIdentityContext:" + user.getCreatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedDate:" + user.getCreatedDate());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedBy:" + user.getLastUpdatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedByIdentityContext:" + user.getLastUpdatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedDate:" + user.getLastUpdatedDate());
            }
        } else if (users == null) {
            BPMOrganizationUtil.debugLog(className, methodName, "Users: <null User list>");
        } else {
            BPMOrganizationUtil.debugLog(className, methodName, "Users: <No Users>");
        }
        List peopleQueryMembers = organizationalUnit.getPeopleQueryMember();
        if (users != null && users.size() > 0) {
            BPMOrganizationUtil.debugLog(className, methodName, "PeopleQueryUsers:");
            for (PeopleQueryMemberType peopleQueryMember : peopleQueryMembers) {
                BPMOrganizationUtil.debugLog(className, methodName, "   Id: " + peopleQueryMember.getMemberId());
                BPMOrganizationUtil.debugLog(className, methodName, "   Name: " + peopleQueryMember.getPeopleQueryName());
                BPMOrganizationUtil.debugLog(className, methodName, "   PeopleQueryId: " + peopleQueryMember.getPeopleQueryId());
                BPMOrganizationUtil.debugLog(className, methodName, "   PeopleQuery: " + peopleQueryMember.getPeopleQuery());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedBy:" + peopleQueryMember.getCreatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedByIdentityContext:" + peopleQueryMember.getCreatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedDate:" + peopleQueryMember.getCreatedDate());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedBy:" + peopleQueryMember.getLastUpdatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedByIdentityContext:" + peopleQueryMember.getLastUpdatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedDate:" + peopleQueryMember.getLastUpdatedDate());
            }
        } else if (users == null) {
            BPMOrganizationUtil.debugLog(className, methodName, "People Query Users: <null peopleQueryUser list>");
        } else {
            BPMOrganizationUtil.debugLog(className, methodName, "People Query Users: <No People Query Users>");
        }
        List childrens = organizationalUnit.getChildOrganizationalUnits();
        if (!CommonUtil.isListNullOrEmpty((List)childrens)) {
            for (OrganizationalUnit childOrganizationalUnit : childrens) {
                BPMOrganizationUtil.printOrganizationalUnit(className, methodName, childOrganizationalUnit);
            }
        }
    }

    public static void printOrganizationalUnit(String className, String methodName, BpmOrganizationalUnit bpmOrganizationalUnit) {
        BPMOrganizationUtil.debugLog(className, methodName, "Id:" + bpmOrganizationalUnit.getOrganizationalUnitId());
        BPMOrganizationUtil.debugLog(className, methodName, "Name:" + bpmOrganizationalUnit.getOrganizationalUnitName());
        BPMOrganizationUtil.debugLog(className, methodName, "Parent:" + bpmOrganizationalUnit.getParentOrganizationalUnit());
        BPMOrganizationUtil.debugLog(className, methodName, "Description:" + bpmOrganizationalUnit.getDescription());
        BPMOrganizationUtil.debugLog(className, methodName, "CalendarRuleId:" + bpmOrganizationalUnit.getCalendarRule());
        BPMOrganizationUtil.debugLog(className, methodName, "CreatedBy:" + bpmOrganizationalUnit.getCreatedBy());
        BPMOrganizationUtil.debugLog(className, methodName, "CreatedByIdentityContext:" + bpmOrganizationalUnit.getCreatedByIdentityContext());
        BPMOrganizationUtil.debugLog(className, methodName, "CreatedDate:" + bpmOrganizationalUnit.getCreatedDate());
        BPMOrganizationUtil.debugLog(className, methodName, "LastUpdatedBy:" + bpmOrganizationalUnit.getLastUpdatedBy());
        BPMOrganizationUtil.debugLog(className, methodName, "LastUpdatedByIdentityContext:" + bpmOrganizationalUnit.getLastUpdatedByIdencontext());
        BPMOrganizationUtil.debugLog(className, methodName, "LastUpdatedDate:" + bpmOrganizationalUnit.getLastUpdatedDate());
        List<BpmOuManager> managers = bpmOrganizationalUnit.getBpmOuManagerCollection();
        if (managers != null && managers.size() > 0) {
            BPMOrganizationUtil.debugLog(className, methodName, "Managers:");
            for (BpmOuManager manager : managers) {
                BPMOrganizationUtil.debugLog(className, methodName, "   Id: " + manager.getId());
                BPMOrganizationUtil.debugLog(className, methodName, "   Name: " + manager.getUserId());
                BPMOrganizationUtil.debugLog(className, methodName, "   Type: " + manager.getUserType());
                BPMOrganizationUtil.debugLog(className, methodName, "   Realm: " + manager.getIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedBy:" + manager.getCreatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedByIdentityContext:" + manager.getCreatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedDate:" + manager.getCreatedDate());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedBy:" + manager.getLastUpdatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedByIdentityContext:" + manager.getLastUpdatedByIdencontext());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedDate:" + manager.getLastUpdatedDate());
            }
        } else if (managers == null) {
            BPMOrganizationUtil.debugLog(className, methodName, "Managers: <null Manager list>");
        } else {
            BPMOrganizationUtil.debugLog(className, methodName, "Managers: <No Managers>");
        }
        List<BpmOuUser> users = bpmOrganizationalUnit.getBpmOuUserCollection();
        if (users != null && users.size() > 0) {
            BPMOrganizationUtil.debugLog(className, methodName, "Users:");
            for (BpmOuUser user : users) {
                BPMOrganizationUtil.debugLog(className, methodName, "   Id: " + user.getId());
                BPMOrganizationUtil.debugLog(className, methodName, "   Name: " + user.getUserId());
                BPMOrganizationUtil.debugLog(className, methodName, "   Type: " + user.getUserType());
                BPMOrganizationUtil.debugLog(className, methodName, "   Realm: " + user.getIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedBy:" + user.getCreatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedByIdentityContext:" + user.getCreatedByIdentityContext());
                BPMOrganizationUtil.debugLog(className, methodName, "   CreatedDate:" + user.getCreatedDate());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedBy:" + user.getLastUpdatedBy());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedByIdentityContext:" + user.getLastUpdatedByIdencontext());
                BPMOrganizationUtil.debugLog(className, methodName, "   LastUpdatedDate:" + user.getLastUpdatedDate());
            }
        } else if (users == null) {
            BPMOrganizationUtil.debugLog(className, methodName, "Users: <null User list>");
        } else {
            BPMOrganizationUtil.debugLog(className, methodName, "Users: <No Users>");
        }
        List<BpmOrganizationalUnit> childrens = bpmOrganizationalUnit.getBpmOrganizationalUnitCollection();
        if (!CommonUtil.isListNullOrEmpty(childrens)) {
            for (BpmOrganizationalUnit childOrganizationalUnit : childrens) {
                BPMOrganizationUtil.printOrganizationalUnit(className, methodName, childOrganizationalUnit);
            }
        }
    }

    public static void printOrganizationalUnitAppRoleCalenderAssociation(String className, String methodName, BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc) {
    }

    public static void printOrganizationalUnitAppRoleCalenderAssociation(String class_name, String methodName, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) {
    }

    private static IdentityType convertJAXB2IdentityTypeToJAXB1IdentityType(oracle.bpm.services.organization.common.IdentityType identityTypeValue) {
        IdentityType idttyType = QueryUtil.getTaskObjectFactory().createIdentityType();
        idttyType.setDisplayName(identityTypeValue.getDisplayName());
        idttyType.setId(identityTypeValue.getId());
        idttyType.setType(identityTypeValue.getType().name());
        idttyType.setSystemVersionFlag(identityTypeValue.getSystemVersionFlag());
        return idttyType;
    }
}

