/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.CommonUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.impl.AppRoleUtil;
import oracle.bpm.services.organization.impl.BPMCalendarHolidayService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.PeopleQueryExecutor;
import oracle.bpm.services.organization.impl.PeopleQueryUtil;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociations;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ApplicationRoles;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.CalendarRules;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayRules;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.LogicalPeopleGroupList;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.organization.model.OrganizationEntitySearchContext;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.OrganizationalUnits;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantPropertiesList;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantPropertyList;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PeopleQueryMemberType;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.Permission;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.RoleProfile;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.model.StatusTypeEnum;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMLogicalPeopleGroupPersistency;
import oracle.bpm.services.organization.persistency.BPMOrganizationPersistency;
import oracle.bpm.services.organization.persistency.ExtendedUserPropertiesPersistencyDriver;
import oracle.bpm.services.organization.persistency.PropertyValueTypeEnum;
import oracle.bpm.services.organization.persistency.model.BpmAppRoleOuCalAssoc;
import oracle.bpm.services.organization.persistency.model.BpmCalendarRule;
import oracle.bpm.services.organization.persistency.model.BpmLogicalPeopleGroup;
import oracle.bpm.services.organization.persistency.model.BpmOrganizationalUnit;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataServiceException;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import oracle.bpm.services.processmetadata.impl.ProcessMetadataService;
import oracle.bpm.services.resource.BPMi18NUtil;
import oracle.security.jps.service.policystore.ApplicationRoleInUseException;
import oracle.security.jps.service.policystore.PolicyObjectAlreadyExistsException;
import oracle.security.jps.service.policystore.PolicyObjectNotFoundException;
import oracle.security.jps.service.policystore.PolicyStoreException;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityType;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.pc.services.identity.jps.AuthorizationServiceImpl;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.sessions.DatabaseRecord;

public class BPMOrganizationService
implements IBPMOrganizationService {
    private BPMLogicalPeopleGroupPersistency bpmLogicalPeopleGroupPersistency = BPMLogicalPeopleGroupPersistency.getInstance();
    private BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
    private ExtendedUserPropertiesPersistencyDriver extUserPropertiesPersistenceDriver = ExtendedUserPropertiesPersistencyDriver.getInstance();
    private ObjectFactory objectFactory = new ObjectFactory();
    public static final String hirearchyPathSeparator = "/";
    private IVerificationService verificationService = null;
    private IBPMUserAuthenticationService bpmUserAuthenticationService = null;
    private IProcessMetadataService processMetadataService = null;
    private static final String CLASS_NAME = "BPMOrganizationService";
    private static final int BPM_SELECT_OPERATION = 11;
    private static final int BPM_CREATE_OPERATION = 12;
    private static final int BPM_UPDATE_OPERATION = 13;
    private static final int BPM_DELETE_OPERATION = 14;
    private static final String DEFAULT_REALM_NAME = AppRoleUtil.getInstance().getDefaultRealmName();

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService newVerificationService) {
        this.verificationService = newVerificationService;
    }

    public IBPMUserAuthenticationService getBpmUserAuthenticationService() {
        return this.bpmUserAuthenticationService;
    }

    public void setBpmUserAuthenticationService(IBPMUserAuthenticationService newBPMUserAuthenticationService) {
        this.bpmUserAuthenticationService = newBPMUserAuthenticationService;
    }

    public IProcessMetadataService getProcessMetadataService() {
        return this.processMetadataService;
    }

    public void setProcessMetadataService(IProcessMetadataService newProcessMetadataService) {
        this.processMetadataService = newProcessMetadataService;
    }

    public List searchOrganizationEntity(IBPMContext ctx, OrganizationEntityTypeEnum organizationEntity, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        return this.searchOrganizationEntity(ctx, organizationEntity, searchMode, searchCriteria, startRow, endRow, null);
    }

    public List searchOrganizationEntity(IBPMContext ctx, OrganizationEntityTypeEnum organizationEntity, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow, OrganizationEntitySearchContext organizationEntitySearchContext) throws BPMOrganizationException {
        String METHOD = "searchOrganizationEntity";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "ctx:" + ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "organizationEntity:" + organizationEntity == null ? "null" : organizationEntity.name());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "searchMode:" + searchMode == null ? "null" : searchMode.name());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "searchCriteria:" + searchCriteria);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "startRow:" + startRow);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "endRow:" + endRow);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "organizationEntitySearchContext:" + (organizationEntitySearchContext == null ? "null" : organizationEntitySearchContext.name()));
        }
        Vector<Object> returnList = null;
        try {
            this.validateBPMOperation(ctx, 11);
            String searchString = searchCriteria;
            if (SearchModeTypeEnum.STARTS_WITH == searchMode) {
                searchString = searchCriteria + "%";
            } else if (SearchModeTypeEnum.ENDS_WITH == searchMode) {
                searchString = "%" + searchCriteria;
            } else if (SearchModeTypeEnum.CONTAINS == searchMode) {
                searchString = "%" + searchCriteria + "%";
            } else if (SearchModeTypeEnum.EQUALS == searchMode) {
                searchString = searchCriteria;
            } else if (SearchModeTypeEnum.LIKE == searchMode) {
                searchString = searchCriteria;
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "searchString:" + searchString);
            }
            if (OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT == organizationEntity) {
                ExpressionBuilder builder = new ExpressionBuilder();
                Expression expression = null;
                expression = SearchModeTypeEnum.EQUALS == searchMode ? builder.get("organizationalUnitName").equalsIgnoreCase(searchString) : builder.get("organizationalUnitName").likeIgnoreCase(searchString);
                if (organizationEntitySearchContext != null && OrganizationEntitySearchContext.ORGANIZATIONAL_UNIT_ROOT_ORGANIZATIONAL_UNIT == organizationEntitySearchContext) {
                    expression = expression.and(builder.get("parentOrganizationalUnit").isNull());
                }
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "expression:" + expression);
                }
                returnList = this.bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, expression);
            } else {
                if (OrganizationEntityTypeEnum.CALENDAR_RULE == organizationEntity) {
                    BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
                    List<Object> list = calSrv.searchCalendarRule(ctx, searchMode, searchCriteria, startRow, endRow);
                    return list;
                }
                if (OrganizationEntityTypeEnum.HOLIDAY_RULE == organizationEntity) {
                    BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
                    List<Object> list = calSrv.searchHolidayRule(ctx, searchMode, searchCriteria, startRow, endRow);
                    return list;
                }
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "searchOrganizationEntity");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "End");
            }
        }
        return returnList;
    }

    public OrganizationalUnit createOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        return this.createOrganizationalUnit(ctx, organizationalUnit, null);
    }

    public OrganizationalUnit updateOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        String METHOD = "updateOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "updateOrganizationalUnit", organizationalUnit);
        }
        try {
            this.validateBPMOperation(ctx, 13);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, organizationalUnit, 13, calendar);
            this.validate(ctx, organizationalUnit, null, 13);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "organizationalUnit after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "updateOrganizationalUnit", organizationalUnit);
            }
            this.bpmOrganizationPersistency.update(ctx, organizationalUnit);
            OrganizationalUnit organizationalUnit2 = organizationalUnit;
            return organizationalUnit2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "updateOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "End");
            }
        }
    }

    public void deleteOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, boolean includingChildren, boolean force) throws BPMOrganizationException {
        String METHOD = "deleteOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "organizationalUnitId:" + organizationalUnitId);
        }
        try {
            this.validateBPMOperation(ctx, 14);
            this.validate(ctx, null, organizationalUnitId, 14);
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
            this.bpmOrganizationPersistency.deleteOrganizationalUnit(ctx, bpmOrganizationalUnit, includingChildren);
            List<BpmAppRoleOuCalAssoc> associations = bpmOrganizationalUnit.getBpmAppRoleOuCalAssocCollection();
            if (associations != null && associations.size() > 0) {
                for (BpmAppRoleOuCalAssoc association : associations) {
                    this.deleteApplicationRoleOrgUnitCalendarAssociation(ctx, association.getId());
                }
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "End");
            }
        }
    }

    public OrganizationalUnit getOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode) throws BPMOrganizationException {
        return this.getOrganizationalUnit(ctx, organizationalUnitId, childOrganizationalUnitRetrievalMode, null);
    }

    public OrganizationalUnit getOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "getOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "ctx:" + ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "organizationalUnitId:" + organizationalUnitId);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "childOrganizationalUnitRetrievalMode:" + (childOrganizationalUnitRetrievalMode == null ? "null" : childOrganizationalUnitRetrievalMode.name()));
        }
        OrganizationalUnit organizationalUnit = null;
        this.validateBPMOperation(ctx, 11);
        this.validate(ctx, (OrganizationalUnit)null, organizationalUnitId, 11, unitOfWorkHolder);
        try {
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
            Object object = this.bpmOrganizationPersistency.read(ctx, bpmOrganizationalUnit, unitOfWorkHolder);
            organizationalUnit = (OrganizationalUnit)object;
            this.addChildrens(ctx, organizationalUnit, childOrganizationalUnitRetrievalMode);
            OrganizationalUnit organizationalUnit2 = organizationalUnit;
            return organizationalUnit2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "End");
            }
        }
    }

    public ApplicationRoleOrgUnitCalendarAssociation createApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) throws BPMOrganizationException {
        return this.createApplicationRoleOrgUnitCalendarAssociation(ctx, applicationRoleOrgUnitCalendarAssociation, null);
    }

    public ApplicationRoleOrgUnitCalendarAssociation createApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
        }
        try {
            this.validateBPMOperation(ctx, 12);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, applicationRoleOrgUnitCalendarAssociation, 12, calendar);
            this.validate(ctx, applicationRoleOrgUnitCalendarAssociation, null, 12, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "applicationRoleOrgUnitCalendarAssociation after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
            }
            this.bpmOrganizationPersistency.insert(ctx, applicationRoleOrgUnitCalendarAssociation, unitOfWorkHolder);
            ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation2 = applicationRoleOrgUnitCalendarAssociation;
            return applicationRoleOrgUnitCalendarAssociation2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public ApplicationRoleOrgUnitCalendarAssociation updateApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) throws BPMOrganizationException {
        return this.updateApplicationRoleOrgUnitCalendarAssociation(ctx, applicationRoleOrgUnitCalendarAssociation, null);
    }

    public ApplicationRoleOrgUnitCalendarAssociation updateApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "updateApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
        }
        try {
            this.validateBPMOperation(ctx, 13);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, applicationRoleOrgUnitCalendarAssociation, 13, calendar);
            this.validate(ctx, applicationRoleOrgUnitCalendarAssociation, null, 13, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "applicationRoleOrgUnitCalendarAssociation after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
            }
            this.bpmOrganizationPersistency.update(ctx, applicationRoleOrgUnitCalendarAssociation, unitOfWorkHolder);
            ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation2 = applicationRoleOrgUnitCalendarAssociation;
            return applicationRoleOrgUnitCalendarAssociation2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public void deleteApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, String applicationRoleOrgUnitCalendarAssociationId) throws BPMOrganizationException {
        String METHOD = "deleteApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "applicationRoleOrgUnitCalendarAssociationId:" + applicationRoleOrgUnitCalendarAssociationId);
        }
        try {
            this.validateBPMOperation(ctx, 14);
            this.validate(ctx, (ApplicationRoleOrgUnitCalendarAssociation)null, applicationRoleOrgUnitCalendarAssociationId, 14, null);
            BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc = new BpmAppRoleOuCalAssoc();
            bpmAppRoleOuCalAssoc.setId(applicationRoleOrgUnitCalendarAssociationId);
            Object obj = this.bpmOrganizationPersistency.readObject(ctx, bpmAppRoleOuCalAssoc);
            if (obj != null) {
                bpmAppRoleOuCalAssoc = (BpmAppRoleOuCalAssoc)obj;
                this.bpmOrganizationPersistency.deleteObject(ctx, bpmAppRoleOuCalAssoc);
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public List<ApplicationRoleOrgUnitCalendarAssociation> getApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, RoleProfile applicationRole) throws BPMOrganizationException {
        String METHOD = "getApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "applicationRole:" + (applicationRole == null ? "null" : ((RoleProfileType)applicationRole.getValue()).getName() + ":" + ((RoleProfileType)applicationRole.getValue()).getIdentityContext()));
        }
        try {
            Vector<Object> results;
            this.validateBPMOperation(ctx, 11);
            ArrayList<ApplicationRoleOrgUnitCalendarAssociation> associations = new ArrayList<ApplicationRoleOrgUnitCalendarAssociation>();
            if (applicationRole == null || ((RoleProfileType)applicationRole.getValue()).getName() == null || ((RoleProfileType)applicationRole.getValue()).getName().trim().isEmpty()) {
                throw new BPMOrganizationException(70691, null);
            }
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = "%".equals(((RoleProfileType)applicationRole.getValue()).getName()) ? builder.get("applicationRoleName").like(((RoleProfileType)applicationRole.getValue()).getName()) : builder.get("applicationRoleName").equal((Object)((RoleProfileType)applicationRole.getValue()).getName());
            if (((RoleProfileType)applicationRole.getValue()).getIdentityContext() != null) {
                expression = expression.and(builder.get("identityContext").likeIgnoreCase(((RoleProfileType)applicationRole.getValue()).getIdentityContext()));
            }
            if (((RoleProfileType)applicationRole.getValue()).getApplicationContext() != null) {
                expression = expression.and(builder.get("applicationContext").likeIgnoreCase(((RoleProfileType)applicationRole.getValue()).getApplicationContext()));
            }
            if ((results = this.bpmOrganizationPersistency.executeQuery(ctx, BpmAppRoleOuCalAssoc.class, expression)) != null && !results.isEmpty()) {
                for (int index = 0; index < results.size(); ++index) {
                    associations.add((ApplicationRoleOrgUnitCalendarAssociation)results.get(index));
                }
            }
            ArrayList<ApplicationRoleOrgUnitCalendarAssociation> arrayList = associations;
            return arrayList;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public CalendarRule getCalendarRuleForRole(IBPMContext ctx, String organizationalUnitId, RoleProfile applicationRole) throws BPMOrganizationException {
        String METHOD = "getCalendarRuleForRole";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "organizationalUnitId:" + organizationalUnitId);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "applicationRole:" + (applicationRole == null ? "null" : ((RoleProfileType)applicationRole.getValue()).getName() + ":" + ((RoleProfileType)applicationRole.getValue()).getIdentityContext()));
        }
        try {
            String sqlQuery = "SELECT * FROM  BPM_APP_ROLE_OU_CAL_ASSOC WHERE ORGANIZATIONAL_UNIT_ID = '" + organizationalUnitId + "'" + "APPLICATION_ROLE_NAME = '" + ((RoleProfileType)applicationRole.getValue()).getName() + "'" + "IDENTITY_CONTEXT = '" + ((RoleProfileType)applicationRole.getValue()).getIdentityContext() + "'";
            Vector<Object> associations = this.bpmOrganizationPersistency.executeObjectQuery(ctx, BpmAppRoleOuCalAssoc.class, sqlQuery);
            if (associations != null && !associations.isEmpty()) {
                BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc = (BpmAppRoleOuCalAssoc)associations.get(0);
                CalendarRule calendarRule = (CalendarRule)this.bpmOrganizationPersistency.convertFromTopLink(ctx, null, bpmAppRoleOuCalAssoc.getCalendarRule(), null);
                return calendarRule;
            }
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
            bpmOrganizationalUnit = (BpmOrganizationalUnit)this.bpmOrganizationPersistency.readObject(ctx, bpmOrganizationalUnit);
            if (bpmOrganizationalUnit.getParentOrganizationalUnit() == null) {
                CalendarRule calendarRule = null;
                return calendarRule;
            }
            CalendarRule calendarRule = this.getCalendarRuleForRole(ctx, bpmOrganizationalUnit.getParentOrganizationalUnit().getOrganizationalUnitId(), applicationRole);
            return calendarRule;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getCalendarRuleForRole");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "End");
            }
        }
    }

    public CalendarRule getCalendarRule(IBPMContext ctx, String calendarID) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRule()", "IN");
        this.validateBPMOperation(ctx, 11);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.getCalendarRule(ctx, calendarID);
    }

    public CalendarRule createCalendarRule(IBPMContext ctx, CalendarRule cal) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "createCalendarRule()", "IN");
        this.validateBPMOperation(ctx, 12);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.createCalendarRule(ctx, cal, null);
    }

    public CalendarRule updateCalendarRule(IBPMContext ctx, CalendarRule updatedCalendar) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "updateCalendarRule()", "IN");
        this.validateBPMOperation(ctx, 13);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.updateCalendarRule(ctx, updatedCalendar);
    }

    public void deleteCalendarRule(IBPMContext ctx, String calendarID, boolean force) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteCalendarRule", "IN");
        this.validateBPMOperation(ctx, 14);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        calSrv.deleteCalendarRule(ctx, calendarID, force);
    }

    public HolidayRule getHolidayRule(IBPMContext ctx, String holidayRuleId) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "getHolidayRule", "IN");
        this.validateBPMOperation(ctx, 11);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.getHolidayRule(ctx, holidayRuleId);
    }

    public HolidayRule createHolidayRule(IBPMContext ctx, HolidayRule holidayRule) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "createHolidayRule", "IN");
        this.validateBPMOperation(ctx, 12);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.createHolidayRule(ctx, holidayRule, null);
    }

    public HolidayRule updateHolidayRule(IBPMContext ctx, HolidayRule updatedHolidayRule) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "updateHolidayRule", "IN");
        this.validateBPMOperation(ctx, 13);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.updateHolidayRule(ctx, updatedHolidayRule);
    }

    public void deleteHolidayRule(IBPMContext ctx, String holidayRuleId, boolean force) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteHolidayRule", "IN");
        this.validateBPMOperation(ctx, 14);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        calSrv.deleteHolidayRule(ctx, holidayRuleId, force);
    }

    public Organization exportOrganization(IBPMContext ctx) throws BPMOrganizationException {
        try {
            this.validateBPMOperation(ctx, 11);
            Organization organization = this.objectFactory.createOrganization();
            OrganizationalUnits organizationalUnits = this.exportOrganizationalUnits(ctx);
            organization.setOrganizationalUnits(organizationalUnits);
            HolidayRules holidayRules = this.exportHolidayRules(ctx);
            organization.setHolidayRules(holidayRules);
            CalendarRules calendarRules = this.exportCalendarRules(ctx);
            organization.setCalendarRules(calendarRules);
            ApplicationRoleOrgUnitCalendarAssociations associations = this.exportApplicationRoleOrgUnitCalendarAssociations(ctx);
            organization.setApplicationRoleOrgUnitCalendarAssociations(associations);
            LogicalPeopleGroupList lpgList = this.exportLogicalPeopleGroups(ctx);
            organization.setLogicalPeopleGroupList(lpgList);
            ParticipantPropertyList participantPropertyList = this.exportParticipantPropertyList(ctx);
            organization.setParticipantPropertyList(participantPropertyList);
            ApplicationRoles applicationRoles = this.exportApplicationRoles(ctx);
            organization.setApplicationRoles(applicationRoles);
            ParticipantPropertiesList participantPropertiesList = this.exportParticipantPropertiesList(ctx);
            organization.setParticipantPropertiesList(participantPropertiesList);
            return organization;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public Organization importOrganization(IBPMContext ctx, Organization organization, boolean validateUsers) throws BPMOrganizationException {
        try {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 0, "STARTED IMPORT");
            this.validateBPMOperation(ctx, 12);
            Organization retOrganization = this.objectFactory.createOrganization();
            AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder = this.bpmOrganizationPersistency.getUnitOfWorkHolder(true);
            HolidayRules holidayRules = this.objectFactory.createHolidayRules();
            CalendarRules calendarRules = this.objectFactory.createCalendarRules();
            ParticipantPropertiesList participantPropertiesList = this.objectFactory.createParticipantPropertiesList();
            ParticipantPropertyList participantPropertyList = this.objectFactory.createParticipantPropertyList();
            ApplicationRoles appRoles = this.objectFactory.createApplicationRoles();
            ApplicationRoleOrgUnitCalendarAssociations associations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
            OrganizationalUnits organizationalUnits = this.objectFactory.createOrganizationalUnits();
            LogicalPeopleGroupList logicalPeopleGroupList = this.objectFactory.createLogicalPeopleGroupList();
            HolidayRules retHolidayRules = this.objectFactory.createHolidayRules();
            CalendarRules retCalendarRules = this.objectFactory.createCalendarRules();
            ParticipantPropertiesList retParticipantPropertiesList = this.objectFactory.createParticipantPropertiesList();
            ParticipantPropertyList retParticipantPropertyList = this.objectFactory.createParticipantPropertyList();
            ApplicationRoles retAppRoles = this.objectFactory.createApplicationRoles();
            ApplicationRoleOrgUnitCalendarAssociations retAssociations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
            OrganizationalUnits retOrganizationalUnits = this.objectFactory.createOrganizationalUnits();
            LogicalPeopleGroupList retLogicalPeopleGroupList = this.objectFactory.createLogicalPeopleGroupList();
            String processOrgUnitId = null;
            try {
                processOrgUnitId = organization.getProcessOrganizationalUnitId();
                this.debugLog("importOrganization()", "process OrganizationalUnitId : " + processOrgUnitId);
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getProcessOrganizationalUnitId() failed", e);
            }
            try {
                holidayRules = organization.getHolidayRules();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getHolidayRules() failed", e);
            }
            try {
                calendarRules = organization.getCalendarRules();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getCalendarRules() failed", e);
            }
            try {
                participantPropertiesList = organization.getParticipantPropertiesList();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getParticipantPropertiesList() failed", e);
            }
            try {
                participantPropertyList = organization.getParticipantPropertyList();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getParticipantPropertyList() failed", e);
            }
            try {
                appRoles = organization.getApplicationRoles();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getApplicationRoles() failed", e);
            }
            try {
                associations = organization.getApplicationRoleOrgUnitCalendarAssociations();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getApplicationRoleOrgUnitCalendarAssociations() failed", e);
            }
            try {
                organizationalUnits = organization.getOrganizationalUnits();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getOrganizationalUnits() failed", e);
            }
            try {
                logicalPeopleGroupList = organization.getLogicalPeopleGroupList();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getLogicalPeopleGroupList() failed", e);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing HolidayRules");
            if (holidayRules != null) {
                retHolidayRules = this.importHolidayRules(ctx, holidayRules, validateUsers, unitOfWorkHolder);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Holiday Rules imported successfully");
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing CalendarRules");
            if (calendarRules != null) {
                retCalendarRules = this.importCalendarRules(ctx, calendarRules, validateUsers, unitOfWorkHolder);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "CalendarRules imported successfully");
            try {
                if (participantPropertyList != null) {
                    retParticipantPropertyList = this.importParticipantProperty(ctx, participantPropertyList);
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "errors while importing extended user properties", e);
            }
            try {
                if (participantPropertiesList != null) {
                    retParticipantPropertiesList = this.importPropertiesOnParticipants(ctx, participantPropertiesList);
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "errors while importing user property assignments", e);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing Application Roles");
            if (appRoles != null) {
                retAppRoles = this.importAppRoles(ctx, appRoles, validateUsers);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Application Roles imported successfully");
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing LogicalPeopleGroupList");
            if (logicalPeopleGroupList != null) {
                retLogicalPeopleGroupList = this.importLogicalPeopleGroupList(ctx, logicalPeopleGroupList, validateUsers, unitOfWorkHolder);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "LogicalPeopleGroupList imported successfully");
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing Organizational Units");
            if (organizationalUnits != null) {
                retOrganizationalUnits = this.importOrgUnits(ctx, organizationalUnits, validateUsers, unitOfWorkHolder);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Organizational Units imported successfully");
            try {
                if (associations != null) {
                    retAssociations = this.importAssociations(ctx, associations, unitOfWorkHolder);
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "errors while importing ApplicationRoleOrgUnitCalendarAssociations", e);
            }
            try {
                boolean validProcessOU = this.validate(ctx, processOrgUnitId, organizationalUnits.getOrganizationalUnit());
                if (!validProcessOU && validateUsers) {
                    throw new BPMOrganizationException(70626, new Object[]{processOrgUnitId});
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "invalid processOrganizationalUnitId : " + processOrgUnitId, e);
                if (e instanceof BPMOrganizationException) {
                    throw (BPMOrganizationException)((Object)e);
                }
                throw new BPMOrganizationException(e);
            }
            retOrganization.setOrganizationalUnits(retOrganizationalUnits);
            retOrganization.setApplicationRoles(retAppRoles);
            retOrganization.setHolidayRules(retHolidayRules);
            retOrganization.setCalendarRules(retCalendarRules);
            retOrganization.setApplicationRoleOrgUnitCalendarAssociations(retAssociations);
            retOrganization.setParticipantPropertyList(retParticipantPropertyList);
            retOrganization.setParticipantPropertiesList(retParticipantPropertiesList);
            unitOfWorkHolder.completed();
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 0, "IMPORT ENDED");
            return retOrganization;
        }
        catch (Exception e) {
            if (e instanceof BPMOrganizationException) {
                throw (BPMOrganizationException)((Object)e);
            }
            throw new BPMOrganizationException(e);
        }
    }

    public void createAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, String optionalDisplayName, String optionalDesc) throws BPMOrganizationException {
        try {
            this.createAppRoleInternal(ctx, appCtx, appRoleName, optionalDisplayName, optionalDesc);
        }
        catch (BPMIdentityException bpmie) {
            throw new BPMOrganizationException(70647, new Object[]{appRoleName}, (Exception)((Object)bpmie));
        }
        catch (PolicyObjectAlreadyExistsException pse) {
            throw new BPMOrganizationException(70633, new Object[]{appRoleName, appCtx.getApplicationType().value()}, (Exception)((Object)pse));
        }
        catch (PolicyStoreException ime) {
            throw new BPMOrganizationException(70636, new Object[]{appRoleName}, (Exception)((Object)ime));
        }
        catch (PrivilegedActionException pae) {
            throw new BPMOrganizationException(70642, new Object[]{"createAppRole"}, (Exception)pae);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public void removeAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, boolean force) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n force=" + force));
        this.validateBPMOperation(ctx, 14);
        try {
            RoleProfileType appRoleProfileType = this.objectFactory.createRoleProfileType();
            appRoleProfileType.setName(appRoleName);
            appRoleProfileType.setIdentityContext(appCtx.getApplicationType().value());
            RoleProfile appRoleProfile = new RoleProfile(appRoleProfileType);
            List<ApplicationRoleOrgUnitCalendarAssociation> list = this.getApplicationRoleOrgUnitCalendarAssociation(ctx, appRoleProfile);
            if (list != null && list.size() > 0 && force) {
                for (ApplicationRoleOrgUnitCalendarAssociation association : list) {
                    this.deleteApplicationRoleOrgUnitCalendarAssociation(ctx, association.getApplicationRoleOrgUnitCalendarAssociationId());
                }
            } else if (list != null && list.size() > 0 && !force) {
                throw new BPMOrganizationException(70643, new Object[]{appRoleName});
            }
            AppRoleUtil.getInstance().removeAppRole(appCtx, appRoleName, force);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeAppRole", (String)"Completed.");
    }

    public void grantAppRoleToPrincipal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Participant participant) throws BPMOrganizationException {
        try {
            this.grantAppRoleToPrincipalInternal(ctx, appCtx, appRoleName, participant);
        }
        catch (PolicyObjectAlreadyExistsException pse) {
            throw new BPMOrganizationException(70634, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName()}, (Exception)((Object)pse));
        }
        catch (ApplicationRoleInUseException ae) {
            throw new BPMOrganizationException(70644, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName(), "grantAppRoleToPrincipal"}, (Exception)((Object)ae));
        }
        catch (PolicyObjectNotFoundException pe) {
            throw new BPMOrganizationException(70645, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName()}, (Exception)((Object)pe));
        }
        catch (PolicyStoreException pe) {
            throw new BPMOrganizationException(70638, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName()}, (Exception)((Object)pe));
        }
        catch (NullPointerException je) {
            throw new BPMOrganizationException(70648, new Object[]{"grantAppRoleToPrincipal"}, (Exception)je);
        }
        catch (PrivilegedActionException pae) {
            throw new BPMOrganizationException(70642, new Object[]{"grantAppRoleToPrincipal"}, (Exception)pae);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public void revokeAppRoleFromPrincipal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Participant participant) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n participant=" + participant));
        if (!this.validateIsBPMComposerAdmin(ctx)) {
            this.validateBPMOperation(ctx, 14);
        }
        try {
            AppRoleUtil.getInstance().revokeAppRoleFromPrincipal(appCtx, appRoleName, participant);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)"Completed.");
    }

    public void grantPermissionToAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Permission perm) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n perm=" + perm));
        this.validateBPMOperation(ctx, 12);
        try {
            AppRoleUtil.getInstance().grantPermissionToAppRole(appCtx, appRoleName, perm);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)"Completed.");
    }

    public void revokePermissionFromAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Permission perm) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n perm=" + perm));
        this.validateBPMOperation(ctx, 14);
        try {
            AppRoleUtil.getInstance().revokePermissionFromAppRole(appCtx, appRoleName, perm);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)"Completed.");
    }

    public String importParticipantProperties(IBPMContext ctx, List<ParticipantProperties> participantProperties) throws BPMOrganizationException {
        return "";
    }

    public void createParticipantProperty(IBPMContext ctx, ParticipantProperty property) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 12);
        if (property == null) {
            Object[] objs = new Object[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        property.setCreatedBy(ctx.getUser());
        property.setCreatedByIdentityContext(ctx.getIdentityContext());
        XMLGregorianCalendar todaysDateAndTime = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
        property.setCreatedDate(todaysDateAndTime);
        property.setLastUpdatedBy(ctx.getUser());
        property.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        property.setLastUpdatedDate(todaysDateAndTime);
        this.extUserPropertiesPersistenceDriver.addProperty(property, null);
    }

    public void addParticipantPropertyValue(IBPMContext ctx, ParticipantProperty property) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 13);
        if (property == null) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        Calendar todaysDateAndTime = Calendar.getInstance();
        property.setLastUpdatedBy(ctx.getUser());
        property.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        property.setLastUpdatedDate(BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance()));
        this.extUserPropertiesPersistenceDriver.addPropertyValue(property, null);
    }

    public void deleteAllPropertiesOnParticipants(IBPMContext ctx, List<Participant> participants) throws BPMOrganizationException {
        this.isAdminOrManagerOfParticipants(ctx, participants);
        if (participants == null || participants.size() <= 0) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        this.extUserPropertiesPersistenceDriver.deleteAllPropertiesOnParticipants(participants, null);
    }

    public void deleteParticipantProperty(IBPMContext ctx, ParticipantProperty property, boolean force) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 14);
        if (property == null) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        this.extUserPropertiesPersistenceDriver.deleteProperty(property, force, null);
    }

    public void deleteParticipantPropertyValue(IBPMContext ctx, ParticipantProperty property, boolean force) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 13);
        if (property == null) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        property.setLastUpdatedBy(ctx.getUser());
        property.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        property.setLastUpdatedDate(BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance()));
        this.extUserPropertiesPersistenceDriver.deletePropertyValue(property, force, null);
    }

    public List<ParticipantProperties> getAllAssignedParticipantProperties(IBPMContext ctx) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 11);
        List<ParticipantProperties> result = this.extUserPropertiesPersistenceDriver.getAllParticipantProperties();
        for (ParticipantProperties partProp : result) {
            List propertiesList = partProp.getParticipantProperty();
            block13: for (ParticipantProperty pp : propertiesList) {
                String type = pp.getPropertyType();
                try {
                    PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(type);
                    switch (valueTypeEnum) {
                        case DATE: 
                        case FREEFORM_STRING: 
                        case NUMBER: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            break;
                        }
                        case STRING: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            List values = pp.getValue();
                            for (Object o : values) {
                                String value = (String)o;
                                try {
                                    String i18nValue = BPMi18NUtil.getExtendedUserPropertiesLabel(value, ctx.getLocale());
                                    pp.getLocalizedValue().add(i18nValue);
                                }
                                catch (Exception e) {
                                    pp.getLocalizedValue().add(value);
                                }
                            }
                            continue block13;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    Object[] objs = new Object[]{type};
                    throw new BPMOrganizationException(70662, objs);
                }
            }
        }
        return result;
    }

    public List<Participant> getParticipantsWithProperties(IBPMContext ctx, List<Participant> setOfParticipants, List<ParticipantProperty> props, int startRow, int endRow) throws BPMOrganizationException {
        if (props == null || props.size() == 0) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        this.validateBPMOperation(ctx, 11);
        return this.extUserPropertiesPersistenceDriver.getParticipantsWithProperties(setOfParticipants, props, startRow, endRow);
    }

    public List<Participant> searchParticipantsWithProperties(IBPMContext ctx, List<Participant> setOfParticipants, oracle.bpm.services.organization.model.Predicate predicate, int startRow, int endRow) throws BPMOrganizationException {
        if (predicate == null) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        try {
            this.validateBPMOperation(ctx, 11);
            PredicateType queryPredicateType = BPMOrganizationUtil.convertJAXB2PredicateIntoJAXB1Predicate((oracle.bpm.services.organization.model.PredicateType)predicate.getValue());
            Predicate repos_predicate = new Predicate(queryPredicateType);
            return this.extUserPropertiesPersistenceDriver.getParticipantsWithProperties(setOfParticipants, repos_predicate, startRow, endRow);
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (WorkflowException e) {
            BPMExceptionContext ctxt = new BPMExceptionContext();
            ctxt.setClassName(this.getClass().getName());
            ctxt.setMethodName("searchParticipantsWithProperties");
            ctxt.setErrorCode(e.getErrorCode());
            ctxt.setMessage(e.getMessage());
            ctxt.setThrowable((Throwable)e);
            throw new BPMOrganizationException(ctxt);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public List<ParticipantProperty> searchExtendedUserProperties(IBPMContext ctx, String propertyName) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 11);
        List<ParticipantProperty> result = this.extUserPropertiesPersistenceDriver.searchExtendedUserProperties(propertyName);
        block12: for (ParticipantProperty pp : result) {
            String type = pp.getPropertyType();
            try {
                PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(type);
                switch (valueTypeEnum) {
                    case DATE: 
                    case FREEFORM_STRING: 
                    case NUMBER: {
                        String i18nName;
                        String name = pp.getName();
                        try {
                            i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                            pp.setLocalizedName(i18nName);
                        }
                        catch (Exception e) {
                            pp.setLocalizedName(name);
                        }
                        break;
                    }
                    case STRING: {
                        String i18nName;
                        String name = pp.getName();
                        try {
                            i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                            pp.setLocalizedName(i18nName);
                        }
                        catch (Exception e) {
                            pp.setLocalizedName(name);
                        }
                        List values = pp.getValue();
                        for (Object o : values) {
                            String value = (String)o;
                            try {
                                String i18nValue = BPMi18NUtil.getExtendedUserPropertiesLabel(value, ctx.getLocale());
                                pp.getLocalizedValue().add(i18nValue);
                            }
                            catch (Exception e) {
                                pp.getLocalizedValue().add(value);
                            }
                        }
                        continue block12;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Object[] objs = new Object[]{};
                throw new BPMOrganizationException(70662, objs);
            }
        }
        return result;
    }

    public List<ParticipantProperties> getPropertiesOfParticipants(IBPMContext ctx, List<Participant> participants) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 11);
        if (participants == null || participants.size() == 0) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        List<ParticipantProperties> result = this.extUserPropertiesPersistenceDriver.getPropertiesOfParticipants(participants);
        for (ParticipantProperties partProp : result) {
            List propertiesList = partProp.getParticipantProperty();
            block13: for (ParticipantProperty pp : propertiesList) {
                String type = pp.getPropertyType();
                try {
                    PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(type);
                    switch (valueTypeEnum) {
                        case DATE: 
                        case FREEFORM_STRING: 
                        case NUMBER: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            break;
                        }
                        case STRING: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            List values = pp.getValue();
                            for (Object o : values) {
                                String value = (String)o;
                                try {
                                    String i18nValue = BPMi18NUtil.getExtendedUserPropertiesLabel(value, ctx.getLocale());
                                    pp.getLocalizedValue().add(i18nValue);
                                }
                                catch (Exception e) {
                                    pp.getLocalizedValue().add(value);
                                }
                            }
                            continue block13;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    Object[] objs = new Object[]{type};
                    throw new BPMOrganizationException(70662, objs);
                }
            }
        }
        return result;
    }

    public void setPropertiesOnParticipants(IBPMContext ctx, List<ParticipantProperties> properties) throws BPMOrganizationException {
        if (properties == null || properties.size() == 0) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (ParticipantProperties partProp : properties) {
            Participant participant = this.objectFactory.createParticipant(partProp.getParticipant());
            participants.add(participant);
        }
        this.isAdminOrManagerOfParticipants(ctx, participants);
        XMLGregorianCalendar todaysDateAndTime = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
        for (ParticipantProperties pp : properties) {
            pp.setCreatedBy(ctx.getUser());
            pp.setCreatedByIdentityContext(ctx.getIdentityContext());
            pp.setCreatedDate(todaysDateAndTime);
            pp.setLastUpdatedBy(ctx.getUser());
            pp.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
            pp.setLastUpdatedDate(todaysDateAndTime);
        }
        this.extUserPropertiesPersistenceDriver.setPropertiesOnParticipants(properties, null);
    }

    public void updateParticipantPropertyName(IBPMContext ctx, String oldName, String newname) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 13);
        this.extUserPropertiesPersistenceDriver.updatePropertyName(ctx, oldName, newname, null);
    }

    public void updateParticipantPropertyValue(IBPMContext ctx, String propertyName, String oldValue, String newValue) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 13);
        this.extUserPropertiesPersistenceDriver.updatePropertyValue(ctx, propertyName, oldValue, newValue, null);
    }

    public LogicalPeopleGroup createLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate) throws BPMOrganizationException {
        return this.createLogicalPeopleGroup(ctx, lpg, isExecuteImmediate, null);
    }

    private LogicalPeopleGroup createLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createLogicalPeopleGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "Begin");
        }
        String lpgName = null;
        try {
            this.validateBPMOperation(ctx, 12);
            if (lpg == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            if (lpg.getPeopleQuery() == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70905, null, (Throwable)new IllegalArgumentException());
            }
            PeopleQuery peopleQuery = new PeopleQuery(lpg.getPeopleQuery());
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "Create LogicalPeopleGroup  with peopleQuery=" + PeopleQueryUtil.getPeopleQueryAsString(peopleQuery));
            }
            String lpgId = lpg.getId();
            LogicalPeopleGroup jaxbLogicalPeopleGroup = this.objectFactory.createLogicalPeopleGroup();
            if (lpgId == null) {
                BPMOrganizationService bPMOrganizationService = this;
                lpgId = bPMOrganizationService.bpmLogicalPeopleGroupPersistency.getGuid();
            }
            jaxbLogicalPeopleGroup.setId(lpgId);
            lpgName = lpg.getName();
            if (lpgName == null) {
                lpgName = "Anonymous-" + lpgId;
            }
            jaxbLogicalPeopleGroup.setName(lpgName);
            jaxbLogicalPeopleGroup.setPeopleQuery((PeopleQueryType)peopleQuery.getValue());
            jaxbLogicalPeopleGroup.setStatus(StatusTypeEnum.ENABLED);
            jaxbLogicalPeopleGroup.setTimeout(PeopleQueryUtil.getTimeout(lpg));
            boolean isExecuted = false;
            if (lpg.getStatus() == null || lpg.getStatus() != null && StatusTypeEnum.ENABLED.equals((Object)lpg.getStatus())) {
                jaxbLogicalPeopleGroup = PeopleQueryUtil.execute(ctx, jaxbLogicalPeopleGroup);
                isExecuted = true;
                PeopleQueryExecutor scheduler = PeopleQueryExecutor.getInstance();
                scheduler.scheduleExecutionJob(jaxbLogicalPeopleGroup);
            }
            PeopleQueryUtil.setCreateUpdateInfo(ctx, jaxbLogicalPeopleGroup, true, isExecuted);
            this.bpmLogicalPeopleGroupPersistency.insert(ctx, jaxbLogicalPeopleGroup, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "Registration is done" + peopleQuery.toString());
            }
            LogicalPeopleGroup logicalPeopleGroup = jaxbLogicalPeopleGroup;
            return logicalPeopleGroup;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Throwable t) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "createLogicalPeopleGroup");
            exCtx.setErrorCode(70901);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgName});
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "End");
            }
        }
    }

    public LogicalPeopleGroup updateLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate) throws BPMOrganizationException {
        String METHOD = "updateLogicalPeopleGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateLogicalPeopleGroup", "Begin");
        }
        try {
            this.validateBPMOperation(ctx, 13);
            if (lpg == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            if (lpg.getId() == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
            }
            if (lpg.getName() == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
            }
            if (lpg.getPeopleQuery() == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70905, null, (Throwable)new IllegalArgumentException());
            }
            PeopleQuery peopleQuery = new PeopleQuery(lpg.getPeopleQuery());
            LogicalPeopleGroup jaxbLogicalPeopleGroup = this.getLogicalPeopleGroup(ctx, lpg.getId());
            if (jaxbLogicalPeopleGroup == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70906, (Object[])new String[]{lpg.getId()}, null);
            }
            PeopleQuery newPQ = new PeopleQuery(lpg.getPeopleQuery());
            String newPQasString = PeopleQueryUtil.getPeopleQueryAsString(newPQ);
            PeopleQuery orgPQ = new PeopleQuery(jaxbLogicalPeopleGroup.getPeopleQuery());
            String orgPQasString = PeopleQueryUtil.getPeopleQueryAsString(orgPQ);
            if (!lpg.getName().equals(jaxbLogicalPeopleGroup.getName()) || !orgPQasString.equals(newPQasString) || lpg.getStatus() != null && !lpg.getStatus().equals((Object)jaxbLogicalPeopleGroup.getStatus()) || lpg.getTimeout() != null && lpg.getTimeout().equals(jaxbLogicalPeopleGroup.getTimeout())) {
                isExecuteImmediate = true;
                jaxbLogicalPeopleGroup.setName(lpg.getName());
                jaxbLogicalPeopleGroup.setPeopleQuery(lpg.getPeopleQuery());
                jaxbLogicalPeopleGroup.setTimeout(PeopleQueryUtil.getTimeout(lpg));
                if (lpg.getStatus() != null) {
                    jaxbLogicalPeopleGroup.setStatus(lpg.getStatus());
                } else {
                    jaxbLogicalPeopleGroup.setStatus(StatusTypeEnum.ENABLED);
                }
            } else {
                isExecuteImmediate = false;
            }
            if (isExecuteImmediate) {
                PeopleQueryExecutor scheduler = PeopleQueryExecutor.getInstance();
                scheduler.unscheduleExecutionJob(lpg);
                if (StatusTypeEnum.ENABLED.equals((Object)jaxbLogicalPeopleGroup.getStatus())) {
                    jaxbLogicalPeopleGroup = PeopleQueryUtil.execute(ctx, jaxbLogicalPeopleGroup);
                    scheduler.scheduleExecutionJob(jaxbLogicalPeopleGroup);
                }
            }
            PeopleQueryUtil.setCreateUpdateInfo(ctx, jaxbLogicalPeopleGroup, false, isExecuteImmediate);
            this.bpmLogicalPeopleGroupPersistency.update(ctx, jaxbLogicalPeopleGroup);
            LogicalPeopleGroup logicalPeopleGroup = jaxbLogicalPeopleGroup;
            return logicalPeopleGroup;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "updateLogicalPeopleGroup");
            exCtx.setErrorCode(70903);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpg.getId()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateLogicalPeopleGroup", "End");
            }
        }
    }

    public void deleteLogicalPeopleGroup(IBPMContext ctx, String lpgId, boolean force) throws BPMOrganizationException {
        String METHOD = "deleteLogicalPeopleGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteLogicalPeopleGroup", "Begin");
        }
        try {
            this.validateBPMOperation(ctx, 14);
            if (lpgId == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
            }
            List<OrganizationalUnit> list = this.getOrganizationalUnitAssociatedWithLPG(ctx, lpgId);
            if (list.size() != 0 && !force) {
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteLogicalPeopleGroup");
                exCtx.setErrorCode(70921);
                exCtx.setSeverity(Severity.ERRORS);
                exCtx.setMessageArguments(new Object[]{lpgId, list.get(0).getOrganizationalUnitName()});
                throw new BPMOrganizationException(exCtx);
            }
            LogicalPeopleGroup jaxbLogicalPeopleGroup = this.getLogicalPeopleGroup(ctx, lpgId);
            if (jaxbLogicalPeopleGroup == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70906, (Object[])new String[]{lpgId}, null);
            }
            this.bpmLogicalPeopleGroupPersistency.delete(ctx, jaxbLogicalPeopleGroup);
            PeopleQueryExecutor scheduler = PeopleQueryExecutor.getInstance();
            scheduler.unscheduleExecutionJob(jaxbLogicalPeopleGroup);
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Throwable t) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteLogicalPeopleGroup");
            exCtx.setErrorCode(70902);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgId});
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteLogicalPeopleGroup", "End");
            }
        }
    }

    public LogicalPeopleGroup getLogicalPeopleGroup(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        return this.getLogicalPeopleGroup(ctx, lpgId, null);
    }

    public LogicalPeopleGroup getLogicalPeopleGroup(IBPMContext ctx, String lpgId, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "getLogicalPeopleGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroup", "Begin");
        }
        try {
            this.validateBPMOperation(ctx, 11);
            if (lpgId == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
            }
            BpmLogicalPeopleGroup tlLogicalPeopleGroup = new BpmLogicalPeopleGroup();
            tlLogicalPeopleGroup.setId(lpgId);
            LogicalPeopleGroup jaxbLogicalPeopleGroup = (LogicalPeopleGroup)this.bpmLogicalPeopleGroupPersistency.read(ctx, tlLogicalPeopleGroup, unitOfWorkHolder);
            if (jaxbLogicalPeopleGroup == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70906, (Object[])new String[]{lpgId}, null);
            }
            LogicalPeopleGroup logicalPeopleGroup = jaxbLogicalPeopleGroup;
            return logicalPeopleGroup;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Throwable t) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getLogicalPeopleGroup");
            exCtx.setErrorCode(70910);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgId});
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroup", "End");
            }
        }
    }

    public List<LogicalPeopleGroup> getLogicalPeopleGroupsForUser(IBPMContext ctx, PrincipleRefType user) throws BPMOrganizationException {
        String METHOD = "getLogicalPeopleGroupsForUser";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroupsForUser", "Begin");
        }
        try {
            List<LogicalPeopleGroup> list;
            this.validateBPMOperation(ctx, 11);
            if (user == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroupsForUser", "Find  LogicalPeopleGroups for user:" + user.getName());
            }
            List<LogicalPeopleGroup> list2 = list = this.bpmLogicalPeopleGroupPersistency.getLogicalPeopleGroupsByUser(user);
            return list2;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getLogicalPeopleGroupsForUser");
            exCtx.setErrorCode(70908);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{user.getName()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroupsForUser", "End");
            }
        }
    }

    public List<LogicalPeopleGroup> searchLogicalPeopleGroups(IBPMContext ctx, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        String METHOD = "searchLogicalPeopleGroups";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchLogicalPeopleGroups", "Begin");
        }
        try {
            this.validateBPMOperation(ctx, 11);
            ArrayList<LogicalPeopleGroup> list = new ArrayList<LogicalPeopleGroup>();
            String searchString = searchCriteria;
            if (SearchModeTypeEnum.STARTS_WITH == searchMode) {
                searchString = searchCriteria + "%";
            } else if (SearchModeTypeEnum.ENDS_WITH == searchMode) {
                searchString = "%" + searchCriteria;
            } else if (SearchModeTypeEnum.CONTAINS == searchMode) {
                searchString = "%" + searchCriteria + "%";
            } else if (SearchModeTypeEnum.EQUALS == searchMode) {
                searchString = searchCriteria;
            } else if (SearchModeTypeEnum.LIKE == searchMode) {
                searchString = searchCriteria;
            }
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = SearchModeTypeEnum.EQUALS == searchMode ? builder.get("name").equalsIgnoreCase(searchString) : builder.get("name").likeIgnoreCase(searchString);
            Vector<Object> vector = this.bpmLogicalPeopleGroupPersistency.executeQuery(ctx, BpmLogicalPeopleGroup.class, expression);
            for (Object e : vector) {
                list.add((LogicalPeopleGroup)e);
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchLogicalPeopleGroups", "Found the following list of LogicalPeopleGroup: " + list);
            }
            ArrayList<LogicalPeopleGroup> arrayList = list;
            return arrayList;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "searchLogicalPeopleGroups");
            exCtx.setErrorCode(70909);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchLogicalPeopleGroups", "End");
            }
        }
    }

    public List<Participant> getLogicalPeopleGroupMembers(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        ArrayList<Participant> list = new ArrayList<Participant>();
        return list;
    }

    public List<Participant> executePeopleQuery(IBPMContext ctx, PeopleQuery peopleQuery, PeopleQueryContext peopleQueryCtx) throws BPMOrganizationException {
        return PeopleQueryUtil.execute(ctx, peopleQuery, peopleQueryCtx);
    }

    public List<OrganizationalUnit> getOrganizationalUnitForUser(IBPMContext ctx, String userId, String identityContext, boolean direct) throws BPMOrganizationException {
        Vector<DatabaseRecord> queriedOrganizationalUnitsMap;
        String METHOD = "getOrganizationalUnitForUser";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "userId:" + userId);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "identityContext:" + identityContext);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "direct:" + direct);
        }
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        ArrayList organizationalUnitList = new ArrayList();
        ArrayList<OrganizationalUnit> allOrganizationalUnitList = new ArrayList<OrganizationalUnit>();
        StringBuffer sqlQuery = new StringBuffer("SELECT DISTINCT(subqry.ORGANIZATIONAL_UNIT_ID) FROM (SELECT ORGANIZATIONAL_UNIT_ID FROM BPM_OU_USER BPMOUUSER, BPM_LPG_MEMBER LPG  WHERE BPMOUUSER.PEOPLE_QUERY = LPG.QUERY_ID AND LPG.USER_ID = '");
        sqlQuery.append(userId);
        sqlQuery.append("' AND LPG.IDENTITY_CONTEXT = '");
        sqlQuery.append(identityContext);
        sqlQuery.append("' UNION SELECT ORGANIZATIONAL_UNIT_ID FROM BPM_OU_USER WHERE (USER_ID = '");
        sqlQuery.append(userId);
        sqlQuery.append("' AND USER_TYPE = '" + ParticipantTypeEnum.USER + "' ");
        sqlQuery.append(" AND IDENTITY_CONTEXT = '");
        sqlQuery.append(identityContext);
        sqlQuery.append("') ");
        try {
            List groups = VerificationService.getGroupNamesList((String)userId, (String)identityContext);
            if (groups != null) {
                for (String group : groups) {
                    sqlQuery.append(" OR (USER_ID = '");
                    sqlQuery.append(group);
                    sqlQuery.append("' AND USER_TYPE = '" + ParticipantTypeEnum.GROUP + "' ");
                    sqlQuery.append(" AND IDENTITY_CONTEXT = '");
                    sqlQuery.append(identityContext);
                    sqlQuery.append("') ");
                }
            }
            Map appRoles = VerificationService.getAppRoleNamesMap((String)userId, (String)identityContext);
            for (String appName : appRoles.keySet()) {
                Set set = (Set)appRoles.get(appName);
                if (set == null) continue;
                Iterator itr = set.iterator();
                while (itr.hasNext()) {
                    String appRoleId = itr.next().toString();
                    sqlQuery.append(" OR (USER_ID = '");
                    sqlQuery.append(appRoleId);
                    sqlQuery.append("' AND USER_TYPE = '" + ParticipantTypeEnum.APPROLE + "' ");
                    sqlQuery.append(") ");
                }
            }
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
        sqlQuery.append(") subqry");
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "OrgUnitForUser computed by running the SQL Query:" + sqlQuery.toString());
        }
        if ((queriedOrganizationalUnitsMap = bpmOrganizationPersistency.executeSQL(ctx, sqlQuery.toString())) != null && !queriedOrganizationalUnitsMap.isEmpty()) {
            for (DatabaseRecord databaseRecord : queriedOrganizationalUnitsMap) {
                if (databaseRecord == null || databaseRecord.isEmpty()) continue;
                Object key = databaseRecord.keySet().iterator().next();
                Object organizationalUnitIdObject = databaseRecord.get(key);
                String organizationalUnitId = (String)organizationalUnitIdObject;
                BPMOrganizationService bpmOrganizationService = new BPMOrganizationService();
                OrganizationalUnit organizationalUnit = bpmOrganizationService.getOrganizationalUnit(ctx, organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
                if (direct) {
                    allOrganizationalUnitList.add(organizationalUnit);
                    continue;
                }
                allOrganizationalUnitList.addAll(BPMOrganizationService.getAllParentOrganizationalUnits(bpmOrganizationService, ctx, organizationalUnit));
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "Computed OrgUnitForUser (" + userId + "):" + organizationalUnitList);
        }
        return allOrganizationalUnitList;
    }

    public List<OrganizationalUnit> getOrganizationalUnitAssociatedWithLPG(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        Vector<Object> queriedOrganizationalUnits;
        String METHOD = "getOrganizationalUnitAssociatedWithLPG";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "lpgId:" + lpgId);
        }
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        ArrayList<OrganizationalUnit> organizationalUnitList = new ArrayList<OrganizationalUnit>();
        StringBuffer sqlQuery = new StringBuffer("SELECT DISTINCT(ORGANIZATIONAL_UNIT_ID) FROM BPM_OU_USER BPMOUUSER  WHERE BPMOUUSER.PEOPLE_QUERY = '");
        sqlQuery.append(lpgId);
        sqlQuery.append("'");
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "OrgUnitForGivenLPGId is computed by running the SQL Query:" + sqlQuery.toString());
        }
        if ((queriedOrganizationalUnits = bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, sqlQuery.toString())) != null && !queriedOrganizationalUnits.isEmpty()) {
            for (int index = 0; index < queriedOrganizationalUnits.size(); ++index) {
                OrganizationalUnit queriedOrganizationalUnit = (OrganizationalUnit)queriedOrganizationalUnits.get(index);
                organizationalUnitList.add(queriedOrganizationalUnit);
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "Computed OrgUnitForLPGId (" + lpgId + "):" + organizationalUnitList);
        }
        return organizationalUnitList;
    }

    void validateBPMOperation(IBPMContext wfCtx, int operation) throws BPMOrganizationException {
        String METHOD = "validateBPMOperation";
        if (wfCtx == null) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "validateBPMOperation", "Called with null context !");
            throw new BPMOrganizationException(70684, new Object[0]);
        }
        BPMOrganizationUtil.debugLog(CLASS_NAME, "validateBPMOperation", "Called with: \n wfCtx user=" + wfCtx.getUser() + "\n operation=" + operation);
        try {
            this.debugLog("validateBPMOperation", "Invoking VerificationService to validate the context.");
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)wfCtx);
            this.debugLog("validateBPMOperation", "Validated context successfully.");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(70684, new Object[]{e.getMessage()});
        }
        if (operation == 11) {
            return;
        }
        try {
            if (!VerificationService.isBPMOrganizationAdmin((IWorkflowContext)wfCtx)) {
                this.debugLog("validateBPMOperation", wfCtx.getUser() + " is not an Administrator. Request to execute operation denied.");
                throw new BPMOrganizationException(70685, new Object[]{wfCtx.getUser() + " is not an Administrator. Request to execute operation denied.."});
            }
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
        this.debugLog("validateBPMOperation", "Authorization check completed successfully. Request to execute operation granted.");
    }

    boolean validateIsBPMComposerAdmin(IBPMContext wfCtx) throws BPMOrganizationException {
        String METHOD = "validateIsBPMComposerAdmin";
        if (wfCtx == null) {
            this.debugLog("validateIsBPMComposerAdmin", "Called with null context !");
            throw new BPMOrganizationException(70684, new Object[]{"Called with null context !"});
        }
        try {
            this.debugLog("validateIsBPMComposerAdmin", "Invoking VerificationService to validate the context.");
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)wfCtx);
            this.debugLog("validateIsBPMComposerAdmin", "Validated context successfully.");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(70684, new Object[]{e.getMessage()});
        }
        try {
            return VerificationService.isBPMComposerAdmin((IWorkflowContext)wfCtx);
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
    }

    void isAdminOrManagerOfParticipants(IBPMContext wfCtx, List<Participant> participants) throws BPMOrganizationException {
        String METHOD = "isAdminOrManagerOfParticipants";
        if (wfCtx == null) {
            this.debugLog("isAdminOrManagerOfParticipants", "Called with null context !");
            throw new BPMOrganizationException(70684, new Object[]{"Called with NULL context"});
        }
        if (participants == null || participants.size() == 0) {
            return;
        }
        this.debugLog("isAdminOrManagerOfParticipants", "Called with: \n wfCtx user=" + wfCtx.getUser());
        try {
            this.debugLog("isAdminOrManagerOfParticipants", "Invoking VerificationService to get context validated.");
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)wfCtx);
            this.debugLog("isAdminOrManagerOfParticipants", "Validated context successfully.");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(70684, new Object[]{e.getMessage()});
        }
        try {
            if (VerificationService.isBPMOrganizationAdmin((IWorkflowContext)wfCtx)) {
                this.debugLog("isAdminOrManagerOfParticipants", "User  wfCtx user=" + wfCtx.getUser() + " is an Administrator. Permission to execute requested operation granted.");
                return;
            }
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
        if (!wfCtx.isManager()) {
            this.debugLog("isAdminOrManagerOfParticipants", "User : " + wfCtx.getUser() + " is neither a manager nor an Administrator. Permission to execute requested operation denied.");
            throw new BPMOrganizationException(70685, new Object[]{"User : " + wfCtx.getUser() + " is neither a manager nor an Administrator. Permission to execute requested operation denied."});
        }
        try {
            String identityContext = wfCtx.getIdentityContext();
            BPMAuthorizationService as = (BPMAuthorizationService)AuthorizationServiceImpl.getInstance((String)identityContext);
            List allReportees = as.getReportees(wfCtx.getUser(), 1);
            HashMap<String, BPMUser> reporteesMap = new HashMap<String, BPMUser>();
            for (BPMUser usr : allReportees) {
                reporteesMap.put(usr.getName(), usr);
            }
            for (Participant p : participants) {
                if (!((PrincipleRefType)p.getValue()).getRealm().equalsIgnoreCase(identityContext)) {
                    this.debugLog("isAdminOrManagerOfParticipants", "Participant " + p.getName() + "is not from the same realm of " + wfCtx.getUser() + " : " + identityContext + ". Permission to execute requested operation denied.");
                    throw new BPMOrganizationException(70685, new Object[]{"Participant " + p.getName() + "is not from the same realm of " + wfCtx.getUser() + " : " + identityContext + ". Permission to execute requested operation denied."});
                }
                if (reporteesMap.get(p.getName()) != null) continue;
                this.debugLog("isAdminOrManagerOfParticipants", "Participant " + p.getName() + "does not report to " + wfCtx.getUser() + ". Permission to execute requested operation denied.");
                throw new BPMOrganizationException(70685, new Object[]{"Participant " + p.getName() + "does not report to " + wfCtx.getUser() + ". Permission to execute requested operation denied."});
            }
        }
        catch (Exception e) {
            Object[] msgs = new String[]{e.getMessage()};
            throw new BPMOrganizationException(70685, msgs);
        }
        this.debugLog("isAdminOrManagerOfParticipants", "Completed successfully. Permission to execute requested operation granted.");
    }

    private static List<OrganizationalUnit> getAllParentOrganizationalUnits(BPMOrganizationService bpmOrganizationService, IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        ArrayList<OrganizationalUnit> organizationalUnitList = new ArrayList<OrganizationalUnit>();
        organizationalUnitList.add(organizationalUnit);
        String parentOrganizationalUnitId = organizationalUnit.getParentOrganizationalUnitId();
        if (parentOrganizationalUnitId != null) {
            OrganizationalUnit parentOrganizationalUnit = bpmOrganizationService.getOrganizationalUnit(ctx, parentOrganizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            organizationalUnitList.addAll(BPMOrganizationService.getAllParentOrganizationalUnits(bpmOrganizationService, ctx, parentOrganizationalUnit));
        }
        return organizationalUnitList;
    }

    private OrganizationalUnit createOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "createOrganizationalUnit", organizationalUnit);
        }
        try {
            this.validateBPMOperation(ctx, 12);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, organizationalUnit, 12, calendar);
            this.validate(ctx, organizationalUnit, null, 12, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "organizationalUnit after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "createOrganizationalUnit", organizationalUnit);
            }
            this.bpmOrganizationPersistency.insert(ctx, organizationalUnit, unitOfWorkHolder);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "createOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "End");
            }
        }
        return organizationalUnit;
    }

    private OrganizationalUnits exportOrganizationalUnits(IBPMContext ctx) throws BPMOrganizationException {
        try {
            OrganizationalUnits organizationalUnits = this.objectFactory.createOrganizationalUnits();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = builder.get("parentOrganizationalUnit").equal(null);
            ArrayList<OrganizationalUnit> parentOrgUnitList = null;
            Vector<Object> v = this.bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, expression);
            if (v.size() > 0) {
                parentOrgUnitList = new ArrayList<OrganizationalUnit>();
                for (int i = 0; i < v.size(); ++i) {
                    OrganizationalUnit orgUnit = (OrganizationalUnit)v.get(i);
                    parentOrgUnitList.add(orgUnit);
                }
            }
            if (parentOrgUnitList != null) {
                for (OrganizationalUnit parentOrgUnit : parentOrgUnitList) {
                    OrganizationalUnit orgUnit = this.getOrganizationalUnit(ctx, parentOrgUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.HIRERARCHY);
                    if (orgUnit == null) continue;
                    organizationalUnits.getOrganizationalUnit().add(orgUnit);
                }
            }
            return organizationalUnits;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private HolidayRules exportHolidayRules(IBPMContext ctx) throws BPMOrganizationException {
        try {
            HolidayRules holidayRules = this.objectFactory.createHolidayRules();
            List holidayRuleList = this.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.LIKE, "%", 0, -1, null);
            if (holidayRuleList != null) {
                holidayRules.getHolidayRule().addAll(holidayRuleList);
            }
            return holidayRules;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private CalendarRules exportCalendarRules(IBPMContext ctx) throws BPMOrganizationException {
        try {
            CalendarRules calendarRules = this.objectFactory.createCalendarRules();
            List calendarRuleList = this.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.LIKE, "%", 0, -1, null);
            if (calendarRuleList != null) {
                calendarRules.getCalendarRule().addAll(calendarRuleList);
            }
            return calendarRules;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private LogicalPeopleGroupList exportLogicalPeopleGroups(IBPMContext ctx) throws BPMOrganizationException {
        try {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Export LogicalPeopleGroups begin");
            LogicalPeopleGroupList lpgList = this.objectFactory.createLogicalPeopleGroupList();
            List<LogicalPeopleGroup> list = this.searchLogicalPeopleGroups(ctx, SearchModeTypeEnum.LIKE, "%", 0, -1);
            if (list != null && list.size() > 0) {
                for (LogicalPeopleGroup lpg : list) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Export found lpg: " + lpg.getName());
                    lpgList.getLogicalPeopleGroup().add(lpg);
                }
            }
            LogicalPeopleGroupList logicalPeopleGroupList = lpgList;
            return logicalPeopleGroupList;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "exportLogicalPeopleGroups", null, e);
            throw new BPMOrganizationException(e);
        }
        finally {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Export LogicalPeopleGroups end");
        }
    }

    private ApplicationRoleOrgUnitCalendarAssociations exportApplicationRoleOrgUnitCalendarAssociations(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ApplicationRoleOrgUnitCalendarAssociations associations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
            List associationList = associations.getApplicationRoleOrgUnitCalendarAssociation();
            RoleProfileType appRoleProfileTypeForOracleBPMProcessRolesApp = this.objectFactory.createRoleProfileType();
            appRoleProfileTypeForOracleBPMProcessRolesApp.setName("%");
            appRoleProfileTypeForOracleBPMProcessRolesApp.setIdentityContext(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
            RoleProfile appRoleProfileForOracleBPMProcessRolesApp = new RoleProfile(appRoleProfileTypeForOracleBPMProcessRolesApp);
            List<ApplicationRoleOrgUnitCalendarAssociation> associationsListForRolesInOracleBPMProcessRolesApp = this.getApplicationRoleOrgUnitCalendarAssociation(ctx, appRoleProfileForOracleBPMProcessRolesApp);
            RoleProfileType appRoleProfileTypeForOracleBPMComposerRolesApp = this.objectFactory.createRoleProfileType();
            appRoleProfileTypeForOracleBPMComposerRolesApp.setName("%");
            appRoleProfileTypeForOracleBPMComposerRolesApp.setIdentityContext(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value());
            RoleProfile appRoleProfileForOracleBPMComposerRolesApp = new RoleProfile(appRoleProfileTypeForOracleBPMComposerRolesApp);
            List<ApplicationRoleOrgUnitCalendarAssociation> associationsListForRolesInOracleBPMComposerRolesApp = this.getApplicationRoleOrgUnitCalendarAssociation(ctx, appRoleProfileForOracleBPMComposerRolesApp);
            if (associationsListForRolesInOracleBPMProcessRolesApp != null) {
                associations.getApplicationRoleOrgUnitCalendarAssociation().addAll(associationsListForRolesInOracleBPMProcessRolesApp);
            }
            if (associationsListForRolesInOracleBPMComposerRolesApp != null) {
                associations.getApplicationRoleOrgUnitCalendarAssociation().addAll(associationsListForRolesInOracleBPMComposerRolesApp);
            }
            return associations;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private ApplicationRoles exportApplicationRoles(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ApplicationRoles applicationRoles = this.objectFactory.createApplicationRoles();
            List<ApplicationRoleType> appRoleListForProcessRoles = this.getAllAppRoles(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
            List<ApplicationRoleType> appRoleListForComposerRoles = this.getAllAppRoles(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value());
            if (appRoleListForProcessRoles != null) {
                applicationRoles.getApplicationRole().addAll(appRoleListForProcessRoles);
            }
            if (appRoleListForComposerRoles != null) {
                applicationRoles.getApplicationRole().addAll(appRoleListForComposerRoles);
            }
            return applicationRoles;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private ParticipantPropertyList exportParticipantPropertyList(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ParticipantPropertyList participantPropertyList = this.objectFactory.createParticipantPropertyList();
            List<ParticipantProperty> propertyList = this.searchExtendedUserProperties(ctx, "*");
            if (propertyList != null) {
                participantPropertyList.getParticipantProperty().addAll(propertyList);
            }
            return participantPropertyList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private ParticipantPropertiesList exportParticipantPropertiesList(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ParticipantPropertiesList participantPropertiesList = this.objectFactory.createParticipantPropertiesList();
            List<ParticipantProperties> propertiesList = this.getAllAssignedParticipantProperties(ctx);
            if (propertiesList != null) {
                participantPropertiesList.getParticipantProperties().addAll(propertiesList);
            }
            return participantPropertiesList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private List<ApplicationRoleType> getAllAppRoles(String appId) throws BPMOrganizationException {
        try {
            List<BPMAppRole> bpmAppRoleList = AppRoleUtil.getInstance().getAppRoles("*", appId);
            ArrayList<ApplicationRoleType> appRoleTypeList = new ArrayList<ApplicationRoleType>();
            if (bpmAppRoleList != null) {
                for (BPMAppRole bpmAppRole : bpmAppRoleList) {
                    ApplicationRoleType appRoleType = this.objectFactory.createApplicationRoleType();
                    appRoleType.setName(bpmAppRole.getName());
                    appRoleType.setIdentityContext(appId);
                    appRoleType.setDescription(bpmAppRole.getDescription());
                    Set<BPMIdentity> granteesList = AppRoleUtil.getInstance().getGrantees(bpmAppRole, true);
                    if (granteesList != null) {
                        for (BPMIdentity identity : granteesList) {
                            PrincipleRefType principleRefType = this.objectFactory.createPrincipleRefType();
                            principleRefType.setName(identity.getName());
                            if (identity.getIdentityType().equals((Object)BPMIdentityType.USER)) {
                                principleRefType.setType(ParticipantTypeEnum.USER);
                                principleRefType.setRealm(identity.getRealmName());
                            } else if (identity.getIdentityType().equals((Object)BPMIdentityType.GROUP)) {
                                principleRefType.setType(ParticipantTypeEnum.GROUP);
                                principleRefType.setRealm(identity.getRealmName());
                            } else if (identity.getIdentityType().equals((Object)BPMIdentityType.APPROLE)) {
                                principleRefType.setType(ParticipantTypeEnum.APPROLE);
                                principleRefType.setApplicationContext(appId);
                            }
                            appRoleType.getMember().add(principleRefType);
                        }
                    }
                    appRoleTypeList.add(appRoleType);
                }
            }
            return appRoleTypeList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private LogicalPeopleGroupList importLogicalPeopleGroupList(IBPMContext ctx, LogicalPeopleGroupList logicalPeopleGroupList, boolean validate, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        ArrayList<LogicalPeopleGroup> retListOflogicalPeopleGroups = new ArrayList<LogicalPeopleGroup>();
        LogicalPeopleGroupList retLogicalPeopleGroupList = this.objectFactory.createLogicalPeopleGroupList();
        List logicalPeopleGroups = logicalPeopleGroupList.getLogicalPeopleGroup();
        if (logicalPeopleGroups != null) {
            for (LogicalPeopleGroup logicalPeopleGroup : logicalPeopleGroups) {
                try {
                    if (!this.isLogicalPeopleGroupExists(ctx, logicalPeopleGroup)) {
                        this.createLogicalPeopleGroup(ctx, logicalPeopleGroup, true, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "LogicalPeopleGroup " + logicalPeopleGroup.getName() + " alreadyExists");
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, logicalPeopleGroup.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importLogicalPeopleGroupList", "Error while importing LogicalPeopleGroup " + logicalPeopleGroup.getName(), e);
                        retListOflogicalPeopleGroups.add(logicalPeopleGroup);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retListOflogicalPeopleGroups.size() > 0) {
            retLogicalPeopleGroupList.getLogicalPeopleGroup().addAll(retListOflogicalPeopleGroups);
        }
        return retLogicalPeopleGroupList;
    }

    private OrganizationalUnits importOrgUnits(IBPMContext ctx, OrganizationalUnits organizationalUnits, boolean validateUsers, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        OrganizationalUnits retOrganizationalUnits = this.objectFactory.createOrganizationalUnits();
        List orgUnitList = new ArrayList();
        orgUnitList = organizationalUnits.getOrganizationalUnit();
        ArrayList<OrganizationalUnit> retList = new ArrayList<OrganizationalUnit>();
        if (orgUnitList != null) {
            for (OrganizationalUnit orgUnit : orgUnitList) {
                try {
                    if (!this.isOrgUnitExists(ctx, orgUnit)) {
                        if (validateUsers) {
                            this.validateOUMembers(orgUnit);
                        }
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, orgUnit.getOrganizationalUnitName());
                        this.createOrganizationalUnit(ctx, orgUnit, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "OrgUnit " + orgUnit.getOrganizationalUnitName() + " alreadyExists");
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, orgUnit.getOrganizationalUnitName() + " could not be processed due to : " + e.getMessage());
                    if (!validateUsers) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrgUnits", "Error while importing OrgUnit " + orgUnit.getOrganizationalUnitName(), e);
                        retList.add(orgUnit);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retList != null) {
            retOrganizationalUnits.getOrganizationalUnit().addAll(retList);
        }
        return retOrganizationalUnits;
    }

    private ApplicationRoles importAppRoles(IBPMContext ctx, ApplicationRoles appRoles, boolean validate) throws BPMOrganizationException {
        ApplicationRoles retAppRoles = this.objectFactory.createApplicationRoles();
        List appRoleList = new ArrayList();
        appRoleList = appRoles.getApplicationRole();
        ArrayList<ApplicationRoleType> retList = new ArrayList<ApplicationRoleType>();
        if (appRoleList != null && appRoleList.size() > 0) {
            for (ApplicationRoleType appRoleType : appRoleList) {
                try {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName());
                    this.insertAppRole(ctx, appRoleType, validate);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importAppRoles", "error in importing appRole: " + appRoleType.getName(), e);
                        retList.add(appRoleType);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retList != null && retList.size() > 0) {
            retAppRoles.getApplicationRole().addAll(retList);
        }
        return retAppRoles;
    }

    private boolean insertAppRole(IBPMContext ctx, ApplicationRoleType appRoleType, boolean validate) throws BPMOrganizationException {
        try {
            ApplicationContext appContext = this.objectFactory.createApplicationContext();
            String appCtx = appRoleType.getIdentityContext();
            if (appCtx == null) {
                appContext.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
            } else if (appCtx.equals(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value())) {
                appContext.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP);
            } else {
                appContext.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
            }
            try {
                this.createAppRoleInternal(ctx, appContext, appRoleType.getName(), appRoleType.getName(), appRoleType.getDescription());
                List membersList = appRoleType.getMember();
                if (membersList != null) {
                    for (PrincipleRefType member : membersList) {
                        try {
                            boolean validParticipant = true;
                            if (validate) {
                                validParticipant = this.validateParticipant(new Participant(member));
                            }
                            if (!validParticipant) continue;
                            this.grantAppRoleToPrincipalInternal(ctx, appContext, appRoleType.getName(), new Participant(member));
                        }
                        catch (Exception e) {
                            BPMOrganizationUtil.infoLog(CLASS_NAME, "insertAppRole", "Exceptions occured  while granting appRole to principal, either role " + appRoleType.getName() + " is already granted to " + member.getName() + " or an error ocured while granting the role to principal, see logs for detailed information.");
                        }
                    }
                }
            }
            catch (PolicyObjectAlreadyExistsException e) {
                BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName() + " already exists, hence ignored");
            }
            catch (Exception e) {
                BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName() + " could not be processed due to : " + e.getMessage());
                throw new BPMOrganizationException(e);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ApplicationRoleOrgUnitCalendarAssociations importAssociations(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociations associations, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        ApplicationRoleOrgUnitCalendarAssociations retAssociations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
        try {
            List appRoleOUCalAssocList = new ArrayList();
            appRoleOUCalAssocList = associations.getApplicationRoleOrgUnitCalendarAssociation();
            ArrayList<ApplicationRoleOrgUnitCalendarAssociation> retList = new ArrayList<ApplicationRoleOrgUnitCalendarAssociation>();
            if (appRoleOUCalAssocList != null) {
                for (ApplicationRoleOrgUnitCalendarAssociation association : appRoleOUCalAssocList) {
                    try {
                        if (!this.isAssociationExists(ctx, association)) {
                            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, association.getApplicationRoleOrgUnitCalendarAssociationId());
                            this.createApplicationRoleOrgUnitCalendarAssociation(ctx, association, unitOfWorkHolder);
                            continue;
                        }
                        BPMOrganizationUtil.debugLog(CLASS_NAME, "importOrganization", "ApplicationRoleOrgUnitCalendarAssociation " + association.getApplicationRoleOrgUnitCalendarAssociationId() + " already exists");
                    }
                    catch (Exception e) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importAssociations", "error while importing ApplicationRoleOrgUnitCalendarAssociation: " + association.getApplicationRoleOrgUnitCalendarAssociationId(), e);
                        retList.add(association);
                    }
                }
            }
            if (retList != null) {
                retAssociations.getApplicationRoleOrgUnitCalendarAssociation().addAll(retList);
            }
            return retAssociations;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importAssociations", "error while importing ApplicationRoleOrgUnitCalendarAssociations", e);
            return retAssociations;
        }
    }

    private HolidayRules importHolidayRules(IBPMContext ctx, HolidayRules holidayRules, boolean validate, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        HolidayRules retHolidayRules = this.objectFactory.createHolidayRules();
        List holidayRuleList = new ArrayList();
        holidayRuleList = holidayRules.getHolidayRule();
        ArrayList<HolidayRule> retList = new ArrayList<HolidayRule>();
        if (holidayRuleList != null) {
            for (HolidayRule holidayRule : holidayRuleList) {
                try {
                    if (!this.isExistsHolidayRule(ctx, holidayRule)) {
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, holidayRule.getName());
                        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
                        calSrv.createHolidayRule(ctx, holidayRule, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "HolidayRule: " + holidayRule.getName() + " adlready exists");
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, holidayRule.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importHolidayRules", "error while importing HolidayRule: " + holidayRule.getName(), e);
                        retList.add(holidayRule);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retList != null) {
            retHolidayRules.getHolidayRule().addAll(retList);
        }
        return retHolidayRules;
    }

    private CalendarRules importCalendarRules(IBPMContext ctx, CalendarRules calendarRules, boolean validate, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        CalendarRules retCalendarRules = this.objectFactory.createCalendarRules();
        List calendarRuleList = new ArrayList();
        calendarRuleList = calendarRules.getCalendarRule();
        ArrayList<CalendarRule> retList = new ArrayList<CalendarRule>();
        if (calendarRuleList != null) {
            for (CalendarRule calendarRule : calendarRuleList) {
                try {
                    if (!this.isExistsCalendarRule(ctx, calendarRule)) {
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, calendarRule.getName());
                        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
                        calSrv.createCalendarRule(ctx, calendarRule, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "calendarRule: " + calendarRule.getName() + " adlready exists");
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, calendarRule.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importCalendarRules", "error while importing calendarRule: " + calendarRule.getName(), e);
                        retList.add(calendarRule);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retList != null) {
            retCalendarRules.getCalendarRule().addAll(retList);
        }
        return retCalendarRules;
    }

    private ParticipantPropertyList importParticipantProperty(IBPMContext ctx, ParticipantPropertyList participantPropertyList) throws BPMOrganizationException {
        ParticipantPropertyList retParticipantPropertyList = this.objectFactory.createParticipantPropertyList();
        try {
            List propertyList = new ArrayList();
            propertyList = participantPropertyList.getParticipantProperty();
            ArrayList<ParticipantProperty> retList = new ArrayList<ParticipantProperty>();
            if (propertyList != null) {
                for (ParticipantProperty property : propertyList) {
                    try {
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, property.getName());
                        this.createParticipantProperty(ctx, property);
                    }
                    catch (Exception e) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importParticipantProperty", "error importing ParticipantProperty: " + property.getName(), e);
                        retList.add(property);
                    }
                }
            }
            if (retList != null) {
                retParticipantPropertyList.getParticipantProperty().addAll(retList);
            }
            return retParticipantPropertyList;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importParticipantProperty", "error importing ParticipantPropertyList", e);
            return retParticipantPropertyList;
        }
    }

    private ParticipantPropertiesList importPropertiesOnParticipants(IBPMContext ctx, ParticipantPropertiesList participantPropertiesList) throws BPMOrganizationException {
        ParticipantPropertiesList retParticipantPropertiesList = this.objectFactory.createParticipantPropertiesList();
        try {
            List participantProperties = new ArrayList();
            participantProperties = participantPropertiesList.getParticipantProperties();
            ArrayList<ParticipantProperties> retList = new ArrayList<ParticipantProperties>();
            for (ParticipantProperties pp : participantProperties) {
                try {
                    ArrayList<ParticipantProperties> ppList = new ArrayList<ParticipantProperties>();
                    ppList.add(pp);
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, pp.getParticipant().getName());
                    this.setPropertiesOnParticipants(ctx, ppList);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.errorLog(CLASS_NAME, "importPropertiesOnParticipants", "error importing properties for participant: " + pp.getParticipant(), e);
                    retList.add(pp);
                }
            }
            if (retList != null) {
                retParticipantPropertiesList.getParticipantProperties().addAll(retList);
            }
            return retParticipantPropertiesList;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importPropertiesOnParticipants", "error importing ParticipantPropertiesList", e);
            return retParticipantPropertiesList;
        }
    }

    private boolean isAssociationExists(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation association) throws BPMOrganizationException {
        try {
            Object associations = null;
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("id").equal((Object)association.getApplicationRoleOrgUnitCalendarAssociationId());
            Vector<Object> results = this.bpmOrganizationPersistency.executeQuery(ctx, BpmAppRoleOuCalAssoc.class, expression);
            return results != null && !results.isEmpty();
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private boolean isAppRoleExists(IBPMContext ctx, String appRoleName, String appID) throws BPMOrganizationException {
        try {
            List<BPMAppRole> list = AppRoleUtil.getInstance().getAppRoles(appRoleName, appID);
            return !list.isEmpty();
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "isAppRoleExists", "App Roles does not exists", e);
            return false;
        }
    }

    private boolean isLogicalPeopleGroupExists(IBPMContext ctx, LogicalPeopleGroup logicalPeopleGroup) throws BPMOrganizationException {
        List<LogicalPeopleGroup> listOfLogicalPeopleGroup = this.searchLogicalPeopleGroups(ctx, SearchModeTypeEnum.EQUALS, logicalPeopleGroup.getName(), 0, -1);
        return listOfLogicalPeopleGroup != null && listOfLogicalPeopleGroup.size() != 0;
    }

    private boolean isOrgUnitExists(IBPMContext ctx, OrganizationalUnit orgUnit) throws BPMOrganizationException {
        List orgUnitList = this.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.EQUALS, orgUnit.getOrganizationalUnitName(), 0, -1, null);
        return orgUnitList != null && orgUnitList.size() > 0;
    }

    private boolean isExistsCalendarRule(IBPMContext ctx, CalendarRule calendarRule) throws BPMOrganizationException {
        List calendarRuleList = this.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.EQUALS, calendarRule.getName(), 0, -1, null);
        return calendarRuleList != null && calendarRuleList.size() > 0;
    }

    private boolean isExistsHolidayRule(IBPMContext ctx, HolidayRule holidayRule) throws BPMOrganizationException {
        List holidayRuleList = this.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.EQUALS, holidayRule.getName(), 0, -1, null);
        return holidayRuleList != null && holidayRuleList.size() > 0;
    }

    private void validateOUMembers(OrganizationalUnit orgUnit) {
        try {
            List managedByMemberList = orgUnit.getManagedByMember();
            for (int i = 0; i < managedByMemberList.size(); ++i) {
                try {
                    boolean validMember = this.validateMember((MemberType)managedByMemberList.get(i));
                    if (validMember) continue;
                    managedByMemberList.remove(i);
                    --i;
                    continue;
                }
                catch (Exception e) {
                    BPMOrganizationUtil.errorLog(CLASS_NAME, "validateOUMembers", "OUMember " + ((MemberType)managedByMemberList.get(i)).getName() + " does not exist  in the identity store", e);
                    managedByMemberList.remove(i);
                    --i;
                }
            }
            List memberList = orgUnit.getMember();
            for (int i = 0; i < memberList.size(); ++i) {
                try {
                    boolean validMember = this.validateMember((MemberType)memberList.get(i));
                    if (validMember) continue;
                    memberList.remove(i);
                    --i;
                    continue;
                }
                catch (Exception e) {
                    BPMOrganizationUtil.errorLog(CLASS_NAME, "validateOUMembers", "OUMember " + ((MemberType)memberList.get(i)).getName() + " does not exist  in the identity store", e);
                    memberList.remove(i);
                    --i;
                }
            }
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrgUnits", "exceptions while importing orgunits", e);
        }
    }

    private void createAppRoleInternal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, String optionalDisplayName, String optionalDesc) throws BPMIdentityException, PolicyObjectAlreadyExistsException, PolicyStoreException, PrivilegedActionException, Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n displayName=" + optionalDisplayName + "\n description=" + optionalDesc));
        this.validateBPMOperation(ctx, 12);
        AppRoleUtil.getInstance().createAppRole(appCtx, appRoleName, optionalDisplayName, optionalDesc);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createAppRole", (String)"Completed.");
    }

    private void grantAppRoleToPrincipalInternal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Participant participant) throws PolicyObjectAlreadyExistsException, ApplicationRoleInUseException, PolicyObjectNotFoundException, PolicyStoreException, NullPointerException, PrivilegedActionException, Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n participant=" + participant));
        if (!this.validateIsBPMComposerAdmin(ctx)) {
            this.validateBPMOperation(ctx, 12);
        }
        AppRoleUtil.getInstance().grantAppRoleToPrincipal(appCtx, appRoleName, participant);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)"Completed.");
    }

    private String getProcessNameList(List<ProcessMetadataSummary> processList) {
        StringBuffer sb = new StringBuffer();
        if (processList == null) {
            return sb.toString();
        }
        for (int i = 0; i < processList.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ProcessMetadataSummary processMetadata = processList.get(i);
            sb.append(processMetadata.getProcessName());
        }
        return sb.toString();
    }

    private void validate(IBPMContext ctx, OrganizationalUnit organizationalUnit, String organizationalUnitId, int operation) throws BPMOrganizationException {
        this.validate(ctx, organizationalUnit, organizationalUnitId, operation, null);
    }

    private void validate(IBPMContext ctx, OrganizationalUnit organizationalUnit, String organizationalUnitId, int operation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        List childrens;
        if ((operation == 11 || operation == 14) && WorkflowUtil.isNull((String)organizationalUnitId)) {
            throw new BPMOrganizationException(70605, null);
        }
        if (operation == 14) {
            try {
                List<ProcessMetadataSummary> processList = this.getActiveOrRetiredProcessMetadataSummaryList(ctx, organizationalUnitId);
                if (processList != null && processList.size() > 0) {
                    throw new BPMOrganizationException(Severity.ERRORS, 70683, new Object[]{organizationalUnitId, this.getProcessNameList(processList)});
                }
            }
            catch (ProcessMetadataServiceException e) {
                throw new BPMOrganizationException((Exception)((Object)e));
            }
        }
        if (operation == 12 || operation == 13) {
            if (organizationalUnit == null) {
                throw new BPMOrganizationException(70605, null);
            }
            organizationalUnitId = organizationalUnit.getOrganizationalUnitId();
        }
        BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
        bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
        Object obj = this.bpmOrganizationPersistency.readObject(ctx, bpmOrganizationalUnit, unitOfWorkHolder);
        if (operation == 11 || operation == 13 || operation == 14) {
            if (obj == null) {
                Object[] objs = new Object[]{organizationalUnitId};
                throw new BPMOrganizationException(70602, objs);
            }
        } else if (operation == 12 && obj != null) {
            Object[] objs = new Object[]{organizationalUnitId};
            throw new BPMOrganizationException(70686, objs);
        }
        if (operation == 12 || operation == 13) {
            if (WorkflowUtil.isNull((String)organizationalUnit.getOrganizationalUnitName())) {
                Object[] objs = new Object[]{organizationalUnit.getOrganizationalUnitId()};
                throw new BPMOrganizationException(70604, objs);
            }
            String parentId = organizationalUnit.getParentOrganizationalUnitId();
            if (parentId != null) {
                OrganizationalUnit parentOU = this.getOrganizationalUnit(ctx, parentId, ChildOrganizationalUnitRetrievalModeTypeEnum.ONLY_FIRST_LEVEL_CHILD, unitOfWorkHolder);
                List children = parentOU.getChildOrganizationalUnits();
                String existingOUID = this.getOUWithSameName(organizationalUnit.getOrganizationalUnitId(), organizationalUnit.getOrganizationalUnitName(), children, operation);
                if (existingOUID != null) {
                    Object[] objs = new Object[]{existingOUID, organizationalUnit.getOrganizationalUnitName()};
                    throw new BPMOrganizationException(70610, objs);
                }
            } else {
                List rootOUList = this.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.LIKE, "%", 0, 0, OrganizationEntitySearchContext.ORGANIZATIONAL_UNIT_ROOT_ORGANIZATIONAL_UNIT);
                String existingOUID = this.getOUWithSameName(organizationalUnit.getOrganizationalUnitId(), organizationalUnit.getOrganizationalUnitName(), rootOUList, operation);
                if (existingOUID != null) {
                    Object[] objs = new Object[]{existingOUID, organizationalUnit.getOrganizationalUnitName()};
                    throw new BPMOrganizationException(70610, objs);
                }
            }
        }
        if (organizationalUnit != null && !WorkflowUtil.isNull((String)organizationalUnit.getCalendarRuleId())) {
            BpmCalendarRule bpmCalendarRule = new BpmCalendarRule();
            bpmCalendarRule.setId(organizationalUnit.getCalendarRuleId());
            bpmCalendarRule = (BpmCalendarRule)this.bpmOrganizationPersistency.readObject(ctx, bpmCalendarRule);
            if (bpmCalendarRule != null) {
                organizationalUnit.setCalendarRuleName(bpmCalendarRule.getName());
            }
        }
        if (organizationalUnit != null && !WorkflowUtil.isNull((String)organizationalUnit.getParentOrganizationalUnitId())) {
            BpmOrganizationalUnit parentBpmOrganizationalUnit = new BpmOrganizationalUnit();
            parentBpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnit.getParentOrganizationalUnitId());
            parentBpmOrganizationalUnit = (BpmOrganizationalUnit)this.bpmOrganizationPersistency.readObject(ctx, parentBpmOrganizationalUnit, unitOfWorkHolder);
            if (parentBpmOrganizationalUnit == null) {
                Object[] objs = new Object[]{organizationalUnit.getParentOrganizationalUnitId()};
                throw new BPMOrganizationException(70603, objs);
            }
            organizationalUnit.setHierarchyPath(parentBpmOrganizationalUnit.getHierarchyPath() + organizationalUnit.getOrganizationalUnitId() + hirearchyPathSeparator);
        } else if (organizationalUnit != null) {
            organizationalUnit.setHierarchyPath(organizationalUnit.getOrganizationalUnitId() + hirearchyPathSeparator);
        }
        if (organizationalUnit != null && CommonUtil.isListNullOrEmpty((List)(childrens = organizationalUnit.getChildOrganizationalUnits()))) {
            for (OrganizationalUnit childOrganizationalUnit : childrens) {
                this.validate(ctx, childOrganizationalUnit, null, operation, unitOfWorkHolder);
            }
        }
    }

    private String getOUWithSameName(String id, String name, List<OrganizationalUnit> list, int operation) {
        for (OrganizationalUnit ou : list) {
            String ouname = ou.getOrganizationalUnitName();
            if (ouname == null || !ouname.equals(name) || operation == 13 && id.equals(ou.getOrganizationalUnitId())) continue;
            return ou.getOrganizationalUnitId();
        }
        return null;
    }

    private void setDefaults(IBPMContext ctx, OrganizationalUnit organizationalUnit, int operation, XMLGregorianCalendar calendar) throws BPMOrganizationException {
        List childrens;
        if (organizationalUnit == null) {
            return;
        }
        if (WorkflowUtil.isNull((String)organizationalUnit.getOrganizationalUnitId())) {
            organizationalUnit.setOrganizationalUnitId(Util.getGuid());
        }
        if (operation == 12) {
            organizationalUnit.setCreatedBy(ctx.getUser());
            if (ctx.getIdentityContext() != null) {
                organizationalUnit.setCreatedByIdentityContext(ctx.getIdentityContext());
            } else {
                organizationalUnit.setCreatedByIdentityContext(DEFAULT_REALM_NAME);
            }
            organizationalUnit.setCreatedDate(calendar);
        }
        organizationalUnit.setLastUpdatedBy(ctx.getUser());
        organizationalUnit.setLastUpdatedDate(calendar);
        if (ctx.getIdentityContext() != null) {
            organizationalUnit.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        } else {
            organizationalUnit.setLastUpdatedByIdentityContext(DEFAULT_REALM_NAME);
        }
        if (operation == 12 || operation == 13) {
            List lpgUsers;
            List users;
            List managers = organizationalUnit.getManagedByMember();
            if (!CommonUtil.isListNullOrEmpty((List)managers)) {
                for (int index = 0; index < managers.size(); ++index) {
                    MemberType manager = (MemberType)managers.get(index);
                    if (manager.getMemberId() != null) continue;
                    manager.setMemberId(Util.getGuid());
                }
            }
            if (!CommonUtil.isListNullOrEmpty((List)(users = organizationalUnit.getMember()))) {
                for (int index = 0; index < users.size(); ++index) {
                    MemberType user = (MemberType)users.get(index);
                    if (user.getMemberId() != null) continue;
                    user.setMemberId(Util.getGuid());
                }
            }
            if (!CommonUtil.isListNullOrEmpty((List)(lpgUsers = organizationalUnit.getPeopleQueryMember()))) {
                for (int index = 0; index < lpgUsers.size(); ++index) {
                    PeopleQueryMemberType peopleQueryUser = (PeopleQueryMemberType)lpgUsers.get(index);
                    if (peopleQueryUser.getMemberId() != null) continue;
                    peopleQueryUser.setMemberId(Util.getGuid());
                }
            }
        }
        if (CommonUtil.isListNullOrEmpty((List)(childrens = organizationalUnit.getChildOrganizationalUnits()))) {
            for (OrganizationalUnit childOrganizationalUnit : childrens) {
                this.setDefaults(ctx, childOrganizationalUnit, operation, calendar);
            }
        }
    }

    private void addChildrens(IBPMContext ctx, OrganizationalUnit organizationalUnit, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode) throws BPMOrganizationException {
        if (ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD == childOrganizationalUnitRetrievalMode) {
            return;
        }
        String sqlQuery = "SELECT * FROM BPM_ORGANIZATIONAL_UNIT WHERE  PARENT_ORGANIZATIONAL_UNIT_ID = '" + organizationalUnit.getOrganizationalUnitId() + "'";
        Vector<Object> childrens = this.bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, sqlQuery);
        if (childrens != null && !childrens.isEmpty()) {
            for (int index = 0; index < childrens.size(); ++index) {
                OrganizationalUnit childrenOrganizationalUnit = (OrganizationalUnit)childrens.get(index);
                organizationalUnit.getChildOrganizationalUnits().add(childrenOrganizationalUnit);
                if (ChildOrganizationalUnitRetrievalModeTypeEnum.ONLY_FIRST_LEVEL_CHILD == childOrganizationalUnitRetrievalMode) continue;
                this.addChildrens(ctx, childrenOrganizationalUnit, childOrganizationalUnitRetrievalMode);
            }
        } else {
            return;
        }
    }

    private void validate(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, String applicationRoleOrgUnitCalendarAssociationId, int operation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String ouId;
        String calRuleId;
        if (operation == 12 || operation == 13) {
            if (applicationRoleOrgUnitCalendarAssociation == null) {
                throw new BPMOrganizationException(70607, null);
            }
            if (WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId())) {
                throw new BPMOrganizationException(70606, null);
            }
        }
        if (operation == 14 && WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociationId)) {
            throw new BPMOrganizationException(70606, null);
        }
        if (!(operation != 12 && operation != 13 || applicationRoleOrgUnitCalendarAssociation.getApplicationRole() != null && applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getName() != null && !applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getName().trim().isEmpty())) {
            throw new BPMOrganizationException(70690, null);
        }
        BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc = new BpmAppRoleOuCalAssoc();
        if (operation == 14) {
            bpmAppRoleOuCalAssoc.setId(applicationRoleOrgUnitCalendarAssociationId);
        }
        if (operation == 12 || operation == 13) {
            bpmAppRoleOuCalAssoc.setId(applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId());
        }
        Object obj = this.bpmOrganizationPersistency.readObject(ctx, bpmAppRoleOuCalAssoc, unitOfWorkHolder);
        List<ApplicationRoleOrgUnitCalendarAssociation> existingAssocs = null;
        RoleProfileType roleType = null;
        RoleProfile roleProfile = null;
        if (operation == 12 || operation == 13) {
            roleType = applicationRoleOrgUnitCalendarAssociation.getApplicationRole();
            roleProfile = new RoleProfile(roleType);
            existingAssocs = this.getApplicationRoleOrgUnitCalendarAssociation(ctx, roleProfile);
        }
        if (operation == 13 || operation == 14) {
            if (obj == null) {
                Object[] objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId()};
                throw new BPMOrganizationException(70609, objs);
            }
            if (operation == 13 && existingAssocs != null && existingAssocs.size() > 0) {
                calRuleId = applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId();
                ouId = applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId();
                for (ApplicationRoleOrgUnitCalendarAssociation assoc : existingAssocs) {
                    if (applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId() == assoc.getApplicationRoleOrgUnitCalendarAssociationId()) continue;
                    if (assoc.getCalendarRuleId().equals(calRuleId) && assoc.getOrganizationalUnitId().equals(ouId)) {
                        Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                        throw new BPMOrganizationException(70681, objs);
                    }
                    if (!assoc.getOrganizationalUnitId().equals(ouId)) continue;
                    Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                    throw new BPMOrganizationException(70682, objs);
                }
            }
        } else if (operation == 12) {
            if (obj != null) {
                Object[] objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId()};
                throw new BPMOrganizationException(70681, objs);
            }
            if (existingAssocs != null && existingAssocs.size() > 0) {
                calRuleId = applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId();
                ouId = applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId();
                for (ApplicationRoleOrgUnitCalendarAssociation assoc : existingAssocs) {
                    if (assoc.getCalendarRuleId().equals(calRuleId) && assoc.getOrganizationalUnitId().equals(ouId)) {
                        Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                        throw new BPMOrganizationException(70681, objs);
                    }
                    if (!assoc.getOrganizationalUnitId().equals(ouId)) continue;
                    Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                    throw new BPMOrganizationException(70682, objs);
                }
            }
        }
        if (operation == 12 || operation == 13) {
            Object[] objs;
            if (WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId())) {
                throw new BPMOrganizationException(70607, null);
            }
            BpmCalendarRule bpmCalendarRule = new BpmCalendarRule();
            bpmCalendarRule.setId(applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId());
            bpmCalendarRule = (BpmCalendarRule)this.bpmOrganizationPersistency.readObject(ctx, bpmCalendarRule, unitOfWorkHolder);
            if (bpmCalendarRule == null) {
                objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId()};
                throw new BPMOrganizationException(70601, objs);
            }
            if (WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId())) {
                throw new BPMOrganizationException(70608, null);
            }
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId());
            bpmOrganizationalUnit = (BpmOrganizationalUnit)this.bpmOrganizationPersistency.readObject(ctx, bpmOrganizationalUnit, unitOfWorkHolder);
            if (bpmOrganizationalUnit == null) {
                objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId()};
                throw new BPMOrganizationException(70602, objs);
            }
        }
    }

    private void setDefaults(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, int operation, XMLGregorianCalendar calendar) throws BPMOrganizationException {
        if (applicationRoleOrgUnitCalendarAssociation == null) {
            return;
        }
        if (operation == 12 && WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId())) {
            applicationRoleOrgUnitCalendarAssociation.setApplicationRoleOrgUnitCalendarAssociationId(Util.getGuid());
        }
        if (operation == 12) {
            applicationRoleOrgUnitCalendarAssociation.setCreatedBy(ctx.getUser());
            if (ctx.getIdentityContext() != null) {
                applicationRoleOrgUnitCalendarAssociation.setCreatedByIdentityContext(ctx.getIdentityContext());
            } else {
                applicationRoleOrgUnitCalendarAssociation.setCreatedByIdentityContext(DEFAULT_REALM_NAME);
            }
            applicationRoleOrgUnitCalendarAssociation.setCreatedDate(calendar);
        }
        applicationRoleOrgUnitCalendarAssociation.setLastUpdatedBy(ctx.getUser());
        if (ctx.getIdentityContext() != null) {
            applicationRoleOrgUnitCalendarAssociation.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        } else {
            applicationRoleOrgUnitCalendarAssociation.setLastUpdatedByIdentityContext(DEFAULT_REALM_NAME);
        }
        applicationRoleOrgUnitCalendarAssociation.setLastUpdatedDate(calendar);
    }

    private void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)method, (String)msg);
        }
    }

    private boolean validate(IBPMContext ctx, String processOrgUnitId, List<OrganizationalUnit> organizationalUnits) throws Exception {
        if (processOrgUnitId == null || processOrgUnitId.equals("")) {
            return true;
        }
        for (OrganizationalUnit orgUnit : organizationalUnits) {
            if (!orgUnit.getOrganizationalUnitId().equalsIgnoreCase(processOrgUnitId)) continue;
            return true;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = null;
        expression = builder.get("organizationalUnitId").equalsIgnoreCase(processOrgUnitId);
        Vector<Object> returnList = this.bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, expression);
        return returnList != null && returnList.size() > 0;
    }

    private boolean validateParticipant(Participant participant) throws BPMOrganizationException {
        try {
            return AppRoleUtil.getInstance().validateParticipant(participant);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private boolean validateMember(MemberType member) throws BPMOrganizationException {
        try {
            return AppRoleUtil.getInstance().validateMember(member);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public List<ProcessMetadataSummary> getActiveOrRetiredProcessMetadataSummaryList(IBPMContext context, String organizationalUnitId) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getActiveOrRetiredProcessMetadataSummaryList", (String)("\n context: " + context + "\n organizationalUnitId: " + organizationalUnitId));
        }
        try {
            ProcessMetadataService processMetadataSvc = new ProcessMetadataService();
            List processMetadataSummaryList = processMetadataSvc.listProcessMetadataSummary(context, organizationalUnitId, null, null);
            return this.getActiveOrRetiredProcessMetadataSummaryListForOU(processMetadataSummaryList, organizationalUnitId);
        }
        catch (Exception e) {
            ProcessMetadataServiceException pmse = new ProcessMetadataServiceException(70807, (Object[])new String[0]);
            throw pmse;
        }
    }

    private List<ProcessMetadataSummary> getActiveOrRetiredProcessMetadataSummaryListForOU(List<ProcessMetadataSummary> processMetadataSummaryList, String organizationalUnitId) {
        ArrayList<ProcessMetadataSummary> pmsList = null;
        if (processMetadataSummaryList != null && processMetadataSummaryList.size() > 0 && organizationalUnitId != null && organizationalUnitId.length() > 0) {
            pmsList = new ArrayList<ProcessMetadataSummary>();
            for (int i = 0; i < processMetadataSummaryList.size(); ++i) {
                ProcessMetadataSummary p = processMetadataSummaryList.get(i);
                if (p.getStatus() == null || !p.getStatus().equals((Object)StatusEnum.ACTIVE) && !p.getStatus().equals((Object)StatusEnum.RETIRED) || p.getOrganizationalUnitId() == null || !p.getOrganizationalUnitId().equals(organizationalUnitId)) continue;
                pmsList.add(p);
            }
        }
        if (pmsList != null && !pmsList.isEmpty() && BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getActiveOrRetiredProcessMetadataSummaryListForOU", (String)("\n The organizationalUnitId: " + organizationalUnitId + " is associated with active or retired processes: {" + this.getProcessNameList(pmsList) + "}"));
        }
        return pmsList;
    }
}

