/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.IInternalOrganizationService;
import oracle.bpel.services.workflow.task.impl.Duration;
import oracle.bpel.services.workflow.task.impl.WorkflowInternalOrgSvcImpl;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMCalendarHolidayService;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.persistency.BPMOrganizationPersistency;
import oracle.bpm.services.organization.persistency.model.BpmCalendarRule;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMRole;
import oracle.tip.pc.services.identity.BPMUser;

public class BPMInternalOrganizationService
implements IInternalOrganizationService {
    private static final String CLASS_NAME = "oracle.bpm.services.organization.impl.BPMInternalOrganizationService";
    private static final BPMOrganizationService bpmOrganizationService = new BPMOrganizationService();

    public Duration getCalendarDuration(Task task, Calendar fromDate, Calendar toDate) {
        String METHOD = "getCalendarDuration";
        this.debugLog("getCalendarDuration", "Calculating business duration between 2 dates for the Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", From Date : " + fromDate + ", To Date : " + toDate);
        if (toDate == null || fromDate == null) {
            return null;
        }
        Duration retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                long longDuration = calMgr.getCalendarDuration(fromDate, toDate);
                retVal = new Duration(longDuration);
            }
        }
        catch (Exception e) {
            this.warningLog("getCalendarDuration", e);
        }
        if (retVal == null) {
            this.debugLog("getCalendarDuration", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.getCalendarDuration(task, fromDate, toDate);
        }
        this.debugLog("getCalendarDuration", "Duration : " + toDate.getTime() + " - " + fromDate.getTime() + " = " + retVal);
        return retVal;
    }

    public Calendar addCalendarDuration(Task task, Calendar fromDate, Duration duration) {
        String METHOD = "addCalendarDuration";
        this.debugLog("addCalendarDuration", "Adding 'Duration' to 'From Date' for the Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", From Date : " + fromDate.getTime() + ", Duration : " + duration);
        if (fromDate == null || duration == null) {
            return null;
        }
        Calendar retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                retVal = calMgr.addCalendarDuration(fromDate, duration.getJavaxXMLDatatypeDuration());
            }
        }
        catch (Exception e) {
            this.warningLog("addCalendarDuration", e);
        }
        if (retVal == null) {
            this.debugLog("addCalendarDuration", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.addCalendarDuration(task, fromDate, duration);
        }
        this.debugLog("addCalendarDuration", "Date after adding duration : " + fromDate.getTime() + " + " + duration + " = " + retVal.getTime());
        return retVal;
    }

    public Duration getNextReminderDurationFromAssignedDate(Task task, Calendar now, Calendar assignedDate, Duration duration, int recurrence) {
        String METHOD = "getNextReminderDurationFromAssignedDate";
        this.debugLog("getNextReminderDurationFromAssignedDate", "Calculating next reminder duration for the Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", Now : " + now.getTime() + ", assignedDate : " + assignedDate.getTime() + ", duration : " + duration + ", recurrence : " + recurrence);
        Duration retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                long longDuration = calMgr.getNextReminderDurationFromAssignedDate(now, assignedDate, duration.getJavaxXMLDatatypeDuration(), recurrence);
                retVal = new Duration(longDuration);
            }
        }
        catch (Exception e) {
            this.warningLog("getNextReminderDurationFromAssignedDate", e);
        }
        if (retVal == null) {
            this.debugLog("getNextReminderDurationFromAssignedDate", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.getNextReminderDurationFromRelativeDate(task, now, assignedDate, duration, recurrence);
        }
        this.debugLog("getNextReminderDurationFromAssignedDate", "Next reminder duration : " + retVal);
        return retVal;
    }

    public Duration getNextReminderDurationFromRelativeDate(Task task, Calendar now, Calendar relativeDate, Duration duration, int recurrence) {
        String METHOD = "getNextReminderDurationFromRelativeDate";
        this.debugLog("getNextReminderDurationFromRelativeDate", "Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", Now : " + now.getTime() + ", relativeDate : " + relativeDate.getTime() + ", duration : " + duration + ", recurrence : " + recurrence);
        Duration retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                long longDuration = calMgr.getNextReminderDurationFromRelativeDate(now, relativeDate, duration.getJavaxXMLDatatypeDuration(), recurrence);
                retVal = new Duration(longDuration);
            }
        }
        catch (Exception e) {
            this.warningLog("getNextReminderDurationFromRelativeDate", e);
        }
        if (retVal == null) {
            this.debugLog("getNextReminderDurationFromRelativeDate", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.getNextReminderDurationFromRelativeDate(task, now, relativeDate, duration, recurrence);
        }
        this.debugLog("getNextReminderDurationFromRelativeDate", "Next reminder duration : " + retVal);
        return retVal;
    }

    public String getAppRoleToUseForCalendarSearch(Task task) throws BPMIdentityException {
        IdentityType idType;
        String METHOD = "getAppRoleToUseForCalendarSearch";
        String appRoleToUse = null;
        List assignees = task.getSystemAttributes().getAssignees();
        if (assignees != null && assignees.size() == 1 && "application_role".equals((idType = (IdentityType)assignees.get(0)).getType())) {
            appRoleToUse = idType.getId();
            this.debugLog("getAppRoleToUseForCalendarSearch", "The task's assingee list contains just one AppRole : " + appRoleToUse + ". Hence using it.");
            return appRoleToUse;
        }
        String identityContext = task.getIdentityContext();
        BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityContext);
        String acquiredByUser = task.getSystemAttributes().getAcquiredBy();
        if (assignees != null && !BPMInternalOrganizationService.isNull(acquiredByUser)) {
            this.debugLog("getAppRoleToUseForCalendarSearch", "The task's assingee list contains multiple users/groups/AppRoles, but the task is acquired by user : " + acquiredByUser + ", Hence trying to find out the AppRole of " + acquiredByUser + " within task's assignee list.");
            BPMUser bpmAcquiredByUser = as.lookupUser(acquiredByUser);
            String applicationContext = task.getApplicationContext();
            for (int i = 0; i < assignees.size(); ++i) {
                BPMAppRole appRole;
                IdentityType idType2 = (IdentityType)assignees.get(i);
                if (!"application_role".equals(idType2.getType()) || (appRole = as.lookupAppRole(idType2.getId(), applicationContext)) == null || !bpmAcquiredByUser.isInRole((BPMRole)appRole)) continue;
                appRoleToUse = idType2.getId();
                this.debugLog("getAppRoleToUseForCalendarSearch", "Found that " + acquiredByUser + " belongs to AppRole : " + appRoleToUse + ". Hence using it.");
                return appRoleToUse;
            }
        } else {
            this.debugLog("getAppRoleToUseForCalendarSearch", "The task's assingee list contains multiple users/groups/AppRoles, but not acquired by a user.Hence did not find AppRole to use for searching 'AppRole-Organizational Unit-Calendar' association.");
        }
        return appRoleToUse;
    }

    public String searchAppRoleGrantHirarchyBottomUpForCalendar(IBPMContext ctx, String applicationContext, BPMOrganizationService svc, String orgUnitId, String appRole) throws BPMOrganizationException, BPMIdentityException {
        String METHOD = "searchAppRoleGrantHirarchyBottomUpForCalendar";
        this.debugLog("searchAppRoleGrantHirarchyBottomUpForCalendar", "Searching 'AppRole-Organizational Unit-Calendar' association with (OrgUnit, AppRole) : (" + orgUnitId + ", " + appRole + ")");
        boolean direct = true;
        if (BPMInternalOrganizationService.isNull(orgUnitId) || BPMInternalOrganizationService.isNull(appRole)) {
            return null;
        }
        String calRulId = null;
        calRulId = this.getCalendarRuleIdForRole(ctx, applicationContext, orgUnitId, appRole);
        if (BPMInternalOrganizationService.isNull(calRulId)) {
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance();
            BPMAppRole bpmAppRole = as.lookupAppRole(appRole, applicationContext);
            List grantedRoles = bpmAppRole.getAppRoles(direct, applicationContext);
            this.debugLog("searchAppRoleGrantHirarchyBottomUpForCalendar", "Did not find any calendar associated. Hence would be searching the 'AppRole-Organizational Unit-Calendar' association using AppRoles : " + this.debugAppRoleString(grantedRoles) + ". These are the AppRoles to which AppRole : " + appRole + " belongs.");
            if (grantedRoles != null) {
                BPMAppRole role;
                Iterator i$ = grantedRoles.iterator();
                while (i$.hasNext() && BPMInternalOrganizationService.isNull(calRulId = this.searchAppRoleGrantHirarchyBottomUpForCalendar(ctx, applicationContext, svc, orgUnitId, (role = (BPMAppRole)i$.next()).getName()))) {
                }
            }
        }
        this.debugLog("searchAppRoleGrantHirarchyBottomUpForCalendar", "Found 'AppRole-Organizational Unit-Calendar' association (OrgUnit, AppRole, Calendar) : (" + orgUnitId + ", " + appRole + ", " + calRulId + ")");
        return calRulId;
    }

    public String searchOUTreeBottomUpForCalendar(IBPMContext ctx, BPMOrganizationService svc, String orgUnitId) throws BPMOrganizationException {
        String METHOD = "searchOUTreeBottomUpForCalendar";
        OrganizationalUnit ou = null;
        ou = svc.getOrganizationalUnit(ctx, orgUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
        if (ou == null) {
            this.debugLog("searchOUTreeBottomUpForCalendar", "Organizational Unit with ID " + orgUnitId + " not found.");
            return null;
        }
        this.setOrganizationalCalendar(ou);
        String calRulId = null;
        this.debugLog("searchOUTreeBottomUpForCalendar", "Considering Organization Unit : " + ou.getOrganizationalUnitName() + " (" + orgUnitId + ")");
        calRulId = ou.getCalendarRuleId();
        if (BPMInternalOrganizationService.isNull(calRulId)) {
            this.debugLog("searchOUTreeBottomUpForCalendar", "No Calendar found. Hence considering parent");
            String parentOrgUnitId = ou.getParentOrganizationalUnitId();
            if (!BPMInternalOrganizationService.isNull(parentOrgUnitId)) {
                calRulId = this.searchOUTreeBottomUpForCalendar(ctx, svc, parentOrgUnitId);
            } else {
                this.debugLog("searchOUTreeBottomUpForCalendar", "No Calendar was found in Organizational tree");
            }
        } else {
            this.debugLog("searchOUTreeBottomUpForCalendar", "Found Calendar : " + ou.getCalendarRuleName() + " (" + calRulId + ")");
        }
        return calRulId;
    }

    public void setOrganizationalCalendar(OrganizationalUnit ou) throws BPMOrganizationException {
        String METHOD = "setOrganizationalCalendar";
        StringBuffer sqlQuery = new StringBuffer("SELECT BPM_CALENDAR_RULE.ID, BPM_CALENDAR_RULE.NAME, BPM_CALENDAR_RULE.TIME_ZONE_ID from BPM_CALENDAR_RULE, BPM_ORGANIZATIONAL_UNIT where BPM_ORGANIZATIONAL_UNIT.CALENDAR_RULE_ID = BPM_CALENDAR_RULE.ID AND BPM_ORGANIZATIONAL_UNIT.ORGANIZATIONAL_UNIT_ID = '");
        sqlQuery.append(ou.getOrganizationalUnitId());
        sqlQuery.append("'");
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        Vector<Object> childrens = bpmOrganizationPersistency.executeQuery(null, BpmCalendarRule.class, sqlQuery.toString());
        if (childrens != null && !childrens.isEmpty()) {
            CalendarRule calendarRule = (CalendarRule)childrens.get(0);
            ou.setCalendarRuleId(calendarRule.getId());
            ou.setCalendarRuleName(calendarRule.getName());
        }
    }

    public String getCalendarRuleIdForRole(IBPMContext ctx, String applicationContext, String orgUnitId, String appRole) throws BPMOrganizationException {
        String METHOD = "getCalendarRuleIdForRole";
        this.debugLog("getCalendarRuleIdForRole", "Finding Calendar associated with Organizational Unit : " + orgUnitId + " and AppRole : " + appRole);
        StringBuffer sqlQuery = new StringBuffer("SELECT CALENDAR_RULE_ID from BPM_APP_ROLE_OU_CAL_ASSOC where APPLICATION_ROLE_NAME = '").append(appRole).append("' AND IDENTITY_CONTEXT = '").append(applicationContext).append("' AND ORGANIZATIONAL_UNIT_ID = '").append(orgUnitId).append("'");
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        Vector<Object> childrens = bpmOrganizationPersistency.executeQuery(null, BpmCalendarRule.class, sqlQuery.toString());
        String calendarId = null;
        if (childrens != null && !childrens.isEmpty()) {
            CalendarRule calendarRule = (CalendarRule)childrens.get(0);
            calendarId = calendarRule.getId();
        }
        this.debugLog("getCalendarRuleIdForRole", "Found Calendar with id : " + calendarId);
        return calendarId;
    }

    public List<String> getOrganizationalUnitForUser(String userId, String identityContext, boolean direct) {
        ArrayList<String> allOrganizationalUnitIdList = new ArrayList<String>();
        try {
            List<OrganizationalUnit> queriedOrganizationalUnits = bpmOrganizationService.getOrganizationalUnitForUser(BPMInternalOrganizationService.getInternalBPMContext(), userId, identityContext, direct);
            if (queriedOrganizationalUnits != null && !queriedOrganizationalUnits.isEmpty()) {
                for (int index = 0; index < queriedOrganizationalUnits.size(); ++index) {
                    OrganizationalUnit queriedOrganizationalUnit = queriedOrganizationalUnits.get(index);
                    allOrganizationalUnitIdList.add(queriedOrganizationalUnit.getOrganizationalUnitId());
                }
            }
        }
        catch (BPMOrganizationException e) {
            e.printStackTrace();
        }
        return allOrganizationalUnitIdList;
    }

    private static IBPMContext getInternalBPMContext() throws BPMOrganizationException {
        try {
            IBPMContext ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw new BPMOrganizationException(orgEx);
            }
            throw new BPMOrganizationException((Exception)pae);
        }
    }

    private static boolean isNull(String str) {
        return str == null || str.trim().equals("");
    }

    private CalendarRule getCalendarRuleToUse(IBPMContext ctx, Task task) throws BPMOrganizationException {
        String METHOD = "getCalendarRuleToUse";
        this.debugLog("getCalendarRuleToUse", "Finding Business Calendar to use.");
        CalendarRule calRul = null;
        String orgUnitId = task.getSystemAttributes().getOrganizationalUnitId();
        String appRoleToUse = null;
        try {
            this.debugLog("getCalendarRuleToUse", "Finding the AppRole to use for searching 'AppRole-Organizational Unit-Calendar' association.");
            appRoleToUse = this.getAppRoleToUseForCalendarSearch(task);
        }
        catch (Exception e) {
            this.warningLog("getCalendarRuleToUse", e);
            this.debugLog("getCalendarRuleToUse", "Could not determine the Approle to use for calendar search. Due to exception :" + e.getMessage());
        }
        String calRulId = null;
        if (!BPMInternalOrganizationService.isNull(appRoleToUse) && !BPMInternalOrganizationService.isNull(orgUnitId)) {
            try {
                this.debugLog("getCalendarRuleToUse", "Searching 'AppRole-Organizational Unit-Calendar' association for Calendar associated with AppRole : " + appRoleToUse + ", and Organizational Unit : " + orgUnitId);
                calRulId = this.searchAppRoleGrantHirarchyBottomUpForCalendar(ctx, task.getApplicationContext(), bpmOrganizationService, orgUnitId, appRoleToUse);
            }
            catch (Exception e) {
                this.warningLog("getCalendarRuleToUse", e);
                this.debugLog("getCalendarRuleToUse", "Could not search AppRole Hirarchy for Calendar association due to exception : " + e.getMessage() + ". \n Continuing with Organizational tree search for Calendar association");
            }
        }
        if (BPMInternalOrganizationService.isNull(calRulId) && !BPMInternalOrganizationService.isNull(orgUnitId)) {
            try {
                this.debugLog("getCalendarRuleToUse", "Searching Organizational tree Hirarchy for Calendar association.");
                calRulId = this.searchOUTreeBottomUpForCalendar(ctx, bpmOrganizationService, orgUnitId);
            }
            catch (BPMOrganizationException boe) {
                this.warningLog("getCalendarRuleToUse", (Exception)((Object)boe));
                this.debugLog("getCalendarRuleToUse", "Could not search Organizational tree for Calendar association due to exception : " + boe.getMessage());
            }
        }
        if (!BPMInternalOrganizationService.isNull(calRulId)) {
            calRul = bpmOrganizationService.getCalendarRule(ctx, calRulId);
        }
        this.debugLog("getCalendarRuleToUse", "OUT : Calendar Rule Id : " + calRulId);
        return calRul;
    }

    private HolidayRule getHolidayRuleToUse(IBPMContext ctx, CalendarRule cal) throws BPMOrganizationException {
        String holRulId = cal.getHolidayRuleId();
        if (holRulId == null || holRulId.trim().equals("")) {
            return null;
        }
        return BPMCalendarHolidayService.getInstance().getHolidayRule(ctx, holRulId);
    }

    private void warningLog(String method, Exception e) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.WARNING)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)method, (Throwable)e);
        }
    }

    private void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)method, (String)msg);
        }
    }

    private String debugAppRoleString(List<BPMAppRole> grantedRoles) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            if (grantedRoles == null) {
                return "None";
            }
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            for (BPMAppRole role : grantedRoles) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(role.getName());
            }
            return buf.toString();
        }
        return "null";
    }
}

