/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.AppRoleUtil;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.calendar.CalendarUtil;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.CalendarRuleList;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayRuleList;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMOrganizationPersistency;
import oracle.bpm.services.organization.persistency.model.BpmCalendarRule;
import oracle.bpm.services.organization.persistency.model.BpmHolidayRule;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;

public class BPMCalendarHolidayService {
    private BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
    private static BPMCalendarHolidayService instance;
    private static final String CLASSNAME = "oracle.bpm.services.organization.impl.BPMCalendarHolidayService";
    private static String DEFAULT_REALM_NAME;
    private static String DEFAULT_TIME_ZONE;

    private BPMCalendarHolidayService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPMCalendarHolidayService getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<BPMCalendarHolidayService> clazz = BPMCalendarHolidayService.class;
        synchronized (BPMCalendarHolidayService.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new BPMCalendarHolidayService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<Object> searchCalendarRule(IBPMContext ctx, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        String METHOD = "searchCalendarRule";
        this.debugLog("searchCalendarRule", "Searching Calendars. Parameters : searchMode : " + searchMode + ", searchCriteria : " + searchCriteria + ", startRow : " + startRow + ", endRow : " + endRow);
        Vector<Object> returnList = null;
        try {
            String searchString = searchCriteria;
            if (SearchModeTypeEnum.STARTS_WITH == searchMode) {
                searchString = searchCriteria + "%";
            } else if (SearchModeTypeEnum.ENDS_WITH == searchMode) {
                searchString = "%" + searchCriteria;
            } else if (SearchModeTypeEnum.CONTAINS == searchMode) {
                searchString = "%" + searchCriteria + "%";
            } else if (SearchModeTypeEnum.EQUALS == searchMode) {
                searchString = searchCriteria;
            } else if (SearchModeTypeEnum.LIKE == searchMode) {
                searchString = searchCriteria;
            }
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = SearchModeTypeEnum.EQUALS == searchMode ? builder.get("name").equalsIgnoreCase(searchString) : builder.get("name").likeIgnoreCase(searchString);
            returnList = this.bpmOrganizationPersistency.executeQuery(ctx, BpmCalendarRule.class, expression);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "searchCalendarRule");
            exCtx.setErrorCode(70650);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{searchMode, searchCriteria});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        this.debugLog("searchCalendarRule", "Searched Calendars : ", returnList);
        return returnList;
    }

    public CalendarRuleList searchCalendarRuleList(IBPMContext ctx, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        String METHOD = "searchCalendarRuleList";
        List<Object> calList = this.searchCalendarRule(ctx, searchMode, searchCriteria, startRow, endRow);
        ObjectFactory of = new ObjectFactory();
        CalendarRuleList retCalList = of.createCalendarRuleList();
        List retList = retCalList.getCalendarRule();
        if (calList != null && calList.size() > 0) {
            retList.addAll(calList);
        }
        return retCalList;
    }

    public CalendarRule getCalendarRule(IBPMContext ctx, String calendarID) throws BPMOrganizationException {
        String METHOD = "getCalendarRule";
        this.debugLog("getCalendarRule", "Fetching Calendar : calendarID: " + calendarID);
        try {
            BpmCalendarRule bpmCal = new BpmCalendarRule();
            bpmCal.setId(calendarID);
            Object object = this.bpmOrganizationPersistency.read(ctx, bpmCal);
            if (object == null) {
                this.debugLog("getCalendarRule", "No Object found for id : " + calendarID);
                return null;
            }
            CalendarRule calRul = (CalendarRule)object;
            this.debugLog("getCalendarRule", "Fetched Calendar : " + calRul);
            return calRul;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getCalendarRule");
            exCtx.setErrorCode(70652);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{calendarID});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    public CalendarRule createCalendarRule(IBPMContext ctx, CalendarRule cal, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createCalendarRule";
        String calendarName = null;
        this.debugLog("createCalendarRule", "Creating Calendar : ", cal);
        try {
            calendarName = cal.getName();
            this.prepareCalendarRuleForPersistency(ctx, cal, true);
            this.bpmOrganizationPersistency.insert(ctx, cal, unitOfWorkHolder);
            this.debugLog("createCalendarRule", "Created Calendar : ", cal);
            return cal;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "createCalendarRule");
            exCtx.setErrorCode(70654);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{calendarName});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    public CalendarRule updateCalendarRule(IBPMContext ctx, CalendarRule updatedCalendar) throws BPMOrganizationException {
        String METHOD = "updateCalendarRule";
        this.debugLog("updateCalendarRule", "Updating Calendar : ", updatedCalendar);
        String calendarName = null;
        try {
            calendarName = updatedCalendar.getName();
            this.prepareCalendarRuleForPersistency(ctx, updatedCalendar, false);
            this.bpmOrganizationPersistency.update(ctx, updatedCalendar);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "updateCalendarRule");
            exCtx.setErrorCode(70656);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{calendarName});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        this.debugLog("updateCalendarRule", "Updated Calendar : ", updatedCalendar);
        return updatedCalendar;
    }

    public void deleteCalendarRule(IBPMContext ctx, String calendarID, boolean force) throws BPMOrganizationException {
        String METHOD = "deleteCalendarRule";
        this.debugLog("deleteCalendarRule", "Deleting Calendar : calendarID: " + calendarID + ", force : " + force);
        try {
            BpmCalendarRule bpmCal = new BpmCalendarRule();
            bpmCal.setId(calendarID);
            Object object = this.bpmOrganizationPersistency.read(ctx, bpmCal);
            if (object != null) {
                CalendarRule calRul = (CalendarRule)object;
                this.handleReferencesToCalendarBeingDeleted(calRul, force);
                this.bpmOrganizationPersistency.delete(ctx, calRul);
                this.debugLog("deleteCalendarRule", "Deleted Calendar : ", calRul);
                return;
            }
            this.debugLog("deleteCalendarRule", "No objects found for id " + calendarID);
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "deleteCalendarRule");
            exCtx.setErrorCode(70622);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{calendarID});
            throw new BPMOrganizationException(exCtx);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "deleteCalendarRule");
            exCtx.setErrorCode(70658);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{calendarID});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    public List<Object> searchHolidayRule(IBPMContext ctx, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        String METHOD = "searchHolidayRule";
        this.debugLog("searchHolidayRule", "Searching Holiday Rules. Parameters : searchMode: " + searchMode + ", searchCriteria: " + searchCriteria + ", startRow: " + startRow + ", endRow: " + endRow);
        Vector<Object> returnList = null;
        try {
            String searchString = searchCriteria;
            if (SearchModeTypeEnum.STARTS_WITH == searchMode) {
                searchString = searchCriteria + "%";
            } else if (SearchModeTypeEnum.ENDS_WITH == searchMode) {
                searchString = "%" + searchCriteria;
            } else if (SearchModeTypeEnum.CONTAINS == searchMode) {
                searchString = "%" + searchCriteria + "%";
            } else if (SearchModeTypeEnum.EQUALS == searchMode) {
                searchString = searchCriteria;
            } else if (SearchModeTypeEnum.LIKE == searchMode) {
                searchString = searchCriteria;
            }
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = SearchModeTypeEnum.EQUALS == searchMode ? builder.get("name").equalsIgnoreCase(searchString) : builder.get("name").likeIgnoreCase(searchString);
            returnList = this.bpmOrganizationPersistency.executeQuery(ctx, BpmHolidayRule.class, expression);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "searchHolidayRule");
            exCtx.setErrorCode(70651);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{searchMode, searchCriteria});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        this.debugLog("searchHolidayRule", "Searched Holiday Rules : ", returnList);
        return returnList;
    }

    public HolidayRuleList searchHolidayRuleList(IBPMContext ctx, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        List<Object> holList = this.searchHolidayRule(ctx, searchMode, searchCriteria, startRow, endRow);
        ObjectFactory of = new ObjectFactory();
        HolidayRuleList retHolList = of.createHolidayRuleList();
        List retList = retHolList.getHolidayRule();
        if (holList != null && holList.size() > 0) {
            retList.addAll(holList);
        }
        return retHolList;
    }

    public HolidayRule getHolidayRule(IBPMContext ctx, String holidayRuleId) throws BPMOrganizationException {
        String METHOD = "getHolidayRule";
        this.debugLog("getHolidayRule", "Fetching Holiday Rule : holidayRuleId: " + holidayRuleId);
        try {
            BpmHolidayRule bpmHol = new BpmHolidayRule();
            bpmHol.setId(holidayRuleId);
            Object object = this.bpmOrganizationPersistency.read(ctx, bpmHol);
            if (bpmHol == null) {
                this.debugLog("getHolidayRule", "No Objects found for id : " + holidayRuleId);
                return null;
            }
            HolidayRule holRul = (HolidayRule)object;
            this.debugLog("getHolidayRule", "Fetched Holiday Rule : ", holRul);
            return holRul;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getHolidayRule");
            exCtx.setErrorCode(70653);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{holidayRuleId});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    public HolidayRule createHolidayRule(IBPMContext ctx, HolidayRule holidayRule, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createHolidayRule";
        String holidayRulName = null;
        this.debugLog("createHolidayRule", "Creating Holiday Rule : ", holidayRule);
        try {
            holidayRulName = holidayRule.getName();
            this.prepareHolidayRuleForPersistency(ctx, holidayRule, true);
            this.bpmOrganizationPersistency.insert(ctx, holidayRule, unitOfWorkHolder);
            this.debugLog("createHolidayRule", "Created Holiday Rule : ", holidayRule);
            return holidayRule;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "createHolidayRule");
            exCtx.setErrorCode(70655);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{holidayRulName});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    public HolidayRule updateHolidayRule(IBPMContext ctx, HolidayRule updatedHolidayRule) throws BPMOrganizationException {
        String METHOD = "updateHolidayRule";
        this.debugLog("updateHolidayRule", "Updating Holiday Rule : ", updatedHolidayRule);
        String holidayRulName = null;
        try {
            holidayRulName = updatedHolidayRule.getName();
            this.prepareHolidayRuleForPersistency(ctx, updatedHolidayRule, false);
            this.bpmOrganizationPersistency.update(ctx, updatedHolidayRule);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "updateHolidayRule");
            exCtx.setErrorCode(70657);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{holidayRulName});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        this.debugLog("updateHolidayRule", "Updated Holiday Rule : ", updatedHolidayRule);
        return updatedHolidayRule;
    }

    public void deleteHolidayRule(IBPMContext ctx, String holidayRuleId, boolean force) throws BPMOrganizationException {
        String METHOD = "deleteHolidayRule";
        this.debugLog("deleteHolidayRule", "Deleting Holiday Rule : holidayRuleId: " + holidayRuleId + ", force: " + force);
        try {
            BpmHolidayRule bpmHol = new BpmHolidayRule();
            bpmHol.setId(holidayRuleId);
            Object object = this.bpmOrganizationPersistency.read(ctx, bpmHol);
            if (object != null) {
                HolidayRule holRul = (HolidayRule)object;
                this.handleReferencesToHolidayRuleBeingDeleted(holRul, force);
                this.bpmOrganizationPersistency.delete(ctx, holRul);
                this.debugLog("deleteHolidayRule", "Deleted Holiday Rule : " + holRul);
                return;
            }
            this.debugLog("deleteHolidayRule", "No objects found for id " + holidayRuleId);
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "deleteHolidayRule");
            exCtx.setErrorCode(70623);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{holidayRuleId});
            throw new BPMOrganizationException(exCtx);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "deleteHolidayRule");
            exCtx.setErrorCode(70659);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{holidayRuleId});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    private void handleReferencesToCalendarBeingDeleted(CalendarRule calRul, boolean force) throws BPMOrganizationException {
        String METHOD = "handleReferencesToCalendarBeingDeleted";
        this.debugLog("handleReferencesToCalendarBeingDeleted", "Checking for references before deleting...");
        try {
            Vector OUs = this.bpmOrganizationPersistency.getOrgUnitsReferringCalendar(calRul.getId());
            if (OUs == null || OUs.isEmpty()) {
                this.debugLog("handleReferencesToCalendarBeingDeleted", "No OU is referring calendar rule : " + calRul.getName());
                return;
            }
            if (!force) {
                StringBuffer referringOUs = new StringBuffer();
                for (int i = 0; i < OUs.size(); ++i) {
                    OrganizationalUnit ou = (OrganizationalUnit)OUs.get(i);
                    if (i != 0) {
                        referringOUs.append(", ");
                    }
                    referringOUs.append(ou.getOrganizationalUnitName());
                }
                String referringOUStr = referringOUs.toString();
                this.debugLog("handleReferencesToCalendarBeingDeleted", "Calendar Rule : " + calRul.getName() + " is being referred by Organizational Units : " + referringOUStr);
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "handleReferencesToCalendarBeingDeleted");
                exCtx.setErrorCode(70624);
                exCtx.setSeverity(Severity.ERRORS);
                exCtx.setMessageArguments(new Object[]{calRul.getName(), referringOUStr});
                throw new BPMOrganizationException(exCtx);
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private void handleReferencesToHolidayRuleBeingDeleted(HolidayRule holRul, boolean force) throws BPMOrganizationException {
        String METHOD = "handleReferencesToHolidayRuleBeingDeleted";
        this.debugLog("handleReferencesToHolidayRuleBeingDeleted", "Checking for references before deleting...");
        try {
            Vector cals = this.bpmOrganizationPersistency.getCalendarsReferringHolidayRule(holRul.getId());
            if (cals == null || cals.isEmpty()) {
                this.debugLog("handleReferencesToHolidayRuleBeingDeleted", "No Calendar is referring Holiday Rule : " + holRul.getName());
                return;
            }
            if (!force) {
                StringBuffer referringCals = new StringBuffer();
                for (int i = 0; i < cals.size(); ++i) {
                    CalendarRule cal = (CalendarRule)cals.get(i);
                    if (i != 0) {
                        referringCals.append(", ");
                    }
                    referringCals.append(cal.getName());
                }
                String referringCalStr = referringCals.toString();
                this.debugLog("handleReferencesToHolidayRuleBeingDeleted", "Holiday Rule : " + holRul.getName() + " is being referred by calendars : " + referringCalStr);
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "handleReferencesToHolidayRuleBeingDeleted");
                exCtx.setErrorCode(70625);
                exCtx.setSeverity(Severity.ERRORS);
                exCtx.setMessageArguments(new Object[]{holRul.getName(), referringCalStr});
                throw new BPMOrganizationException(exCtx);
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private void prepareCalendarRuleForPersistency(IBPMContext ctx, CalendarRule cal, boolean forCreate) throws BPMOrganizationException {
        String METHOD = "prepareCalendarRuleForPersistency";
        this.debugLog("prepareCalendarRuleForPersistency", "Preparing the Calendar for persistency... ");
        String identityContext = ctx.getIdentityContext();
        if (WorkflowUtil.isNull((String)identityContext)) {
            identityContext = DEFAULT_REALM_NAME;
        }
        XMLGregorianCalendar curTime = this.getNow();
        if (forCreate) {
            if (WorkflowUtil.isNull((String)cal.getId())) {
                cal.setId(Util.getGuid());
            }
            cal.setCreatedBy(ctx.getUser());
            cal.setCreatedIdentityCtx(identityContext);
            cal.setCreatedDate(curTime);
        }
        cal.setLastUpdatedBy(ctx.getUser());
        cal.setLastUpdatedIdentityCtx(identityContext);
        cal.setLastUpdatedDate(curTime);
        String tzName = cal.getTimeZone();
        if (WorkflowUtil.isNull((String)tzName)) {
            tzName = DEFAULT_TIME_ZONE;
        }
        if (tzName.indexOf("/") < 0) {
            tzName = CalendarUtil.getLongTimeZoneName(cal.getTimeZone());
        }
        TimeZone tz = TimeZone.getTimeZone(tzName);
        cal.setTimeZone(tz.getID());
    }

    private void prepareHolidayRuleForPersistency(IBPMContext ctx, HolidayRule holidayRule, boolean forCreate) throws BPMOrganizationException {
        String METHOD = "prepareHolidayRuleForPersistency";
        this.debugLog("prepareHolidayRuleForPersistency", "Preparing the Holiday Rule for persistency... ");
        String identityContext = ctx.getIdentityContext();
        if (WorkflowUtil.isNull((String)identityContext)) {
            identityContext = DEFAULT_REALM_NAME;
        }
        XMLGregorianCalendar curTime = this.getNow();
        if (forCreate) {
            if (WorkflowUtil.isNull((String)holidayRule.getId())) {
                holidayRule.setId(Util.getGuid());
            }
            holidayRule.setCreatedBy(ctx.getUser());
            holidayRule.setCreatedIdentityCtx(ctx.getIdentityContext());
            holidayRule.setCreatedDate(curTime);
        }
        holidayRule.setLastUpdatedBy(ctx.getUser());
        holidayRule.setLastUpdatedIdentityCtx(ctx.getIdentityContext());
        holidayRule.setLastUpdatedDate(curTime);
    }

    private XMLGregorianCalendar getNow() throws BPMOrganizationException {
        return BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
    }

    private void debugLog(String method, String msg, Object obj) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            if (obj != null && obj instanceof List && ((List)obj).size() > 0) {
                List lst = (List)obj;
                for (int i = 0; i < lst.size(); ++i) {
                    this.debugLog(method, "\n" + msg + "[" + i + "] : " + BPMOrganizationUtil.getJaxbObjectXMLAsString(lst.get(i)) + "\n");
                }
            } else {
                this.debugLog(method, msg + "\n" + BPMOrganizationUtil.getJaxbObjectXMLAsString(obj));
            }
        }
    }

    private void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)method, (String)msg);
        }
    }

    static {
        DEFAULT_REALM_NAME = AppRoleUtil.getInstance().getDefaultRealmName();
        DEFAULT_TIME_ZONE = "Etc/GMT";
    }
}

