/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.internal.processmodel.impl;

import com.oracle.bpel.client.ServerException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNProcessManagerLocalBean;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.IncludesStoredI18n;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.processmodel.impl.IProcessModelServiceExt;
import oracle.soa.management.ComponentDN;

public class ProcessModelService
implements IProcessModelServiceExt {
    private IBPMNProcessManagerLocalBean bpmnProcessManager;
    private static final Pattern defaultPattern = Pattern.compile("(__default__\\()(.*)(\\))");

    public IBPMNProcessManagerLocalBean getBpmnProcessManager() {
        return this.bpmnProcessManager;
    }

    public void setBpmnProcessManager(IBPMNProcessManagerLocalBean bpmnProcessManager) {
        this.bpmnProcessManager = bpmnProcessManager;
    }

    public Process getProcessModel(IBPMContext context, String projectId, String processName) throws BPMException {
        ComponentDN componentDN = new ComponentDN(projectId, processName);
        try {
            Process bpmnProcessModel = this.getBpmnProcessManager().getBPMNProcessModel(componentDN);
            return bpmnProcessModel;
        }
        catch (ServerException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Process model for process '" + processName + "' from deployed project '" + projectId + "' could not be retrieved."));
            throw new BPMException(71201, new Object[]{projectId, processName}, (Throwable)e);
        }
    }

    @Override
    public byte[] getProcessModelXML(IBPMContext context, String projectId, String processName) throws BPMException {
        try {
            String xmlString;
            Matcher matcher = defaultPattern.matcher(processName);
            if (matcher.matches() && matcher.groupCount() == 3) {
                String decodedProcessName = matcher.group(2);
                ComponentDN componentDN = new ComponentDN(projectId, decodedProcessName);
                Process process = this.getBpmnProcessManager().getBPMNProcessModel(componentDN);
                Process projectModel = process.getProject().getProjectModel();
                projectModel.getFeatures().extendFeature((Feature)IncludesStoredI18n.create((boolean)true));
                xmlString = projectModel.asXml();
            } else {
                ComponentDN componentDN = new ComponentDN(projectId, processName);
                xmlString = this.getBpmnProcessManager().getBPMNProcessModelXML(componentDN);
            }
            byte[] processModelXML = xmlString.getBytes("UTF-8");
            return processModelXML;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Process model for process '" + processName + "' from deployed project '" + projectId + "' could not be retrieved."));
            throw new BPMException(71201, new Object[]{projectId, processName}, (Throwable)e);
        }
    }
}

