/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery.impl;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.query.impl.QueryUtil;
import oracle.bpel.services.workflow.query.impl.TaskQueryService;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.query.model.TaskOrderingType;
import oracle.bpel.services.workflow.query.model.TaskPredicateType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.PersistencyDriver;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.PredicateImpl;
import oracle.bpel.services.workflow.repos.Table;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.task.model.ActionType;
import oracle.bpel.services.workflow.task.model.AttachmentType;
import oracle.bpel.services.workflow.task.model.CommentType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.impl.StandardViewLoaderUtil;
import oracle.bpel.services.workflow.user.model.ColumnListType;
import oracle.bpel.services.workflow.user.model.ColumnType;
import oracle.bpel.services.workflow.user.model.PresentationType;
import oracle.bpel.services.workflow.user.model.UserViewDetail;
import oracle.bpel.services.workflow.user.model.UserViewDetailType;
import oracle.bpel.services.workflow.verification.ITaskActionPermission;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.services.common.AbstractBPMService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.model.IProcessAttachment;
import oracle.bpm.services.instancemanagement.model.IProcessComment;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessInstanceUser;
import oracle.bpm.services.instancemanagement.model.impl.IdentityType;
import oracle.bpm.services.instancemanagement.model.impl.ProcessAttachment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessComment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstance;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstanceUser;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;

public class InstanceQueryService
extends AbstractBPMService
implements IInstanceQueryService {
    private static final String logClassName = InstanceQueryService.class.getName();
    private static final String ACTION_VIEW_AUDIT_INFO = "VIEW_AUDIT_INFO";
    private static final String STANDARD_PROCESS_VIEWS_FILE = "oracle/bpm/services/config/StandardProcessViews.xml";
    private static final String STANDARD_TASK_VIEWS_FILE = "oracle/bpel/services/workflow/user/config/StandardTaskViews.xml";
    private static List<Column> sColumnList = null;

    public List<IProcessInstance> queryParallelInstances(IBPMContext context, IProcessInstance instance, List<Column> displayColumns) throws BPMException {
        ArrayList<IProcessInstance> arrayList;
        IPersistencyService service = null;
        try {
            String instanceId = instance.getSystemAttributes().getProcessInstanceId();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)"oracle.bpmn.process.query.impl.InstanceQueryService", (String)"queryParallelInstances", (String)("Start of queryParallelInstances based on id " + instanceId));
            String state = instance.getSystemAttributes().getState();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 0, (Object)instanceId);
            predicate.addClause(7, IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)state);
            predicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 1, (Object)Integer.parseInt("0"));
            predicate.addClause(7, IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN, 0, (Object)"BPMN");
            this.addManadatoryColumns(displayColumns);
            service = PersistencyDriver.getInstance();
            List taskList = service.getWFTask((IWorkflowContext)context, displayColumns, (Predicate)predicate, null, 0, 0);
            ArrayList<IProcessInstance> processInstances = new ArrayList<IProcessInstance>(taskList.size());
            for (Object object : taskList) {
                Task itask = (Task)object;
                ProcessInstance pInstance = new ProcessInstance(itask);
                processInstances.add((IProcessInstance)pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryParallelInstances", (String)("End of queryParallelInstances based on id " + instanceId));
            arrayList = processInstances;
        }
        catch (Exception exc) {
            try {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
                Object[] obj = new String[]{instance.getSystemAttributes().getProcessInstanceId()};
                throw new BPMException(70403, obj, (Throwable)exc);
            }
            catch (Throwable throwable) {
                InstanceQueryService.closeService(service);
                throw throwable;
            }
        }
        InstanceQueryService.closeService(service);
        return arrayList;
    }

    public List<IProcessInstance> queryProcessInstances(IBPMContext context, List<Column> displayColumns, Predicate predicate, Ordering ordering, IInstanceQueryInput queryInput) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryProcessInstances", (String)"Start of queryProcessInstances");
        return this.queryInstances(context, displayColumns, predicate, ordering, queryInput, false);
    }

    public List<IProcessInstance> queryInstances(IBPMContext context, List<Column> displayColumns, Predicate predicate, Ordering ordering, IInstanceQueryInput queryInput) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryInstances", (String)"Start of queryInstances");
        return this.queryInstances(context, displayColumns, predicate, ordering, queryInput, true);
    }

    public List<IProcessInstance> queryViewProcessInstances(IBPMContext context, String viewId, Predicate extraPredicate, Ordering ordering, int startRow, int endRow) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewProcessInstances", (String)("Start of queryViewInstances for view id " + viewId));
        return this.queryViewInstances(context, viewId, extraPredicate, ordering, startRow, endRow, false);
    }

    public List<IProcessInstance> queryViewInstances(IBPMContext context, String viewId, Predicate extraPredicate, Ordering ordering, int startRow, int endRow) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewInstances", (String)("Start of queryViewInstances for view id " + viewId));
        return this.queryViewInstances(context, viewId, extraPredicate, ordering, startRow, endRow, true);
    }

    public IProcessInstance getProcessInstance(IBPMContext context, int processNumber) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("Start of getProcessInstance for instance id " + processNumber));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)processNumber);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                pInstance = new ProcessInstance((Task)taskLists.get(0));
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("End of getProcessInstance for instance id " + processNumber));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processNumber + ""};
            throw new BPMException(70402, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public IProcessInstance getInstance(IBPMContext context, int processNumber, int threadId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("Start of getInstance for instance id " + processNumber + ", thread id " + threadId));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)processNumber);
            predicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)threadId);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                pInstance = new ProcessInstance((Task)taskLists.get(0));
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("End of getInstance for instance id " + processNumber + ", thread id " + threadId));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processNumber + ""};
            throw new BPMException(70402, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public IProcessInstance getProcessInstance(IBPMContext context, String processId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("Start of getProcessInstance for instance id " + processId));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)processId);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                pInstance = new ProcessInstance((Task)taskLists.get(0));
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("End of getProcessInstance for instance id " + processId));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public IProcessInstance getInstance(IBPMContext context, String processId, int threadId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("Start of getProcessInstance for instance id " + processId + ", thread id " + threadId));
        IPersistencyService service = null;
        ProcessInstance pInstance = null;
        Locale locale = context.getLocale();
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)processId);
            predicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)threadId);
            context.setLocale(Locale.getDefault());
            List taskLists = service.getWFTask((IWorkflowContext)context, sColumnList, (Predicate)predicate, null);
            if (taskLists.size() > 0) {
                pInstance = new ProcessInstance((Task)taskLists.get(0));
                this.addOtherInfo(context, service, pInstance);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstance", (String)("End of getInstance for instance id " + processId + ", thread id " + threadId));
            ProcessInstance processInstance = pInstance;
            return processInstance;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{processId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
        }
    }

    public List<IProcessInstanceUser> getInstanceUpdatedUserHistoryByInstanceId(IBPMContext context, String instanceId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("Start of getInstanceUpdatedUserHistoryByInstanceId for instance id " + instanceId));
        IPersistencyService service = null;
        try {
            service = PersistencyDriver.getInstance();
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESSHISTORY_INSTANCEID_COLUMN, 0, (Object)instanceId);
            List taskUpdateHistory = service.getProcessInstanceStakeHolders((IWorkflowContext)context, (Predicate)predicate);
            ArrayList<IProcessInstanceUser> convertedHistory = new ArrayList();
            if (taskUpdateHistory != null) {
                convertedHistory = this.convertMapToProcessIdentityType(taskUpdateHistory);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessInstance", (String)("End of getProcessInstance for instance id " + instanceId));
            ArrayList<IProcessInstanceUser> arrayList = convertedHistory;
            return arrayList;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{instanceId + ""};
            throw new BPMException(70406, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IProcessInstanceUser> getInstanceUpdatedUserHistoryByTaskNumber(IBPMContext context, int taskNumber) throws BPMException {
        ArrayList<IProcessInstanceUser> arrayList;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstanceUpdatedUserHistoryByTaskNumber", (String)("Start of getInstanceUpdatedUserHistoryByTaskNumber for taskNumber " + taskNumber));
        IPersistencyService service = null;
        PreparedStatement pStmt = null;
        try {
            service = PersistencyDriver.getInstance();
            StringBuilder buffer = new StringBuilder();
            buffer.append("SELECT ").append(IColumnConstants.PROCESS_INSTANCEID_COLUMN.getName()).append(" FROM ").append(IColumnConstants.PROCESS_TABLE.getName()).append(" WHERE ").append(IColumnConstants.PROCESS_NUMBER_COLUMN.getName()).append(" = " + taskNumber);
            pStmt = service.getPreparedStatement(buffer.toString());
            ResultSet rset = pStmt.executeQuery();
            String instanceId = null;
            if (rset.next()) {
                instanceId = rset.getString(1);
            }
            rset.close();
            ArrayList<IProcessInstanceUser> assigneeHistory = new ArrayList();
            if (instanceId != null) {
                assigneeHistory = this.getInstanceUpdatedUserHistoryByInstanceId(context, instanceId);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstanceUpdatedUserHistoryByTaskNumber", (String)("End of getProcessInstance for instance id " + instanceId));
            arrayList = assigneeHistory;
        }
        catch (Exception exc) {
            try {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
                Object[] objs = new String[]{taskNumber + ""};
                throw new BPMException(70406, objs, (Throwable)exc);
            }
            catch (Throwable throwable) {
                InstanceQueryService.closeService(service);
                InstanceQueryService.closePreparedStatement(pStmt);
                throw throwable;
            }
        }
        InstanceQueryService.closeService(service);
        InstanceQueryService.closePreparedStatement(pStmt);
        return arrayList;
    }

    public List<String> getInstancesActedByAssignee(IBPMContext context, Calendar startDate, Calendar endDate) throws BPMException {
        String userName = context.getUser();
        String identityContext = context.getIdentityContext();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstancesActedByAssignee", (String)("Start of getInstancesActedByAssignee for assignee id " + userName));
        IPersistencyService service = null;
        try {
            service = PersistencyDriver.getInstance();
            oracle.bpel.services.workflow.task.model.IdentityType identityType = new ObjectFactory().createIdentityType();
            identityType.setId(userName);
            identityType.setType("user");
            PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESSHISTORY_UPDATEDBY_COLUMN, 0, identityType);
            predicate.addClause(7, IColumnConstants.PROCESSHISTORY_IDENTITYCONTEXT_COLUMN, 0, (Object)identityContext);
            predicate.addClause(7, IColumnConstants.PROCESSHISTORY_UPDATEDDATE_COLUMN, 3, (Object)startDate);
            predicate.addClause(7, IColumnConstants.PROCESSHISTORY_UPDATEDDATE_COLUMN, 5, (Object)endDate);
            List instanceIds = service.getProcessInstanceIdsUpdatedByUser((IWorkflowContext)context, (Predicate)predicate);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getInstancesActedByAssignee", (String)("Start of getInstancesActedByAssignee for assignee id " + userName));
            List list = instanceIds;
            return list;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{userName};
            throw new BPMException(70405, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IProcessComment> getProcessComments(IBPMContext context, IProcessInstance instance) throws BPMException {
        IPersistencyService service = null;
        String taskId = instance.getSystemAttributes().getProcessInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("Start of getProcessComments for instance id " + taskId));
        try {
            service = PersistencyDriver.getInstance();
            Task task = ((ProcessInstance)instance).getTask();
            List comments = service.getProcessInstanceComments((IWorkflowContext)context, task);
            ArrayList<IProcessComment> processComments = new ArrayList<IProcessComment>();
            for (int i = 0; i < comments.size(); ++i) {
                ProcessComment pComment = new ProcessComment((CommentType)comments.get(i));
                processComments.add((IProcessComment)pComment);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("End of getProcessComments for instance id " + taskId));
            ArrayList<IProcessComment> arrayList = processComments;
            return arrayList;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{taskId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IProcessAttachment> getProcessAttachments(IBPMContext context, IProcessInstance instance) throws BPMException {
        IPersistencyService service = null;
        String taskId = instance.getSystemAttributes().getProcessInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("Start of getProcessComments for instance id " + taskId));
        try {
            service = PersistencyDriver.getInstance();
            Task task = ((ProcessInstance)instance).getTask();
            List attacments = service.getProcessInstanceAttachments((IWorkflowContext)context, task);
            ArrayList<IProcessAttachment> processAttachment = new ArrayList<IProcessAttachment>();
            for (int i = 0; i < attacments.size(); ++i) {
                ProcessAttachment pAttachment = new ProcessAttachment((AttachmentType)attacments.get(i));
                processAttachment.add((IProcessAttachment)pAttachment);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getProcessComments", (String)("End of getProcessComments for instance id " + taskId));
            ArrayList<IProcessAttachment> arrayList = processAttachment;
            return arrayList;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{taskId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
        }
    }

    public List<IAuditInstance> queryAuditInstanceByProcessId(IBPMContext context, String instanceId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstanceByProcessId(instanceId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{instanceId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public List<IAuditInstance> getActiveInstancesAsOfQueryId(IBPMContext context, long queryId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.getActiveInstancesAsOfQueryId(queryId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{queryId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public List<IAuditInstance> getAllInstancesAfterQueryId(IBPMContext context, long queryId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.getAllInstancesAfterQueryId(queryId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{queryId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public List<IAuditInstance> queryAuditInstances(IBPMContext context, String expression) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstances(expression);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70401, null, (Throwable)e);
        }
    }

    public List<IAuditInstance> queryAuditInstances(IBPMContext context, String expression, Map<String, Object> parameters) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.queryAuditInstances(expression, parameters);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{parameters + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    public byte[] getAuditInstancePayload(IBPMContext ctx, long queryId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.getAuditInstancePayload(queryId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{queryId + " "};
            throw new BPMException(70401, objs, (Throwable)e);
        }
    }

    private static Predicate getAssigneePredicate(IBPMContext context, IInstanceQueryInput.AssignmentFilter filter) throws Exception {
        ITaskQueryService.AssignmentFilter assignmentFilter = null;
        if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.ADMIN)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.ADMIN;
        }
        if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.ALL)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.ALL;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.GROUP)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.GROUP;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.MY)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.MY;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.MY_AND_GROUP;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.OWNER)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.OWNER;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.REPORTEES)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.REPORTEES;
        } else if (filter.equals((Object)IInstanceQueryInput.AssignmentFilter.PREVIOUS)) {
            assignmentFilter = ITaskQueryService.AssignmentFilter.PREVIOUS;
        }
        if (assignmentFilter == null) {
            throw new Exception("Invalid assignment filter " + filter);
        }
        Predicate assigneePredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)context, (ITaskQueryService.AssignmentFilter)assignmentFilter);
        if (!(filter.equals((Object)IInstanceQueryInput.AssignmentFilter.PREVIOUS) || filter.equals((Object)IInstanceQueryInput.AssignmentFilter.ALL) || filter.equals((Object)IInstanceQueryInput.AssignmentFilter.ADMIN) || filter.equals((Object)IInstanceQueryInput.AssignmentFilter.OWNER))) {
            ArrayList<Table> mainQueryTables = new ArrayList<Table>();
            mainQueryTables.add(TableConstants.WFTASK_TABLE);
            assigneePredicate = PredicateImpl.wrapAsExistsSubquery((Predicate)assigneePredicate, mainQueryTables);
        }
        return assigneePredicate;
    }

    private static void closeService(IPersistencyService service) {
        if (service != null) {
            try {
                service.close();
            }
            catch (Exception exc) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.WARNING, (String)logClassName, (String)"closeService", (String)("Exception thrown when closing persistency service instance. Ignoring and continuing. Exception was: " + exc.getMessage()));
            }
        }
    }

    private static void closePreparedStatement(PreparedStatement pStmt) {
        if (pStmt != null) {
            try {
                pStmt.close();
            }
            catch (Exception exc) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.WARNING, (String)logClassName, (String)"closeService", (String)("Exception thrown when closing PreparedStatement. Ignoring and continuing. Exception was: " + exc.getMessage()));
            }
        }
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private List<IProcessInstance> queryInstances(IBPMContext context, List<Column> displayColumns, Predicate predicate, Ordering ordering, IInstanceQueryInput queryInput, boolean includeParallelThreads) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryProcessInstances", (String)"Start of queryProcessInstances");
        try {
            Predicate currentPredicate = this.getCurrentPredicate(context, predicate, queryInput, includeParallelThreads);
            Predicate historicPredicate = this.getHistoricPredicate(context, null, queryInput.getAssignmentFilter());
            int startRow = queryInput.getStartRow();
            int endRow = queryInput.getEndRow();
            List<IProcessInstance> processInstances = this.doPersistencyServiceQuery(context, displayColumns, currentPredicate, historicPredicate, ordering, startRow, endRow);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryProcessInstances", (String)"End of queryProcessInstances");
            return processInstances;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70400, null, (Throwable)exc);
        }
    }

    private List<IProcessInstance> queryViewInstances(IBPMContext context, String viewId, Predicate extraPredicate, Ordering ordering, int startRow, int endRow, boolean includeParallelThreads) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewInstances", (String)("Start of queryViewInstances for view id " + viewId + ", includeParallelThreads: " + includeParallelThreads));
        try {
            UserViewDetailType view = this.getUserViewDetail((IWorkflowContext)context, viewId);
            PresentationType presentation = this.getViewPresentation(view);
            Predicate currentPredicate = this.getCurrentViewPredicate(context, view, includeParallelThreads);
            currentPredicate = this.combinePredicates(currentPredicate, extraPredicate);
            Predicate historicPredicate = this.getHistoricViewPredicate(context, view);
            List<Column> displayColumns = this.getViewDisplayColumns(view, presentation);
            if (ordering == null) {
                ordering = this.getViewOrdering(view, presentation);
            }
            List<IProcessInstance> processInstances = this.doPersistencyServiceQuery(context, displayColumns, currentPredicate, historicPredicate, ordering, startRow, endRow);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryViewInstances", (String)"End of queryViewInstances");
            return processInstances;
        }
        catch (BPMException bpe) {
            throw bpe;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70400, null, (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IProcessInstance> doPersistencyServiceQuery(IBPMContext context, List<Column> displayColumns, Predicate currentPredicate, Predicate historicPredicate, Ordering ordering, int startRow, int endRow) throws Exception {
        ArrayList<IProcessInstance> arrayList;
        IPersistencyService service = null;
        Locale locale = context.getLocale();
        try {
            if (ordering == null) {
                ordering = new Ordering(IColumnConstants.PROCESS_NUMBER_COLUMN, true, true);
            }
            this.addManadatoryColumns(displayColumns);
            if (startRow < 0) {
                startRow = 0;
            }
            if (endRow < 0) {
                endRow = 0;
            }
            service = PersistencyDriver.getInstance();
            context.setLocale(Locale.getDefault());
            List taskList = null;
            taskList = historicPredicate != null ? service.getPreviousTasks((IWorkflowContext)context, displayColumns, currentPredicate, historicPredicate, ordering, startRow, endRow) : service.getWFTask((IWorkflowContext)context, displayColumns, currentPredicate, ordering, startRow, endRow);
            ArrayList<IProcessInstance> processInstances = new ArrayList<IProcessInstance>(taskList.size());
            for (Object object : taskList) {
                Task itask = (Task)object;
                ProcessInstance pInstance = new ProcessInstance(itask);
                processInstances.add((IProcessInstance)pInstance);
            }
            arrayList = processInstances;
        }
        catch (Throwable throwable) {
            InstanceQueryService.closeService(service);
            context.setLocale(locale);
            throw throwable;
        }
        InstanceQueryService.closeService(service);
        context.setLocale(locale);
        return arrayList;
    }

    private List<IProcessInstanceUser> convertMapToProcessIdentityType(List<Task> input) {
        ArrayList<IProcessInstanceUser> output = new ArrayList<IProcessInstanceUser>();
        for (int i = 0; i < input.size(); ++i) {
            Task task = input.get(i);
            SystemAttributesType syAttr = task.getSystemAttributes();
            String userName = null;
            String userDName = null;
            oracle.bpel.services.workflow.task.model.IdentityType updatedBy = syAttr.getUpdatedBy();
            if (updatedBy != null && !updatedBy.getId().equals("workflowsystem")) {
                userName = updatedBy.getId();
                userDName = updatedBy.getDisplayName();
            } else {
                userName = task.getCreator();
            }
            if (userName == null || userName.equals("") || userName.equals("workflowsystem")) continue;
            String appContext = task.getApplicationContext();
            String idContext = task.getIdentityContext();
            ProcessInstanceUser processUser = null;
            for (int k = 0; k < output.size(); ++k) {
                IProcessInstanceUser user = (IProcessInstanceUser)output.get(k);
                if (!user.getName().equals(userName)) continue;
                processUser = user;
                break;
            }
            if (processUser == null) {
                processUser = new ProcessInstanceUser(userName, userDName, appContext, idContext);
                output.add((IProcessInstanceUser)processUser);
            }
            List assignees = syAttr.getAssignees();
            for (int j = 0; j < assignees.size(); ++j) {
                oracle.bpel.services.workflow.task.model.IdentityType identity = (oracle.bpel.services.workflow.task.model.IdentityType)assignees.get(j);
                String type = identity.getType();
                IdentityType cType = new IdentityType(identity);
                if (type.equals("group")) {
                    processUser.getGroups().add(cType);
                    continue;
                }
                if (!type.equals("application_role")) continue;
                processUser.getRoles().add(cType);
            }
        }
        return output;
    }

    private void addManadatoryColumns(List<Column> displayColumns) {
        if (displayColumns.size() == 0) {
            displayColumns.addAll(sColumnList);
            return;
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_INSTANCEID_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_INSTANCEID_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_NUMBER_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_NUMBER_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_THREAD_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_THREAD_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_STEP_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_STEP_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN);
        }
        if (!displayColumns.contains(IColumnConstants.PROCESS_VERSION_COLUMN)) {
            displayColumns.add(IColumnConstants.PROCESS_VERSION_COLUMN);
        }
    }

    private Predicate getCurrentPredicate(IBPMContext context, Predicate predicate, IInstanceQueryInput input, boolean includeParallelThreads) throws Exception {
        IInstanceQueryInput.AssignmentFilter filter = input.getAssignmentFilter();
        Predicate currentPredicate = null;
        List states = input.getStates();
        if (states != null && !states.isEmpty()) {
            currentPredicate = new Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 9, states);
        }
        if (!IInstanceQueryInput.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            Predicate assigneerPredicate = InstanceQueryService.getAssigneePredicate(context, filter);
            currentPredicate = this.combinePredicates(currentPredicate, assigneerPredicate);
        }
        Predicate searchPredicate = this.getSearchPredicate(input.getKeyword());
        currentPredicate = this.combinePredicates(currentPredicate, searchPredicate);
        currentPredicate = this.combinePredicates(currentPredicate, predicate);
        if (!includeParallelThreads) {
            currentPredicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)Integer.parseInt("0"));
        }
        Predicate componentTypePredicate = new Predicate(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN, 0, (Object)"BPMN");
        currentPredicate = this.combinePredicates(currentPredicate, componentTypePredicate);
        return currentPredicate;
    }

    private Predicate getHistoricPredicate(IBPMContext context, Predicate predicate, IInstanceQueryInput.AssignmentFilter filter) throws Exception {
        Predicate historicPredicate = null;
        if (IInstanceQueryInput.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            historicPredicate = InstanceQueryService.getAssigneePredicate(context, filter);
        }
        historicPredicate = this.combinePredicates(historicPredicate, predicate);
        return historicPredicate;
    }

    private Predicate getCurrentViewPredicate(IBPMContext context, UserViewDetailType view, boolean includeParallelThreads) throws Exception {
        TaskPredicateType viewQueryInfo = view.getViewPredicate();
        ITaskQueryService.AssignmentFilter filter = QueryUtil.getAssignmentFilterEnum((String)viewQueryInfo.getAssignmentFilter());
        Predicate currentPredicate = null;
        if (!ITaskQueryService.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            currentPredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)context, (ITaskQueryService.AssignmentFilter)filter);
        }
        Predicate searchPredicate = this.getSearchPredicate(viewQueryInfo.getKeywords());
        currentPredicate = this.combinePredicates(currentPredicate, searchPredicate);
        Predicate viewPredicate = QueryUtil.getPredicateFromPredicateType((TaskPredicateType)viewQueryInfo);
        currentPredicate = this.combinePredicates(currentPredicate, viewPredicate);
        PredicateImpl componentTypePredicate = new PredicateImpl(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN, 0, (Object)"BPMN");
        currentPredicate = this.combinePredicates(currentPredicate, (Predicate)componentTypePredicate);
        if (!includeParallelThreads) {
            currentPredicate.addClause(7, IColumnConstants.PROCESS_THREAD_COLUMN, 0, (Object)Integer.parseInt("0"));
        }
        return currentPredicate;
    }

    private Predicate getHistoricViewPredicate(IBPMContext context, UserViewDetailType view) throws Exception {
        TaskPredicateType viewQueryInfo = view.getViewPredicate();
        ITaskQueryService.AssignmentFilter filter = QueryUtil.getAssignmentFilterEnum((String)viewQueryInfo.getAssignmentFilter());
        Predicate historicPredicate = null;
        if (ITaskQueryService.AssignmentFilter.PREVIOUS.equals((Object)filter)) {
            historicPredicate = TaskQueryService.getAssignmentFilterPredicate((IWorkflowContext)context, (ITaskQueryService.AssignmentFilter)filter);
        }
        Predicate viewHistoryPredicate = null;
        PredicateType predicateType = view.getViewHistoryPredicate();
        if (predicateType != null) {
            viewHistoryPredicate = new Predicate(predicateType);
        }
        historicPredicate = this.combinePredicates(historicPredicate, viewHistoryPredicate);
        return historicPredicate;
    }

    private List<Column> getViewDisplayColumns(UserViewDetailType view, PresentationType presentation) throws Exception {
        ArrayList<Column> displayColumns = new ArrayList<Column>();
        ColumnListType columnListType = null;
        columnListType = presentation != null ? presentation.getColumns() : view.getViewColumns();
        if (columnListType != null) {
            List colTypes = columnListType.getColumn();
            for (ColumnType colType : colTypes) {
                Column column = Column.getColumn((String)colType.getColumnName());
                if (column == null) continue;
                displayColumns.add(column);
            }
        }
        return displayColumns;
    }

    private Ordering getViewOrdering(UserViewDetailType view, PresentationType presentation) throws Exception {
        Ordering ordering = null;
        TaskOrderingType orderingType = null;
        orderingType = presentation != null ? presentation.getOrdering() : view.getViewOrdering();
        if (orderingType != null) {
            List orderingClause = orderingType.getClause();
            ordering = QueryUtil.getOrderingFromOrderingClause((List)orderingClause);
        }
        return ordering;
    }

    private Predicate getSearchPredicate(String keywords) throws Exception {
        String textAttribNumber;
        int i;
        String textAttribNumberPrefix;
        String textAttribColumnName;
        PredicateImpl searchPredicate = null;
        if (keywords == null || keywords.trim().equals("")) {
            return searchPredicate;
        }
        String searchTerm = "%" + keywords.trim() + "%";
        searchPredicate = new PredicateImpl(IColumnConstants.PROCESS_TITLE_COLUMN, 6, (Object)searchTerm, true);
        searchPredicate.addClause(8, IColumnConstants.PROCESS_ACTIVITYNAME_COLUMN, 6, (Object)searchTerm, true);
        searchPredicate.addClause(8, IColumnConstants.PROCESS_ACTIVITYID_COLUMN, 6, (Object)searchTerm, true);
        String textAttribColumnPrefix = "textAttribute";
        for (int i2 = 1; i2 <= 20; ++i2) {
            textAttribColumnName = textAttribColumnPrefix + i2;
            searchPredicate.addClause(8, Column.getColumn((String)textAttribColumnName), 6, (Object)searchTerm, true);
        }
        try {
            Integer taskNum = Integer.valueOf(keywords);
            searchPredicate.addClause(8, IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)taskNum);
            textAttribNumberPrefix = "numberAttribute";
            for (i = 1; i <= 10; ++i) {
                textAttribNumber = textAttribNumberPrefix + i;
                searchPredicate.addClause(8, Column.getColumn((String)textAttribNumber), 0, (Object)taskNum, true);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        textAttribColumnPrefix = "protectedTextAttribute";
        for (int i3 = 1; i3 <= 20; ++i3) {
            textAttribColumnName = textAttribColumnPrefix + i3;
            searchPredicate.addClause(8, Column.getColumn((String)textAttribColumnName), 6, (Object)searchTerm, true);
        }
        try {
            Integer taskNum = Integer.valueOf(keywords);
            searchPredicate.addClause(8, IColumnConstants.PROCESS_NUMBER_COLUMN, 0, (Object)taskNum);
            textAttribNumberPrefix = "protectedNumberAttribute";
            for (i = 1; i <= 10; ++i) {
                textAttribNumber = textAttribNumberPrefix + i;
                searchPredicate.addClause(8, Column.getColumn((String)textAttribNumber), 0, (Object)taskNum, true);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return searchPredicate;
    }

    private Predicate combinePredicates(Predicate firstPredicate, Predicate secondPredicate) throws WorkflowException {
        PredicateImpl firstPredicateImpl;
        PredicateImpl combinedPredicate = firstPredicateImpl = PredicateImpl.getPredicateImpl((Predicate)firstPredicate);
        if (secondPredicate != null) {
            PredicateImpl secondPredicateImpl = PredicateImpl.getPredicateImpl((Predicate)secondPredicate);
            combinedPredicate = firstPredicateImpl != null ? new PredicateImpl(firstPredicateImpl, 7, secondPredicateImpl) : secondPredicateImpl;
        }
        return combinedPredicate;
    }

    private void addOtherInfo(IBPMContext context, IPersistencyService service, ProcessInstance instance) throws Exception {
        Task task = instance.getTask();
        List comments = service.getProcessInstanceComments((IWorkflowContext)context, task);
        for (Object comment : comments) {
            task.addUserComment((CommentType)comment);
        }
        List attachments = service.getProcessInstanceAttachments((IWorkflowContext)context, task);
        for (Object attachment : attachments) {
            task.addAttachment((AttachmentType)attachment);
        }
        this.getPermissionsService().addPermissibleProcessActions(context, (IProcessInstance)instance);
    }

    private List<IAuditInstance> filterAuditInstancesForUser(IBPMContext ctx, List<IAuditInstance> auditList) throws Exception {
        if (VerificationService.isWFAdmin((IWorkflowContext)ctx)) {
            return auditList;
        }
        LinkedHashMap<String, List<IAuditInstance>> auditInstCache = new LinkedHashMap<String, List<IAuditInstance>>();
        ArrayList<String> processIds = new ArrayList<String>();
        for (IAuditInstance auditInst : auditList) {
            ArrayList<IAuditInstance> cachedList;
            String processId = auditInst.getCompositeInstanceId();
            if (!processIds.contains(processId)) {
                processIds.add(processId);
            }
            if ((cachedList = (ArrayList<IAuditInstance>)((HashMap)auditInstCache).get(processId)) == null) {
                cachedList = new ArrayList<IAuditInstance>();
                auditInstCache.put(processId, cachedList);
            }
            cachedList.add(auditInst);
        }
        return this.compileAuditInstancesForProcessInstances(ctx, processIds, auditInstCache);
    }

    private List<IAuditInstance> compileAuditInstancesForProcessInstances(IBPMContext ctx, List<String> processIds, HashMap<String, List<IAuditInstance>> auditInstCache) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"compileAuditInstancesForProcessInstances", (String)"Start of compileAuditInstancesForProcessInstances ");
        ArrayList returnAuditList = new ArrayList();
        IPersistencyService service = null;
        Locale locale = ctx.getLocale();
        try {
            Object svc;
            if (processIds != null && processIds.size() > 0) {
                svc = this.getPermissionsService();
                ITaskActionPermission permission = null;
                ProcessInstance pInstance = null;
                service = PersistencyDriver.getInstance();
                PredicateImpl predicate = new PredicateImpl(IColumnConstants.PROCESS_ID_COLUMN, 9, processIds);
                ctx.setLocale(Locale.getDefault());
                List taskLists = service.getWFTask((IWorkflowContext)ctx, sColumnList, (Predicate)predicate, null);
                for (int i = 0; i < taskLists.size(); ++i) {
                    Task taskObj = (Task)taskLists.get(i);
                    pInstance = new ProcessInstance(taskObj);
                    permission = svc.canUserPerformProcessAction(ctx, (IProcessInstance)pInstance, ACTION_VIEW_AUDIT_INFO);
                    if (!permission.getHasPermission()) continue;
                    returnAuditList.addAll(auditInstCache.get(taskObj.getProcessInfo().getInstanceId()));
                }
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)logClassName, (String)"compileAuditInstancesForProcessInstances", (String)"End of compileAuditInstancesForProcessInstances");
            svc = returnAuditList;
            return svc;
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70407, null, (Throwable)exc);
        }
        finally {
            InstanceQueryService.closeService(service);
            ctx.setLocale(locale);
        }
    }

    private boolean canUserSeeAuditForProcessInstance(IBPMContext ctx, String processId) throws Exception {
        IProcessInstance pInstance = this.getProcessInstance(ctx, processId);
        Task task = ((ProcessInstance)pInstance).getTask();
        List systemActions = task.getSystemAttributes().getSystemActions();
        for (int i = 0; i < systemActions.size(); ++i) {
            ActionType actionType = (ActionType)systemActions.get(i);
            if (!actionType.getAction().equals(ACTION_VIEW_AUDIT_INFO)) continue;
            return true;
        }
        return false;
    }

    private UserViewDetailType getUserViewDetail(IWorkflowContext ctx, String viewId) throws BPMException {
        try {
            UserViewDetail userViewDetail = this.getUserMetadataService().getUserTaskViewDetails(ctx, viewId);
            if (userViewDetail == null) {
                throw new BPMException(70408, new Object[]{viewId}, null);
            }
            if (!this.isProcessView((UserViewDetailType)userViewDetail)) {
                Object[] objs = new Object[]{userViewDetail.getName(), userViewDetail.getViewType()};
                throw new BPMException(70409, objs, null);
            }
            return userViewDetail;
        }
        catch (BPMException bpe) {
            throw bpe;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw new BPMException(70410, new Object[]{e.getLocalizedMessage()}, (Throwable)e);
        }
    }

    private boolean isProcessView(UserViewDetailType view) {
        String viewType = view.getViewType();
        return IUserMetadataService.UserTaskViewType.PROCESS_VIEW.name().equals(viewType) || IUserMetadataService.UserTaskViewType.STDPROCESS_VIEW.name().equals(viewType);
    }

    private PresentationType getViewPresentation(UserViewDetailType view) throws Exception {
        String presentationId = view.getPresentationId();
        PresentationType presentation = null;
        if (presentationId != null && presentationId.length() > 0) {
            presentation = this.getUserMetadataService().getPresentation(InstanceQueryService.getInternalWorkflowContext(), presentationId);
        }
        return presentation;
    }

    static {
        sColumnList = new ArrayList<Column>();
        try {
            Field[] constantfields;
            Class<?> tableConstantsClass = Class.forName("oracle.bpm.services.instancequery.IColumnConstants");
            for (Field constantField : constantfields = tableConstantsClass.getFields()) {
                Column colm;
                Class<?> constantClass = constantField.getType();
                String name = constantField.getName();
                if (!constantClass.getName().equals("oracle.bpel.services.workflow.repos.Column") || !name.startsWith("PROCESS_") || !(colm = (Column)constantField.get(null)).getTable().getName().equalsIgnoreCase("WFTask")) continue;
                sColumnList.add((Column)constantField.get(null));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        StandardViewLoaderUtil.loadViewsFromFile((IUserMetadataService.UserTaskViewType)IUserMetadataService.UserTaskViewType.STANDARD_VIEW, (String)STANDARD_TASK_VIEWS_FILE);
        StandardViewLoaderUtil.loadViewsFromFile((IUserMetadataService.UserTaskViewType)IUserMetadataService.UserTaskViewType.STDPROCESS_VIEW, (String)STANDARD_PROCESS_VIEWS_FILE);
    }
}

