/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.impl;

import com.collaxa.cube.persistence.dto.ICubeInstanceMetaData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.repos.Transaction;
import oracle.bpel.services.workflow.task.model.AttachmentType;
import oracle.bpel.services.workflow.task.model.CommentType;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.ITaskActionPermission;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeInstanceManagerLocalBean;
import oracle.bpm.services.common.AbstractBPMService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.IInstanceManagementService;
import oracle.bpm.services.instancemanagement.model.IProcessAttachment;
import oracle.bpm.services.instancemanagement.model.IProcessComment;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.impl.IdentityType;
import oracle.bpm.services.instancemanagement.model.impl.ProcessAttachment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessComment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstance;
import oracle.bpm.services.permissions.IPermissionsService;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.integration.platform.common.NMUtil;
import oracle.soa.management.ComponentDN;
import org.jetbrains.annotations.NotNull;

public class InstanceManagementService
extends AbstractBPMService
implements IInstanceManagementService {
    private IBPMNCubeInstanceManagerLocalBean bpmnInstanceManager;
    private IProcessMetadataService processMetadataService;
    private ITaskQueryService taskQueryService;
    private static final String CLASSNAME = InstanceManagementService.class.getName();
    private static final String ADD_COMMENT = "ADD_COMMENT";
    private static final String ADD_ATTACHMENT = "ADD_ATTACHMENT";
    private static final String DELETE_ATTACHMENT = "DELETE_ATTACHMENT";

    public IBPMNCubeInstanceManagerLocalBean getBpmnInstanceManager() {
        return this.bpmnInstanceManager;
    }

    public void setBpmnInstanceManager(IBPMNCubeInstanceManagerLocalBean instanceManagerBean) {
        this.bpmnInstanceManager = instanceManagerBean;
    }

    public ITaskQueryService getTaskQueryService() {
        return this.taskQueryService;
    }

    public void setTaskQueryService(ITaskQueryService taskQueryService) {
        this.taskQueryService = taskQueryService;
    }

    public IProcessMetadataService getProcessMetadataService() {
        return this.processMetadataService;
    }

    public void setProcessMetadataService(IProcessMetadataService processMetadataService) {
        this.processMetadataService = processMetadataService;
    }

    public String createProcessInstance(IBPMContext context, String processId) throws BPMException {
        ICubeInstanceMetaData instance;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstance()", (String)"Start");
        ComponentDN targetDN = new ComponentDN(processId);
        this.performInitiatePermissionCheck(context, targetDN);
        try {
            Properties invocationProperties = new Properties();
            String conversationId = NMUtil.generateConversationId();
            String name = context.getUser();
            if (name != null) {
                invocationProperties.setProperty("creator", name);
            }
            invocationProperties.setProperty("tracking.conversationId", conversationId);
            invocationProperties.put("START_EVENT_ID_PROPERTY", "START_EVENT_USER_INITIATE");
            this.getBpmnInstanceManager().createComponentInstance(targetDN, invocationProperties);
            instance = this.getBpmnInstanceManager().getCubeInstanceByConversationId(conversationId);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] args = new Object[]{processId};
            throw new BPMException(70204, args, (Throwable)e);
        }
        if (instance == null) {
            Object[] args = new Object[]{processId};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Instance could not be created for unknown reason for target process '" + processId + "'. " + "Verify server log for error cause."));
            throw new BPMException(70204, args, null);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstance()", (String)"End");
        return String.valueOf(instance.getCikey());
    }

    public Task createProcessInstanceTask(IBPMContext context, String processId) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstanceTask()", (String)"Start");
        ComponentDN targetDN = new ComponentDN(processId);
        this.performInitiatePermissionCheck(context, targetDN);
        Task task = null;
        try {
            Properties invocationProperties = new Properties();
            String conversationId = NMUtil.generateConversationId();
            String name = context.getUser();
            if (name != null) {
                invocationProperties.setProperty("creator", name);
            }
            invocationProperties.setProperty("tracking.conversationId", conversationId);
            invocationProperties.put("START_EVENT_ID_PROPERTY", "START_EVENT_USER_INITIATE");
            this.getBpmnInstanceManager().createComponentInstance(targetDN, invocationProperties);
            task = null;
            List tasks = null;
            ITaskQueryService queryService = this.getTaskQueryService();
            ArrayList<ITaskQueryService.OptionalInfo> optionalInfo = new ArrayList<ITaskQueryService.OptionalInfo>();
            ArrayList<String> displayColumns = new ArrayList<String>();
            Predicate predicate = new Predicate(TableConstants.WFTASK_IDENTIFICATIONKEY_COLUMN, 0, (Object)conversationId);
            optionalInfo.add(ITaskQueryService.OptionalInfo.DISPLAY_INFO);
            displayColumns.add("taskId");
            displayColumns.add("activityId");
            displayColumns.add("instanceId");
            displayColumns.add("assignees");
            displayColumns.add("processId");
            displayColumns.add("applicationName");
            displayColumns.add("componentName");
            displayColumns.add("compositeDN");
            displayColumns.add("compositeInstanceId");
            displayColumns.add("compositeName");
            displayColumns.add("compositeVersion");
            displayColumns.add("ecid");
            displayColumns.add("parentComponentInstanceId");
            displayColumns.add("parentComponentInstRefId");
            displayColumns.add("createdDate");
            displayColumns.add("state");
            displayColumns.add("invokedComponent");
            tasks = queryService.queryTasks((IWorkflowContext)context, null, optionalInfo, ITaskQueryService.AssignmentFilter.ALL, null, predicate, null, 0, 0);
            if (tasks != null && !tasks.isEmpty()) {
                task = (Task)tasks.get(0);
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] args = new Object[]{processId};
            throw new BPMException(70204, args, (Throwable)e);
        }
        if (task == null) {
            Object[] args = new Object[]{processId};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Initiate task could not be created for unknown reason for target process '" + processId + "'. " + "Verify server log for error cause."));
            throw new BPMException(70204, args, null);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"createProcessInstanceTask()", (String)"End");
        return task;
    }

    public IProcessComment addComment(IBPMContext context, IProcessInstance instance, IProcessComment comment) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addComment()", (String)"Start of adding process comment");
        boolean inTransaction = false;
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.UPDATE_COMMENT);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task taskObject = ((ProcessInstance)instance).getTask();
            String taskId = instance.getCubeInstanceId();
            String userName = context.getUser();
            IdentityType type = new IdentityType();
            type.setType("user");
            type.setId(userName);
            SystemAttributesType attributes = taskObject.getSystemAttributes();
            attributes.setUpdatedBy(type.getIdentityType());
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(System.currentTimeMillis());
            attributes.setUpdatedDate(updatedDate);
            String versionReason = attributes.getVersionReason();
            if (versionReason == null || versionReason.equals("")) {
                attributes.setVersionReason(ADD_COMMENT);
            }
            CommentType cType = ((ProcessComment)comment).getCommentType();
            taskObject.getSystemAttributes().setTaskId(taskId);
            service.addProcessInstanceComment((IWorkflowContext)context, taskObject, cType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addComment()", (String)"End of adding process comment");
            IProcessComment iProcessComment = comment;
            return iProcessComment;
        }
        catch (Exception exc) {
            String id = instance.getCubeInstanceId();
            Object[] obj = new String[]{id};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70200, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public IProcessAttachment addAttachment(IBPMContext context, IProcessInstance instance, IProcessAttachment attachment) throws BPMException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addAttachment()", (String)"Start of adding process attachment");
        boolean inTransaction = false;
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.UPDATE_ATTACHMENT);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task taskObject = ((ProcessInstance)instance).getTask();
            String taskId = instance.getCubeInstanceId();
            String userName = context.getUser();
            IdentityType type = new IdentityType();
            type.setType("user");
            type.setId(userName);
            SystemAttributesType attributes = taskObject.getSystemAttributes();
            attributes.setUpdatedBy(type.getIdentityType());
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(System.currentTimeMillis());
            attributes.setUpdatedDate(updatedDate);
            String versionReason = attributes.getVersionReason();
            if (versionReason == null || versionReason.equals("")) {
                attributes.setVersionReason("ADD_ATTACHMENT " + attachment.getName());
            }
            attachment.setUpdatedBy(userName);
            AttachmentType aType = ((ProcessAttachment)attachment).getAttachmentType();
            taskObject.getSystemAttributes().setTaskId(taskId);
            aType = service.addProcessInstanceAttachment((IWorkflowContext)context, taskObject, aType);
            ((ProcessAttachment)attachment).setAttachmentType(aType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"addAttachment()", (String)"End of adding process comment");
            IProcessAttachment iProcessAttachment = attachment;
            return iProcessAttachment;
        }
        catch (Exception exc) {
            String id = instance.getCubeInstanceId();
            Object[] obj = new String[]{id};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            throw new BPMException(70201, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public void deleteProcessAttachments(IBPMContext context, IProcessInstance instance, IProcessAttachment attachment) throws BPMException {
        String taskId = instance.getSystemAttributes().getProcessInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"deleteProcessAttachments", (String)("Start of deleteProcessAttachments for instance id " + taskId));
        boolean inTransaction = false;
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.UPDATE_ATTACHMENT);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task task = ((ProcessInstance)instance).getTask();
            SystemAttributesType attributes = task.getSystemAttributes();
            String versionReason = attributes.getVersionReason();
            if (versionReason == null || versionReason.equals("")) {
                attributes.setVersionReason("DELETE_ATTACHMENT " + attachment.getName());
            }
            AttachmentType attType = ((ProcessAttachment)attachment).getAttachmentType();
            service.deleteProcessInstanceAttachment((IWorkflowContext)context, task, attType);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"deleteProcessAttachments", (String)("End of deleteProcessAttachments for instance id " + taskId));
        }
        catch (Exception exc) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (Throwable)exc);
            Object[] objs = new String[]{taskId + ""};
            throw new BPMException(70401, objs, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public void cancelProcessInstance(@NotNull IBPMContext context, @NotNull IProcessInstance instance) throws BPMException {
        String cubeInstanceId = instance.getCubeInstanceId();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"cancelInstance", (String)("Start of cancelInstance for instance id " + cubeInstanceId));
        this.performPermissionsCheck(context, instance, IPermissionsService.InstanceAction.CANCEL);
        try {
            this.getBpmnInstanceManager().cancelInstance(Long.parseLong(cubeInstanceId));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"cancelInstance", (String)("End of cancelInstance for instance id " + cubeInstanceId));
        }
        catch (Exception e) {
            Object[] args = new Object[]{cubeInstanceId};
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)("Instance could not be cancelled. Instance: '" + cubeInstanceId + "'. " + "Verify server log for error cause."));
            throw new BPMException(70206, args, (Throwable)e);
        }
    }

    public List<String> getAllowedActions(@NotNull IBPMContext context, @NotNull IProcessInstance instance) throws BPMException {
        return this.getPermissionsService().getPermissibleProcessActions(context, instance);
    }

    private String getId(IProcessInstance instance) {
        String cubeInstanceId = instance.getCubeInstanceId();
        int thread = instance.getSystemAttributes().getThread();
        int parentThread = instance.getSystemAttributes().getParentThread();
        String taskId = cubeInstanceId;
        if (thread > 0 || parentThread > 0) {
            taskId = taskId + "-" + thread;
            taskId = taskId + "-" + parentThread;
        }
        return taskId;
    }

    private void performPermissionsCheck(@NotNull IBPMContext context, @NotNull IProcessInstance instance, @NotNull IPermissionsService.InstanceAction action) throws BPMException {
        IPermissionsService svc = this.getPermissionsService();
        ITaskActionPermission permission = svc.canUserPerformProcessAction(context, instance, action.toString());
        if (!permission.getHasPermission()) {
            BPMException exception = new BPMException(70205, new Object[]{action, instance.getCubeInstanceId(), context.getUser()}, null);
            throw exception;
        }
    }

    private void performInitiatePermissionCheck(@NotNull IBPMContext context, @NotNull ComponentDN targetProcess) throws BPMException {
        ProcessMetadataSummary metadataSummary = this.getProcessMetadataService().getProcessMetadataSummary(context, targetProcess.getCompositeDN(), targetProcess.getComponentName());
        if (metadataSummary == null) {
            throw new BPMException(70806, (Object[])new String[]{targetProcess.getStringDN()}, null);
        }
        boolean canPerform = false;
        List initiatables = this.getProcessMetadataService().getInitiatableProcesses(context);
        for (ProcessMetadataSummary candidate : initiatables) {
            if (!candidate.getCompositeDN().equals(targetProcess.getCompositeDN()) || !candidate.getProcessName().equals(targetProcess.getComponentName())) continue;
            canPerform = true;
            break;
        }
        if (!canPerform) {
            BPMException exception = new BPMException(70207, new Object[]{IPermissionsService.InstanceAction.INITIATE, targetProcess.toString(), context.getUser()}, null);
            throw exception;
        }
    }
}

