/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.document.impl;

import java.io.Serializable;
import java.util.Properties;
import oracle.security.jps.JpsContext;
import oracle.security.jps.JpsContextFactory;
import oracle.security.jps.service.credstore.CredentialStore;
import oracle.security.jps.service.credstore.PasswordCredential;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.IdcContext;

public class RIDCContext
implements Serializable {
    private String m_idcURL = "http://dthakkar-pc:8081/idc/idcplg";
    private static String m_idcUser = "WFUCM";
    private static String m_idcPass = "welcome";
    private String m_idcSecGroup = "Public";
    private String m_idcDocType = "Task";
    private static String sUcmKey = "WF-ADMIN-CREDENTIAL";
    private static String sUcmAlias = "WF-ADMIN-USER";
    transient IdcClientManager m_idcClientManager = null;
    transient IdcClient m_idcClient = null;
    transient IdcContext m_idcContext = null;

    public static RIDCContext createContext() {
        return null;
    }

    public RIDCContext() {
        this.init();
    }

    private void init() {
        try {
            Properties properties = new Properties();
            properties.setProperty("oracle.bpel.services.jpscsf.oc4jalias", sUcmAlias);
            properties.setProperty("oracle.bpel.services.jpscsf.oc4jkey", sUcmKey);
            JpsContextFactory ctxFactory = JpsContextFactory.getContextFactory();
            String jpxContextName = "default";
            JpsContext ctx = ctxFactory.getContext("default");
            CredentialStore store = (CredentialStore)ctx.getServiceInstance(CredentialStore.class);
            PasswordCredential pwdcred = (PasswordCredential)store.getCredential(sUcmAlias, sUcmKey);
            String[] credentials = new String[2];
            if (pwdcred != null) {
                credentials[0] = pwdcred.getName();
                credentials[1] = String.valueOf(pwdcred.getPassword());
            }
            m_idcUser = credentials[0];
            m_idcPass = credentials[1];
            this.m_idcClientManager = new IdcClientManager();
            this.m_idcClient = this.m_idcClientManager.createClient(this.m_idcURL);
            this.m_idcContext = new IdcContext(m_idcUser, m_idcPass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Error initializing RIDC DocumentStore.");
        }
    }

    public IdcClientManager getClientManager() {
        if (this.m_idcClientManager == null) {
            this.init();
        }
        return this.m_idcClientManager;
    }

    public IdcClient getIdcClient() {
        if (this.m_idcClient == null) {
            this.init();
        }
        return this.m_idcClient;
    }

    public IdcContext getIdcContext() {
        if (this.m_idcContext == null) {
            this.init();
        }
        return this.m_idcContext;
    }

    public String getSecurityGroup() {
        return this.m_idcSecGroup;
    }

    public String getDocType() {
        return this.m_idcDocType;
    }
}

