/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.authentication.test;

import junit.framework.TestCase;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;

public abstract class AbstractBPMUserAuthenticationServiceTest
extends TestCase {
    public static final String ADMIN_USERNAME = "weblogic";
    public static final String ADMIN_PASSWORD = "weblogic1";
    public static final String REALM_NAME = "jazn.com";
    public static final String PASSWORD = "welcome1";
    IBPMUserAuthenticationService service = null;
    private IBPMContext ctx;

    public AbstractBPMUserAuthenticationServiceTest(String name) {
        super(name);
    }

    public IBPMContext getContext(String user, String password) {
        try {
            return this.service.authenticate(user, password.toCharArray(), REALM_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testAuthenticate() throws Exception {
        try {
            System.out.println("Test testAuthenticate begins ");
            IBPMContext bpmContext = this.service.authenticate("jstein", PASSWORD.toCharArray(), REALM_NAME);
            System.out.println("Authenticated UserName: " + bpmContext.getUser() + " context: " + bpmContext.getIdentityContext());
            System.out.println("========== Test testAuthenticate ends ==========");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testAuthenticateOnBehalfOf() throws Exception {
        try {
            System.out.println("========== Test testAuthenticateOnBehalfOf begins ==========");
            IBPMContext bpmContext = this.service.authenticateOnBehalfOf(this.getContext(ADMIN_USERNAME, ADMIN_PASSWORD), "jstein");
            System.out.println("Authenticated UserName: " + bpmContext.getUser() + " context: " + bpmContext.getIdentityContext());
            System.out.println("========== Test testAuthenticateOnBehalfOf ends ==========");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testDestroyBPMContext() throws Exception {
        try {
            System.out.println("========== Test testDestroyBPMContext  begins ==========");
            this.service.destroyBPMContext(this.getContext("jcooper", PASSWORD));
            System.out.println("========== Test testDestroyBPMContext ends ==========");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testGetBPMContextForAuthenticatedUser() throws Exception {
        try {
            System.out.println("========== Test testGetBPMContextForAuthenticatedUser  begins ==========");
            IBPMContext bpmContext = this.service.getBPMContextForAuthenticatedUser();
            System.out.println("========== Test testGetBPMContextForAuthenticatedUser ends ==========");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

