/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.authentication.impl;

import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class BPMUserAuthenticationService
implements IBPMUserAuthenticationService {
    private IVerificationService verificationService = null;
    private static BPMException s_bootstrupException = null;
    private static String INTERNAL_CONTEXT_TOKEN;
    private static Object sContextCreationMonitor;
    private static String CLASS_NAME;

    public IBPMContext authenticate(String user, char[] password, String identityContext) throws BPMException {
        String METHOD = "authenticate";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
            BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "Begin");
        }
        String passwd = null;
        if (password != null) {
            passwd = new String(password);
        }
        try {
            IBPMContext ctx;
            IBPMContext iBPMContext = ctx = (IBPMContext)this.getVerificationService().authenticateUser(user, passwd, identityContext, null);
            return iBPMContext;
        }
        catch (Exception cause) {
            throw new BPMException(71051, new Object[]{user, identityContext}, (Throwable)cause);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
                BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "End");
            }
        }
    }

    public IBPMContext authenticateOnBehalfOf(IBPMContext adminWorkflowContext, String onBehalfOfUser) throws BPMException {
        String METHOD = "authenticateOnBehalfOf";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
            BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "Begin");
        }
        try {
            IBPMContext ctx;
            IBPMContext iBPMContext = ctx = (IBPMContext)this.getVerificationService().authenticateUser((IWorkflowContext)adminWorkflowContext, onBehalfOfUser);
            return iBPMContext;
        }
        catch (Exception cause) {
            throw new BPMException(71052, new Object[]{onBehalfOfUser, adminWorkflowContext}, (Throwable)cause);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
                BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "End");
            }
        }
    }

    public IBPMContext getBPMContextForAuthenticatedUser() throws BPMException {
        String METHOD = "getBPMContextForAuthenticatedUser";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
            BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "Begin");
        }
        try {
            IBPMContext ctx;
            IBPMContext iBPMContext = ctx = (IBPMContext)this.getVerificationService().authenticateUser(null, null, null, null);
            return iBPMContext;
        }
        catch (Exception cause) {
            throw new BPMException(71054, null, (Throwable)cause);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
                BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "End");
            }
        }
    }

    public void destroyBPMContext(IBPMContext ctx) throws BPMException {
        String METHOD = "destroyBPMContext";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
            BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "Begin");
        }
        try {
            this.getVerificationService().destroyContext(ctx.getToken());
        }
        catch (Exception e) {
            throw new BPMException(71053, new Object[]{ctx}, (Throwable)e);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
                BPMUserAuthenticationService.debugLog(CLASS_NAME, METHOD, "End");
            }
        }
    }

    public IVerificationService getVerificationService() {
        if (this.verificationService == null) {
            this.verificationService = new VerificationService();
        }
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService newVerificationService) {
        this.verificationService = newVerificationService;
    }

    private static void debugLog(String className, String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_USER_AUTHENTICATION_SERVICE, (Severity)Severity.DEBUG, (String)className, (String)method, (String)msg);
        }
    }

    static {
        sContextCreationMonitor = new Object();
        CLASS_NAME = "BPMUserAuthenticationService";
    }
}

