/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.test;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.imageio.ImageIO;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import oracle.bpel.services.workflow.StaleObjectException;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.activityguide.query.ejb.AGQueryServiceRemote;
import oracle.bpel.services.workflow.activityguide.query.ejb.AGQueryServiceRemoteHome;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfoType;
import oracle.bpel.services.workflow.query.ejb.TaskQueryServiceRemote;
import oracle.bpel.services.workflow.query.ejb.TaskQueryServiceRemoteHome;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.task.ejb.TaskServiceRemote;
import oracle.bpel.services.workflow.task.ejb.TaskServiceRemoteHome;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.task.model.TaskType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;

public class BpmAGQueryTest
extends TestCase {
    public static final String USERNAME = "weblogic";
    protected static final String PASSWORD = "weblogic1";
    public static final String REALM = "jazn.com";
    protected IWorkflowContext adminCtx = null;
    protected IWorkflowContext jsteinCtx = null;
    TaskQueryServiceRemote task_query_svc = null;
    AGQueryServiceRemote ag_query_svc = null;
    TaskServiceRemote task_svc = null;
    protected static String instanceId = null;

    public BpmAGQueryTest(String name) {
        super(name);
        try {
            Object obj = BpmAGQueryTest.getInitialContext().lookup("TaskQueryService");
            TaskQueryServiceRemoteHome home = (TaskQueryServiceRemoteHome)PortableRemoteObject.narrow((Object)obj, TaskQueryServiceRemoteHome.class);
            this.task_query_svc = (TaskQueryServiceRemote)PortableRemoteObject.narrow((Object)home.create(), TaskQueryServiceRemote.class);
            this.adminCtx = this.task_query_svc.authenticate(USERNAME, PASSWORD.toCharArray(), REALM);
            this.adminCtx.setLocale(Locale.getDefault());
            this.jsteinCtx = this.task_query_svc.authenticate("jstein", "welcome1".toCharArray(), REALM);
            Object obj1 = BpmAGQueryTest.getInitialContext().lookup("AGQueryService");
            AGQueryServiceRemoteHome home1 = (AGQueryServiceRemoteHome)PortableRemoteObject.narrow((Object)obj1, AGQueryServiceRemoteHome.class);
            this.ag_query_svc = (AGQueryServiceRemote)PortableRemoteObject.narrow((Object)home1.create(), AGQueryServiceRemote.class);
            Object obj2 = BpmAGQueryTest.getInitialContext().lookup("ejb/bpel/services/workflow/TaskServiceBean");
            TaskServiceRemoteHome home2 = (TaskServiceRemoteHome)PortableRemoteObject.narrow((Object)obj2, TaskServiceRemoteHome.class);
            this.task_svc = (TaskServiceRemote)PortableRemoteObject.narrow((Object)home2.create(), TaskServiceRemote.class);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (CreateException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TestRunner.run(BpmAGQueryTest.class);
    }

    public void setUp() {
    }

    public void testBPMQueryAGDisplayInfos() {
        System.out.println("Invoking queryAGDisplayInfos() method for fetching BPM instances");
        List agDisplayInfosList = null;
        try {
            agDisplayInfosList = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), IAGQueryService.AGAssignmentFilter.ADMIN, null, null, 0, 0);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        int size = agDisplayInfosList == null || agDisplayInfosList.isEmpty() ? 0 : agDisplayInfosList.size();
        BpmAGQueryTest.assertNotNull((String)"AG DisplayInfo List is null", (Object)agDisplayInfosList);
        BpmAGQueryTest.assertTrue((String)"AGDisplay list is empty", (size > 0 ? 1 : 0) != 0);
        System.out.println("Size of AGDisplayInfoList is:" + size);
        if (size > 0) {
            instanceId = ((AGDisplayInfo)agDisplayInfosList.get(0)).getInstanceId();
        }
    }

    public void testAGProcessQueryModes() {
        try {
            List ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPEL", this.adminCtx, new ArrayList(), IAGQueryService.AGAssignmentFilter.ADMIN, null, null, 0, 0);
            BpmAGQueryTest.assertTrue((ag_list == null || ag_list.size() == 0 ? 1 : 0) != 0);
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPEL", this.adminCtx, new ArrayList(), "Admin", null, null, 0, 0);
            BpmAGQueryTest.assertTrue((ag_list == null || ag_list.size() == 0 ? 1 : 0) != 0);
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGANY", this.adminCtx, new ArrayList(), IAGQueryService.AGAssignmentFilter.ADMIN, null, null, 0, 0);
            BpmAGQueryTest.assertTrue((ag_list.size() == 1 ? 1 : 0) != 0);
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGANY", this.adminCtx, new ArrayList(), "Admin", null, null, 0, 0);
            BpmAGQueryTest.assertTrue((ag_list.size() == 1 ? 1 : 0) != 0);
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), "My", null, null, 0, 0);
            BpmAGQueryTest.assertTrue((ag_list.size() == 1 ? 1 : 0) != 0);
            AGDisplayInfo ag_info = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPEL", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "Admin");
            BpmAGQueryTest.assertNull((Object)ag_info);
            ag_info = this.ag_query_svc.getAGDisplayInfoDetailsById("AGANY", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "Admin");
            BpmAGQueryTest.assertNotNull((Object)ag_info);
            MilestoneDisplayInfo ms_info = this.ag_query_svc.getMilestoneDisplayInfo("AGBPEL", this.adminCtx, new Long(instanceId).longValue(), "Milestone1", new ArrayList(), "Admin");
            BpmAGQueryTest.assertNull((Object)ms_info);
            ms_info = this.ag_query_svc.getMilestoneDisplayInfo("AGANY", this.adminCtx, new Long(instanceId).longValue(), "Milestone1", new ArrayList(), "Admin");
            BpmAGQueryTest.assertNotNull((Object)ms_info);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void testPredicatesAndOrdering() {
        List ag_list = new ArrayList();
        try {
            Predicate predicate = new Predicate(TableConstants.WFTASK_COMPONENTNAME_COLUMN, 0, (Object)"BPMAGProcess");
            Ordering order = new Ordering(TableConstants.WFTASK_INSTANCEID_COLUMN, false, true);
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), "Admin", predicate, order, 0, 0);
            BpmAGQueryTest.assertEquals((String)"AG with matching predicates and ordering not returned for ADMIN", (int)1, (int)ag_list.size());
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void testQueryAGForNonParticipantUser() {
        System.out.println("Invoking queryAGDisplayInfos() method for user who has not participated in AG");
        List agDisplayInfosList = null;
        try {
            agDisplayInfosList = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.jsteinCtx, new ArrayList(), IAGQueryService.AGAssignmentFilter.MY, null, null, 0, 0);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        int size = agDisplayInfosList == null || agDisplayInfosList.isEmpty() ? 0 : agDisplayInfosList.size();
        BpmAGQueryTest.assertTrue((String)"AGDisplay list should be empty for non-participant user", (size == 0 ? 1 : 0) != 0);
        System.out.println("Invoking getAGDisplayInfoDetailsById() method for user who has not participated in AG");
        AGDisplayInfo agDisplayInfo = null;
        try {
            agDisplayInfo = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPM", this.jsteinCtx, new Long(instanceId).longValue(), new ArrayList(), "My");
            BpmAGQueryTest.fail((String)"Exception not thrown when non-participant user invokes getAGDisplayInfoDetailsById");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        System.out.println("Invoking getMilestoneDisplayInfo() method for user who has not participated in AG");
        MilestoneDisplayInfo msDisplayInfo = null;
        try {
            msDisplayInfo = this.ag_query_svc.getMilestoneDisplayInfo("AGBPM", this.jsteinCtx, new Long(instanceId).longValue(), "Milestone1", new ArrayList(), "My");
            BpmAGQueryTest.fail((String)"Exception not thrown when non-participant user invokes getMilestonDisplayInfo");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void testBPMGetAGDisplayInfoDetailsById() {
        System.out.println("Invoking getAGDisplayInfoDetailsById() method for fetching BPM instances");
        AGDisplayInfo agDisplayInfo = null;
        try {
            agDisplayInfo = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPM", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "Admin");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        BpmAGQueryTest.assertNotNull((String)"AG DisplayInfo List is null", agDisplayInfo);
        if (agDisplayInfo != null) {
            BpmAGQueryTest.assertEquals((String)"AG Title mismatch", (String)agDisplayInfo.getTitle(), (String)"BPMAGProcess");
            BpmAGQueryTest.assertEquals((String)"AG Description mismatch", (String)agDisplayInfo.getDescription(), (String)"BPM-AG process");
            BpmAGQueryTest.assertEquals((String)"Total # of tasks is incorrect", (int)agDisplayInfo.getTotalTasks().intValue(), (int)2);
            BpmAGQueryTest.assertEquals((String)"Completed tasks is incorrect", (int)agDisplayInfo.getCompletedTaskCount().intValue(), (int)0);
            BpmAGQueryTest.assertEquals((String)"Percentage complete is incorrect", (int)agDisplayInfo.getPercentageComplete().intValue(), (int)0);
            BpmAGQueryTest.assertEquals((String)"Status is incorrect", (String)agDisplayInfo.getStatus(), (String)"In Progress");
            BpmAGQueryTest.assertEquals((String)"Task access mode is incorrect", (String)agDisplayInfo.getGlobalTaskAccessMode(), (String)"anyStates");
            List msDisplayInfoList = agDisplayInfo.getMilestoneDisplayInfo();
            BpmAGQueryTest.assertNotNull((String)"Milestone list is null", (Object)msDisplayInfoList);
            BpmAGQueryTest.assertTrue((String)"Milestone list size is incorrect", (msDisplayInfoList.size() == 1 ? 1 : 0) != 0);
            MilestoneDisplayInfo milestone = (MilestoneDisplayInfo)msDisplayInfoList.get(0);
            BpmAGQueryTest.assertEquals((String)"Milestone Title mismatch", (String)milestone.getTitle(), (String)"Milestone1");
            BpmAGQueryTest.assertEquals((String)"Milestone description mismatch", (String)milestone.getDescription(), (String)"First milestone");
            BpmAGQueryTest.assertEquals((String)"Milestone status is incorrect", (String)milestone.getStatus(), (String)"In Progress");
            BpmAGQueryTest.assertEquals((String)"Total # of tasks is incorrect", (int)milestone.getTotalTasksLeft().intValue(), (int)2);
            BpmAGQueryTest.assertEquals((String)"Completed tasks in milestone is incorrect", (int)milestone.getCompletedTaskCount().intValue(), (int)0);
            List taskDisplayInfoList = milestone.getTaskDisplayInfo();
            BpmAGQueryTest.assertNotNull((String)"Task list is null", (Object)taskDisplayInfoList);
            BpmAGQueryTest.assertTrue((String)"Task list size is incorrect", (taskDisplayInfoList.size() == 2 ? 1 : 0) != 0);
            TaskDisplayInfoType taskDisp1 = (TaskDisplayInfoType)taskDisplayInfoList.get(0);
            BpmAGQueryTest.assertEquals((String)"Task is active but flagged incorrectly", (boolean)taskDisp1.isTaskInactive(), (boolean)false);
            BpmAGQueryTest.assertEquals((String)"Task Id mismatch ", (String)taskDisp1.getId(), (String)"a3_BPMAGProcess");
            BpmAGQueryTest.assertEquals((String)"Task is not a blocking task but flagged incorrectly ", (boolean)taskDisp1.isDisplayBlockedIcon(), (boolean)false);
            BpmAGQueryTest.assertEquals((String)"Task is not optional but flagged incorrectly ", (boolean)taskDisp1.isOptional(), (boolean)false);
            TaskType task1 = taskDisp1.getTask();
            BpmAGQueryTest.assertNotNull((String)"Task VO is null", (Object)task1);
            if (task1 != null) {
                BpmAGQueryTest.assertEquals((String)"Task VO status is incorrect", (String)task1.getSystemAttributes().getState(), (String)"ASSIGNED");
                BpmAGQueryTest.assertEquals((String)"Task VO title is incorrect", (String)"Task1", (String)task1.getTitle());
            }
            TaskDisplayInfoType taskDisp2 = (TaskDisplayInfoType)taskDisplayInfoList.get(1);
            BpmAGQueryTest.assertEquals((String)"Task is inactive but flagged incorrectly", (boolean)taskDisp2.isTaskInactive(), (boolean)true);
            BpmAGQueryTest.assertEquals((String)"Task Id mismatch ", (String)taskDisp2.getId(), (String)"a8_BPMAGProcess");
            BpmAGQueryTest.assertEquals((String)"Task is not a blocking task but flagged incorrectly ", (boolean)taskDisp2.isDisplayBlockedIcon(), (boolean)false);
            BpmAGQueryTest.assertEquals((String)"Task is not optional but flagged incorrectly ", (boolean)taskDisp2.isOptional(), (boolean)false);
            TaskType task2 = taskDisp2.getTask();
            BpmAGQueryTest.assertNotNull((String)"Task VO is null", (Object)task2);
            if (task2 != null) {
                BpmAGQueryTest.assertEquals((String)"Task VO status is incorrect", (String)task2.getSystemAttributes().getState(), (String)"Not Started");
            }
        }
    }

    public void testIconURL() {
        System.out.println("Invoking getAGDisplayInfoDetailsById() method for checking icon URL");
        AGDisplayInfo agDisplayInfo = null;
        try {
            agDisplayInfo = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPM", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "Admin");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        BpmAGQueryTest.assertNotNull((String)"AG DisplayInfo is null", agDisplayInfo);
        String iconURL = this.verifyImageURL(agDisplayInfo.getTaskBlockedIconLocation());
        BpmAGQueryTest.assertNotNull((String)"URL for task blocked icon is not found", (Object)iconURL);
        iconURL = this.verifyImageURL(agDisplayInfo.getIconLocation());
        BpmAGQueryTest.assertNotNull((String)"URL for AG icon is not found", (Object)iconURL);
        MilestoneDisplayInfo milestone = (MilestoneDisplayInfo)agDisplayInfo.getMilestoneDisplayInfo().get(0);
        iconURL = this.verifyImageURL(milestone.getIconLocation());
        BpmAGQueryTest.assertNotNull((String)"URL for milestone icon is not found", (Object)iconURL);
    }

    public void testBPMGetMilestoneDisplayInfo() {
        System.out.println("Invoking getMilestoneDisplayInfo() method for fetching BPM instances");
        MilestoneDisplayInfo msDisplayInfo = null;
        try {
            msDisplayInfo = this.ag_query_svc.getMilestoneDisplayInfo("AGBPM", this.adminCtx, new Long(instanceId).longValue(), "Milestone1", new ArrayList(), "Admin");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        BpmAGQueryTest.assertNotNull((String)"Milestone object is null", msDisplayInfo);
        if (msDisplayInfo != null) {
            BpmAGQueryTest.assertEquals((String)"Milestone Title mismatch", (String)msDisplayInfo.getTitle(), (String)"Milestone1");
            BpmAGQueryTest.assertEquals((String)"Milestone description mismatch", (String)msDisplayInfo.getDescription(), (String)"First milestone");
            BpmAGQueryTest.assertEquals((String)"Milestone status is incorrect", (String)msDisplayInfo.getStatus(), (String)"In Progress");
            BpmAGQueryTest.assertEquals((String)"Total # of tasks is incorrect", (int)msDisplayInfo.getTotalTasksLeft().intValue(), (int)2);
            BpmAGQueryTest.assertEquals((String)"Completed tasks in milestone is incorrect", (int)msDisplayInfo.getCompletedTaskCount().intValue(), (int)0);
            List taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
            BpmAGQueryTest.assertNotNull((String)"Task list is null", (Object)taskDisplayInfoList);
            BpmAGQueryTest.assertTrue((String)"Task list size is incorrect", (taskDisplayInfoList.size() == 2 ? 1 : 0) != 0);
            TaskDisplayInfoType taskDisp1 = (TaskDisplayInfoType)taskDisplayInfoList.get(0);
            BpmAGQueryTest.assertEquals((String)"Task is active but flagged incorrectly", (boolean)taskDisp1.isTaskInactive(), (boolean)false);
            BpmAGQueryTest.assertEquals((String)"Task Id mismatch ", (String)taskDisp1.getId(), (String)"a3_BPMAGProcess");
            BpmAGQueryTest.assertEquals((String)"Task is not a blocking task but flagged incorrectly ", (boolean)taskDisp1.isDisplayBlockedIcon(), (boolean)false);
            BpmAGQueryTest.assertEquals((String)"Task is not optional but flagged incorrectly ", (boolean)taskDisp1.isOptional(), (boolean)false);
            TaskType task1 = taskDisp1.getTask();
            BpmAGQueryTest.assertNotNull((String)"Task VO is null", (Object)task1);
            if (task1 != null) {
                BpmAGQueryTest.assertEquals((String)"Task VO status is incorrect", (String)task1.getSystemAttributes().getState(), (String)"ASSIGNED");
            }
            TaskDisplayInfoType taskDisp2 = (TaskDisplayInfoType)taskDisplayInfoList.get(1);
            BpmAGQueryTest.assertEquals((String)"Task is inactive but flagged incorrectly", (boolean)taskDisp2.isTaskInactive(), (boolean)true);
            BpmAGQueryTest.assertEquals((String)"Task Id mismatch ", (String)taskDisp2.getId(), (String)"a8_BPMAGProcess");
            BpmAGQueryTest.assertEquals((String)"Task is not a blocking task but flagged incorrectly ", (boolean)taskDisp2.isDisplayBlockedIcon(), (boolean)false);
            BpmAGQueryTest.assertEquals((String)"Task is not optional but flagged incorrectly ", (boolean)taskDisp2.isOptional(), (boolean)false);
            TaskType task2 = taskDisp2.getTask();
            BpmAGQueryTest.assertNotNull((String)"Task VO is null", (Object)task2);
            if (task2 != null) {
                BpmAGQueryTest.assertEquals((String)"Task VO status is incorrect", (String)task2.getSystemAttributes().getState(), (String)"Not Started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFrenchLocaleDisplayText() {
        Locale frenchLocale = new Locale("fr");
        this.adminCtx.setLocale(frenchLocale);
        List agDisplayInfosList = null;
        AGDisplayInfo agDisplayInfo = null;
        MilestoneDisplayInfo msDisplayInfo = null;
        try {
            agDisplayInfosList = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), IAGQueryService.AGAssignmentFilter.MY, null, null, 0, 0);
            BpmAGQueryTest.assertTrue((agDisplayInfosList != null && agDisplayInfosList.size() == 1 ? 1 : 0) != 0);
            agDisplayInfo = (AGDisplayInfo)agDisplayInfosList.get(0);
            BpmAGQueryTest.assertTrue((String)"AG title for french locale is incorrect", (boolean)agDisplayInfo.getTitle().startsWith("fr"));
            BpmAGQueryTest.assertTrue((String)"AG description for french locale is incorrect", (boolean)agDisplayInfo.getDescription().startsWith("fr"));
            agDisplayInfo = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPM", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "My");
            BpmAGQueryTest.assertNotNull((Object)agDisplayInfo);
            BpmAGQueryTest.assertTrue((String)"AG title for french locale is incorrect", (boolean)agDisplayInfo.getTitle().startsWith("fr"));
            BpmAGQueryTest.assertTrue((String)"AG description for french locale is incorrect", (boolean)agDisplayInfo.getDescription().startsWith("fr"));
            msDisplayInfo = (MilestoneDisplayInfo)agDisplayInfo.getMilestoneDisplayInfo().get(0);
            BpmAGQueryTest.assertNotNull((Object)msDisplayInfo);
            BpmAGQueryTest.assertTrue((String)"Milestone title for french locale is incorrect", (boolean)msDisplayInfo.getTitle().startsWith("fr"));
            BpmAGQueryTest.assertTrue((String)"Milestone description for french locale is incorrect", (boolean)msDisplayInfo.getDescription().startsWith("fr"));
            List taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
            BpmAGQueryTest.assertTrue((String)"Task list size is incorrect", (taskDisplayInfoList != null && taskDisplayInfoList.size() == 2 ? 1 : 0) != 0);
            TaskDisplayInfoType taskDisp1 = (TaskDisplayInfoType)taskDisplayInfoList.get(0);
            TaskType task1 = taskDisp1.getTask();
            BpmAGQueryTest.assertNotNull((String)"Task VO is null", (Object)task1);
            BpmAGQueryTest.assertTrue((String)"Task VO title for french locale is incorrect", (boolean)task1.getTitle().startsWith("fr"));
            msDisplayInfo = this.ag_query_svc.getMilestoneDisplayInfo("AGBPM", this.adminCtx, new Long(instanceId).longValue(), "Milestone1", new ArrayList(), "My");
            BpmAGQueryTest.assertNotNull((Object)msDisplayInfo);
            BpmAGQueryTest.assertTrue((String)"Milestone title for french locale is incorrect", (boolean)msDisplayInfo.getTitle().startsWith("fr"));
            BpmAGQueryTest.assertTrue((String)"Milestone description for french locale is incorrect", (boolean)msDisplayInfo.getDescription().startsWith("fr"));
            taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
            BpmAGQueryTest.assertTrue((String)"Task list size is incorrect", (taskDisplayInfoList != null && taskDisplayInfoList.size() == 2 ? 1 : 0) != 0);
            taskDisp1 = (TaskDisplayInfoType)taskDisplayInfoList.get(0);
            task1 = taskDisp1.getTask();
            BpmAGQueryTest.assertNotNull((String)"Task VO is null", (Object)task1);
            BpmAGQueryTest.assertTrue((String)"Task VO title for french locale is incorrect", (boolean)task1.getTitle().startsWith("fr"));
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        finally {
            this.adminCtx.setLocale(Locale.getDefault());
        }
    }

    public void testAGCompletion() {
        Task task;
        AGDisplayInfo agDisplayInfo = null;
        try {
            agDisplayInfo = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPM", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "Admin");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        List msDisplayInfoList = agDisplayInfo.getMilestoneDisplayInfo();
        MilestoneDisplayInfo msDisplayInfo = (MilestoneDisplayInfo)msDisplayInfoList.get(0);
        List taskList = msDisplayInfo.getTaskDisplayInfo();
        TaskType tasktype = ((TaskDisplayInfoType)taskList.get(0)).getTask();
        String taskId = tasktype.getSystemAttributes().getTaskId();
        Task outcome = null;
        System.out.println("Approving first task");
        try {
            task = this.task_query_svc.getTaskDetailsById(this.adminCtx, taskId);
            outcome = this.task_svc.updateTaskOutcome(this.adminCtx, task, "APPROVE");
        }
        catch (StaleObjectException e) {
            e.printStackTrace();
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Invoking getAGDisplayInfoDetailsByID() after approving first task");
        try {
            agDisplayInfo = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPM", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "Admin");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        BpmAGQueryTest.assertEquals((String)"Total # of tasks is incorrect", (int)agDisplayInfo.getTotalTasks().intValue(), (int)2);
        BpmAGQueryTest.assertEquals((String)"Completed tasks is incorrect", (int)agDisplayInfo.getCompletedTaskCount().intValue(), (int)1);
        BpmAGQueryTest.assertEquals((String)"Percentage complete is incorrect", (int)agDisplayInfo.getPercentageComplete().intValue(), (int)50);
        BpmAGQueryTest.assertEquals((String)"AG Status is incorrect", (String)agDisplayInfo.getStatus(), (String)"In Progress");
        msDisplayInfoList = agDisplayInfo.getMilestoneDisplayInfo();
        msDisplayInfo = (MilestoneDisplayInfo)msDisplayInfoList.get(0);
        BpmAGQueryTest.assertEquals((String)"Milestone status is incorrect", (String)msDisplayInfo.getStatus(), (String)"In Progress");
        BpmAGQueryTest.assertEquals((String)"Total # of tasks is incorrect", (int)msDisplayInfo.getTotalTasksLeft().intValue(), (int)2);
        BpmAGQueryTest.assertEquals((String)"Completed tasks in milestone is incorrect", (int)msDisplayInfo.getCompletedTaskCount().intValue(), (int)1);
        taskList = msDisplayInfo.getTaskDisplayInfo();
        tasktype = ((TaskDisplayInfoType)taskList.get(1)).getTask();
        taskId = tasktype.getSystemAttributes().getTaskId();
        System.out.println("Approving last task");
        try {
            task = this.task_query_svc.getTaskDetailsById(this.adminCtx, taskId);
            outcome = this.task_svc.updateTaskOutcome(this.adminCtx, task, "APPROVE");
        }
        catch (StaleObjectException e) {
            e.printStackTrace();
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Invoking getAGDisplayInfoDetailsByID() after approving last task");
        try {
            agDisplayInfo = this.ag_query_svc.getAGDisplayInfoDetailsById("AGBPM", this.adminCtx, new Long(instanceId).longValue(), new ArrayList(), "Admin");
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        BpmAGQueryTest.assertEquals((String)"Total # of tasks is incorrect", (int)agDisplayInfo.getTotalTasks().intValue(), (int)2);
        BpmAGQueryTest.assertEquals((String)"Completed tasks is incorrect", (int)agDisplayInfo.getCompletedTaskCount().intValue(), (int)2);
        BpmAGQueryTest.assertEquals((String)"Percentage complete is incorrect", (int)agDisplayInfo.getPercentageComplete().intValue(), (int)100);
        BpmAGQueryTest.assertEquals((String)"AG Status is incorrect", (String)agDisplayInfo.getStatus(), (String)"Completed");
        msDisplayInfoList = agDisplayInfo.getMilestoneDisplayInfo();
        msDisplayInfo = (MilestoneDisplayInfo)msDisplayInfoList.get(0);
        BpmAGQueryTest.assertEquals((String)"Milestone status is incorrect", (String)msDisplayInfo.getStatus(), (String)"Completed");
        BpmAGQueryTest.assertEquals((String)"Total # of tasks is incorrect", (int)msDisplayInfo.getTotalTasksLeft().intValue(), (int)2);
        BpmAGQueryTest.assertEquals((String)"Completed tasks in milestone is incorrect", (int)msDisplayInfo.getCompletedTaskCount().intValue(), (int)2);
    }

    public void testAGSelectionFilters() {
        List ag_list = new ArrayList();
        try {
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), "Admin", null, null, 0, 0);
            BpmAGQueryTest.assertEquals((String)"AG with completed tasks should be returned for ADMIN", (int)1, (int)ag_list.size());
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), "My", null, null, 0, 0);
            BpmAGQueryTest.assertEquals((String)"AG with completed tasks should not be returned for MY filter", (int)0, (int)ag_list.size());
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), "Reportees", null, null, 0, 0);
            BpmAGQueryTest.assertEquals((String)"AG with completed tasks should not be returned for REPORTEES filter", (int)0, (int)ag_list.size());
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), "Previous", null, null, 0, 0);
            BpmAGQueryTest.assertEquals((String)"AG with completed tasks should be returned for PREVIOUS filter", (int)1, (int)ag_list.size());
            ag_list = this.ag_query_svc.queryAGDisplayInfos("AGBPM", this.adminCtx, new ArrayList(), "Creator", null, null, 0, 0);
            BpmAGQueryTest.assertEquals((String)"No AG should be returned since CREATOR filter is not supported", (int)0, (int)ag_list.size());
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static Context getInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        String hostname = System.getProperty("host.name");
        String hosturl = "t3://" + hostname + ":7001";
        env.put("java.naming.provider.url", hosturl);
        return new InitialContext(env);
    }

    protected String verifyImageURL(String imageURL) {
        String result = null;
        try {
            URL url = new URL(imageURL);
            if (ImageIO.read(url) != null) {
                result = imageURL;
            }
        }
        catch (Exception ex) {
            System.out.println("Image URL is invalid");
        }
        System.out.println("Returning url string:" + result);
        return result;
    }
}

