/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.model.metadata.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.services.activityguide.common.AGMetadataServiceUtil;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;
import oracle.bpm.services.activityguide.model.metadata.IMilestone;
import oracle.bpm.services.activityguide.model.metadata.ITranslatableValue;
import oracle.bpm.services.activityguide.model.metadata.IUserTask;
import oracle.bpm.services.activityguide.model.metadata.impl.ActivityGuideImpl;
import oracle.bpm.services.activityguide.model.metadata.impl.TranslatableValueImpl;
import oracle.bpm.services.activityguide.model.metadata.impl.UserTaskImpl;

public class MilestoneImpl
implements IMilestone {
    private Map<String, IUserTask> childTaskMap = new HashMap<String, IUserTask>();
    private List<IUserTask> childTasks = new ArrayList<IUserTask>();
    private String milestoneIconUrlString = null;
    private Milestone msModel = null;
    private ActivityGuideImpl parentActivityGuide = null;
    private DisplayMode taskLevelDisplayMode = null;
    private TranslatableValueImpl title = null;
    private TranslatableValueImpl description = null;

    public MilestoneImpl(Milestone msModel, ActivityGuideImpl parentAgModel) {
        this.msModel = msModel;
        this.parentActivityGuide = parentAgModel;
        this.taskLevelDisplayMode = msModel.getDisplayMode() == null || msModel.getDisplayMode() == DisplayMode.DEFAULT ? parentAgModel.getDisplayMode() : msModel.getDisplayMode();
        String soaApplicationBaseUrl = parentAgModel.getSoaApplicationBaseUrl();
        String iconLocation = msModel.getIconLocation();
        if (soaApplicationBaseUrl != null && iconLocation != null && !iconLocation.isEmpty()) {
            this.milestoneIconUrlString = AGMetadataServiceUtil.getResourceLocationUrl(soaApplicationBaseUrl, iconLocation);
        }
        if (msModel.getTranslatableTitle() != null) {
            this.title = new TranslatableValueImpl(msModel.getTranslatableTitle().getType(), msModel.getTranslatableTitle().getValue());
        }
        if (msModel.getTranslatableDescription() != null) {
            this.description = new TranslatableValueImpl(msModel.getTranslatableDescription().getType(), msModel.getTranslatableDescription().getValue());
        }
        Sequence milestoneActivities = msModel.getChildrenByType(MilestoneActivity.class);
        Iterator iter = milestoneActivities.iterator();
        while (iter.hasNext()) {
            UserTaskImpl taskMetadata = new UserTaskImpl((MilestoneActivity)iter.next(), this);
            this.childTasks.add(taskMetadata);
            this.childTaskMap.put(taskMetadata.getId(), taskMetadata);
        }
    }

    public String getId() {
        return this.msModel.getId();
    }

    public ITranslatableValue getTitle() {
        return this.title;
    }

    public ITranslatableValue getDescription() {
        return this.description;
    }

    public String getIconLocation() {
        return this.milestoneIconUrlString;
    }

    public String getDisplayMode() {
        return this.taskLevelDisplayMode.getValue();
    }

    public DisplayMode getInternalDisplayMode() {
        return this.taskLevelDisplayMode;
    }

    public int getTasksRemaining() {
        return this.msModel.getTasksRemaining();
    }

    public IActivityGuide getParentActivityGuide() {
        return this.parentActivityGuide;
    }

    public List<IUserTask> getUserTasks() {
        return this.childTasks;
    }

    public IUserTask findUserTask(String id) {
        return this.childTaskMap.get(id);
    }
}

