/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.model.metadata.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.services.activityguide.common.AGMetadataServiceUtil;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;
import oracle.bpm.services.activityguide.model.metadata.IMilestone;
import oracle.bpm.services.activityguide.model.metadata.IResourceBundleInfo;
import oracle.bpm.services.activityguide.model.metadata.ITranslatableValue;
import oracle.bpm.services.activityguide.model.metadata.impl.MilestoneImpl;
import oracle.bpm.services.activityguide.model.metadata.impl.ResourceBundleInfoImpl;
import oracle.bpm.services.activityguide.model.metadata.impl.TranslatableValueImpl;

public class ActivityGuideImpl
implements IActivityGuide {
    private String activityGuideIconUrlString = null;
    private DisplayMode agLevelDisplayMode = null;
    private ActivityGuide agModel = null;
    private Map<String, IMilestone> childMilestoneMap = new HashMap<String, IMilestone>();
    private List<IMilestone> childMilestones = new ArrayList<IMilestone>();
    private String compositeDN = null;
    private String soaApplicationBaseUrl = null;
    private String taskBlockedIconUrlString = null;
    private TranslatableValueImpl title = null;
    private TranslatableValueImpl description = null;
    private ResourceBundleInfoImpl resourceBundleInfo = null;
    static final String TASKBLOCKEDICONLOCATION = "resources/taskBlockedIcon.png";

    public ActivityGuideImpl(String compositeDN, ActivityGuide agProjectModel) {
        this.compositeDN = compositeDN;
        this.agModel = agProjectModel;
        this.agLevelDisplayMode = this.agModel.getDisplayMode() == null || this.agModel.getDisplayMode() == DisplayMode.DEFAULT ? DisplayMode.ALWAYS : this.agModel.getDisplayMode();
        try {
            this.soaApplicationBaseUrl = BPMNServiceEngine.getInstance().getDeployedCompositeBaseURL(compositeDN);
            this.soaApplicationBaseUrl = AGMetadataServiceUtil.getURLSafeString(this.soaApplicationBaseUrl);
        }
        catch (Exception e) {
            this.soaApplicationBaseUrl = null;
        }
        String iconLocation = this.agModel.getIconLocation();
        if (this.soaApplicationBaseUrl != null && iconLocation != null && !iconLocation.isEmpty()) {
            this.activityGuideIconUrlString = AGMetadataServiceUtil.getResourceLocationUrl(this.soaApplicationBaseUrl, iconLocation);
        }
        this.taskBlockedIconUrlString = AGMetadataServiceUtil.getResourceLocationUrl(this.soaApplicationBaseUrl, TASKBLOCKEDICONLOCATION);
        if (this.agModel.getResourceBundle() != null) {
            this.resourceBundleInfo = new ResourceBundleInfoImpl(this.agModel.getResourceBundle());
        }
        if (this.agModel.getTranslatableTitle() != null) {
            this.title = new TranslatableValueImpl(this.agModel.getTranslatableTitle().getType(), this.agModel.getTranslatableTitle().getValue());
        }
        if (this.agModel.getTranslatableDescription() != null) {
            this.description = new TranslatableValueImpl(this.agModel.getTranslatableDescription().getType(), this.agModel.getTranslatableDescription().getValue());
        }
        Sequence milestones = this.agModel.getChildrenByType(Milestone.class);
        Iterator iter = milestones.iterator();
        while (iter.hasNext()) {
            MilestoneImpl msMetadata = new MilestoneImpl((Milestone)iter.next(), this);
            this.childMilestones.add(msMetadata);
            this.childMilestoneMap.put(msMetadata.getId(), msMetadata);
        }
    }

    public String getId() {
        return this.agModel.getId();
    }

    public ITranslatableValue getTitle() {
        return this.title;
    }

    public ITranslatableValue getDescription() {
        return this.description;
    }

    public String getIconLocation() {
        return this.activityGuideIconUrlString;
    }

    public String getTaskBlockedIconLocation() {
        return this.taskBlockedIconUrlString;
    }

    public String getRootProcessId() {
        return this.agModel.getRootProcess().getId();
    }

    public IResourceBundleInfo getResourceBundleInfo() {
        return this.resourceBundleInfo;
    }

    public String getTaskAccessMode() {
        return this.agModel.getTaskAccessMode().getValue();
    }

    public List<IMilestone> getMilestones() {
        return this.childMilestones;
    }

    public IMilestone findMilestone(String id) {
        return this.childMilestoneMap.get(id);
    }

    public DisplayMode getDisplayMode() {
        return this.agLevelDisplayMode;
    }

    public String getCompositeDN() {
        return this.compositeDN;
    }

    String getSoaApplicationBaseUrl() {
        return this.soaApplicationBaseUrl;
    }
}

