/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.activityguide.impl;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfo;
import oracle.bpel.services.workflow.metadata.impl.TaskMetadataCache;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.permission.WorkflowPermission;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.task.model.TaskType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.InternalWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.activityguide.common.AGi18nUtil;
import oracle.bpm.services.activityguide.impl.BaseAGQueryService;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;
import oracle.bpm.services.activityguide.model.metadata.IMilestone;
import oracle.bpm.services.activityguide.model.metadata.IUserTask;
import oracle.bpm.services.activityguide.model.metadata.TranslatableValueTypeEnum;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;

public class BpmAGQueryService
extends BaseAGQueryService {
    private static final String CLASSNAME = "oracle.bpm.services.activityguide.impl.BpmAGQueryService";
    private static final String ALL_TASK_MAP = "AllTasksIdMap";
    private static final String FILTERED_TASK_MAP = "FilteredTasksIdMap";
    private static final Map<String, String> AG_BPM_STATE_MAP = new HashMap<String, String>();
    protected static List taskVerificationColumns = new ArrayList();

    public static IAGQueryService.AGAssignmentFilter getAGAssignmentFilterEnum(String filter) {
        if (filter == null) {
            return null;
        }
        return IAGQueryService.AGAssignmentFilter.valueOf((String)filter.toUpperCase());
    }

    @Override
    public List queryAGDisplayInfos(IWorkflowContext ctx, List displayColumns, String assignmentFilter, Predicate predicate, Ordering order, int startRow, int endRow) throws WorkflowException {
        return this.queryAGDisplayInfos(ctx, displayColumns, BpmAGQueryService.getAGAssignmentFilterEnum(assignmentFilter), predicate, order, startRow, endRow);
    }

    @Override
    public List queryAGDisplayInfos(IWorkflowContext ctx, List displayColumns, IAGQueryService.AGAssignmentFilter assignmentFilter, Predicate customPredicate, Ordering order, int startRow, int endRow) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"queryAGDisplayInfos", (String)("Start of queryAGDisplayInfos for user: " + ctx.getUser()));
        if (assignmentFilter == null) {
            return null;
        }
        ArrayList<AGDisplayInfo> agDisplayInfoList = new ArrayList<AGDisplayInfo>();
        AGDisplayInfo agDisplayInfo = null;
        this.getVerificationService().validateContext(ctx);
        List<String> instanceIds = this.getProcessInstanceIds(ctx, assignmentFilter);
        if (instanceIds == null || instanceIds.isEmpty()) {
            return agDisplayInfoList;
        }
        Ordering finalOrdering = order;
        if (finalOrdering == null) {
            finalOrdering = new Ordering(IColumnConstants.PROCESS_INSTANCEID_COLUMN, true, true);
        }
        IWorkflowContext internalCtx = BpmAGQueryService.getInternalWorkflowContext();
        IBPMContext authContext = (IBPMContext)internalCtx;
        InstanceQueryInput queryInput = new InstanceQueryInput();
        IInstanceQueryInput.AssignmentFilter processAssignmentFilter = IInstanceQueryInput.AssignmentFilter.ALL;
        queryInput.setAssignmentFilter(processAssignmentFilter);
        queryInput.setStartRow(startRow);
        queryInput.setEndRow(endRow);
        Predicate agPredicate = new Predicate(TableConstants.WFTASK_AG_ROOTID_COLUMN, 22, (Object)null);
        Predicate instanceIdPredicate = new Predicate(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 9, instanceIds);
        Predicate processStatePredicate = new Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 1, (Object)"STALE");
        if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN) || assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS)) {
            processStatePredicate.addClause(8, IColumnConstants.PROCESS_STATE_COLUMN, 21, (Object)null);
        }
        Predicate agQueryPredicate = BpmAGQueryService.combineTwoPredicatesByAND(agPredicate, instanceIdPredicate);
        agQueryPredicate = BpmAGQueryService.combineTwoPredicatesByAND(agQueryPredicate, processStatePredicate);
        Predicate finalPredicate = BpmAGQueryService.combineTwoPredicatesByAND(agQueryPredicate, customPredicate);
        ArrayList processDisplayColumns = new ArrayList();
        this.addDefaultProcessColumns(processDisplayColumns);
        IInstanceQueryService instQrySvc = BPMServiceLocator.getInstanceQueryService();
        List agProcessInstances = new ArrayList();
        try {
            agProcessInstances = instQrySvc.queryProcessInstances(authContext, processDisplayColumns, finalPredicate, finalOrdering, (IInstanceQueryInput)queryInput);
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to query AG process instance in queryAGDisplayInfos."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"queryAGDisplayInfos()", (String)("Number of active BPM AGs returned: " + agProcessInstances.size()));
        if (agProcessInstances.size() > 0) {
            IBpmAGMetadataService metadataSvc = BPMServiceLocator.getBpmAGMetadataService();
            for (int i = 0; i < agProcessInstances.size(); ++i) {
                IProcessInstance processInstance = (IProcessInstance)agProcessInstances.get(i);
                IActivityGuide activityGuide = null;
                try {
                    String compositeDN = processInstance.getSca().getCompositeDN();
                    activityGuide = metadataSvc.getAGDefinition(compositeDN);
                }
                catch (BPMException e) {
                    Object[] errorObjs = new Object[]{"Failure to query AG definition from metadata service in queryAGDisplayInfos."};
                    WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
                    throw we;
                }
                if (activityGuide == null) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"queryAGDisplayInfos", (String)("Null AG Definition returned by Bpm AG Metadata service for Instance Id" + processInstance.getCubeInstanceId()));
                    continue;
                }
                AGi18nUtil.setBpmMetadataService(metadataSvc);
                agDisplayInfo = this.constructAGDisplayInfo(processInstance, activityGuide, ctx, assignmentFilter, false, null);
                agDisplayInfoList.add(agDisplayInfo);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"queryAGDisplayInfos", (String)("End of queryAGDisplayInfos for user: " + ctx.getUser()));
        return agDisplayInfoList;
    }

    @Override
    public AGDisplayInfo getAGDisplayInfoDetailsById(IWorkflowContext ctx, long ciKey, List taskDisplayColumns, String agAssignmentFilter) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("Start of getAGDisplayInfoDetailsById for user: " + ctx.getUser() + ", InstanceId: " + ciKey));
        if (agAssignmentFilter == null) {
            return null;
        }
        if (agAssignmentFilter.equals("Admin") && !BpmAGQueryService.isUserAGAdmin(ctx)) {
            Object[] errorObjs = new Object[]{ctx.getUser(), "isUserAGAdmin"};
            String reason = "User does not have the activity guide administration privilege required for using the ADMIN assignment filter. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser();
            WorkflowException we = new WorkflowException(38004, reason, errorObjs);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)we);
            throw we;
        }
        this.getVerificationService().validateContext(ctx);
        IWorkflowContext internalCtx = BpmAGQueryService.getInternalWorkflowContext();
        IBPMContext authContext = (IBPMContext)internalCtx;
        ArrayList processDisplayColumns = new ArrayList();
        this.addDefaultProcessColumns(processDisplayColumns);
        IInstanceQueryService instQrySvc = BPMServiceLocator.getInstanceQueryService();
        IProcessInstance agProcessInstance = null;
        try {
            agProcessInstance = instQrySvc.getProcessInstance(authContext, String.valueOf(ciKey));
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to query AG process instance " + ciKey + "in getAGDisplayInfoDetailsById."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (agProcessInstance == null) {
            return null;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("Got the process Instance with Id: " + ciKey + "from process query service"));
        IActivityGuide activityGuide = null;
        IBpmAGMetadataService metadataSvc = BPMServiceLocator.getBpmAGMetadataService();
        try {
            String compositeDN = agProcessInstance.getSca().getCompositeDN();
            activityGuide = metadataSvc.getAGDefinition(compositeDN);
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG definition from metadata service in getAGDisplayInfoDetailsById."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (activityGuide == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("Null AG Definition returned by Bpm AG Metadata service for Instance Id" + ciKey));
            return null;
        }
        AGi18nUtil.setBpmMetadataService(metadataSvc);
        AGDisplayInfo agDisplayInfo = this.constructAGDisplayInfo(agProcessInstance, activityGuide, ctx, BpmAGQueryService.getAGAssignmentFilterEnum(agAssignmentFilter), true, taskDisplayColumns);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getAGDisplayInfoDetailsById", (String)("End of getAGDisplayInfoDetailsById for user: " + ctx.getUser() + ", InstanceId: " + ciKey));
        return agDisplayInfo;
    }

    @Override
    public MilestoneDisplayInfo getMilestoneDisplayInfo(IWorkflowContext ctx, long cikey, String milestoneName, List taskDisplayColumns, String agAssignmentFilter) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("Start of getMilestoneDisplayInfo for user: " + ctx.getUser() + ", InstanceId: " + cikey + ", Milestone: " + milestoneName));
        if (agAssignmentFilter == null) {
            return null;
        }
        if (agAssignmentFilter.equals("Admin") && !BpmAGQueryService.isUserAGAdmin(ctx)) {
            Object[] errorObjs = new Object[]{ctx.getUser(), "isUserAGAdmin"};
            String reason = "User does not have the activity guide administration privilege required for using the ADMIN assignment filter. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser();
            WorkflowException we = new WorkflowException(38004, reason, errorObjs);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)we);
            throw we;
        }
        this.getVerificationService().validateContext(ctx);
        IWorkflowContext internalCtx = null;
        IBPMContext authContext = null;
        internalCtx = BpmAGQueryService.getInternalWorkflowContext();
        authContext = (IBPMContext)internalCtx;
        ArrayList processDisplayColumns = new ArrayList();
        this.addDefaultProcessColumns(processDisplayColumns);
        IInstanceQueryService instQrySvc = BPMServiceLocator.getInstanceQueryService();
        IProcessInstance processInstance = null;
        try {
            processInstance = instQrySvc.getProcessInstance(authContext, String.valueOf(cikey));
        }
        catch (Exception e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG process instance " + cikey + "in getMilestoneDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (processInstance == null) {
            return null;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("Got the process Instance with Id: " + cikey + "from process query service"));
        IActivityGuide activityGuide = null;
        IBpmAGMetadataService metadataSvc = BPMServiceLocator.getBpmAGMetadataService();
        try {
            String compositeDN = processInstance.getSca().getCompositeDN();
            activityGuide = metadataSvc.getAGDefinition(compositeDN);
        }
        catch (BPMException e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG definition from metadata service in getMilestoneDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        if (activityGuide == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.WARNING, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("Null AG Definition returned by Bpm AG Metadata service for Instance Id" + cikey));
            return null;
        }
        IMilestone milestoneDefn = activityGuide.findMilestone(milestoneName);
        if (milestoneDefn == null) {
            return null;
        }
        String compositeInstanceID = processInstance.getSca().getCompositeInstanceId();
        HashMap taskListMap = this.getTasksInAG(compositeInstanceID, ctx, BpmAGQueryService.getAGAssignmentFilterEnum(agAssignmentFilter), taskDisplayColumns);
        HashMap taskIdMap = (HashMap)taskListMap.get(FILTERED_TASK_MAP);
        boolean canUserSeeAG = this.canUserSeeAGDisplayInfo(ctx, taskIdMap);
        if (!canUserSeeAG) {
            Object[] errorObjs = new Object[]{ctx.getUser(), String.valueOf(cikey), "getMilestoneDisplayInfo"};
            String reason = "User is not allowed to see the activity guide. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(cikey) + " milestoneName = " + milestoneName;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (String)CLASSNAME, (String)"getMilestoneDisplayInfo()", (String)reason);
            throw new WorkflowException(38003, reason, errorObjs);
        }
        MilestoneDisplayInfo msDisplayInfo = null;
        AGi18nUtil.setBpmMetadataService(metadataSvc);
        msDisplayInfo = this.constructMilestoneDisplayInfo(ctx, activityGuide, taskListMap, milestoneDefn);
        List taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
        String ag_status = AG_BPM_STATE_MAP.get(processInstance.getSystemAttributes().getState());
        taskDisplayInfoList = this.filterBranchEntries(taskDisplayInfoList, milestoneDefn, ag_status, false);
        msDisplayInfo.getTaskDisplayInfo().clear();
        msDisplayInfo.getTaskDisplayInfo().addAll(taskDisplayInfoList);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getMilestoneDisplayInfo", (String)("End of getMilestoneDisplayInfo for user: " + ctx.getUser() + ", InstanceId: " + cikey + ", Milestone: " + milestoneName));
        return msDisplayInfo;
    }

    private static void initTaskVerificationColumns() {
        taskVerificationColumns.add("ACQUIREDBY");
        taskVerificationColumns.add("ACTIVITYID");
        taskVerificationColumns.add("INSTANCEID");
        taskVerificationColumns.add("ASSIGNEES");
        taskVerificationColumns.add("ASSIGNEEGROUPS");
        taskVerificationColumns.add("ASSIGNEEUSERS");
        taskVerificationColumns.add("REVIEWERS");
        taskVerificationColumns.add("OWNERUSER");
        taskVerificationColumns.add("OWNERGROUP");
        taskVerificationColumns.add("ORIGINALASSIGNEEUSER");
        taskVerificationColumns.add("PARTICIPANTNAME");
        taskVerificationColumns.add("APPROVERS");
        taskVerificationColumns.add("IDENTITYCONTEXT");
        taskVerificationColumns.add("TASKDEFINITIONNAME");
        taskVerificationColumns.add("COMPONENTNAME");
        taskVerificationColumns.add("COMPOSITENAME");
        taskVerificationColumns.add("CALLBACKID");
        taskVerificationColumns.add("STATE");
        taskVerificationColumns.add("SUBSTATE");
    }

    private static Predicate combineTwoPredicatesByAND(Predicate predicate1, Predicate predicate2) throws WorkflowException {
        if (predicate1 == null) {
            return predicate2;
        }
        if (predicate2 == null) {
            return predicate1;
        }
        return new Predicate(predicate1, 7, predicate2);
    }

    private static boolean isUserAGAdmin(IWorkflowContext ctx) throws WorkflowException {
        boolean hasPermission = VerificationService.hasPermission((String)ctx.getUser(), (String)ctx.getIdentityContext(), (Permission)WorkflowPermission.ADMIN_ACTIVITYGUIDE_PERMISSION);
        boolean isWFSystemUser = ctx instanceof InternalWorkflowContext;
        return hasPermission || isWFSystemUser;
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private static String getProcessNameFromCallbackId(String callbackId) {
        String processName = null;
        if (callbackId == null) {
            return processName;
        }
        int delimiterPosition = callbackId.indexOf("/");
        processName = callbackId.substring(0, delimiterPosition);
        return processName;
    }

    private AGDisplayInfo constructAGDisplayInfo(IProcessInstance processInstance, IActivityGuide activityGuide, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter filter, boolean bDisplayTasks, List taskDisplayColumns) throws WorkflowException {
        HashMap taskIdMap;
        boolean canUserSeeAG;
        AGDisplayInfo agDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createAGDisplayInfo();
        agDisplayInfo.setCompletedTaskCount(BigInteger.ZERO);
        agDisplayInfo.setTotalTasks(BigInteger.ZERO);
        agDisplayInfo.setName(activityGuide.getId());
        TranslatableValueTypeEnum titleType = activityGuide.getTitle().getType();
        String titleValue = activityGuide.getTitle().getValue();
        TranslatableValueTypeEnum descriptionType = activityGuide.getDescription().getType();
        String descriptionValue = activityGuide.getDescription().getValue();
        try {
            titleValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, titleValue, titleType.toString());
            descriptionValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, descriptionValue, descriptionType.toString());
        }
        catch (Exception e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG resource bundle from metadata service in constructAGDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        agDisplayInfo.setTitle(titleValue);
        agDisplayInfo.setDescription(descriptionValue);
        agDisplayInfo.setIconLocation(activityGuide.getIconLocation());
        agDisplayInfo.setGlobalTaskAccessMode(activityGuide.getTaskAccessMode().toString());
        agDisplayInfo.setTaskBlockedIconLocation(activityGuide.getTaskBlockedIconLocation());
        HashMap taskListMap = new HashMap();
        String compositeInstanceID = processInstance.getSca().getCompositeInstanceId();
        if (bDisplayTasks && !(canUserSeeAG = this.canUserSeeAGDisplayInfo(ctx, taskIdMap = (HashMap)(taskListMap = this.getTasksInAG(compositeInstanceID, ctx, filter, taskDisplayColumns)).get(FILTERED_TASK_MAP)))) {
            Object[] errorObjs = new Object[]{ctx.getUser(), String.valueOf(processInstance.getCubeInstanceId()), "constructAGDisplayInfo()"};
            String reason = "User is not allowed to see the activity guide. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser() + " ciKey = " + String.valueOf(processInstance.getCubeInstanceId());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (String)CLASSNAME, (String)"constructAGDisplayInfo()", (String)reason);
            throw new WorkflowException(38003, reason, errorObjs);
        }
        String process_state = processInstance.getSystemAttributes().getState();
        String ag_status = AG_BPM_STATE_MAP.get(process_state);
        agDisplayInfo.setStatus(ag_status);
        List milestoneDisplayInfoList = this.constructMilestoneDisplayInfoList(ctx, taskListMap, activityGuide, ag_status);
        BigInteger agTotalTasks = BigInteger.ZERO;
        for (int i = 0; i < milestoneDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo ms = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(i);
            BigInteger completedTasks = agDisplayInfo.getCompletedTaskCount().add(ms.getCompletedTaskCount());
            agDisplayInfo.setCompletedTaskCount(completedTasks);
            if (ms.getStatus().equals("In Progress")) {
                BigInteger past_completed_count = completedTasks.subtract(ms.getCompletedTaskCount()).abs();
                agTotalTasks = past_completed_count.add(ms.getTotalTasksLeft());
                TaskDisplayInfo taskDisplayInfo = (TaskDisplayInfo)ms.getTaskDisplayInfo().get(0);
                if (taskDisplayInfo.getTask().getSystemAttributes().getState() != null && taskDisplayInfo.getTask().getSystemAttributes().getState().equals("ASSIGNED")) {
                    agTotalTasks = completedTasks.add(ms.getTotalTasksLeft());
                }
                agDisplayInfo.setTotalTasks(agTotalTasks);
            }
            if (i != milestoneDisplayInfoList.size() - 1 || !ms.getStatus().equals("Completed")) continue;
            agTotalTasks = completedTasks;
            agDisplayInfo.setTotalTasks(agTotalTasks);
        }
        agDisplayInfo.setProcessMode("AGBPM");
        agDisplayInfo.setInstanceId(processInstance.getCubeInstanceId());
        if (process_state.equals("COMPLETED") && !agDisplayInfo.getTotalTasks().equals(agDisplayInfo.getCompletedTaskCount())) {
            process_state = "OPEN";
        }
        BigInteger percentageComplete = BigInteger.ZERO;
        if (!agDisplayInfo.getTotalTasks().equals(BigInteger.ZERO)) {
            percentageComplete = agDisplayInfo.getCompletedTaskCount().multiply(new BigInteger("100")).divide(agDisplayInfo.getTotalTasks());
        }
        agDisplayInfo.setPercentageComplete(percentageComplete);
        HashMap filteredTaskIDMap = (HashMap)taskListMap.get(FILTERED_TASK_MAP);
        for (int i = 0; i < milestoneDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo ms = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(i);
            List taskList = ms.getTaskDisplayInfo();
            ArrayList<TaskDisplayInfo> filteredTaskDisplayInfoList = new ArrayList<TaskDisplayInfo>();
            for (int j = 0; taskList != null && j < taskList.size(); ++j) {
                TaskDisplayInfo taskDisplayInfo = (TaskDisplayInfo)taskList.get(j);
                String taskId = taskDisplayInfo.getId();
                if (taskDisplayInfo.isTaskInactive()) {
                    filteredTaskDisplayInfoList.add(taskDisplayInfo);
                    continue;
                }
                if (!filteredTaskIDMap.containsKey(taskId)) continue;
                filteredTaskDisplayInfoList.add(taskDisplayInfo);
            }
            ms.getTaskDisplayInfo().clear();
            ms.getTaskDisplayInfo().addAll(filteredTaskDisplayInfoList);
        }
        agDisplayInfo.getMilestoneDisplayInfo().clear();
        agDisplayInfo.getMilestoneDisplayInfo().addAll(milestoneDisplayInfoList);
        return agDisplayInfo;
    }

    private List constructMilestoneDisplayInfoList(IWorkflowContext ctx, HashMap taskListMap, IActivityGuide activityGuide, String ag_status) throws WorkflowException {
        IMilestone milestoneDefinition = null;
        MilestoneDisplayInfo milestoneDisplayInfo = null;
        List<MilestoneDisplayInfo> milestoneDisplayInfoList = new ArrayList();
        List milestoneDefinitionList = activityGuide.getMilestones();
        HashMap<String, IMilestone> milestoneDefnMap = new HashMap<String, IMilestone>();
        for (int i = 0; i < milestoneDefinitionList.size(); ++i) {
            milestoneDefinition = (IMilestone)milestoneDefinitionList.get(i);
            milestoneDisplayInfo = this.constructMilestoneDisplayInfo(ctx, activityGuide, taskListMap, milestoneDefinition);
            if (milestoneDisplayInfo == null) continue;
            milestoneDisplayInfoList.add(milestoneDisplayInfo);
            milestoneDefnMap.put(milestoneDisplayInfo.getName(), milestoneDefinition);
        }
        milestoneDisplayInfoList = this.filterBranchEntries(milestoneDisplayInfoList, activityGuide, ag_status, false);
        List<MilestoneDisplayInfo> filteredMSDisplayInfoList = new ArrayList<MilestoneDisplayInfo>();
        for (int i = 0; milestoneDisplayInfoList != null && i < milestoneDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo nextMilestone;
            boolean isNextMSEnabled = false;
            MilestoneDisplayInfo msDisplayInfo = (MilestoneDisplayInfo)milestoneDisplayInfoList.get(i);
            List taskDisplayInfoList = msDisplayInfo.getTaskDisplayInfo();
            MilestoneDisplayInfo milestoneDisplayInfo2 = nextMilestone = i < milestoneDisplayInfoList.size() - 1 ? (MilestoneDisplayInfo)milestoneDisplayInfoList.get(i + 1) : null;
            if (nextMilestone != null && !nextMilestone.getStatus().equals("Not Started")) {
                isNextMSEnabled = true;
            }
            IMilestone milestoneDefn = (IMilestone)milestoneDefnMap.get(msDisplayInfo.getName());
            List filteredTaskDisplayInfoList = this.filterBranchEntries(taskDisplayInfoList, milestoneDefn, ag_status, isNextMSEnabled);
            msDisplayInfo.getTaskDisplayInfo().clear();
            msDisplayInfo.getTaskDisplayInfo().addAll(filteredTaskDisplayInfoList);
            filteredMSDisplayInfoList.add(msDisplayInfo);
        }
        filteredMSDisplayInfoList = this.checkTaskBlockedStatus(filteredMSDisplayInfoList, ag_status);
        return filteredMSDisplayInfoList;
    }

    private MilestoneDisplayInfo constructMilestoneDisplayInfo(IWorkflowContext ctx, IActivityGuide activityGuide, HashMap taskListMap, IMilestone milestoneDefinition) throws WorkflowException {
        if (milestoneDefinition == null) {
            return null;
        }
        MilestoneDisplayInfo milestoneDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createMilestoneDisplayInfo();
        milestoneDisplayInfo.setCompletedTaskCount(BigInteger.ZERO);
        milestoneDisplayInfo.setName(milestoneDefinition.getId());
        TranslatableValueTypeEnum titleType = milestoneDefinition.getTitle().getType();
        String titleValue = milestoneDefinition.getTitle().getValue();
        TranslatableValueTypeEnum descriptionType = milestoneDefinition.getDescription().getType();
        String descriptionValue = milestoneDefinition.getDescription().getValue();
        try {
            titleValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, titleValue, titleType.toString());
            descriptionValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), activityGuide, descriptionValue, descriptionType.toString());
        }
        catch (Exception e) {
            Object[] errorObjs = new Object[]{"Failure to retrieve AG resource bundle from metadata service in constructMilestoneDisplayInfo."};
            WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
            throw we;
        }
        milestoneDisplayInfo.setTitle(titleValue);
        milestoneDisplayInfo.setDescription(descriptionValue);
        milestoneDisplayInfo.setIconLocation(milestoneDefinition.getIconLocation());
        milestoneDisplayInfo.setTotalTasksLeft(BigInteger.valueOf(milestoneDefinition.getTasksRemaining()));
        HashMap allTaskIdMap = (HashMap)taskListMap.get(ALL_TASK_MAP);
        boolean hasMilestoneStarted = this.hasMilestoneStarted(milestoneDefinition, allTaskIdMap);
        if (hasMilestoneStarted) {
            milestoneDisplayInfo.setStatus("In Progress");
        } else {
            if (milestoneDefinition.getUserTasks() == null || milestoneDefinition.getUserTasks().isEmpty()) {
                milestoneDisplayInfo.setStatus("Completed");
            } else {
                milestoneDisplayInfo.setStatus("Not Started");
            }
            if (milestoneDefinition.getDisplayMode().equals("whenInstantiated")) {
                milestoneDisplayInfo.setTitle("switch_" + milestoneDefinition.getId());
            }
        }
        ArrayList<TaskDisplayInfo> taskDisplayInfoList = new ArrayList<TaskDisplayInfo>();
        TaskDisplayInfo taskDisplayInfo = null;
        List userTaskList = milestoneDefinition.getUserTasks();
        for (IUserTask userTask : userTaskList) {
            List taskList;
            String userTaskId = userTask.getId();
            List list = taskList = allTaskIdMap == null ? null : (List)allTaskIdMap.get(userTaskId);
            if (taskList != null && !taskList.isEmpty()) {
                for (Task task : taskList) {
                    taskDisplayInfo = this.constructTaskDisplayInfo(ctx, userTask, task);
                    String taskState = task.getSystemAttributes().getState();
                    if (taskState != null && (taskState.equals("COMPLETED") || taskState.equals("EXPIRED") || taskState.equals("ERRORED"))) {
                        milestoneDisplayInfo.setCompletedTaskCount(milestoneDisplayInfo.getCompletedTaskCount().add(BigInteger.ONE));
                        if (userTask.isLastTaskInMilestone()) {
                            milestoneDisplayInfo.setStatus("Completed");
                        }
                    }
                    taskDisplayInfoList.add(taskDisplayInfo);
                }
                int futureTaskCount = userTask.getTasksRemaining() > 0 ? userTask.getTasksRemaining() : milestoneDisplayInfo.getTotalTasksLeft().intValue();
                milestoneDisplayInfo.setTotalTasksLeft(BigInteger.valueOf(futureTaskCount));
                continue;
            }
            taskDisplayInfo = this.constructTaskDisplayInfo(ctx, userTask, null);
            taskDisplayInfoList.add(taskDisplayInfo);
        }
        if (milestoneDisplayInfo.getStatus().equals("Completed")) {
            for (int i = 0; i < taskDisplayInfoList.size(); ++i) {
                TaskDisplayInfo taskInfo = (TaskDisplayInfo)taskDisplayInfoList.get(i);
                if (taskInfo.getTask() == null || !taskInfo.getTask().getSystemAttributes().getState().equals("ALERTED") && !taskInfo.getTask().getSystemAttributes().getState().equals("ASSIGNED")) continue;
                milestoneDisplayInfo.setStatus("In Progress");
                break;
            }
        }
        milestoneDisplayInfo.getTaskDisplayInfo().clear();
        milestoneDisplayInfo.getTaskDisplayInfo().addAll(taskDisplayInfoList);
        return milestoneDisplayInfo;
    }

    private TaskDisplayInfo constructTaskDisplayInfo(IWorkflowContext ctx, IUserTask userTask, Task task) throws WorkflowException {
        TaskDisplayInfo taskDisplayInfo = new oracle.bpel.services.workflow.activityguide.query.model.ObjectFactory().createTaskDisplayInfo();
        taskDisplayInfo.setTaskInactive(true);
        if (task != null) {
            taskDisplayInfo.setTaskInactive(false);
            String taskTitle = AGi18nUtil.renderValueforTaskValueType(ctx.getLocale(), task);
            if (taskTitle != null) {
                task.setTitle(taskTitle);
            }
            taskDisplayInfo.setTask((TaskType)task);
        } else {
            ObjectFactory objf = new ObjectFactory();
            Task dummyTask = objf.createTask();
            dummyTask.getSystemAttributes().setTaskId("AGDM_" + Long.toString(System.currentTimeMillis()) + userTask.getId());
            dummyTask.getSystemAttributes().setState("Not Started");
            if (userTask.getDisplayMode().equals("whenInstantiated")) {
                dummyTask.setTitle("switch_" + userTask.getId());
            } else {
                Task tempTask = objf.createTask();
                TaskMetadataCache taskCache = TaskMetadataCache.getInstance();
                TaskDefinition taskDefn = taskCache.getTaskDefinition(userTask.getTaskDefinitionId(), null);
                tempTask.setTaskDefinitionId(taskDefn.getId());
                String taskTitle = null;
                if (taskDefn.getTitle().getType().equals("STATIC")) {
                    taskTitle = taskDefn.getTitle().getValue();
                } else if (taskDefn.getTitle().getType().equals("XPATH")) {
                    taskTitle = taskDefn.getName();
                } else if (taskDefn.getTitle().getType().equals("RESOURCEREF") || taskDefn.getTitle().getType().equals("RESOURCE")) {
                    taskTitle = AGi18nUtil.renderValueforTaskValueType(ctx.getLocale(), tempTask);
                }
                dummyTask.setTitle(taskTitle);
            }
            taskDisplayInfo.setTask((TaskType)dummyTask);
        }
        this.copyTaskAttributes(ctx, taskDisplayInfo, userTask);
        return taskDisplayInfo;
    }

    private void copyTaskAttributes(IWorkflowContext ctx, TaskDisplayInfo taskDisplayInfo, IUserTask userTask) throws WorkflowException {
        TaskType task;
        taskDisplayInfo.setId(userTask.getId());
        taskDisplayInfo.setOptional(userTask.isMarkedAsOptional());
        taskDisplayInfo.setLastMilestoneTask(userTask.isLastTaskInMilestone());
        if (userTask.isDisplayBlockedIcon() && (task = taskDisplayInfo.getTask()) != null && task.getSystemAttributes().getState() != null && task.getSystemAttributes().getState().equals("COMPLETED")) {
            taskDisplayInfo.setDisplayBlockedIcon(userTask.isDisplayBlockedIcon());
            if (userTask.getExplanation() != null) {
                String blockedExplanationValue = userTask.getExplanation().getValue();
                TranslatableValueTypeEnum blockedExplanationType = userTask.getExplanation().getType();
                try {
                    blockedExplanationValue = AGi18nUtil.renderValueForValueType(ctx.getLocale(), userTask.getParentMilestone().getParentActivityGuide(), blockedExplanationValue, blockedExplanationType.toString());
                }
                catch (Exception e) {
                    Object[] errorObjs = new Object[]{"Failure to retrieve AG resource bundle from metadata service in copyTaskAttributes."};
                    WorkflowException we = new WorkflowException(38006, errorObjs, (Throwable)e);
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)e);
                    throw we;
                }
                taskDisplayInfo.setBlockedExplanation(blockedExplanationValue);
            }
        }
    }

    private HashMap getTasksInAG(String compositeInstanceID, IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter assignmentFilter, List taskDisplayColumns) throws WorkflowException {
        HashMap taskIdMap = new HashMap(2);
        HashMap<String, Task> filteredTaskIDMap = new HashMap<String, Task>();
        HashMap<String, ArrayList<Task>> allTaskIDMap = new HashMap<String, ArrayList<Task>>();
        Predicate taskPredicate = new Predicate(IColumnConstants.PROCESS_COMPOSITEINSTANCEID_COLUMN, 0, (Object)compositeInstanceID);
        ArrayList taskQueryColumns = new ArrayList(taskVerificationColumns);
        if (taskDisplayColumns != null && !taskDisplayColumns.isEmpty()) {
            taskQueryColumns.addAll(taskDisplayColumns);
        }
        Ordering ordering = new Ordering(TableConstants.WFTASK_CREATEDDATE_COLUMN, true, true);
        ArrayList<ITaskQueryService.OptionalInfo> optionInfos = new ArrayList<ITaskQueryService.OptionalInfo>();
        optionInfos.add(ITaskQueryService.OptionalInfo.DISPLAY_INFO);
        List allTaskList = new ArrayList();
        allTaskList = this.getTaskQueryService().queryTasks(BpmAGQueryService.getInternalWorkflowContext(), taskQueryColumns, optionInfos, ITaskQueryService.AssignmentFilter.ALL, null, taskPredicate, ordering, 0, 0);
        for (Task taskVO : allTaskList) {
            String activityID = taskVO.getSystemAttributes().getActivityId();
            String processName = BpmAGQueryService.getProcessNameFromCallbackId(taskVO.getCallback().getId());
            String taskID = activityID + "_" + processName;
            ArrayList<Task> taskList = (ArrayList<Task>)allTaskIDMap.get(taskID);
            if (taskList == null || taskList.isEmpty()) {
                taskList = new ArrayList<Task>();
                taskList.add(taskVO);
            } else {
                taskList.add(taskVO);
            }
            allTaskIDMap.put(taskID, taskList);
        }
        List filteredTaskList = new ArrayList();
        ITaskQueryService.AssignmentFilter taskFilter = this.getTaskAssignmentFilter(assignmentFilter);
        filteredTaskList = this.getTaskQueryService().queryTasks(ctx, taskQueryColumns, optionInfos, taskFilter, null, taskPredicate, ordering, 0, 0);
        if (filteredTaskList.size() > 0) {
            Task task = null;
            for (int i = filteredTaskList.size() - 1; i >= 0; --i) {
                task = (Task)filteredTaskList.get(i);
                if (!this.getVerificationService().canUserSeeTaskDetails(ctx, task)) {
                    filteredTaskList.remove(i);
                    continue;
                }
                String activityID = task.getSystemAttributes().getActivityId();
                String processName = BpmAGQueryService.getProcessNameFromCallbackId(task.getCallback().getId());
                String taskID = activityID + "_" + processName;
                filteredTaskIDMap.put(taskID, task);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"getTasksInAG", (String)("Number of TaskVO in AG that user can see" + filteredTaskList.size()));
        taskIdMap.put(ALL_TASK_MAP, allTaskIDMap);
        taskIdMap.put(FILTERED_TASK_MAP, filteredTaskIDMap);
        return taskIdMap;
    }

    private List filterBranchEntries(List displayInfoList, Object parent_definition, String ag_status, boolean isNextMSEnabled) {
        ArrayList returnListObject = new ArrayList();
        if (displayInfoList == null || displayInfoList.isEmpty()) {
            return returnListObject;
        }
        ArrayList temporary_branch_list = new ArrayList();
        for (int i = 0; i < displayInfoList.size(); ++i) {
            Object listItem = displayInfoList.get(i);
            String displayMode = this.getDisplayMode(parent_definition, listItem);
            if (displayMode.equals("whenInstantiated")) {
                String current_item_status = this.getStatus(listItem);
                if (temporary_branch_list.isEmpty()) {
                    Object nextItem;
                    if (current_item_status != null && !current_item_status.equals("Not Started")) {
                        temporary_branch_list.add(listItem);
                        returnListObject.add(listItem);
                        continue;
                    }
                    if (current_item_status == null || !current_item_status.equals("Not Started")) continue;
                    boolean isNextItemEnabled = false;
                    int j = i + 1;
                    Object v0 = nextItem = j < displayInfoList.size() ? displayInfoList.get(j) : null;
                    while (nextItem != null) {
                        String next_item_status = this.getStatus(nextItem);
                        if (!next_item_status.equals("Not Started")) {
                            isNextItemEnabled = true;
                            break;
                        }
                        nextItem = ++j < displayInfoList.size() ? displayInfoList.get(j) : null;
                    }
                    if (isNextItemEnabled || ag_status == null || ag_status.equals("Completed")) continue;
                    if (listItem instanceof TaskDisplayInfo) {
                        if (isNextMSEnabled) continue;
                        temporary_branch_list.add(listItem);
                        returnListObject.add(listItem);
                        continue;
                    }
                    temporary_branch_list.add(listItem);
                    returnListObject.add(listItem);
                    continue;
                }
                if (current_item_status == null || current_item_status.equals("Not Started")) continue;
                Object old_item = temporary_branch_list.get(temporary_branch_list.size() - 1);
                String old_item_status = this.getStatus(old_item);
                if (old_item_status != null && old_item_status.equals("Not Started")) {
                    returnListObject.remove(old_item);
                    temporary_branch_list.remove(old_item);
                }
                temporary_branch_list.add(listItem);
                returnListObject.add(listItem);
                continue;
            }
            returnListObject.add(listItem);
            temporary_branch_list.clear();
        }
        return returnListObject;
    }

    private String getStatus(Object listItem) {
        if (listItem instanceof MilestoneDisplayInfo) {
            return ((MilestoneDisplayInfo)listItem).getStatus();
        }
        if (listItem instanceof TaskDisplayInfo) {
            return ((TaskDisplayInfo)listItem).getTask().getSystemAttributes().getState();
        }
        return null;
    }

    private String getDisplayMode(Object parent_definition, Object listItem) {
        if (parent_definition instanceof IActivityGuide) {
            MilestoneDisplayInfo milestoneItem = (MilestoneDisplayInfo)listItem;
            IMilestone child_definition = ((IActivityGuide)parent_definition).findMilestone(milestoneItem.getName());
            return child_definition.getDisplayMode();
        }
        if (parent_definition instanceof IMilestone) {
            TaskDisplayInfo taskItem = (TaskDisplayInfo)listItem;
            IUserTask child_definition = ((IMilestone)parent_definition).findUserTask(taskItem.getId());
            return child_definition.getDisplayMode();
        }
        return null;
    }

    private List<MilestoneDisplayInfo> checkTaskBlockedStatus(List<MilestoneDisplayInfo> msDisplayInfoList, String agStatus) {
        for (int i = 0; i < msDisplayInfoList.size(); ++i) {
            MilestoneDisplayInfo currentMSDisplayInfo = msDisplayInfoList.get(i);
            List taskDisplayInfoList = currentMSDisplayInfo.getTaskDisplayInfo();
            for (int j = 0; taskDisplayInfoList != null && j < taskDisplayInfoList.size(); ++j) {
                TaskDisplayInfo nextTaskDisplayInfo;
                TaskDisplayInfo currentTaskDisplayInfo = (TaskDisplayInfo)taskDisplayInfoList.get(j);
                if (!currentTaskDisplayInfo.isDisplayBlockedIcon()) continue;
                if (currentTaskDisplayInfo.isLastMilestoneTask()) {
                    TaskDisplayInfo nextMSTaskDisplayInfo;
                    if (i == msDisplayInfoList.size() - 1) {
                        if (agStatus == null || !agStatus.equals("Completed")) continue;
                        currentTaskDisplayInfo.setDisplayBlockedIcon(false);
                        currentTaskDisplayInfo.setBlockedExplanation("");
                        continue;
                    }
                    MilestoneDisplayInfo nextMSDisplayInfo = msDisplayInfoList.get(i + 1);
                    List nextMSTaskDisplayInfoList = nextMSDisplayInfo.getTaskDisplayInfo();
                    if (nextMSTaskDisplayInfoList == null || nextMSTaskDisplayInfoList.isEmpty() || (nextMSTaskDisplayInfo = (TaskDisplayInfo)nextMSTaskDisplayInfoList.get(0)) == null || nextMSTaskDisplayInfo.getTask().getSystemAttributes().getState() == null || nextMSTaskDisplayInfo.getTask().getSystemAttributes().getState().equals("Not Started")) continue;
                    currentTaskDisplayInfo.setDisplayBlockedIcon(false);
                    currentTaskDisplayInfo.setBlockedExplanation("");
                    continue;
                }
                TaskDisplayInfo taskDisplayInfo = nextTaskDisplayInfo = j < taskDisplayInfoList.size() - 1 ? (TaskDisplayInfo)taskDisplayInfoList.get(j + 1) : null;
                if (nextTaskDisplayInfo == null || nextTaskDisplayInfo.getTask().getSystemAttributes().getState() == null || nextTaskDisplayInfo.getTask().getSystemAttributes().getState().equals("Not Started")) continue;
                currentTaskDisplayInfo.setDisplayBlockedIcon(false);
                currentTaskDisplayInfo.setBlockedExplanation("");
            }
        }
        return msDisplayInfoList;
    }

    private boolean hasMilestoneStarted(IMilestone milestoneDefinition, HashMap allTaskMap) {
        boolean milestoneStarted = false;
        if (allTaskMap != null && !allTaskMap.isEmpty()) {
            Set taskIds = allTaskMap.keySet();
            for (String taskId : taskIds) {
                IUserTask userTask = milestoneDefinition.findUserTask(taskId);
                if (userTask == null) continue;
                milestoneStarted = true;
                break;
            }
        }
        return milestoneStarted;
    }

    private List<String> getProcessInstanceIds(IWorkflowContext ctx, IAGQueryService.AGAssignmentFilter agFilter) throws WorkflowException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        Predicate taskStatePredicate = null;
        if (agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN)) {
            if (!BpmAGQueryService.isUserAGAdmin(ctx)) {
                Object[] errorObjs = new Object[]{ctx.getUser(), "isUserAGAdmin"};
                String reason = "User does not have the activity guide administration privilege required for using the ADMIN assignment filter. token = " + ctx.getToken() + " ctxUser = " + ctx.getUser();
                WorkflowException we = new WorkflowException(38004, reason, errorObjs);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.ERRORS, (Throwable)we);
                throw we;
            }
        } else if (agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.MY) || agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REPORTEES)) {
            ArrayList<String> taskStateList = new ArrayList<String>();
            taskStateList.add("ASSIGNED");
            taskStateList.add("INFO_REQUESTED");
            taskStatePredicate = new Predicate(TableConstants.WFTASK_STATE_COLUMN, 9, taskStateList);
        } else if (!agFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS)) {
            return instanceIds;
        }
        List taskList = new ArrayList();
        ITaskQueryService task_query_svc = this.getTaskQueryService();
        taskList = task_query_svc.queryTasks(ctx, taskVerificationColumns, null, this.getTaskAssignmentFilter(agFilter), null, taskStatePredicate, null, 0, 0);
        for (Task task : taskList) {
            String instanceId = task.getProcessInfo().getInstanceId();
            instanceIds.add(instanceId);
        }
        return instanceIds;
    }

    private ITaskQueryService.AssignmentFilter getTaskAssignmentFilter(IAGQueryService.AGAssignmentFilter assignmentFilter) {
        ITaskQueryService.AssignmentFilter taskFilter = null;
        if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.ADMIN)) {
            taskFilter = ITaskQueryService.AssignmentFilter.ALL;
        } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.MY)) {
            taskFilter = ITaskQueryService.AssignmentFilter.MY_AND_GROUP;
        } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.PREVIOUS)) {
            taskFilter = ITaskQueryService.AssignmentFilter.PREVIOUS;
        } else if (assignmentFilter.equals((Object)IAGQueryService.AGAssignmentFilter.REPORTEES)) {
            taskFilter = ITaskQueryService.AssignmentFilter.REPORTEES;
        }
        return taskFilter;
    }

    private void addDefaultProcessColumns(List processColumns) {
        this.addOnce(processColumns, IColumnConstants.PROCESS_STATE_COLUMN);
        this.addOnce(processColumns, IColumnConstants.PROCESS_AGROOT_ID);
        this.addOnce(processColumns, IColumnConstants.PROCESS_COMPONENTNAME_COLUMN);
        this.addOnce(processColumns, IColumnConstants.PROCESS_COMPOSITEDN_COLUMN);
        this.addOnce(processColumns, IColumnConstants.PROCESS_COMPOSITEINSTANCEID_COLUMN);
    }

    private void addOnce(List list, Column column) {
        if (list == null || column == null) {
            return;
        }
        if (!list.contains(column)) {
            list.add(column);
        }
    }

    private boolean canUserSeeAGDisplayInfo(IWorkflowContext ctx, Map taskIdMap) throws WorkflowException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)("Start of canUserSeeAGDisplayInfo for user: " + ctx.getUser()));
        boolean bCanUserSeeAGDisplayInfo = false;
        if (BpmAGQueryService.isUserAGAdmin(ctx)) {
            bCanUserSeeAGDisplayInfo = true;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)"User is AG admin and can see AG");
            return bCanUserSeeAGDisplayInfo;
        }
        if (taskIdMap != null && !taskIdMap.isEmpty()) {
            bCanUserSeeAGDisplayInfo = true;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)"User can see the AG.");
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AG_QUERY_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)"canUserSeeAGDisplayInfo", (String)("Completed. canUserSeeAGDisplayInfo " + String.valueOf(bCanUserSeeAGDisplayInfo)));
        return bCanUserSeeAGDisplayInfo;
    }

    static {
        BpmAGQueryService.initTaskVerificationColumns();
        AG_BPM_STATE_MAP.put("COMPLETED", "Completed");
        AG_BPM_STATE_MAP.put("OPEN", "In Progress");
        AG_BPM_STATE_MAP.put("STALE", "Stale");
    }
}

