/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.virtual;

import java.util.Comparator;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.virtual.VirtualContainer;

public class VirtualActivities
extends VirtualContainer<NodeContainer> {
    public VirtualActivities(NodeContainer parent) {
        super(parent, parent, ProjectMsg.ACTIVITIES);
    }

    @Override
    protected Sequence<? extends ProjectObject> getVirtualChildren() {
        TreeSet<FlowNode> flowNodes = new TreeSet<FlowNode>(new FlowNodeComparator());
        for (FlowNode flowNode : ((NodeContainer)this.getRealParent()).getFlowNodes()) {
            flowNodes.add(flowNode);
        }
        Sequence<BoundaryEvent> boundaryEvents = ((NodeContainer)this.getRealParent()).getBoundaryEvents();
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            flowNodes.add(boundaryEvent);
        }
        return CollectionUtils.asSequence(flowNodes);
    }

    private static class FlowNodeComparator
    implements Comparator<FlowNode> {
        private FlowNodeComparator() {
        }

        @Override
        public int compare(FlowNode flowNode1, FlowNode flowNode2) {
            return ModelUtils.isEndEvent(flowNode1) ? 1 : -1;
        }
    }
}

