/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.transitions;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.CurveTransitionFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.RoutingModeFeature;
import oracle.bpm.project.model.features.TransitionUserNameFeature;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.processes.transitions.ConditionalTransitionFeature;
import oracle.bpm.project.transitions.CollapsedMessageFeature;
import oracle.bpm.project.transitions.TransitionOrderFeature;

public class FeaturesByTransition {
    public static Features get(TransitionType transitionType) {
        HashMap<Class, Feature> result = new HashMap<Class, Feature>();
        FeaturesByTransition.addTo(result, CollapsedMessageFeature.create());
        FeaturesByTransition.addTo(result, RoutingModeFeature.create());
        FeaturesByTransition.addTo(result, CurveTransitionFeature.create());
        FeaturesByTransition.addTo(result, TransitionUserNameFeature.create());
        FeaturesByTransition.addTo(result, AnnotationsFeature.create());
        switch (transitionType) {
            case CONDITIONAL: {
                FeaturesByTransition.addTo(result, TransitionOrderFeature.create());
                FeaturesByTransition.addTo(result, ConditionalTransitionFeature.create());
                break;
            }
        }
        return Features.create(result);
    }

    private static void addTo(Map<Class, Feature> result, Feature feature) {
        result.put(feature.getClass(), feature);
    }
}

