/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.dataassociations;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationContainerProvider;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemRef;
import org.jetbrains.annotations.NotNull;

public class DataAssociationItemImpl
implements DataAssociationItem {
    private DataDeclarationContainerProvider context;
    private DataAssociationItemEndpoint endpoint;
    private Expression expression;
    private boolean isQuery;
    private Sequence<DataAssociationItemRef> refs;
    private DataAssociationItem relatedItem;

    private DataAssociationItemImpl(@NotNull DataAssociationItemEndpoint endpoint, @NotNull Expression expression, @NotNull DataDeclarationContainerProvider context, @NotNull Sequence<DataAssociationItemRef> refs, boolean isQuery) {
        this.endpoint = endpoint;
        this.expression = expression;
        this.context = context;
        this.refs = refs;
        this.isQuery = isQuery;
    }

    public static DataAssociationItem create(@NotNull DataAssociationItemEndpoint endpoint, @NotNull Expression expression, @NotNull DataDeclarationContainerProvider context, @NotNull Sequence<DataAssociationItemRef> refs, boolean isQuery) {
        return new DataAssociationItemImpl(endpoint, expression, context, refs, isQuery);
    }

    @Override
    public String getText() {
        DataAssociationItem target;
        CatalogType resultType = null;
        if (this.isSource() && (target = this.getRelatedItem()) != null && target.isTarget()) {
            resultType = ExpressionHelper.getExpressionType((Expression)target.getExpression(), (DataDeclarationContainer)target.getContext(), null);
        }
        return ExpressionHelper.getText((Expression)this.expression, (DataDeclarationContainer)this.context.getDataDeclarationContainer(), resultType);
    }

    @Override
    public Sequence<String> getRefs() {
        ArrayList<String> result = new ArrayList<String>();
        for (DataAssociationItemRef ref : this.refs) {
            if (ref.isOtherRef()) continue;
            result.add(ref.getRef());
        }
        return CollectionUtils.asSequence(result);
    }

    @Override
    public Sequence<String> getOtherRefs() {
        ArrayList<String> result = new ArrayList<String>();
        for (DataAssociationItemRef ref : this.refs) {
            if (!ref.isOtherRef()) continue;
            result.add(ref.getRef());
        }
        return CollectionUtils.asSequence(result);
    }

    @Override
    public Sequence<DataAssociationItemRef> getDataAssociationItemRefs() {
        return this.refs;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean isQuery() {
        return this.isQuery;
    }

    @Override
    public DataDeclarationContainer getContext() {
        return this.context.getDataDeclarationContainer();
    }

    @Override
    public DataAssociationItemEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public boolean isSource() {
        return DataAssociationItemEndpoint.isAnySource(this.endpoint);
    }

    @Override
    public boolean isTarget() {
        return DataAssociationItemEndpoint.isAnyTarget(this.endpoint);
    }

    @Override
    public void setRelatedItem(DataAssociationItem relatedItem) {
        this.relatedItem = relatedItem;
    }

    @Override
    public DataAssociationItem getRelatedItem() {
        return this.relatedItem;
    }
}

