/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.dataassociations;

import java.util.ArrayList;
import java.util.Set;
import oracle.bpm.cil.CilException;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.XPathReferenceResult;
import oracle.bpm.project.compile.XPathReferencesParser;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemRef;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.process.dataassociations.DataAssociationItemRefImpl;
import org.jetbrains.annotations.NotNull;

public class DataAssociationHelper {
    public static Sequence<DataAssociationItemRef> getRefsFromExpression(@NotNull DataAssociationItemEndpoint endpoint, @NotNull Expression expression, @NotNull DataDeclarationContainer context) {
        Sequence<DataAssociationItemRef> result = CollectionUtils.emptySequence();
        XPathReferencesParser xPathReferencesParser = new XPathReferencesParser(context);
        XPathExpression xPathExpression = (XPathExpression)expression;
        try {
            XPathReferenceResult xPathReferenceResult = xPathReferencesParser.generate(xPathExpression);
            result = DataAssociationHelper.getRefs(endpoint, xPathReferenceResult.variables);
        }
        catch (CilException e) {
            // empty catch block
        }
        return result;
    }

    public static Sequence<DataDeclaration> getCustomTargets(@NotNull DataAssociationSet dataAssociationSet) {
        ArrayList<DataDeclaration> result = new ArrayList<DataDeclaration>();
        for (DataAssociation dataAssociation : dataAssociationSet.getDataAssociations()) {
            DataDeclaration targetDeclaration;
            DataDeclarationContainer context;
            DataAssociationItem target;
            Expression targetExpression;
            Sequence targetPath;
            if (!dataAssociation.isCustom() || (targetPath = ExpressionHelper.getDeclarationsPath((Expression)(targetExpression = (target = dataAssociation.getTarget()).getExpression()), (DataDeclarationContainer)(context = target.getContext()))).isEmpty() || result.contains(targetDeclaration = (DataDeclaration)targetPath.iterator().next())) continue;
            result.add(targetDeclaration);
        }
        return CollectionUtils.asSequence(result);
    }

    private static Sequence<DataAssociationItemRef> getRefs(@NotNull DataAssociationItemEndpoint endpoint, @NotNull Set<DataDeclaration> usedDeclarations) {
        ArrayList<DataAssociationItemRefImpl> result = new ArrayList<DataAssociationItemRefImpl>();
        boolean isFirstDeclaration = true;
        for (DataDeclaration refDeclaration : usedDeclarations) {
            if (endpoint.equals((Object)DataAssociationItemEndpoint.TARGET) || endpoint.equals((Object)DataAssociationItemEndpoint.CUSTOM_TARGET) || !refDeclaration.isPredefinedDeclaration()) {
                boolean isOtherRef = endpoint.equals((Object)DataAssociationItemEndpoint.CUSTOM_SOURCE) && refDeclaration.getDeclarationType().equals((Object)DataDeclarationType.DATA_OBJECT) || DataAssociationItemEndpoint.isAnyTarget(endpoint) && !isFirstDeclaration;
                DataAssociationItemRefImpl ref = new DataAssociationItemRefImpl(refDeclaration.getName(), isOtherRef);
                result.add(ref);
            }
            isFirstDeclaration = false;
        }
        return CollectionUtils.asSequence(result);
    }
}

