/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation.views.adapters;

import fuego.papi.Activity;
import fuego.papi.ArgumentSet;
import fuego.papi.Participant;
import fuego.papi.Process;
import fuego.papi.VarDefinition;
import fuego.papi.utils.FilterDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.deployment.ProcessDeployment;
import oracle.bpm.project.model.organization.Participant;

public class ViewFilterDescriptionInformation
implements FilterDescriptor.FilterDescriptionInformation {
    private final Project project;

    public ViewFilterDescriptionInformation(Project project) {
        this.project = project;
    }

    public Locale getLocale() {
        return this.project.getDefaultLanguage();
    }

    public TimeZone getTimezone() {
        return TimeZone.getDefault();
    }

    public fuego.papi.Participant getParticipant(String participantId) {
        Participant participant = this.project.getOrganization().findParticipant(participantId);
        if (participant == null) {
            return null;
        }
        return new fuego.papi.Participant(participant.getDisplayName(), participant.getFirstName(), participant.getLastName(), participant.getId(), participant.getOrganizationalUnit().getDescription(), participant.getMail(), new Participant.RoleAssignment[0], participant.isAdministrator()){

            public boolean hasRole(String role, String parameter) {
                return false;
            }
        };
    }

    public Process getProcess(String processId) {
        Collection<ProcessDeployment> deployments = this.project.getDeployment().getTopology().getDeployments();
        for (ProcessDeployment processDeployment : deployments) {
            if (!processDeployment.getProcessName().equals(processId)) continue;
            return new PapiProcessAdapter(processDeployment.getProcessName());
        }
        return null;
    }

    public VarDefinition getVariable(String variableId) {
        ProjectDataObject dataObject = this.project.findDataObject(variableId);
        HashMap<String, String> labels = new HashMap<String, String>();
        Locale defaultLanguage = this.project.getDefaultLanguage();
        labels.put(defaultLanguage.getLanguage(), dataObject.getLabel(defaultLanguage));
        return new VarDefinition(dataObject.getId(), dataObject.getType().getKind(), "", dataObject.getSize(), labels);
    }

    private final class PapiProcessAdapter
    implements Process {
        private final String processName;

        public PapiProcessAdapter(String processName) {
            this.processName = processName;
        }

        public void activate() {
        }

        public boolean containsDocumentation(Locale locale) {
            return false;
        }

        public void deprecate() {
        }

        public Activity[] getActivities() {
            return null;
        }

        public String[] getActivitiesForParticipant(fuego.papi.Participant participant) {
            return null;
        }

        public String[] getActivitiesForRoles(String[] roles) {
            return null;
        }

        public Activity getActivity(String activity) {
            return null;
        }

        public String[] getApplicationRoles() {
            return null;
        }

        public ArgumentSet[] getArgumentSets() {
            return null;
        }

        public ArgumentSet[] getArgumentSets(String activity) {
            return null;
        }

        public Activity getBeginActivity() {
            return null;
        }

        public int getCatalogIn() {
            return 0;
        }

        public String getConsolidatedId() {
            return null;
        }

        public String getDeployedEngine() {
            return null;
        }

        public String getDescription(Locale locale) {
            return null;
        }

        public String getDocumentation(Locale locale) {
            return null;
        }

        public Map<Locale, String> getDocumentationMap() {
            return null;
        }

        public String getFolderName() {
            return null;
        }

        public String[] getGlobalCreationRoles() {
            return null;
        }

        public Activity[] getGrabActivitiesForActivity(String activityId) {
            return null;
        }

        public String getId() {
            return null;
        }

        public int getIn() {
            return 0;
        }

        public String[] getInteractiveRoles() {
            return null;
        }

        public String getLabel(Locale locale) {
            return null;
        }

        public String getLabelWithOU(Locale locale) {
            return null;
        }

        public String getLabelWithOUForParticipant(Locale locale, fuego.papi.Participant participant) {
            return null;
        }

        public LocaleStringMap getLabels() {
            return null;
        }

        public long getLastNewsTimestamp() {
            return 0L;
        }

        public Activity[] getMeasurements() {
            return null;
        }

        public String getName() {
            return this.processName;
        }

        public String getOrganizationUnit() {
            return null;
        }

        public String getProjectName() {
            return null;
        }

        public String[] getRoles() {
            return null;
        }

        public VarDefinition[] getVariables() {
            return null;
        }

        public VarDefinition[] getVars() {
            return null;
        }

        public String getVersion() {
            return null;
        }

        public boolean hasApplicationRole(String roleId) {
            return false;
        }

        public boolean hasGlobalCreationRole(String roleId) {
            return false;
        }

        public boolean hasInteractiveRole(String roleId) {
            return false;
        }

        public boolean hasLocalDocumentation() {
            return false;
        }

        public boolean hasProcessDiagram() {
            return false;
        }

        public boolean hasRole(String role) {
            return false;
        }

        public boolean isActive() {
            return false;
        }

        public boolean isAutomatic() {
            return false;
        }

        public boolean isOnline() {
            return false;
        }

        public boolean isVisibleTo(fuego.papi.Participant participant) {
            return false;
        }

        public void setLastNewsTimestamp(long l) {
        }

        public void setDocumentation(Locale locale, String fileName) {
        }
    }
}

