/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.lang.Str;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.presentation.Filter;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.presentation.FilterAdapter;
import oracle.bpm.project.presentation.FilterAttributeAdapter;
import oracle.bpm.project.presentation.views.ViewAdapter;
import oracle.bpm.view.FilterAttributeImpl;
import oracle.bpm.view.FilterImpl;
import oracle.bpm.view.InstancesViewImpl;
import oracle.bpm.view.ParticipantScope;
import oracle.bpm.view.StatusScope;
import oracle.bpm.view.ViewType;
import org.jetbrains.annotations.NotNull;

public class InstancesViewAdapter<L extends InstancesViewImpl>
extends ViewAdapter<L>
implements InstancesView,
View,
ProjectObject.Mutable {
    public InstancesViewAdapter(Project project, L viewImpl) {
        super(project, viewImpl);
        this.setViewType(ViewType.INSTANCES);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.VIEW_INSTANCES;
    }

    @Override
    public void setFilter(Filter filter) {
        ((InstancesViewImpl)this.viewImpl).setFilter(filter.getFilterImpl());
    }

    @Override
    public Filter getFilter() {
        return new FilterAdapter(((InstancesViewImpl)this.viewImpl).getFilter());
    }

    @Override
    public Sequence<FlowNode> getActivities() {
        String[] assignedProcesses = this.getAssignedProcesses();
        SequenceBuilder nodes = SequenceBuilder.create();
        for (String processDeploymentId : assignedProcesses) {
            if (Str.isEmpty((String)processDeploymentId)) continue;
            String processName = ProcessDeploymentUtils.getProcessNameFromDeploymentId(processDeploymentId);
            nodes.append(this.project.findProcess(processName).getFlowNodes());
        }
        return nodes.build();
    }

    @Override
    public void setMatchAll(boolean matchAll) {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        filter.setMatchAll(matchAll);
        ((InstancesViewImpl)this.viewImpl).setFilter(filter);
    }

    @Override
    public void setParticipantScope(ParticipantScope scope) {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        filter.getSearchScope().setParticipantScope(scope);
        ((InstancesViewImpl)this.viewImpl).setFilter(filter);
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        filter.setCaseSensitive(caseSensitive);
        ((InstancesViewImpl)this.viewImpl).setFilter(filter);
    }

    @Override
    public void updateFilterAttributes(List<FilterAttribute> filterAttributes) {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        filter.clearAttributes();
        for (FilterAttribute filterAttribute : filterAttributes) {
            filter.addAttribute(filterAttribute.getFilterAttributeImpl());
        }
    }

    @Override
    public void addFilterAttribute(FilterAttribute attribute) {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        filter.addAttribute(attribute.getFilterAttributeImpl());
        ((InstancesViewImpl)this.viewImpl).setFilter(filter);
    }

    @Override
    public Collection<ProjectDataObject> getConditions() {
        return this.project.getAllVariables();
    }

    @Override
    public List<FilterAttribute> getFilterAttributes() {
        ArrayList<FilterAttribute> result = new ArrayList<FilterAttribute>();
        List filterAttributes = ((InstancesViewImpl)this.viewImpl).getFilter().getAttributes();
        for (FilterAttributeImpl filterAttribute : filterAttributes) {
            String variableId = filterAttribute.getVariableId();
            ProjectDataObject dataObject = this.getProject().findDataObject(variableId);
            result.add(new FilterAttributeAdapter(dataObject, filterAttribute));
        }
        return result;
    }

    @Override
    public ParticipantScope getParticipantScope() {
        return ((InstancesViewImpl)this.viewImpl).getFilter().getSearchScope().getParticipantScope();
    }

    @Override
    public boolean isCaseSensitiveFilterSelected() {
        return ((InstancesViewImpl)this.viewImpl).getFilter().isCaseSensitive();
    }

    @Override
    public boolean isMatchAllSelected() {
        return ((InstancesViewImpl)this.viewImpl).getFilter().isMatchAll();
    }

    @Override
    public boolean containsFilterAttribute(String variableId) {
        return ((InstancesViewImpl)this.viewImpl).getFilter().getAttributesByVariable().size() > 0;
    }

    @Override
    public void removeFilterAttribute(String variableId) {
        ((InstancesViewImpl)this.viewImpl).getFilter().removeAttributes(variableId);
    }

    @Override
    public void removeFilterAttribute(FilterAttribute attribute) {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        filter.removeAttribute(attribute.getFilterAttributeImpl());
        ((InstancesViewImpl)this.viewImpl).setFilter(filter);
    }

    @Override
    public void setPresentation(String presentationId) {
        ((InstancesViewImpl)this.viewImpl).setPresentation(presentationId);
    }

    @Override
    public boolean isInProcess() {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        StatusScope statusScope = filter.getSearchScope().getStatusScope();
        boolean isInProcess = statusScope == StatusScope.ONLY_INPROCESS || statusScope == StatusScope.INPROCESS_AND_ABORTED || statusScope == StatusScope.INPROCESS_AND_COMPLETED || statusScope == StatusScope.ALL;
        return isInProcess;
    }

    @Override
    public boolean isAborted() {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        StatusScope statusScope = filter.getSearchScope().getStatusScope();
        boolean isInProcess = statusScope == StatusScope.ONLY_ABORTED || statusScope == StatusScope.INPROCESS_AND_ABORTED || statusScope == StatusScope.ABORTED_AND_COMPLETED || statusScope == StatusScope.ALL;
        return isInProcess;
    }

    @Override
    public boolean isComplete() {
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        StatusScope statusScope = filter.getSearchScope().getStatusScope();
        boolean isInProcess = statusScope == StatusScope.ONLY_COMPLETED || statusScope == StatusScope.INPROCESS_AND_COMPLETED || statusScope == StatusScope.ABORTED_AND_COMPLETED || statusScope == StatusScope.ALL;
        return isInProcess;
    }

    @Override
    public void setStatusScope(boolean isInProcess, boolean isComplete, boolean isAborted) {
        StatusScope statusScope = null;
        if (isInProcess) {
            if (isComplete) {
                statusScope = StatusScope.INPROCESS_AND_COMPLETED;
                if (isAborted) {
                    statusScope = StatusScope.ALL;
                }
            } else {
                statusScope = isAborted ? StatusScope.INPROCESS_AND_ABORTED : StatusScope.ONLY_INPROCESS;
            }
        } else if (isComplete) {
            statusScope = isAborted ? StatusScope.ABORTED_AND_COMPLETED : StatusScope.ONLY_COMPLETED;
        } else if (isAborted) {
            statusScope = StatusScope.ONLY_ABORTED;
        }
        FilterImpl filter = ((InstancesViewImpl)this.viewImpl).getFilter();
        filter.getSearchScope().setStatusScope(statusScope);
        ((InstancesViewImpl)this.viewImpl).setFilter(filter);
    }
}

