/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation.presentations;

import fuego.papi.OperationException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.lang.exception.CouldNotDeleteResourceException;
import oracle.bpm.project.ResourceContainerImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.presentations.PresentationManager;
import oracle.bpm.project.presentation.ColumnAdapter;
import oracle.bpm.project.presentation.presentations.PresentationAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.PresentationType;
import oracle.bpm.view.io.PresentationLoader;
import org.jetbrains.annotations.NotNull;

public class PresentationManagerAdapter
extends ResourceContainerImpl
implements PresentationManager {
    private Map<String, Presentation> presentationAdapterMap = new HashMap<String, Presentation>();
    private oracle.bpm.view.mgmt.PresentationManager presentationManager;

    public PresentationManagerAdapter(Project project) {
        super(project);
        this.path = Path.PRESENTATION;
        PresentationLoader presentationLoader = project.getLoader().getPresentationLoader();
        this.presentationManager = new oracle.bpm.view.mgmt.PresentationManager(presentationLoader);
        this.adaptProjectObject(this.getVFile(Path.PRESENTATION));
    }

    public static Presentation createPresentation(Project project, String id) {
        return project.getPresentationManager().createPresentation(id);
    }

    @Override
    public List<Presentation> getPresentations() {
        ArrayList<Presentation> result = new ArrayList<Presentation>();
        SortedStringMap map = this.presentationManager.getOrganizationPresentations();
        ArrayList presentations = new ArrayList(map.values());
        for (PresentationImpl presentationImpl : presentations) {
            result.add(this.findOrCreateAdapter(presentationImpl));
        }
        return result;
    }

    @Override
    public List<Presentation> getPresentations(PresentationType presentationType) {
        ArrayList<Presentation> result = new ArrayList<Presentation>();
        for (Presentation presentation : this.getPresentations()) {
            if (!presentation.getType().isType(presentationType)) continue;
            result.add(presentation);
        }
        return result;
    }

    @Override
    public SortedStringMap<PresentationImpl> getSortedStringOrganizationPresentations() {
        return this.presentationManager.getOrganizationPresentations();
    }

    @Override
    public SortedStringMap<PresentationImpl> getSortedStringParticipantPresentations(String participantId) {
        return this.presentationManager.getParticipantPresentations(participantId);
    }

    @Override
    public boolean isDefaultPresentation(Presentation presentation) {
        return presentation.getId().equals("default_activity") || presentation.getId().equals("default_instances");
    }

    @Override
    public void removePresentation(Presentation presentation) throws ProjectException {
        try {
            this.events().preObjectRemoved(presentation, (ProjectObject)this);
            this.presentationAdapterMap.remove(presentation.getId());
            this.presentationManager.remove(presentation.getId());
            this.events().postObjectRemoved(presentation, (ProjectObject)this);
        }
        catch (CouldNotDeleteResourceException e) {
            this.presentationAdapterMap.put(presentation.getId(), presentation);
            this.addPresentation(presentation.getPresentationImpl());
            throw e;
        }
    }

    @Override
    public Presentation getPresentation(String id) {
        return this.findOrCreateAdapter(id);
    }

    @Override
    public boolean containsPresentation(String id) {
        return this.presentationManager.getOrganizationPresentation(id) != null;
    }

    @Override
    public void storePresentation(Presentation presentation, Writer writer) throws ProjectException {
        try {
            this.presentationManager.storeOrganizationalPresentation(presentation.getPresentationImpl(), writer);
        }
        catch (OperationException e) {
            throw new ProjectException(presentation, Msg.QUOTE((String)e.getMessage()));
        }
    }

    public Presentation.Column[] getAllAvailableColumns() {
        HashMap<String, ColumnAdapter> allColumns = new HashMap<String, ColumnAdapter>();
        Collection<ProjectDataObject> aDefaults = this.project.getDefaultVariables();
        ProjectDataObject[] external = new ProjectDataObject[]{};
        if (this.project.getProjectDataObjects() != null) {
            external = this.project.getProjectDataObjects().toArray(new ProjectDataObject[this.project.getProjectDataObjects().size()]);
        }
        if (aDefaults != null) {
            for (ProjectDataObject dataObject : aDefaults) {
                ColumnAdapter c = new ColumnAdapter(dataObject);
                allColumns.put(c.getId(), c);
            }
        }
        for (ProjectDataObject dataObject : external) {
            ColumnAdapter c = new ColumnAdapter(dataObject);
            allColumns.put(c.getId(), c);
        }
        return allColumns.values().toArray(new Presentation.Column[allColumns.values().size()]);
    }

    @Override
    public List<Presentation.Column> getAvailableColumns(Presentation presentation) {
        ArrayList<Presentation.Column> availableColumns = new ArrayList<Presentation.Column>();
        Presentation.Column[] allAvailableColumns = this.getAllAvailableColumns();
        Presentation.Column[] usedColumns = presentation.getColumns();
        for (int i = 0; allAvailableColumns != null && i < allAvailableColumns.length; ++i) {
            Presentation.Column column = allAvailableColumns[i];
            boolean used = false;
            for (int j = 0; usedColumns != null && j < usedColumns.length; ++j) {
                Presentation.Column usedColumn = usedColumns[j];
                if (!usedColumn.getId().equals(column.getId())) continue;
                used = true;
                break;
            }
            if (used) continue;
            availableColumns.add(column);
        }
        return availableColumns;
    }

    @Override
    public List<String> getPresentationIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (Presentation presentation : this.getPresentations()) {
            result.add(presentation.getId());
        }
        return result;
    }

    @Override
    public List<String> getPresentationIds(PresentationType presentationType) {
        ArrayList<String> result = new ArrayList<String>();
        for (Presentation presentation : this.getPresentations(presentationType)) {
            result.add(presentation.getId());
        }
        return result;
    }

    @Override
    public void addPresentation(Presentation presentation) throws ProjectException {
        this.events().preObjectAdded(presentation, (ProjectObject)this);
        this.presentationAdapterMap.put(presentation.getId(), presentation);
        PresentationImpl presentationImpl = presentation.getPresentationImpl();
        this.addPresentation(presentationImpl);
        presentationImpl.setOwner("custom");
        this.events().postObjectAdded(presentation, (ProjectObject)this);
    }

    @Override
    public Presentation createPresentation(String id) {
        return this.findOrCreateAdapter(id);
    }

    public Presentation findOrCreateAdapter(PresentationImpl presentationImpl) {
        String id = presentationImpl.getId();
        Presentation presentationAdapter = this.presentationAdapterMap.get(id);
        if (presentationAdapter == null) {
            presentationAdapter = new PresentationAdapter(this.project, presentationImpl);
            this.presentationAdapterMap.put(id, presentationAdapter);
        }
        return presentationAdapter;
    }

    @Override
    public void updatePresentation(Presentation presentation) {
        this.presentationAdapterMap.put(presentation.getId(), presentation);
        this.presentationManager.updatePresentation(presentation.getPresentationImpl());
    }

    @Override
    public Presentation create(PresentationImpl presentationImpl) {
        return presentationImpl != null ? new PresentationAdapter(this.getProject(), presentationImpl) : null;
    }

    public void add(Presentation presentation) throws ProjectException {
        this.addPresentation(presentation);
    }

    @NotNull
    public Sequence<Presentation> getChildren() {
        return CollectionUtils.asSequence(this.getPresentations());
    }

    @Override
    public void removeChild(ProjectObject presentation) throws ProjectException {
        this.removePresentation((Presentation)presentation);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROJECT_OBJECT_CONTAINER;
    }

    @Override
    public void replaceChild(ProjectObject oldPresentation, ProjectObject newPresentation) throws ProjectException {
        this.updatePresentation((Presentation)newPresentation);
        this.events().objectReplaced(oldPresentation, newPresentation);
    }

    @Override
    public void clear() {
    }

    private Presentation findOrCreateAdapter(String id) {
        PresentationImpl presentation = this.presentationManager.getOrganizationPresentation(id);
        if (presentation == null) {
            presentation = new PresentationImpl(PresentationType.INSTANCES, id, new PresentationImpl.Column[0]);
        }
        return this.findOrCreateAdapter(presentation);
    }

    private void addPresentation(PresentationImpl presentation) {
        this.presentationManager.put(presentation);
    }
}

