/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation.layouts;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.model.presentation.layouts.Layout;
import oracle.bpm.project.organization.RoleAssignmentImpl;
import org.jetbrains.annotations.NotNull;

public class LayoutImpl
extends ResourceObjectImpl
implements Layout.Mutable,
ResourceObject {
    private String name;
    private Collection<RoleAssignment> roleAssignments = new ArrayList<RoleAssignment>();
    private String xml;

    public LayoutImpl(Project project) {
        super(project);
    }

    public LayoutImpl(Project project, String id) {
        this(project);
        this.setId(id);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.LAYOUT.create(this.getId());
        }
        return this.path;
    }

    @Override
    @NotNull
    public Layout.Mutable asMutable() {
        return this;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.LAYOUT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setXml(String xml) {
        this.xml = xml;
    }

    @Override
    public String getXml() {
        return this.xml;
    }

    @Override
    public Collection<RoleAssignment> getRoleAssignments() {
        return this.roleAssignments;
    }

    @Override
    public Organization getOrganization() {
        return this.getProject().getOrganization();
    }

    @Override
    public void addRoleAssignment(RoleAssignment roleAssignment) {
        this.roleAssignments.add(roleAssignment);
    }

    @Override
    public void clearRoleAssignments() {
        this.roleAssignments.clear();
    }

    @Override
    public RoleAssignment.Mutable createRoleAssignment() {
        RoleAssignment.Mutable roleAssignment = new RoleAssignmentImpl().asMutable();
        roleAssignment.setAssignedObject(this);
        return roleAssignment;
    }

    @Override
    public void removeRoleAssignment(RoleAssignment roleAssignment) {
        this.roleAssignments.remove(roleAssignment);
    }

    @Override
    public void addRole(Role role) {
        RoleAssignment.Mutable roleAssignment = this.createRoleAssignment();
        roleAssignment.setRole(role);
        roleAssignment.addRelation();
    }

    @Override
    public RoleAssignment findRoleAssignment(String roleId, String parametricValue) {
        for (RoleAssignment roleAssignment : this.roleAssignments) {
            if (!roleAssignment.match(roleId, parametricValue)) continue;
            return roleAssignment;
        }
        return null;
    }
}

