/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation;

import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.view.Comparison;
import oracle.bpm.view.FilterAttributeImpl;

public class FilterAttributeAdapter
implements FilterAttribute {
    private ProjectDataObject dataObject;
    private FilterAttributeImpl filterAttributeImpl;

    public FilterAttributeAdapter(ProjectDataObject dataObject) {
        this.dataObject = dataObject;
        int kind = dataObject.getType().getKind();
        this.filterAttributeImpl = new FilterAttributeImpl(dataObject.getId(), kind, FilterAttributeAdapter.getDefaultComparison(kind), null);
    }

    public FilterAttributeAdapter(ProjectDataObject dataObject, FilterAttributeImpl filterAttribute) {
        this.dataObject = dataObject;
        this.filterAttributeImpl = filterAttribute;
    }

    @Override
    public void setComparison(Comparison comparison) {
        if (comparison != null) {
            this.filterAttributeImpl.setComparison(comparison);
        }
    }

    @Override
    public Comparison getComparison() {
        return this.filterAttributeImpl.getComparison();
    }

    @Override
    public int getKind() {
        return this.filterAttributeImpl.getKind();
    }

    @Override
    public void setParametric(boolean parametric) {
        this.filterAttributeImpl.setParametric(parametric);
    }

    @Override
    public boolean isParametric() {
        return this.filterAttributeImpl.isParametric();
    }

    @Override
    public void setValue(Object value) {
        this.filterAttributeImpl.setValue(value);
    }

    @Override
    public Object getValue() {
        return this.filterAttributeImpl.getValue();
    }

    @Override
    public ProjectDataObject getVariable() {
        return this.dataObject;
    }

    @Override
    public String getVariableId() {
        return this.filterAttributeImpl.getVariableId();
    }

    @Override
    public void setKind(int kind) {
        this.filterAttributeImpl.setKind(kind);
    }

    @Override
    public void setVariable(ProjectDataObject dataObject) {
        this.filterAttributeImpl.setVariableId(dataObject.getId());
    }

    @Override
    public FilterAttributeImpl getFilterAttributeImpl() {
        return this.filterAttributeImpl;
    }

    private static Comparison getDefaultComparison(int kind) {
        return Comparison.IS;
    }
}

