/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation;

import java.util.Locale;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.Variable;

public class ColumnAdapter
implements Presentation.Column {
    private PresentationImpl.Column columnImpl;
    private Project project;

    public ColumnAdapter(ProjectDataObject dataObject) {
        this.columnImpl = new PresentationImpl.Column(this.adaptVariable(dataObject));
    }

    public ColumnAdapter(PresentationImpl.Column column, Project project) {
        this.columnImpl = column;
        this.project = project;
    }

    @Override
    public String getId() {
        return this.columnImpl.getId();
    }

    @Override
    public String getLabel(Locale locale) {
        ProjectDataObject varDefinition = this.getVarDefinition();
        if (varDefinition == null) {
            return "";
        }
        String label = varDefinition.getLabel(locale);
        return Str.isEmpty((String)label) ? varDefinition.getName() : label;
    }

    @Override
    public void setSize(int size) {
        this.columnImpl.setSize(size);
    }

    @Override
    public int getSize() {
        return this.columnImpl.getSize();
    }

    @Override
    public void setVarDefinition(ProjectDataObject varDefinition) {
        this.columnImpl.setVariable((Object)this.adaptVariable(varDefinition));
    }

    @Override
    public ProjectDataObject getVarDefinition() {
        String variableId = this.columnImpl.getId();
        for (ProjectDataObject currentDataObject : this.project.getDefaultVariables()) {
            if (!currentDataObject.getId().equals(variableId)) continue;
            return currentDataObject;
        }
        for (ProjectDataObject currentDataObject : this.project.getProjectDataObjects()) {
            if (!currentDataObject.getId().equals(variableId)) continue;
            return currentDataObject;
        }
        return null;
    }

    @Override
    public PresentationImpl.Column getPresentationImplColumn() {
        return this.columnImpl;
    }

    @Override
    public void setColumnFormat(ColumnFormat columnFormat) {
        this.columnImpl.setColumnFormat(columnFormat);
    }

    @Override
    public ColumnFormat getColumnFormat() {
        return this.columnImpl.getColumnFormat();
    }

    private Variable adaptVariable(ProjectDataObject dataObject) {
        this.project = dataObject.getProject();
        Variable adaptedVariable = Variable.create((String)dataObject.getId(), (int)dataObject.getType().getKind());
        adaptedVariable.setSize(dataObject.getSize());
        adaptedVariable.setLabels(dataObject.getLabelMap());
        return adaptedVariable;
    }
}

