/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.preferences;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Platform;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.kpi.KeyPerformanceIndicatorsContainerImpl;
import oracle.bpm.project.model.ExceptionHandlingType;
import oracle.bpm.project.model.LaneOrientation;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.kpi.KeyPerformanceIndicatorsContainer;
import org.jetbrains.annotations.NotNull;

public class ProjectPreferencesImpl
extends ResourceObjectImpl
implements Serializable,
ProjectPreferences {
    private boolean allowReadWriteOptionalTasks = false;
    private boolean allowsNotToShareInstanceVars = false;
    private List<Locale> availableLanguages = new ArrayList<Locale>();
    private Locale defaultLanguage = Platform.getLocaleService().getProjectDefaultLocale().asJavaLocale();
    private List<String> dependencies = new ArrayList<String>();
    private ExceptionHandlingType exceptionHandlingType = ExceptionHandlingType.PROPAGATE;
    private boolean generatesInteractiveRole;
    private String interactiveRole = "";
    private boolean isTemplate;
    private boolean J2EEMode = false;
    private KeyPerformanceIndicatorsContainer keyPerformanceIndicatorContainer;
    private LaneOrientation lanesOrientation = LaneOrientation.UNDEFINED;
    private Map<String, List<ObjectPropertyListener>> observers = CollectionFactory.createMap();
    private Map<String, List<ObjectRelationListener>> relationObservers = CollectionFactory.createMap();
    private StringList vcsIgnoredFiles = StringList.create();
    public static final String TEMPLATE_PROPERTY = "template";
    static final long serialVersionUID = -9138668937738255685L;
    static final long serialCheck = -5733063713573405922L;

    public ProjectPreferencesImpl() {
        super(null);
    }

    public ProjectPreferencesImpl(Project project, String id) {
        super(project);
        this.setId(id);
        this.path = Path.CONFIG.create(this.getId());
        this.events().enable();
    }

    @Override
    public ProjectObject getParentObject() {
        return this.project;
    }

    @Override
    public void setAllowReadWriteOptionalTasks(boolean allowReadWriteOptionalTasks) {
        this.allowReadWriteOptionalTasks = allowReadWriteOptionalTasks;
    }

    @Override
    public boolean isAllowReadWriteOptionalTasks() {
        return this.allowReadWriteOptionalTasks;
    }

    @Override
    public void setAvailableLanguages(List<Locale> locales) {
        this.availableLanguages = locales;
        this.firePropertyChanged("availableLanguages");
    }

    @Override
    public List<Locale> getAvailableLanguages() {
        if (this.availableLanguages.size() == 0) {
            this.availableLanguages.add(this.getDefaultLanguage());
        }
        return Collections.unmodifiableList(this.availableLanguages);
    }

    @Override
    public void setDefaultLanguage(Locale locale) {
        if (this.defaultLanguage != null && locale == null) {
            throw new IllegalArgumentException("Cannot remove default language");
        }
        this.defaultLanguage = locale;
        this.firePropertyChanged("defaultLanguage");
    }

    @Override
    public List<String> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    @Override
    public void setDependencies(List<String> projects) {
        this.dependencies = projects;
        this.firePropertyChanged("dependencies");
    }

    @Override
    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public void setExceptionHandlingType(ExceptionHandlingType exceptionHandlingType) {
        this.exceptionHandlingType = exceptionHandlingType;
    }

    @Override
    public ExceptionHandlingType getExceptionHandlingType() {
        return this.exceptionHandlingType;
    }

    @Override
    public void setGeneratesInteractiveRole(boolean generatesInteractiveRole) {
        this.generatesInteractiveRole = generatesInteractiveRole;
    }

    @Override
    public boolean getGeneratesInteractiveRole() {
        return this.generatesInteractiveRole;
    }

    @Override
    public void setInteractiveRole(String interactiveRole) {
        this.interactiveRole = interactiveRole;
    }

    @Override
    public boolean getAllowsNotToShareInstanceVars() {
        return this.allowsNotToShareInstanceVars;
    }

    @Override
    public void setAllowsNotToShareInstanceVars(boolean allowsNotToShareInstanceVars) {
        this.allowsNotToShareInstanceVars = allowsNotToShareInstanceVars;
    }

    @Override
    public String getInteractiveRole() {
        return this.interactiveRole;
    }

    @Override
    public void setJ2EEMode(boolean j2EEMode) {
        this.J2EEMode = j2EEMode;
        this.firePropertyChanged("j2eeMode");
    }

    @Override
    public boolean isJ2EEMode() {
        return this.J2EEMode;
    }

    @Override
    public LaneOrientation getLanesOrientation() {
        return this.lanesOrientation == LaneOrientation.UNDEFINED ? LaneOrientation.VERTICAL : this.lanesOrientation;
    }

    @Override
    public void setLanesOrientation(LaneOrientation orientation) {
        this.lanesOrientation = orientation;
        this.firePropertyChanged("lanesOrientation");
    }

    @Override
    public boolean isHorizontalOrientation() {
        return this.lanesOrientation.isHorizontal();
    }

    @Override
    public KeyPerformanceIndicatorsContainer getKeyPerformanceIndicatorsContainer() {
        if (this.keyPerformanceIndicatorContainer == null) {
            this.keyPerformanceIndicatorContainer = new KeyPerformanceIndicatorsContainerImpl(this.getProject());
        }
        return this.keyPerformanceIndicatorContainer;
    }

    @Override
    public void setTemplate(boolean isTemplate) {
        if (isTemplate != this.isTemplate) {
            this.isTemplate = isTemplate;
            this.events().objectChanged(TEMPLATE_PROPERTY, !isTemplate, isTemplate);
            this.setDirty(true);
        }
    }

    @Override
    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setVCSIgnoredFiles(StringList vcsIgnoredFiles) {
        assert (vcsIgnoredFiles != null);
        this.vcsIgnoredFiles = vcsIgnoredFiles;
    }

    public StringList getVCSIgnoredFiles() {
        return this.vcsIgnoredFiles;
    }

    public void addPropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getPropertyObservers(propertyName).add(observer);
    }

    public void removePropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getPropertyObservers(propertyName).remove(observer);
    }

    public void addRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).add(observer);
    }

    public void removeRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).remove(observer);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROJECT_PREFERENCES;
    }

    protected void firePropertyChanged(String propertyName) {
        for (ObjectPropertyListener observer : this.getPropertyObservers(propertyName)) {
            observer.propertyChanged((Object)this, propertyName);
        }
    }

    protected void fireRelationAdded(String relationName) {
        for (ObjectRelationListener observer : this.getRelationsObservers(relationName)) {
            observer.relationAdded((Object)this, relationName);
        }
    }

    protected void fireRelationRemoved(String relationName) {
        for (ObjectRelationListener observer : this.getRelationsObservers(relationName)) {
            observer.relationRemoved((Object)this, relationName);
        }
    }

    private List<ObjectPropertyListener> getPropertyObservers(String propertyName) {
        if (!this.observers.containsKey(propertyName)) {
            this.observers.put(propertyName, CollectionFactory.createList());
        }
        return this.observers.get(propertyName);
    }

    private List<ObjectRelationListener> getRelationsObservers(String relationName) {
        if (!this.relationObservers.containsKey(relationName)) {
            this.relationObservers.put(relationName, CollectionFactory.createList());
        }
        return this.relationObservers.get(relationName);
    }
}

