/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

public class ParticipantOrganizationalUnitChecker
implements ProjectObjectChecker<Participant> {
    private Collection<ProjectObjectChecker> participantOuCheckers = new ArrayList<ProjectObjectChecker>();

    public ParticipantOrganizationalUnitChecker(Organization organization) {
        this.participantOuCheckers.add(OrganizationCheckerFactory.getOrganizationalUnitExistenceChecker());
    }

    @Override
    public MsgList check(Participant participant) {
        MsgList messages = MsgList.create();
        if (participant.getOrganizationalUnit() != null) {
            for (ProjectObjectChecker projectObjectChecker : this.participantOuCheckers) {
                messages.addAll((Collection)projectObjectChecker.check(participant.getOrganizationalUnit()));
            }
        }
        return messages;
    }
}

