/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.WorkDaySchedule;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

public class CalendarRuleChecker
implements ProjectObjectChecker<CalendarRule> {
    private Collection<ProjectObjectChecker> calendarRuleCheckers = new ArrayList<ProjectObjectChecker>();

    public CalendarRuleChecker() {
        this.calendarRuleCheckers.add(OrganizationCheckerFactory.getWorkWeekChecker());
        this.calendarRuleCheckers.add(OrganizationCheckerFactory.getTimeZoneChecker());
    }

    @Override
    public MsgList check(CalendarRule calendarRule) {
        Day[] days;
        MsgList messages = MsgList.create();
        for (ProjectObjectChecker projectObjectChecker : this.calendarRuleCheckers) {
            messages.addAll((Collection)projectObjectChecker.check(calendarRule));
        }
        WorkWeek workWeek = calendarRule.getWorkWeek();
        for (Day day : days = Day.values()) {
            WorkDaySchedule workDaySchedule;
            if (!workWeek.isWorkingDay(day) || (workDaySchedule = workWeek.getSchedule(day)).isValid()) continue;
            messages.add((Object)ProjectMsg.INVALID_WORKING_DAY(day.getString(), calendarRule.getName()));
        }
        return messages;
    }
}

