/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.organization.compiler.PresentationChecker;
import oracle.bpm.resources.Msg;

@CompilerExtensionMetadata
public class PresentationCompiler
extends AbstractCompilerExtension<Presentation> {
    public PresentationCompiler() {
        super(Presentation.class, CollectionFactory.createListWith((Object[])new ProjectObjectType[]{ProjectObjectType.PRESENTATION}));
    }

    @Override
    public boolean supports(Presentation object) {
        return true;
    }

    @Override
    public void compile(Presentation presentation, CompilationSession session) throws ProjectException {
        MsgList errors = MsgList.create();
        MsgList warnings = MsgList.create();
        PresentationChecker.validateFormats(presentation, errors, warnings);
        this.reportErrors((List<Msg>)errors, presentation);
        this.reportWarnings((List<Msg>)warnings, presentation);
    }
}

