/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;
import oracle.bpm.resources.Msg;

@CompilerExtensionMetadata
public class GroupCompiler
extends AbstractCompilerExtension<Group> {
    public GroupCompiler() {
        super(Group.class, Arrays.asList(ProjectObjectType.ORGANIZATION_GROUP));
    }

    @Override
    public void compile(Group group, CompilationSession session) throws ProjectException {
        ProjectObjectChecker<Group> groupChecker = OrganizationCheckerFactory.getGroupChecker(group.getOrganization());
        super.reportErrors((List<Msg>)groupChecker.check(group), group);
    }

    @Override
    public boolean supports(Group group) {
        return true;
    }
}

