/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;
import oracle.bpm.resources.Msg;

@CompilerExtensionMetadata
public class CalendarRuleCompiler
extends AbstractCompilerExtension<CalendarRule> {
    public CalendarRuleCompiler() {
        super(CalendarRule.class, Arrays.asList(ProjectObjectType.CALENDAR_RULE));
    }

    @Override
    public void compile(CalendarRule calendarRule, CompilationSession session) throws ProjectException {
        ProjectObjectChecker<CalendarRule> calendarRuleChecker = OrganizationCheckerFactory.getCalendarRuleChecker(calendarRule.getOrganization());
        super.reportErrors((List<Msg>)calendarRuleChecker.check(calendarRule), calendarRule);
    }

    @Override
    public boolean supports(CalendarRule calendarRule) {
        return true;
    }
}

