/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.identity.MemberContainerImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.impl.keys.OrganizationalUnitKey;
import oracle.bpm.project.model.impl.keys.ProjectObjectKey;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.variables.DefaultValueAssignment;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.CalendarRuleAssignmentImpl;
import org.jetbrains.annotations.NotNull;

public class OrganizationalUnitImpl
extends MemberContainerImpl
implements OrganizationalUnit.Mutable {
    public Exception exception = new Exception();
    private CalendarRuleAssignment calendarRuleAssignment;
    private OrganizationalChart chart;
    private List<DefaultValueAssignment> defaultValueAssignments;
    private StringFeature description = StringFeature.create("description", ProjectMsg.DESCRIPTION, null, "");
    private String name;
    private Organization organization;
    private OrganizationalUnit parent;

    OrganizationalUnitImpl(Organization organization) {
        super(organization.getProject());
        this.organization = organization;
        this.defaultValueAssignments = new ArrayList<DefaultValueAssignment>();
    }

    OrganizationalUnitImpl(@NotNull Organization organization, @NotNull OrganizationalChart chart) {
        this(organization);
        this.chart = chart;
    }

    public static boolean isRootId(String id) {
        return OrganizationalUnitKey.rootKey.getId().equals(id);
    }

    @Override
    public boolean isAncestorOf(OrganizationalUnit other) {
        for (OrganizationalUnit organizationalUnit : this.getChildrenByType(OrganizationalUnit.class)) {
            if (other == organizationalUnit) {
                return true;
            }
            if (!organizationalUnit.isAncestorOf(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ProjectObjectKey getKey() {
        return this.key;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (id != null) {
            this.setKey(this.createKey(id));
        }
    }

    @Override
    public void setDescription(String description) {
        String prevDescription = this.description.getValue();
        this.description.setValue(description);
        this.events().objectChanged("description", prevDescription, this.description.getValue());
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.events().objectChanged();
    }

    @Override
    public String getDescription() {
        return this.description.getValue();
    }

    @Override
    public OrganizationalUnit getParent() {
        return this.parent;
    }

    @Override
    public void setParent(OrganizationalUnit parent) throws ProjectException {
        assert (this.parent == null) : "cannot change parent; if you want this to be editable check that this ou is removed from parent...";
        if (parent == null) {
            throw new ProjectException(this);
        }
        if (this.isAncestorOf(parent)) {
            throw new ProjectException(this);
        }
        assert (parent.getClass().equals(this.getClass())) : "wrong parent class " + parent.getClass().getName();
        this.parent = parent;
        this.setKey(this.createKey(this.getId()));
        this.path = null;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            OrganizationalUnit parent = this.getParent();
            Path parentPath = this.isRoot() || parent == null || parent.isRoot() ? Path.ORGANIZATIONAL_UNIT : parent.getPath();
            this.path = parentPath.create(this.getId());
        }
        return this.path;
    }

    @Override
    public CalendarRuleAssignment.Mutable createCalendarRuleAssignment() {
        CalendarRuleAssignmentImpl result = new CalendarRuleAssignmentImpl();
        result.setOrganizationalUnit(this);
        return result;
    }

    @Override
    public boolean isRoot() {
        return OrganizationalUnitKey.rootKey.getId().equals(this.id);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.OU;
    }

    @Override
    public String getInternalPath() {
        if (this.isRoot()) {
            return "/";
        }
        if (this.parent == null || this.parent.isRoot()) {
            return "/".concat(this.getName());
        }
        return this.parent.getInternalPath().concat("/").concat(this.getName());
    }

    @Override
    public OrganizationalUnit.Mutable createChild(String id) throws ProjectException {
        if (this.findChild(OrganizationalUnit.class, id) != null) {
            throw new ProjectException(this.findChild(OrganizationalUnit.class, id), ProjectModelMsg.PROJECT_OBJECT_ALREADY_EXIST);
        }
        OrganizationalUnitImpl child = new OrganizationalUnitImpl(this.getOrganization(), this.chart);
        child.setId(id);
        child.setParent(this);
        return child;
    }

    @Override
    @NotNull
    public OrganizationalUnit.Mutable asMutable() {
        return this;
    }

    @Override
    public void addCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        CalendarRuleAssignment prevCalendarRuleAssignment = this.calendarRuleAssignment;
        this.calendarRuleAssignment = calendarRuleAssignment;
        this.events().objectChanged("calendarRuleAssignment", prevCalendarRuleAssignment, this.calendarRuleAssignment);
    }

    @Override
    public void removeCalendarRuleAssignment() {
        this.calendarRuleAssignment = null;
    }

    @Override
    public void addDefaultValueAssignment(DefaultValueAssignment defaultValueAssignment) {
        this.defaultValueAssignments.add(defaultValueAssignment);
    }

    @Override
    public void removeDefaultValueAssignment(DefaultValueAssignment defaultValueAssignment) {
        this.defaultValueAssignments.remove(defaultValueAssignment);
    }

    @Override
    public CalendarRuleAssignment getCalendarRuleAssignment() {
        if (this.calendarRuleAssignment != null && this.calendarRuleAssignment.getCalendarRule() == null && this.getOrganization().findCalendarRule(this.calendarRuleAssignment.getCalendarRuleId()) != null) {
            this.calendarRuleAssignment.asMutable().setCalendarRule(this.getOrganization().findCalendarRule(this.calendarRuleAssignment.getCalendarRuleId()));
            this.calendarRuleAssignment.addRelation();
        }
        return this.calendarRuleAssignment;
    }

    @Override
    public CalendarRule getCalendarRule() {
        return this.getCalendarRuleAssignment() != null ? this.getCalendarRuleAssignment().getCalendarRule() : null;
    }

    @Override
    public int compareTo(OrganizationalUnit ou) {
        return this.getId().compareTo(ou.getId());
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization();
    }

    @Override
    public Organization getOrganization() {
        return this.organization;
    }

    public final String toString() {
        return this.getId();
    }

    @Override
    public void setCalendarRule(String calendarRuleId) {
        CalendarRuleAssignment.Mutable calendarRuleAssignment = this.createCalendarRuleAssignment();
        calendarRuleAssignment.setCalendarRule(calendarRuleId);
        this.addCalendarRuleAssignment(calendarRuleAssignment);
    }

    protected OrganizationalUnitKey createKey(String id) {
        return OrganizationalUnitKey.valueOf(this.parent, id);
    }

    private void setKey(OrganizationalUnitKey key) {
        this.key = key;
    }
}

