/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.impl.keys.OrganizationalUnitKey;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.OrganizationalUnitRef;
import oracle.bpm.project.organization.OrganizationalUnitImpl;
import oracle.bpm.project.organization.OrganizationalUnitsContainerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrganizationalChartImpl
extends OrganizationalUnitsContainerImpl
implements OrganizationalChart,
ResourceObject {
    private Organization organization;
    private OrganizationalUnitRef ouMappingRef;
    private static final String ROOT_ID = "";

    public OrganizationalChartImpl(@NotNull Organization organization, @NotNull String id) {
        super(organization.getProject());
        this.setId(id);
        this.organization = organization;
        this.path = Path.ORGANIZATION.create(id);
        this.setDeletable(false);
    }

    @Override
    @Deprecated
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ORGANIZATIONAL_CHART;
    }

    @NotNull
    public ProjectObject.Mutable asMutable() {
        return this;
    }

    @Override
    public OrganizationalUnit createOrganizationalUnit(@NotNull String ouId, OrganizationalUnit parent) throws ProjectException {
        OrganizationalUnitImpl child = new OrganizationalUnitImpl(this.getOrganization(), this);
        child.setId(ouId);
        if (parent != null) {
            child.setParent(parent);
        }
        return child;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public OrganizationalUnitRef getOrganizationalUnitMapping() {
        return this.ouMappingRef;
    }

    @Override
    public void setOrganizationalUnitMapping(OrganizationalUnitRef ouRef) {
        OrganizationalUnitRef oldRef = this.ouMappingRef;
        this.ouMappingRef = ouRef;
        if (ouRef == null && oldRef != null || ouRef != null && !ouRef.equals(oldRef)) {
            this.events().objectChanged(this.getOrganization(), "orgUnitMapping", oldRef, ouRef);
        }
    }

    @Override
    public Organization getOrganization() {
        return this.organization;
    }

    @Override
    public OrganizationalUnit getRootOrganizationalUnit() {
        if (this.ouRoot == null) {
            this.ouRoot = new OrganizationalUnitImpl(this.getProject().getOrganization(), this);
            this.ouRoot.asMutable().setId(OrganizationalUnitKey.rootKey.getId());
        }
        return this.ouRoot;
    }

    @Override
    public Path getPath() {
        VFile file = this.as(VFile.class);
        return file != null ? Path.createFromVFile(file) : this.path;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization();
    }

    @Override
    public OrganizationalUnit findOrganizationalUnit(final String id) {
        if (ROOT_ID.equals(id)) {
            return null;
        }
        Sequence unitSequence = this.getOrganizationalUnitsWithoutRoot().select((Predicate)new Predicate<OrganizationalUnit>(){

            public boolean check(@Nullable OrganizationalUnit value) {
                return value != null && id.equals(value.getId());
            }
        });
        OrganizationalUnit ou = null;
        if (!unitSequence.isEmpty()) {
            ou = (OrganizationalUnit)unitSequence.iterator().next();
        }
        return ou;
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        assert (child instanceof OrganizationalUnit);
        OrganizationalUnit ou = (OrganizationalUnit)child;
        if (ou.getParent() == null) {
            super.addChild(child);
        } else {
            ou.getParent().addChild(ou);
        }
    }
}

