/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import oracle.bpm.project.ResourceContainerImpl;
import oracle.bpm.project.model.HolidayRulesContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.organization.HolidayRuleImpl;
import org.jetbrains.annotations.NotNull;

public class HolidayRulesContainerImpl
extends ResourceContainerImpl
implements HolidayRulesContainer {
    public HolidayRulesContainerImpl(Project project) {
        super(project);
        this.path = Path.HOLIDAY;
        this.id = this.path.getName();
        this.adaptProjectObject(this.getVFile(Path.HOLIDAY));
        this.setDeletable(false);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.HOLIDAY_RULES_CONTAINER;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject().getOrganization();
    }

    @Override
    public HolidayRule createHolidayRule() {
        return new HolidayRuleImpl(this.getProject().getOrganization());
    }

    @Override
    public HolidayRule createHolidayRule(String id) throws ProjectException {
        HolidayRule.Mutable holidayRule = this.createHolidayRule().asMutable();
        holidayRule.setId(id);
        return holidayRule;
    }
}

