/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.GroupAssignmentImpl;
import oracle.bpm.project.organization.OrganizationObjectImpl;
import oracle.bpm.project.organization.RoleAssignmentImpl;
import org.jetbrains.annotations.NotNull;

public class GroupImpl
extends OrganizationObjectImpl
implements Group.Mutable,
ResourceObject {
    private StringFeature description = StringFeature.create("description", ProjectMsg.DESCRIPTION, null, "");
    private BooleanFeature enabled = BooleanFeature.create("enabled", ProjectMsg.ENABLED, null, true);
    private Collection<GroupAssignment> groupAssignments;
    private Collection<GroupAssignment> objectsAssigned;
    private Collection<RoleAssignment> roleAssignments = new ArrayList<RoleAssignment>();

    public GroupImpl(Organization organization) {
        super(organization);
        this.groupAssignments = new ArrayList<GroupAssignment>();
        this.objectsAssigned = new ArrayList<GroupAssignment>();
    }

    @Override
    public Collection<GroupAssignment> getGroupAssignments() {
        for (GroupAssignment groupAssignment : this.groupAssignments) {
            if (groupAssignment.getGroup() != null || this.getOrganization().findGroup(groupAssignment.getGroupId()) == null) continue;
            groupAssignment.asMutable().setGroup(this.getOrganization().findGroup(groupAssignment.getGroupId()));
            groupAssignment.addRelation();
        }
        return this.groupAssignments;
    }

    @Override
    @NotNull
    public Group.Mutable asMutable() {
        return this;
    }

    @Override
    public AssignableToGroup findAssignedObject(String groupId) {
        for (GroupAssignment groupAssignment : this.getAssignedObjects()) {
            if (!groupAssignment.getGroup().getId().equals(groupId)) continue;
            return groupAssignment.getGroup();
        }
        return null;
    }

    @Override
    public void setDescription(String description) {
        String prev = this.description.getValue();
        this.description.setValue(description == null ? "" : description);
        this.events().objectChanged("description", prev, this.description.getValue());
    }

    @Override
    public String getDescription() {
        return this.description.getValue();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.getValue();
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.GROUP.create(this.getId());
        }
        return this.path;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean prevValue = this.isEnabled();
        this.enabled.setValue(enabled);
        this.events().objectChanged("enabled", prevValue, this.isEnabled());
    }

    @Override
    public Collection<RoleAssignment> getRoleAssignments() {
        for (RoleAssignment roleAssignment : this.roleAssignments) {
            if (roleAssignment.getRole() != null || this.getOrganization().findRoleById(roleAssignment.getRoleId()) == null) continue;
            roleAssignment.asMutable().setRole(this.getOrganization().findRoleById(roleAssignment.getRoleId()));
            roleAssignment.addRelation();
        }
        return this.roleAssignments;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ORGANIZATION_GROUP;
    }

    @Override
    public RoleAssignment.Mutable createRoleAssignment() {
        RoleAssignmentImpl result = new RoleAssignmentImpl();
        result.setAssignedObject(this);
        return result;
    }

    @Override
    public void addRoleAssignment(RoleAssignment roleAssignment) {
        this.roleAssignments.add(roleAssignment);
        this.events().objectChanged("roleAssignment", null, roleAssignment);
    }

    @Override
    public void removeRoleAssignment(RoleAssignment roleAssignment) {
        this.roleAssignments.remove(roleAssignment);
    }

    @Override
    public GroupAssignment.Mutable createGroupAssignment() {
        GroupAssignmentImpl result = new GroupAssignmentImpl();
        result.setAssignedObject(this);
        return result;
    }

    @Override
    public void addGroupAssignment(GroupAssignment groupAssignment) {
        this.groupAssignments.add(groupAssignment);
        if (this.equals(groupAssignment.getAssignedObject())) {
            this.events().objectChanged("groupAssignment", null, groupAssignment);
        }
    }

    @Override
    public void removeGroupAssignment(GroupAssignment groupAssignment) {
        this.groupAssignments.remove(groupAssignment);
        if (this.equals(groupAssignment.getAssignedObject())) {
            this.events().objectChanged("groupAssignment", groupAssignment, null);
        }
    }

    @Override
    public Collection<GroupAssignment> getAssignedObjects() {
        return this.objectsAssigned;
    }

    @Override
    public void assignGroup(Group group) {
        GroupAssignment.Mutable groupAssignment = this.createGroupAssignment();
        groupAssignment.setGroup(group);
        groupAssignment.addRelation();
    }

    @Override
    public GroupAssignment getGroupAssignment(Group group) {
        GroupAssignment groupAssignment = null;
        for (GroupAssignment assignment : this.getGroupAssignments()) {
            if (!assignment.getAssignedObject().equals(this) || !assignment.getGroup().equals(group)) continue;
            groupAssignment = assignment;
            break;
        }
        return groupAssignment;
    }

    @Override
    public Collection<GroupAssignment> getGroupAssignments(Group group) {
        ArrayList<GroupAssignment> grAssignments = new ArrayList<GroupAssignment>();
        for (GroupAssignment assignment : this.getGroupAssignments()) {
            if (!assignment.getAssignedObject().equals(group)) continue;
            grAssignments.add(assignment);
        }
        return grAssignments;
    }

    @Override
    public void removeAssignedGroup(Group group) {
        GroupAssignment groupAssignment = this.getGroupAssignment(group);
        groupAssignment.removeRelation();
    }

    @Override
    public Role getRoleAssigned(String id) {
        for (RoleAssignment roleAssignment : this.roleAssignments) {
            if (!roleAssignment.getRole().getId().equals(id)) continue;
            return roleAssignment.getRole();
        }
        return null;
    }

    @Override
    public void removeAllGroupAssignments(Collection<GroupAssignment> groupAssignments) {
        this.groupAssignments.removeAll(groupAssignments);
    }

    @Override
    public void clearRoleAssignments() {
        this.roleAssignments.clear();
    }

    @Override
    public void clearGroupAssignments() {
        this.groupAssignments.clear();
    }

    @Override
    public void assignGroup(String groupId) {
        GroupAssignment.Mutable groupAssignment = this.createGroupAssignment();
        groupAssignment.setGroupId(groupId);
        this.addGroupAssignment(groupAssignment);
    }

    @Override
    public int compareTo(Group group) {
        return this.getId().compareTo(group.getId());
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization().getGroupsContainer();
    }
}

